//
// filterGropup - global filter group handling and editor
//


var filterGroup = {
	
	panel: null,
	validator: null,
	
	// active filter item properties
	id: '',
	isNew: false,
	isSaveCheckedAsNewGroup: false
	
	// itemIndex is the index of the item object in globalFilter.savedFilterItems array.
	// It is send back to globalFilter upon saving where the existing object is replaced
	// with the new one
};


filterGroup.init = function() {
	
	var panelObj = {
		panelId:'filter_group:panel',
		panelClassName: 'panel-50',
		panelHeaderLabel: '-',
		left: 70,
		top: 120,
		zIndex: 40,
		isCover: true,
		closeEvent: filterGroup.close
	};
			
	filterGroup.panel = new util.Panel3(panelObj);
	filterGroup.validator = new util.Validator();
	
	YAHOO.util.Event.addListener('filter_group:label', 'keypress', filterGroup.saveGroupViaEnter);
	
	var okBtn = new util.Button2('filter_group:ok_btn', 'btn-50', filterGroup.saveGroup);
	var cancelBtn = new util.Button2('filter_group:cancel_btn', 'btn-50', filterGroup.close);
}


filterGroup.open = function(itemId, groupLabel, isNew, isSaveCheckedAsNewGroup) {
	
	// Initialize panel, buttons and list if not yet done
	if (filterGroup.panel == null) {
		filterGroup.init();
	}
	
	filterGroup.id = itemId;
	filterGroup.isNew = isNew;
	filterGroup.isSaveCheckedAsNewGroup = isSaveCheckedAsNewGroup;
	
	var panelHeaderLabel;
	
	if (!isNew && !isSaveCheckedAsNewGroup) {
		panelHeaderLabel = langVar('lang_stats.global_filter.edit_group');
	}
	else if (isSaveCheckedAsNewGroup) {
		panelHeaderLabel = langVar('lang_stats.global_filter.save_checked_as_group');
	}
	else {
		panelHeaderLabel = langVar('lang_stats.global_filter.new_group');
	}
	
	globalFilter.disableForm();
	
	// set the form
	util.setF('filter_group:label', groupLabel);
	
	filterGroup.panel.open({label:panelHeaderLabel});
	
	var element = util.getE('filter_group:label');
	element.focus();
}


filterGroup.close = function() {
	
	filterGroup.validator.reset();
	filterGroup.panel.close();
	
	globalFilter.enableForm();
}

filterGroup.saveGroupViaEnter = function(event) {
		
	var keyCode = (event.which) ? event.which : event.keyCode;
	if (keyCode == 13 || keyCode == 3) {
		filterGroup.saveGroup();
	}
}

filterGroup.saveGroup = function() {
	
	// alert('save group');
	
	var validator = filterGroup.validator;
	var isNew = filterGroup.isNew;
	var isSaveCheckedAsNewGroup = filterGroup.isSaveCheckedAsNewGroup;
	
	// Validate group name
	
	var groupLabelItems = globalFilter.getGroupValuesByKey('label', filterGroup.id);
	
	var groupLabel = validator.isValue('filter_group:label');
	groupLabel = validator.isUnique('filter_group:label', groupLabelItems);
	
	if (validator.allValid()) {
		
		// get unique node name
		var groupNameItems = globalFilter.getGroupValuesByKey('name', filterGroup.id);
		var groupName = util.labelToUniqueNodeName(groupLabel, groupNameItems, 'filter_group');
		
		if (isSaveCheckedAsNewGroup) {
			
			globalFilter.saveCheckedAsNewGroupProcessing(groupName, groupLabel);
			
		}
		else {
			globalFilter.saveFilterGroup(filterGroup.id, groupName, groupLabel, isNew);
		}
		
		filterGroup.close();
	}
}

