//
// profileInfoUtil - used in Config Profile Info, Update Database and Build Database
//

var profileInfoUtil = function() {
	
	/*
	var GD = {
		isRealTimeProcessing: false,
		isActiveSnaponOperation: false,
		databaseIsBuilding: false,
		initialBuildDone: false,
		databaseIsReadyForReporting: false,
		lastProfileInfoTime: -1 // the time profile info data have been updated
	};
	*/

	function updateProfileInfo(dat) {
		
		// util.showObject(dat);
	
		var isInternalSQL = (dat.dbServerType === 'internal_sql');
		
		util.updateT('profile_info:profile_label', dat.profileLabel);
		// util.updateT('profile_info:log_format', dat.logFormatLabel);
		util.updateT('profile_info:real_time_processing', dat.realTimeProcessingLabel);
		
		util.updateT('profile_info:db_server_type', dat.dbServerTypeLabel);
		util.updateT('profile_info:db_directory', dat.dbDirectory);
		util.updateT('profile_info:db_name', dat.dbName);
		
		util.updateT('profile_info:db_last_modified', dat.dbLastModified);
		util.updateT('profile_info:db_last_operation', dat.dbLastOperation);
		
		util.updateT('profile_info:db_earliest_log_entry', dat.dbErliestDateTime);
		util.updateT('profile_info:db_latest_log_entry', dat.dbLatestDateTime);        
		
		util.showE('profile_info:db_directory:tr', isInternalSQL);
		util.showE('profile_info:db_name:tr', !isInternalSQL);
		
		updateLogFormatInfo(dat);
		
		
		setProfileInfoDisplay(dat);
	}
	
	function setProfileInfoDisplay(dat) {
		
		// Called when receiving fresh profile info data but also used to reset the display
		// after Update Database or Build Database
		
		// Update 
	
		//
		// Handle basic database info display
		//
		
		var isRealTimeProcessing = dat.isRealTimeProcessing;
		var isActiveSnaponOperation = dat.isActiveSnaponOperation;
		var databaseIsBuilding = dat.databaseIsBuilding;
		var initialBuildDone = dat.initialBuildDone;
		var databaseIsReadyForReporting = dat.databaseIsReadyForReporting;

		
		var showDatabaseBuildDetails = !isRealTimeProcessing ? (!databaseIsBuilding && initialBuildDone) : databaseIsReadyForReporting;
		var showNoDatabaseBuildInfo = !isRealTimeProcessing  ? (!databaseIsBuilding && !initialBuildDone) : !databaseIsReadyForReporting;
		
		// var showDatabaseProgress = (!isRealTimeProcessing && databaseIsBuilding);
		
		// Set current operation parameters
		var operationIcon = '';
		var operationLabel = '';
	
		if (isActiveSnaponOperation) {
			
			// operationIcon = 'blink';
			// operationLabel = langVar('lang_admin.config_home.snapon_active_checking_for_progress');
			
			// Get snapon progress
			// showSnaponProgress();
			
			operationIcon = 'run';
			operationLabel = 'Snapon operation active.'; //LM
		}
		else if (databaseIsBuilding) {
			
			if (!isRealTimeProcessing) {
				
				// operationIcon = 'blink';
				// operationLabel = langVar('lang_admin.config_home.database_active_checking_for_progress');
				
				// get database progress
				// showDatabaseProgress();
				
				operationIcon = 'run';
				operationLabel = 'Database is updating or building.'; //LM
			}
			else {
				
				// real time mode
				operationIcon = 'run';
				operationLabel = langVar('lang_admin.config_home.database_is_building_updating');
			}
		}
		else {
			
			operationIcon = 'stop';
			operationLabel = langVar('lang_admin.config_home.none_no_database_or_snapon_active');
		}
		
		util.showE('profile_info:db_build_details_section', showDatabaseBuildDetails);
		util.showE('profile_info:db_no_build_info_section', showNoDatabaseBuildInfo);
		setCurrentOperation(operationIcon, operationLabel);
	}
	
	function updateLogFormatInfo(dat) {
		
		var isStandaloneLogFormat = (dat.logFormat.label != null);
		
		function addLabels(theFormat, elementId) {
			
			var mainLabel = theFormat.label;
			util.updateT(elementId, mainLabel);
			
			if (theFormat.infoLabels != null) {
				
				// add one or more info labels in a lighter color
				var infoLabels = theFormat.infoLabels;
				infoLabels.sort();
				
				var element = util.getE(elementId);
				
				for (var i = 0; i < infoLabels.length; i++) {
					
					var br = util.createE('br');
					var span = util.createE('span', {color:'#666666'});
					var text = util.createT('- ' + infoLabels[i]);
					util.chainE([element, br, [span, text]]);
				}
			}
		}
		
		if (isStandaloneLogFormat) {
			
			addLabels(dat.logFormat, 'profile_info:log_format');
		}
		else {
			addLabels(dat.syslogFormat, 'profile_info:syslog_format');
			addLabels(dat.syslogRequiredFormat, 'profile_info:syslog_required_format');
		};
		
		util.showE('profile_info:log_format:tr', isStandaloneLogFormat);
		util.showE(['profile_info:syslog_format:tr', 'profile_info:syslog_required_format:tr'], !isStandaloneLogFormat);
	}

	function setCurrentOperation(operationIcon, operationLabel) {
		
		// operationIcon is: stop | blink | run
		
		util.hideE([
			'profile_info:progress_animation_stop',
			'profile_info:progress_animation_blink',
			'profile_info:progress_animation_run'
		]);
		
		if (operationIcon == 'stop') {
			util.showE('profile_info:progress_animation_stop');
		}
		else if (operationIcon == 'blink') {
			util.showE('profile_info:progress_animation_blink');
		}
		else {
			util.showE('profile_info:progress_animation_run');
		}
		
		util.updateT('profile_info:current_operation_text', operationLabel);
		util.showE('profile_info:current_operation_section');
	}
	
	
	//
	// Return global properties and methods
	//
	
	return {
		updateProfileInfo: updateProfileInfo
		// getIsUpToDateProfileInfo: getIsUpToDateProfileInfo
	}
}();
	
