//
// logFilterLists.js
//

var logFilterLists = {
	
	// Note, we maintain three different lists,
	// one per if, then and else statemenets
	
	moveControl: null,
	// list: null,
	
	conditions: null,
	actions: null,
	alternativeActions: null,
	
	// We track active list selection in selectedItemIndexes object so that we know if we need to deselect other lists
	// (only one of the three lists can have a selected row)
	selectedItemIndexes: {
		// Use list name for selectedItemIndexes properties!
		conditions: -1,
		actions: -1,
		alternativeActions: -1
	},
	
	// Track the number of conditionItems and actionItems so that we know
	// when to enable/disable the New Alternative Action button
	numberOfItems: {
		// Use list name for numberOfItems properties!
		conditions: 0,
		actions: 0,
		alternativeActions: 0
	},
	
	init: function() {
		
		//
		// Create the list objects
		//
		
		logFilterLists.moveControl = new util.MoveControl('log_filters:structured:move_control', logFilterLists.moveItem);

		var conditionsObj = {
			name: 'conditions',
			tbodyElementId: 'log_filters:structured:conditions:tbody',
			noItemText: '',
			isDefaultItem: false,
			customSequence: logFilters.sequenceLettersDb,
			listChangeNotificationFunction: logFilterLists.listChangeNotification,
			editItemFunction: logFilterCondition.editItem,
			duplicateItemFunction: logFilterCondition.duplicateItem,
			labelBuilderFunction: logFilterCondition.labelBuilder
		};
		
		var actionsObj = {
			name: 'actions',
			tbodyElementId: 'log_filters:structured:actions:tbody',
			noItemText: '',
			isDefaultItem: false,
			listChangeNotificationFunction: logFilterLists.listChangeNotification,
			editItemFunction: logFilterAction.editActionItem,
			duplicateItemFunction: logFilterAction.duplicateActionItem,
			labelBuilderFunction: logFilterAction.actionLabelBuilder
		};
		
		var alternativeActionsObj = {
			name: 'alternativeActions',
			tbodyElementId: 'log_filters:structured:alternative_actions:tbody',
			noItemText: '',
			isDefaultItem: false,
			listChangeNotificationFunction: logFilterLists.listChangeNotification,
			editItemFunction: logFilterAction.editAlternativeActionItem,
			duplicateItemFunction: logFilterAction.duplicateAlternativeActionItem,
			labelBuilderFunction: logFilterAction.alternativeActionLabelBuilder
		};
		
		logFilterLists.conditions = new listcontrollerB.List(conditionsObj);
		logFilterLists.actions = new listcontrollerB.List(actionsObj);
		logFilterLists.alternativeActions = new listcontrollerB.List(alternativeActionsObj);
	},
	
	reset: function() {
		
		// Called upon updateForm() in logFilters.js
		// Reset selectedItemIndex object
		var obj = logFilterLists.selectedItemIndexes;
		obj.conditions = -1;
		obj.actions = -1;
		obj.alternativeActions = -1;
		
		// Reset numberOfItems object
		var obj2 = logFilterLists.numberOfItems;
		obj2.conditions = 0;
		obj2.actions = 0;
		obj2.alternativeActions = 0;
	},
	
	listChangeNotification: function(listName, selectedItemIndex, numberOfItems) {
		
		// alert('logFilterLists.listChangeNotification()\nlistName: ' + listName + '\nselectedItemIndex: ' + selectedItemIndex + '\nnumberOfItems: ' + numberOfItems);
		
		// Called from wide item list controller upon list change

		//
		// Check if the selection state changed
		//
		
		var indexes = logFilterLists.selectedItemIndexes;
		
		if (indexes[listName] != selectedItemIndex) {
			
			// Selection state changed, we need to
			// a.) Update the button state
			// b.) Deselect any other list item if selected and if current selectedItemIndex is > -1
			
			if (selectedItemIndex > -1) {
				
				// Deselect any selected row in other lists
				for (var prop in indexes) {
					
					if (prop != listName && indexes[prop] > -1) {
						
						// alert('call deselectRowTEMP() for list: ' + prop);
						
						logFilterLists[prop].deselectRow();
						indexes[prop] = -1;
					}
				}
			}
			
			// alert('We set moveControl button State' + '\nlistName: ' + listName + '\nselectedItemIndex: ' + selectedItemIndex + '\nnumberOfItems: ' + numberOfItems);

			// Set button state of move control for current item
			logFilterLists.moveControl.setState(selectedItemIndex, numberOfItems);
		}
		
	
		// Update selectedItemIndexes
		indexes[listName] = selectedItemIndex;
		
		// Update numberOfItems
		logFilterLists.numberOfItems[listName] = numberOfItems;
		
		
		//
		// Enable/Disable New Alternative Action button
		//
		
		var numberOfConditions = logFilterLists.numberOfItems.conditions;
		var numberOfActions = logFilterLists.numberOfItems.actions;
		var numberOfAlternativeActions = logFilterLists.numberOfItems.alternativeActions;
		
		var allowAddingAlternativeActions = (numberOfConditions > 0 && numberOfActions > 0);
		logFilters.newAlternativeActionBtn.enable(allowAddingAlternativeActions);
		
		//
		// Display no item info
		//
		
		var showNoItemInfo = (numberOfConditions == 0 && numberOfActions == 0 && numberOfAlternativeActions == 0);
		util.showE('log_filters:structured:list:no_items_info', showNoItemInfo);
		
		
		//
		// Reset error display
		//
		
		util.hideE('log_filters:structured:error');
		
		//
		// Update boolean operator display
		//
		if (listName == 'conditions') {
			// Show/hide boolean operator display depending on number of conditions
			logFiltersUtil.boolOperator.setSectionDisplay(numberOfItems);
		}
		
		// util.showObject(indexes);
	},
	
	moveItem: function(direction) {
		
		// Invoked from moveControl
		// var direction = logFilterLists.moveControl.getMoveDirection(this.id);
		
		// Move item in list
		var indexs = logFilterLists.selectedItemIndexes;
		
		for (var prop in indexs) {
			
			if (indexs[prop] != -1) {
				logFilterLists[prop].moveItem(direction);
				break;
			}
		}
	}
};


