//
// log source
//


var theList;
var itemsDb = [];  // items work array
var itemsDbBackup = []; // items array in the state when first loaded or last saved, it is used upon Undo Changes


var validator = new util.Validator();

var logSource = {
	
	saveChangesBtn: null,
	newItemBtn: null,
	deleteBtn: null,
	duplicateBtn: null,
	undoAllChangesBtn: null,
	isEditPermission: false
}

function init() {
	
	var YE = YAHOO.util.Event;
	
	var permissions = pageInfo.permissions;
	var isEdit = permissions.isEdit;
	var isAdd = permissions.isAdd;
	var isDelete = permissions.isDelete;
	
	// init toolbar buttons
	logSource.saveChangesBtn = new util.ToolbarButton('save_changes', saveChanges, toolbarButtonsDb);		
	logSource.newItemBtn = new util.ToolbarButton('new_log_source', newItem, toolbarButtonsDb);
	logSource.duplicateBtn = new util.ToolbarButton('duplicate', duplicateItem, toolbarButtonsDb);
	logSource.deleteBtn = new util.ToolbarButton('delete', deleteItem, toolbarButtonsDb);
	logSource.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
	
	var permissions = pageInfo.permissions;

	if (permissions.isEdit) {
		
		if (!permissions.isAdd) {
			logSource.newItemBtn.disableAndIgnore();
			logSource.duplicateBtn.disableAndIgnore();
		}
		
		if (!permissions.isDelete) {
			logSource.deleteBtn.disableAndIgnore();
		}
		
		// Register isModifiedPageHandler in adminConfig.js
		// (We don't check for modifications if there is no edit 
		// permission because there is no Save button anyway!)
		adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
	}
	else {
		
		logSource.saveChangesBtn.disableAndIgnore();
		logSource.newItemBtn.disableAndIgnore();
		logSource.duplicateBtn.disableAndIgnore();
		logSource.deleteBtn.disableAndIgnore();
		logSource.undoAllChangesBtn.disableAndIgnore();
	}
	
	//
	// Create theList object
	//
	
	theList = new listcontroller.List({
		containerElementId: 'item_list_body',
		itemEvent: itemActivated,
		isSwitch1: true,
		isMoveControl: true
	});
	
	
	//
	// misc
	//
	
	YE.addListener('log_source:label', 'blur', updateFormLabel);
	YE.addListener('log_source:show_matching_files_btn', 'click', showMatchingFiles);
	
	// Init and log_source
	var isConfig = true;
	var isLite = (pageInfo.licensingTier == 'lite');
	logSourceUtil.init(isLite, isConfig);
	
	// init OptionInfo
	optionInfo.init();
}

function initItemList() {
	
	theList.init(itemsDb);
	
	// select the first item
	var firstItemId = theList.getFirstItemId();
	setItem(firstItemId);
}

function getLogSourceData() {
	
	if (!pageInfo.exitActive) {

		var url = '?dp=config_pages.log_source.get_data';
		url += '&p=' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		
		util.helpWindow.init('');
		util.serverPost(url, dat);
	}
}

function getLogSourceDataResponse(dat) {
	
	if (!pageInfo.exitActive) {
		itemsDb = dat;
		itemsDbBackup = util.cloneObject(dat);

		// util.showObject(dat);
		
		init();
		initItemList();
		
		// Set final toolbar state
		logSource.saveChangesBtn.enable();
		logSource.undoAllChangesBtn.enable();
		logSource.newItemBtn.enable();
		logSource.duplicateBtn.enable();
		
		util.showE('form_section');
		// IE 7 the form_section to be displayed for setItemListSize()
		adminConfig.setItemListSize();
		YAHOO.util.Event.addListener(window, 'resize', adminConfig.setItemListSize);
		pageInfo.initComplete = true;
	}
}

function itemActivated(itemId) {
	
	if (validateActiveItem()) {
		setItem(itemId);
	}
}

function setItem(itemId) {
	
	matchingFiles.closePanel();
	
	// Select active item in list and displays the form	
	theList.selectItem(itemId);
	
	updateForm(itemId);
	
	// Set delete button
	var makeEnabled = (theList.getNumberOfItems() > 1);
	logSource.deleteBtn.enable(makeEnabled);
}

function newItem() {
	
	if (validateActiveItem()) {
	
		var newItemId = theList.getNewItemId();
		var label = langVar('lang_admin.general.new_log_source');
		
		var newLogSource = {
			id: newItemId,
			type: '',
			switch1: true,
			label: label,
			dat: {
				label: label,
				type: 'local',
				pathname: '',
				file_mask: '',
				pattern_is_regular_expression: false,
				process_subdirectories: false
			}
		}
		
		theList.newItem(newLogSource);
		
		setItem(newItemId);
	}
}

function duplicateItem() {
		
	if (validateActiveItem()) {

		var clonedItemId = theList.cloneItem();
		setItem(clonedItemId);
	}
}

function deleteItem() {
	
	var nextItemIdToBeSelected = theList.deleteItem();
	validator.reset();
	setItem(nextItemIdToBeSelected);
}


function updateForm(itemId) {
	
	util.resetF('log_source_form');
	
	var item = theList.getSelectedItem();
	var itemDat = item.dat;
	
	logSourceUtil.updateForm(itemDat);
	
	// Set display
	logSourceUtil.setLogSourceDisplay();
}

function updateFormLabel() {
		
	var item = theList.getSelectedItem();
	var itemLabel = item.dat.label;
	var formFieldLabel = util.getF('log_source:label');

	if (itemLabel != formFieldLabel) {
		// update item list label and form label
		// util.updateT('item_form_label', formFieldLabel);
		theList.updateListLabel(formFieldLabel);
	}
}

function validateActiveItem() {
	
	// Don't validate if there is no edit permission
	
	if (pageInfo.permissions.isEdit) {
	
		validator.reset();

		var obj = logSourceUtil.getValidatedLogSourceObject(validator);
	
		if (validator.allValid()) {
			theList.saveItem(obj);
			return true;
		}
		
		return false;
	}
	
	// No edit permission, don't validate at all
	return true;
}

function saveChanges() {
	
	if (validateActiveItem()) {
		
		var isModified = theList.getIsModified();
		
		// alert('saveChanges() - isModified: ' + isModified);
		
		if (isModified) {
			
			var atLeastOneLogSourceActive = false;
			
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			
			for (var i = 0; i < itemsDb.length; i++) {

				var item = itemsDb[i];
				var itemDat = item.dat;
				var prop;
				
				var path = 'v.fp.source.' + i + '.';
				
				dat += path + 'position=' + i + '&';
				dat += path + 'disabled=' + !item.switch1 + '&';
				
				if (itemDat.type != 'odbc') {
					for (prop in itemDat) {
						dat += path + prop + '=' + encodeURIComponent(itemDat[prop]) + '&';
					}
				}
				else {
					// odbc log source
					dat += path + 'label=' + encodeURIComponent(itemDat.label) + '&';
					dat += path + 'type=odbc&';
					dat += path + 'query=' + encodeURIComponent(itemDat.query) + '&';
					
					var serverDat = itemDat.server;
					
					for (prop in serverDat) {
						dat += path + 'server.' + prop + '=' + encodeURIComponent(serverDat[prop]) + '&';
					}
				}
				
				if (item.switch1) {atLeastOneLogSourceActive = true;}
			}
			
			dat = dat.replace(/&$/, '');
			
			if (atLeastOneLogSourceActive) {
				
				util.hideE('form_section');
				util.showE('saving_info');

				var url = '?dp=config_pages.log_source.save_data';
				url += '&p=' + pageInfo.profileName;
				
				pageInfo.saveActive = true;
				
				util.serverPost(url, dat);
			}
			else {
				
				alert(langVar('lang_admin.log_source.no_log_source_active'));
			}
		}
		else {
			
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	}
}

function saveChangesResponse() {
	
	// reset isModified
	theList.resetIsModified();
	
	// the saved work itemsDb becomes now the itemsDbBackup
	itemsDbBackup = util.cloneObject(itemsDb);
	
	pageInfo.saveActive = false;
	
	util.hideE('saving_info');
	util.showE('form_section');
}

function undoAllChanges() {
	
	itemsDb = util.cloneObject(itemsDbBackup);
	initItemList();
	validator.reset();
}

function getIsModifiedPage() {
	
	if (!validateActiveItem() || theList.getIsModified()) {
		return true;
	}
	return false;
}


/*
	Show matching files
*/


function showMatchingFiles() {
	
	if (validateActiveItem()) {
		
		matchingFiles.openPanel();
		
		var item = theList.getSelectedItem();
		var itemDat = item.dat;
		var itemValue;

		var url = '?dp=config_pages.log_source.get_matching_files';
		url += '&p=' + pageInfo.profileName;

		var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
		var path = 'v.fp.log_source.0.';
		var pattern = /\W/; // The pattern /\W/ is equal [^a-zA-Z0-9_]
		
		// dat += path + 'type=' + item.type + '&';
		
		for (var prop in itemDat) {
			
			itemValue = itemDat[prop];
			
			if (pattern.test(itemValue)) {
				itemValue = encodeURIComponent(itemValue);
			}
			
			dat += path + prop + '=' + itemValue + '&';
		}
		
		dat = dat.replace(/&$/, '');
		
		util.serverPost(url, dat);
	}
}

function showMatchingFilesResponse(dat) {
	
	matchingFiles.showFiles(dat);
}
