//
//
// reportElement.js (Report Element Editor)
//
//

var reportElement = {
	
	panel: null,
	
	// tabs: null, // KHP 20/Oct/2008 - add new general tab items
	// tabIds: ['display_options', 'filters', 'header_footer'], // KHP 20/Oct/2008 - add new general tab items
	// tabPanelIds: [], // generated upon init // KHP 20/Oct/2008 - add new general tab items
	
	// validator: null,
	
	// Customize report element objects
	// graphs: null,
	// graphOptions: null,
	// tableColumns: null,
	// tableOptions: null,
	// pivotTable: null,
	
	// defaultColumnsDb
	// Created upon init, it contains the default columns per report element type.
	// The default columns are cloned to activeReportElement.types by initActiveReportElementDbs()
	
	defaultColumnsDb: {
		overview: [],
		table: [],
		log_detail: []
	},
	
	
	//
	//
	// Active form parameters
	//
	//
	
	mode: '', // the active mode of an item is: new | edit | duplicate (We need to know the mode when saving the item back to the listcontrollerB
	itemIndex: 0, // refers to the active item index in listcontrollerB items array, respectively to the active row index

	labelOri: '',
	activeMetaType: '',
	activeReportElementType: '',
	activeReportElementDbs: {},
	activeDisplay: '', // '' | graphs | table | graphs_and_table
	
	activeGraphsDb: {}, // contains the active graphs object (default graphs overriden by any report element graphs data)
			  	// graphsDb is used by 'graphs' and 'graphOptions'!


	/*
	activeReportElementDbs: { // initialized via initActiveReportElementDbs()
		
		overview: {},
		table: {},
		log_detail: {},
		...

		activeReportElementDbs keeps the active reportElementDb per report element type.
		So if we switch between table and log_detail we are able to maintain state between
		different report element types. If we change i.e. a table report element from file_type to
		page_directory then we only replace the report field and the first column
		of the active "table" types and then update the Customize Report Element objects accordingly.
	},
	*/
	
	
	// newItemObj is used for common properties
	// upon New Report Element or when editing an empty Report Element object
	
	newItemObj: {
		
		// Set common properties only so that
		// we can set/reset the initial form values
		// which are not covered by Customize Report Element objects
		label: langVar('lang_admin.report_editor.new_report_element'),
		label_ori: '',
		compact_view: '',
		display_side_by_side: false,
		show_header_bar: false,
		report_link: '',
		type: '',
		description: '',
		header:'',
		footer: '',
		date_filter: '',
		filter_expression: '',
		table_filter_expression: '',
		show_graphs: true,
		show_table: true
	},
	
	init: function() {
		
		//
		// Init the Editor panel
		//
		
		var panelObj = {
			panelId: 'ree:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 330,
			top: 120,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: reportElement.closePanel
		};
		
		reportElement.panel = new util.Panel3(panelObj);
		
		// Create report element meta types list
		util.populateSelect('ree:report_element_meta_type', [{name:'', label:langVar('lang_admin.report_editor.select_report_element_type')}], 'name', 'label');
		util.extendSelect('ree:report_element_meta_type', reports.reportElementMetaTypesDb, 'name', 'label');
		
		
		//
		// Init Customize Report Element object
		//
		var isCustomizeInReports = false;
		var isPivotTablePermission = true; // is always true in Config
		var isGraphOptionsPermission = true; // is always true in Config
		
		var hideLogDetailSortingMessage = pageInfo.hideLogDetailSortingMessage;
		
		creControl.initCreObject(
			reports.queryFieldsDb,
			reports.defaultGraphsDb,
			isCustomizeInReports,
			isPivotTablePermission,
			isGraphOptionsPermission,
			hideLogDetailSortingMessage
		);
				
			
		//
		// Add events
		//
		
		var YE = YAHOO.util.Event;
		YE.addListener('ree:report_element_meta_type', 'change', reportElement.display.metaTypeActor);
		YE.addListener('ree:report_element_display', 'change', reportElement.display.reportElementDisplayActor);
		YE.addListener('ree:okay_btn', 'click', reportElement.saveItem);
		YE.addListener('ree:cancel_btn', 'click', reportElement.closePanel);
		
		//
		// Create default column objects
		//
		
		reportElement.defaultColsUtil.create();


		// Create a reports list for the
		reportElement.updateReportLinkList();
	},
	
	display: {
		
		//
		//
		// Main display
		//
		//
		
		/*
		tabActivated: function(tabId) {
			
			alert('tabId: ' + tabId);
			
			if (!util.isObject(tabId)) { // isObject has be addded due an IE problem as described in creControl.js!
				reportElement.display.setTabPanel(tabId);
			}
		},
		
		setTabPanel: function(tabId) {
			
			util.hideE(reportElement.tabPanelIds);
			
			if (tabId != '') {
				reportElement.tabs.setActiveTab(tabId);
				util.showE('ree:' + tabId + ':panel');
			}
		},
		*/
		
		//
		//
		// Report Element meta type
		//
		//
		
		metaTypeActor: function() {
			
			var metaType = util.getF('ree:report_element_meta_type');
			reportElement.display.setMetaType(metaType);
		},
		
		setMetaType: function(metaType) {
			
			// alert('setMetaType() - metaType: ' + metaType);
            // util.showObject(reports.reportElementMetaTypesDb);
			
			if (reportElement.activeMetaType != '') {

				// Save current data to Customize Report Element objects because
				// the customize report element objects become re-initialized.
				creControl.saveChanges();
			}
			
			var reportElementType = '';
			
			var reportElementDisplay = '';
			var enableReportElementDisplayList;
			// var showTableFilterExpression = false;
			
			if (metaType != '') {
				
				showCreObjectPanel = true;

                // util.showObject({metaType:metaType});
                // util.showObject(reports.reportElementMetaTypesDb);
				
				var metaTypeItem = reports.reportElementMetaTypesDb[util.h(metaType)];
				reportElementType = metaTypeItem.type;
				
				// alert('reportElementType: ' + reportElementType);
				
				var reportElementDb = reportElement.activeReportElementDbs[reportElementType];
				
				// util.showObject(reportElementDb);
				
				if (reportElementType == 'table') {
					
					//
					// We need to update the default reportElementDb
					//
					
					var reportFieldName = metaTypeItem.name;
					
					reportElement.display.setMainColumn(reportElementDb, reportFieldName); 
					
					//
					// Check default reportElementDisplay
					//
					
					var showGraphs = reportElementDb.show_graphs;
					var showTable = reportElementDb.show_table;
					
					if (showGraphs && showTable) {
						reportElementDisplay = 'graphs_and_table';
					}
					else if (showGraphs) {
						reportElementDisplay = 'graphs';
					}
					else {
						reportElementDisplay = 'table';
					}
					
					enableReportElementDisplayList = true;
				}
				else {
					
					reportElementDisplay = 'table';
					enableReportElementDisplayList = false;
				}
				
				//
				// Update the Customize Report Element object
				//
				
				var obj = {}; // no obj paramters are required upon init() in Config, so we specify an empty object
				creControl.init(reportElementDb, obj);
			}
			else {
				
				// No meta type is selected
				reportElementDisplay = 'table';
				enableReportElementDisplayList = false;
				showCreObjectPanel = false;
				
				// Update the tab sequence because we don't init a reportElementDb
				creControl.updateTabSequence();
			}
			
			reportElement.activeMetaType = metaType;
			reportElement.activeReportElementType = reportElementType;
						
			util.setF('ree:report_element_display', reportElementDisplay);
			util.enableE('ree:report_element_display', enableReportElementDisplayList);
			
			//util.showE('ree:table_filter_expression:section', showTableFilterExpression);
			
			util.hideE('ree:no_report_element_selceted'); // hides the no report element selected error message
			
			util.showEV('ree:customize_report_element:object', showCreObjectPanel);
		},
		
		updateMetaTypeList: function(reportFieldName) {
			
			// Called from Manage Fields if report element is of type table.
			// This updates the meta type so that it displays the name of
			// the first text column.
			util.setF('ree:report_element_meta_type', reportFieldName);
		},
		
		setMainColumn: function(reportElementDb, reportFieldName) {
			
			// This sets the report field of the main column by considering corrupted 
			// report elements where the main column is not the first column.
			
			// reportElementDb.columns[0].report_field = reportFieldName;
			
			var columns = reportElementDb.columns;
			var firstColumn = columns[0];
			
			// util.showObject(firstColumn, 'firstColumn');
			
			if (firstColumn.report_field != reportFieldName) {
				
				var i;
			
				if (firstColumn.report_field == '') {
					
					// Report field is not yet set, set first column now.
					
					firstColumn.report_field = reportFieldName;
					
					// Make sure that the set report_field does not exist in any other column.
					// We don't check the set 1st column, so i = 1
					for (i = 1; i < columns.length; i++) {
						
						if (columns[i].report_field == reportFieldName) {
							// Remove the column
							columns.splice(i, 1);
                            i--; // re-adjusts array index after delete
						}
					}
				}
				else {
										
					// Check if a column with the report field name already exists
					var reportFieldNameExists = false;
					
					for (i = 1; i < columns.length; i++) {
						
						if (columns[i].report_field == reportFieldName) {
							reportFieldNameExists = true;
							break;
						}
					}
					
					// Set reportFieldName in 1st column if it doesn't exist in other column
					if (!reportFieldNameExists) {
						firstColumn.report_field = reportFieldName;
					}
				}
			}
		},
		
		//
		//
		// Report Element display (graphs, table or graphs_and_table)
		//
		//
		
		reportElementDisplayActor: function() {
			
			// Update the active reportElementDb.show_graphs and reportElementDb.show_table property
			// and update the tab squence
			
			var reportElementDisplay = util.getF('ree:report_element_display');
			var showGraphs = false;
			var showTable = false;
			
			switch (reportElementDisplay) {
				case 'graphs':
					showGraphs = true;
					break;
				case 'table':
					showTable = true;
					break;
				case 'graphs_and_table':
					showGraphs = true;
					showTable = true;
					break;
			}
			
			var reportElementType = reportElement.activeReportElementType;
			var reportElementDb = reportElement.activeReportElementDbs[reportElementType];
			
			reportElementDb.show_graphs = showGraphs;
			reportElementDb.show_table = showTable;
			
			creControl.updateTabSequence();
			
			if (showGraphs) {
				// We need to save and re-init the graph options
				// because graphs sorting depends if a table is displayed or not.
				creControl.saveAndReInitGraphOptions();
			}
		}
	},
	
	newItem: function() {
		// invoked from report.js
		reportElement.mode = 'new';
		
		var newItemObj = util.cloneObject(reportElement.newItemObj);
		reportElement.initForm(newItemObj);
	},
	
	editItem: function(itemIndex, item) {
		
		// invoked from listcontrollerB
		reportElement.mode = 'edit';
		reportElement.itemIndex = itemIndex;
		
		// If there is no item yet then create one now.
		if (!item.type) {
			item = util.cloneObject(reportElement.newItemObj);
		}
		
		// util.showObject(item);
		
		// alert('editItem with itemIndex: ' + itemIndex);
		reportElement.initForm(item);
	},
	
	duplicateItem: function(itemIndex, item) {
		
		// invoked from listcontrollerB
		// itemIndex is the index of the item we duplicate!
		// item is the original item, so don't modify object parameters such as label
		
		reportElement.mode = 'duplicate';
		reportElement.itemIndex = itemIndex;
		
		// var label = item.label;
		// item.label = label + ' ' + langVar('lang_stats.general.copy');
		var oriLabel = item.label;
		var newlabel = langVar('lang_stats.general.item_copy');
		newlabel = newlabel.replace(/__PARAM__1/, oriLabel);
		item.label = newlabel;
		
		// alert('editItem with itemIndex: ' + itemIndex);
		reportElement.initForm(item);
	},
	
	openPanel: function() {
		
		var mode = reportElement.mode;
		var panelLabel = '';
		
		if (mode == 'new') {
			panelLabel = langVar('lang_admin.report_editor.new_report_element');
		}
		else if (mode == 'edit') {
			panelLabel = langVar('lang_admin.report_editor.edit_report_element');
		}
		else {
			panelLabel = langVar('lang_admin.report_editor.edit_duplicated_report_element');
		}
		
		reportElement.panel.open({label:panelLabel});
	},
	
	closePanel: function() {
		
		reportElement.panel.close();
	},
	
	initForm: function(reportElementDb) {
		
		// util.showObject(reportElementDb);
		
		// Reset
		reportElement.labelOri = reportElementDb.label_ori;
		reportElement.activeMetaType = '';
		reportElement.activeReportElementType = '';
		
		// 
		// Initialize reportElementDbs
		//
	
		reportElement.initActiveReportElementDbs(reportElementDb);
		
		//
		//
		// Update form data which are not covered by Customize Report Element Objects
		//
		//
		
		util.setF('ree:report_element_label', reportElementDb.label);

		
		//
		// 
		// Set metaType which handles the Customize Report Element Objects
		//
		//
		
		var metaType = '';
		var reportElementType = reportElementDb.type;		
		
		// Before we set the metaType init the general and filters tab (they are not handled within creControl by metaType!)
		creGeneral.updateForm(reportElementDb);
		creFilters.updateForm(reportElementDb);
		
		if (reportElementType != '') {
			
			if (reportElementType == 'table') {
				// metaType = reportElementDb.report_field;
				metaType = reportElement.getMetaTypeOfTableReportElement(reportElementDb.columns);
			}
			else {
				metaType = '__RET__' + reportElementType;
			}
		}
		
		util.setF('ree:report_element_meta_type', metaType);
		
		reportElement.display.setMetaType(metaType); // --> this handles creControl.init()
		
		
		//
		// Open the panel
		//
		
		reportElement.openPanel();
	},

	
	saveItem: function() {
		
		var metaType = reportElement.activeMetaType;
		
		if (metaType != '') {
			
			// Save Customize Report Element object
			creControl.saveChanges();
			
			var reportElementType = reportElement.activeReportElementType;
			
			// Validate session fields of session reports
			if (reportElementType == 'sessions_overview' ||
				reportElementType == 'session_paths' ||
				reportElementType == 'session_page_paths') {
			
				if (!creSessionFields.getAllFieldsValid()) {
					// Activate session fields tab
					creControl.setTabPanel('session_fields');
					return false;
				}
			}
			
			var reportElementDb = reportElement.activeReportElementDbs[reportElementType];
				
			// Note, reportElementDb only contains data of the Basics tab panel!
			// We create a new report element object which is saved to the report element db in listcontrollerB
			
			var obj = {};
			obj.label = util.getF('ree:report_element_label'); // Duplicate labels are allowed!
			obj.label_ori = reportElement.labelOri;
			obj.type = reportElementType;

			obj.display_side_by_side = reportElementDb.display_side_by_side;
			obj.show_header_bar = reportElementDb.show_header_bar;
			obj.report_link = reportElementDb.report_link;
			obj.description = reportElementDb.description;
			obj.header = reportElementDb.header;
			obj.footer = reportElementDb.footer;
			obj.date_filter = reportElementDb.date_filter;
			obj.filter_expression = reportElementDb.filter_expression;
			
			switch (reportElementType) {
				
                case 'table':

                    obj.number_of_rows = reportElementDb.number_of_rows;
                    obj.show_graphs = reportElementDb.show_graphs;
                    obj.show_table = reportElementDb.show_table;

					obj.display_graphs_side_by_side = reportElementDb.display_graphs_side_by_side;
//					obj.display_graphs_table_side_by_side = reportElementDb.display_graphs_table_side_by_side;
					obj.maximum_table_bar_graph_length = reportElementDb.maximum_table_bar_graph_length;

                    obj.omit_parenthesized_items = reportElementDb.omit_parenthesized_items;
                    obj.use_overview_for_totals = reportElementDb.use_overview_for_totals;

                    obj.table_filter_expression = reportElementDb.table_filter_expression;

                    obj.sort_by = reportElementDb.sort_by;
                    obj.sort_direction = reportElementDb.sort_direction;
                    obj.show_remainder_row = reportElementDb.show_remainder_row;
                    obj.show_averages_row = reportElementDb.show_averages_row;
                    obj.show_min_row = reportElementDb.show_min_row;
                    obj.show_max_row = reportElementDb.show_max_row;
                    obj.show_totals_row = reportElementDb.show_totals_row;

                    obj.graphs = util.cloneObject(reportElementDb.graphs);
                    obj.pivot_table = util.cloneObject(reportElementDb.pivot_table);

                    obj.columns =  util.cloneObject(reportElementDb.columns);

                    break;

                case 'overview':

					obj.compact_view = reportElementDb.compact_view;
                    obj.columns =  util.cloneObject(reportElementDb.columns);

                    break;

                case 'log_detail':

                    obj.number_of_rows = reportElementDb.number_of_rows;
                    obj.show_graphs = false;
                    obj.show_table = true;

                    obj.table_filter_expression = reportElementDb.table_filter_expression;

                    obj.sort_by = reportElementDb.sort_by;
                    obj.sort_direction = reportElementDb.sort_direction;
                    obj.columns =  util.cloneObject(reportElementDb.columns);

                    break;

                case 'sessions_overview':

                    obj.session_user_field = reportElementDb.session_user_field;
                    obj.session_date_time_field = reportElementDb.session_date_time_field;
                    obj.session_id_field = reportElementDb.session_id_field;
                    obj.session_duration_field =reportElementDb.session_duration_field;
                    obj.session_events_field =reportElementDb.session_events_field;
                    obj.session_entrances_field =reportElementDb.session_entrances_field;
                    obj.session_exits_field = reportElementDb.session_exits_field;

                    break;

                case 'session_paths':

                    obj.number_of_rows = reportElementDb.number_of_rows;

                    obj.session_user_field = reportElementDb.session_user_field;
                    obj.session_id_field = reportElementDb.session_id_field;
                    obj.session_sequence_number_field = reportElementDb.session_sequence_number_field;
                    obj.session_page_field = reportElementDb.session_page_field;

                    obj.number_of_rows_expanded = reportElementDb.number_of_rows_expanded;
                    obj.expand_paths_greater_than = reportElementDb.expand_paths_greater_than;

                    break;

                case 'session_page_paths':

                    obj.number_of_rows = reportElementDb.number_of_rows;

                    obj.session_date_time_field = reportElementDb.session_date_time_field;
                    obj.session_id_field = reportElementDb.session_id_field;
                    obj.session_entrances_field = reportElementDb.session_entrances_field;
                    obj.session_exits_field = reportElementDb.session_exits_field;
                    obj.session_page_field  = reportElementDb.session_page_field;

                    break;
			}
			
			// util.showObject(obj);
			
			// Save the item to the report element list (listcontrollerB handles saving the object)
			reportElementsList.list.saveItem(reportElement.mode, reportElement.itemIndex, obj);
			reportElement.closePanel();
		}
		else {
			// No report element type selected.
			// reportElement.display.setTabPanel('basics');
			util.showE('ree:no_report_element_selceted');
		}
	},
	
	labelBuilder: function(reportElementItem) {
		
		var label = '';
		
		if (reportElementItem.label != '') {
			label = reportElementItem.label;
		}
		else {
			label = '<span>' + langVar('lang_admin.report_editor.no_name_defined') + '</span>';
		}
		
		// alert('label: ' + label);
		
		return label;
	},
	
	//
	//
	//
	// Utilities
	//
	//
	//
	
	defaultColsUtil: {
		
		
		getColumnObject: function(queryFieldItem) {
			
			var column = {};
			column.report_field = queryFieldItem.name;
			column.show_column = true;
			
			if (queryFieldItem.isAggregatingField) {
				
				column.show_percent_column = false;
				column.show_bar_column = false;
				column.show_graph = false;
			}
			
			return column;
		},
		
		getOverviewColumns: function(queryFields) {
			
			var a = [];
			var numQueryFields = queryFields.length;
			
			for (var i = 0; i < numQueryFields; i++) {
				
				var item = queryFields[i];
				
				if (item.isAggregatingField) {
					a[a.length] = {report_field: item.name, show_column: true};
				}
			}

			return a;
		},
		
		getTableColumns: function(queryFields) {
						
			// We add a fake column as the first column. This column
			// becomes replaced with the actual report element report field
			
			var a = [{report_field:'', show_column:true}]; 
			
			var getColObject = reportElement.defaultColsUtil.getColumnObject;
			
			var numQueryFields = queryFields.length;
			
			for (var i = 0; i < numQueryFields; i++) {
				
				var item = queryFields[i];
				var isAggregatingField = item.isAggregatingField;
				var sessionField = item.sessionField;
				var nonDefaultSessionFields = /session_(begin|end|entrances|exits)/;
				var isNonDefaultSesssionField = nonDefaultSessionFields.test(sessionField);
				
				if (isAggregatingField && !isNonDefaultSesssionField) {
					a[a.length] = getColObject(item);
				}
			}
			
			return a;
		},
		
		getLogDetailColumns: function(queryFields) {
			
			var a = [];
			
			// KHP-RC, refine which fields are allowed in the log_detail report element.
			// For now we add most of the fields, though some are definely not allowed!
			
			var getColObject = reportElement.defaultColsUtil.getColumnObject;
			var i;
			var item;
			
			//
			// Add non-aggregating fields
			//
			
			var numQueryFields = queryFields.length;
			
			for (i = 0; i < numQueryFields; i++) {
				
				item = queryFields[i];
				if (!item.isAggregatingField && item.reportElementTypeSupport.log_detail) {
					
					a[a.length] = getColObject(item);
				}
			}
			
			//
			// Add aggregating fields
			//
			
			for (i = 0; i < numQueryFields; i++) {
				
				item = queryFields[i];
				if (item.isAggregatingField && item.reportElementTypeSupport.log_detail) {
					
					a[a.length] = getColObject(item);
				}
			}
		
			return a;
		},
	
		create: function() {
			
			var queryFields = reports.queryFieldsDb;
			var defaultColumnsDb = reportElement.defaultColumnsDb;
		
			//
			// Set default columns
			//
			
			var cols = reportElement.defaultColsUtil;
			defaultColumnsDb.overview = cols.getOverviewColumns(queryFields);
			defaultColumnsDb.table = cols.getTableColumns(queryFields);
			defaultColumnsDb.log_detail = cols.getLogDetailColumns(queryFields);
		}
	},
	
	
	createDefaultReportElementDb: function(type) {
		
		// Creates a default report element.
		// Note, although the Overview and other report elements don't have i.e.
		// a sort_by property it doesn't harm if we add it to the defaultDb
		// because the property will be simply ignored.
		// However, when we save the item object back to the report element db
		// in listcontrollerB we only save the appropriate report element options!
	
		var db = {
			label: '',
			label_ori: '',
			compact_view: false,
			display_side_by_side: false,
			show_header_bar: false,
			report_link: '',
			type: type,
			description: '',
			header:'',
			footer: '',
			omit_parenthesized_items: false,
			use_overview_for_totals: false,
			date_filter: '',
			filter_expression: '',
			table_filter_expression: '',
			// report_field: '',
			show_graphs: true,
	        show_table: true,
			display_graphs_side_by_side: true,
//			display_graphs_table_side_by_side: false,
			maximum_table_bar_graph_length: '',
			sort_by: '',
			sort_direction: '',
	        number_of_rows: 10,
	        session_user_field: '',
	        session_date_time_field: '',
	        session_id_field: '',
	        session_duration_field: '',
	        session_events_field: '',
	        session_entrances_field: '',
	        session_exits_field: '',
	        session_sequence_number_field: '',
	        session_page_field: '',
	        number_of_rows_expanded: 10,
	        expand_paths_greater_than: 100,
	        show_remainder_row: true,
	        show_averages_row: false,
	        show_min_row: false,
	        show_max_row: false,
	        show_totals_row: true,
			pivot_table: {
				show_pivot_table: false,
				report_field: '',
				sort_by: '',
				sort_direction: '',
				number_of_rows: 10,
				show_averages_row: false,
				show_min_row: false,
				show_max_row: false,
				show_totals_row: true
			}
		};
				
		if (type == 'overview' || type == 'table' || type == 'log_detail') {
			
			// Get a clone of the default columns
			db.columns = util.cloneObject(reportElement.defaultColumnsDb[type]);
		}
		
		// util.showObject(db);
		
		return db;
	},
	
	initActiveReportElementDbs: function(currentReportElementDb) {
		
		// creates default active report element Dbs, except for the given
		// currentReportElementDb which contains the data as in the
		// opened report element item.
		// currentReportElementDb is an empty object when we create
		// a new report element.
	
		var reportElementDbs = {};
		var currentReportElementType = currentReportElementDb.type;
		var reportElementTypes = [
			'overview',
			'table',
			'log_detail',
			'sessions_overview',
			'entry_pages',
			'exit_pages',
			'session_pages',
			'session_users',
			'individual_sessions',
			'session_paths',
			'session_page_paths'];
		
		// var activeReportElementCommon = reportElement.activeReportElement.common;
		// var activeReportElementTypes = reportElement.activeReportElement.types;
		
		var activeReportElementDbs = reportElement.activeReportElementDbs;
		
		for (var i = 0; i < reportElementTypes.length; i++) {
			
			var type = reportElementTypes[i];
			
			// Clean up existing data
			activeReportElementDbs[type] = {};
			
			if (type != currentReportElementType) {
				
				//
				// Create a default report element for the given report element type
				//
				
				activeReportElementDbs[type] = reportElement.createDefaultReportElementDb(type);
				
			}
			else {
				
				//
				// Clone the given report element to activeReportElement
				//
				
				activeReportElementDbs[type] = util.cloneObject(currentReportElementDb);
			}
		}
	},
	
	getMetaTypeOfTableReportElement: function(columns) {
		
		// The metaType of a table report element is the first
		// aggreagting column
		
		var i,
			j,
			metaType = '',
			queryFieldsDb = reports.queryFieldsDb,
			queryFieldItem,
			reportFieldName;
			
			for (i = 0, j = columns.length; i < j; i++) {
				reportFieldName = columns[i].report_field;
				queryFieldItem = queryFieldsDb[util.h(reportFieldName)];
				// util.showObject(queryFieldItem);
				if (!queryFieldItem.isAggregatingField) {
					metaType = reportFieldName;
					break;
				}
			}
		
		return metaType;
	},

	addToReportLinkList: function(items, newReportLinkList) {

		var maxItems = items.length,
			item,
			itemDat,
			reportName,
			reportLabel;

		for (var i = 0; i < maxItems; i++) {

			item = items[i];

			if (item.type == 'report') {

				itemDat = item.dat;
				reportName = itemDat.report_name;
				reportLabel = itemDat.label;
				newReportLinkList[newReportLinkList.length] = {name: reportName, label: reportLabel};
			}
			else {
				// This is a report group
				reportElement.addToReportLinkList(item.subitems, newReportLinkList);
			}

			itemDat = items[i].dat;
		}
	},

	updateReportLinkList: function() {

		// This updates the report_link list

		// ToDo - revise node names and labels upon report changes\
		// ToDo - add group name if duplicate labels

		function compareLabels(a, b) {
			var labelA = a.label.toLowerCase();
			var labelB = b.label.toLowerCase();
			if (labelA < labelB) {return -1}
			if (labelA > labelB) {return 1}
			return 0;
		}

		var noneLabel = '(' + langVar('lang_stats.btn.none') + ')';
		var a = [{name:'', label:noneLabel}];
		var b = [];

		reportElement.addToReportLinkList(reports.itemsDb, b);

		// Sort list by label
		b.sort(compareLabels);

		// util.showObject(b);

		util.populateSelect('cre_obj:general:report_link', a, 'name', 'label');
		util.extendSelect('cre_obj:general:report_link', b, 'name', 'label');
	}
}
