//
// reports/databaseUtil.js
//


var databaseUtil = function() {
	
	var YE = YAHOO.util.Event;
	var GD = { // General global data
		
		panel: null,
		isUpdateDatabase: false
		// isActiveSnaponOperation: false,
		// isRealTimeProcessing: false,
		// databaseIsBuilding: false
	};
	
	function init() {
		
		var panelObj = {
			panelId: 'update_build_database:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 300,
			top: 80,
			zIndex: 20,
			isCover: true,
			closeEvent: databaseUtil.closePanel
		};
		
		GD.panel = new util.Panel3(panelObj);
		
		YE.addListener('update_build_database:yes_btn', 'click', databaseUtil.startDatabaseOperation);
		YE.addListener('update_build_database:no_btn', 'click', databaseUtil.closePanel);
		YE.addListener('update_build_database:close_btn', 'click', databaseUtil.closePanel);
		YE.addListener('update_build_database:refresh_report_btn', 'click', databaseUtil.refreshReport);
	}
	
	function updateDatabase() {
		
		// alert('updateDatabase');
		GD.isUpdateDatabase = true;
		getDatabaseInfoData();
	}
	
	function buildDatabase() {
		
		// alert('buildDatabase');
		GD.isUpdateDatabase = false;
		getDatabaseInfoData()
	}
	
	function getDatabaseInfoData() {
		
		report.busyPanel.showLoading();
		
		var url = '?dp=statistics.database_info.get_db_info_data';
		url += '&p=' + reportInfo.profileName;
		var dat = 'v.fp.page_token=' + reportInfo.pageToken;
		util.serverPost(url, dat);
	}
	
	function getDatabaseInfoDataResponse(dat) {

		// util.showObject(dat);
		report.busyPanel.stop();
		
		var isActiveSnaponOperation = dat.isActiveSnaponOperation;
		var isRealTimeProcessing = dat.isRealTimeProcessing;
		var databaseIsBuilding = dat.databaseIsBuilding;
		var lastModificationTime = dat.lastModificationTime;
		
		if (GD.panel == null) {
			init();
		}
		
		// Hide all form sections
		var a = ['update_build_database:last_modified_section',
			'update_build_database:update_section',
			'update_build_database:build_section',
			'update_build_database:refresh_report_section',
			'update_build_database:snapon_active_section',
			'update_build_database:yes_no_btn_section',
			'update_build_database:close_btn_section'
		];

		util.hideE(a);
		
		var panelLabel = GD.isUpdateDatabase ? langVar('lang_stats.btn.update_database') : langVar('lang_stats.btn.build_rebuild_database');
		
		if (isActiveSnaponOperation) {
			
			util.showE('update_build_database:snapon_active_section');
			util.showE('update_build_database:close_btn_section');
		}
		else {
		
			if (lastModificationTime != '') {
				util.updateT('update_build_database:last_modified', lastModificationTime);
				util.showE('update_build_database:last_modified_section');
			}
			
			
			if ((!isRealTimeProcessing && databaseIsBuilding) ||
				(isRealTimeProcessing && GD.isUpdateDatabase)) {
			
				// Show 'Refresh report info'
				util.showE('update_build_database:refresh_report_section');
				util.showE('update_build_database:close_btn_section');
			}
			else {
				
				if (GD.isUpdateDatabase) {
					util.showE('update_build_database:update_section');
				}
				else {
					util.showE('update_build_database:build_section');
				}
				
				util.showE('update_build_database:yes_no_btn_section');
			}
		}
		
		GD.panel.open({label:panelLabel});
	}
	
	function closePanel() {
		
		GD.panel.close();
	}
	
	function refreshReport() {
		
		newReport.request();
		closePanel();
	}
	
	function startDatabaseOperation() {
		
		closePanel();
		
		var mainLabel;
		var mainInfo;
		var url;
		
		if (GD.isUpdateDatabase) {
			
			url = '?dp=update_database.start_update_database';
			operationLabel = langVar('lang_stats.database.updating_database_initiated_please_wait');
			
		}
		else {
			
			url = '?dp=build_database.start_build_database';
			operationLabel = langVar('lang_stats.database.building_database_initiated_please_wait');
		}
		
		report.busyPanel.showCustom(operationLabel);
		
		url += '&p=' + reportInfo.profileName;
		var dat = 'v.fp.client_response_function=' + 'databaseUtil.startDatabaseOperationResponse';
		
		util.serverPost(url, dat);
	}
	
	function startDatabaseOperationResponse(dat) {
		
		// util.showObject(dat);
		
		var errorMessage = dat.errorMessage;
		
		report.busyPanel.stop();
			
		if (errorMessage == '') {
			
			// We assume there is database update or build progress and request a new report
			newReport.request();
		}
		else {
			// show error message
			alert(errorMessage);
		}
	}
	
	
	//
	//
	// Return global properties and methods
	//
	//
	
	return {
		
		updateDatabase: updateDatabase,
		buildDatabase: buildDatabase,
		getDatabaseInfoDataResponse: getDatabaseInfoDataResponse,
		closePanel: closePanel,
		refreshReport: refreshReport,
		startDatabaseOperation: startDatabaseOperation,
		startDatabaseOperationResponse: startDatabaseOperationResponse
	}
	
}();


