//
// exportTable.js
//

var exportTable = {
	
	panel: null,
	// validator: null,
	reportElementName: '',
	isLogDetail: false,
	totalRows: 0,
	isUnknownTotalRows: false,
	
	csvFile: '', // Active exported csv directory path with file name (received from server)
	csvFilerefArgument: '', // The exported file string required by the C++ filref to get the actual href once the exported file exists on disk.
	taskId: '', // Active taskId (pid) of exporting process on server side
	
	init: function() {
		
		var YE = YAHOO.util.Event;
		YE.addListener('export_table:ok_btn', 'click', exportTable.startExport);
		YE.addListener('export_table:cancel_btn', 'click', exportTable.close);
		YE.addListener('export_table:close_btn', 'click', exportTable.close);
		
		var panelObj = {
			panelId:"export_table:panel",
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.export.export_table'),
			width: 500,
			zIndex: 20,
			isCover: true,
			closeEvent: exportTable.close
		};
		
		exportTable.panel = new util.Panel3(panelObj);
		exportTable.validator = new util.Validator();
	},
	
	open: function(e) {
				
		// alert('exportTable.open()');
		
		var reportElements = reportInfo.reportElements;
		
		if (exportTable.panel == null) {exportTable.init();}

		//
		// Get report element reference
		// 
	
		var elementId = e.id;
		var dat = elementId.split(':');
		var shortReportElementId = dat[0];
		
		var reportElement = reportElements[util.h(shortReportElementId)];
		var reportElementType = reportElement.reportElementType;
		var isLogDetail = reportElementType == 'log_detail';
		var isUnknownTotalRows = isLogDetail ? reportElement.isUnknownTotalRows : false;
		
		var isPivotTable = reportElement.isPivotTable;
		
		var startingRow = 0;
		var endingRow = 0;
		var totalRows = 0;
		
		if (!isPivotTable) {
			
			startingRow = reportElement.startingRow;
			endingRow = reportElement.endingRow;
			totalRows = reportElement.totalRows;
		}
		else {
			
			// Pivot table, used row numbers of flat table!
			startingRow = 1;
			endingRow = reportElement.totalRowsOfFlatTable;
			totalRows = reportElement.totalRowsOfFlatTable;
		}

		// Set global variables which are used upon export
		exportTable.reportElementName = reportElement.name;
		exportTable.isLogDetail = isLogDetail;
		exportTable.totalRows = totalRows;
		exportTable.isUnknownTotalRows = isUnknownTotalRows;

				
		//
		// Update form
		//
		
		util.hideE(['export_table:progress', 'export_table:complete']);
		util.showE('export_table:options');
		
		util.setF('export_table:rows:all_btn', true);

		var totalRowsText = '';
		if (!isUnknownTotalRows) {
			totalRowsText = '(' + totalRows + ')';
		}
		else {
			totalRowsText = '(' + langVar('lang_stats.export.unknown_total_items') + ')';
		}

		util.updateT('export_table:rows:total_info', totalRowsText);
		util.setF('export_table:rows:range_field', startingRow + '-' + endingRow);
		util.setF('export_table:export_aggregation_rows_btn', false);


		// Get panel display position
		exportTable.panel.prePositionAtCenter();
		exportTable.panel.open();
	},
	
	startExport: function() {

		// validate rows
		var totalRows = exportTable.totalRows;
		var isUnknownTotalRows = exportTable.isUnknownTotalRows;
		var startingRow;
		var endingRow;
		var export_all_rows = util.getF('export_table:rows:all_btn');
		var isValidRowNumbers = false;
		
		if (export_all_rows) {

			startingRow = 1;

			// If log_detail with isUnknownTotalRows=true then set endingRow to -1 so that all rows become exported.
			endingRow = !isUnknownTotalRows ? totalRows : -1;
			isValidRowNumbers = true;
		}
		else {
			
			// Get startingRow and endingRow
			var rangeValue = util.getF('export_table:rows:range_field');
			
			// remove white space
			rangeValue = rangeValue.replace(/\s/g, '');
			
			if (rangeValue.indexOf('-') != -1) {
				
				var rangeValueSplit = rangeValue.split('-');
				startingRow = rangeValueSplit[0];
				endingRow = rangeValueSplit[1];
			}
			else {
				// No range, treat single number as endingRow
				startingRow = 1;
				endingRow = rangeValue;
			}
			
			// Validate startingRow and endingRow
			// Ignore totalRows validation if isUnknownTotalRows=true
			if ((!isUnknownTotalRows &&
				util.isInteger(startingRow, 1, totalRows) &&
				util.isInteger(endingRow, 1, totalRows)) ||
				(isUnknownTotalRows &&
				util.isInteger(startingRow, 1) &&
				util.isInteger(endingRow, 1))) {
				
				if (parseInt(startingRow, 10) <= parseInt(endingRow, 10)) {
					isValidRowNumbers = true;
				}
			}
		}
		
		// alert('Export rows: ' + startingRow + '-' + endingRow);
		
		//
		// Check if the table with specified options has already been exported
		//
		
		if (isValidRowNumbers) {
			
			var exportActiveAggregationRows = util.getF('export_table:export_aggregation_rows_btn');
		
			util.hideE('export_table:options');
			util.showE('export_table:progress');
			
			var url = '?dp=statistics.export.export_from_gui_init';
			url += '&p=' + reportInfo.profileName;
			
			var dat = 'v.fp.page_token=' + reportInfo.pageToken + '&';
			dat += 'v.fp.report_job_id=' + reportInfo.reportJobId + '&';
			dat += 'v.fp.report_name=' + reportInfo.reportName + '&';
			dat += 'v.fp.report_element_name=' + exportTable.reportElementName + '&';
			dat += 'v.fp.starting_row=' + startingRow + '&';
			dat += 'v.fp.ending_row=' + endingRow + '&';
			dat += 'v.fp.export_active_aggregation_rows=' + exportActiveAggregationRows;
			
			util.serverPost(url, dat);
		}
		else {
			
			alert('Invalid range in number of rows.');
		}
	},
	
	startExportResponse: function(dat) {
	
		// alert('export done, csvFileHref: ' + dat.csvFileHref);
		
		exportTable.csvFile = dat.csvFile;
		exportTable.csvFilerefArgument = dat.csvFilerefArgument;
		exportTable.taskId = dat.taskId;
		
		exportTable.checkExportComplete();
	},
	
	checkExportComplete: function() {
		
		var url = '?dp=statistics.export.check_export_complete';
		url += '&p=' + reportInfo.profileName;
		
		var dat = 'v.fp.page_token=' + reportInfo.pageToken + '&';
		dat += 'v.fp.csv_file=' + exportTable.csvFile + '&';
		dat += 'v.fp.csv_fileref_argument=' + exportTable.csvFilerefArgument + '&';
		dat += 'v.fp.task_id=' + exportTable.taskId;
		
		// alert('checkExportComplete()\n' + dat);
		
		util.serverPost(url, dat);
	},
	
	checkExportCompleteResponse: function(dat) {
		
		if (dat.isComplete) {
			
			var csvFileHref = dat.csvFileHref;
			
			// alert('Export is complete, file exists!');
			
			var downloadLink = util.getE('export_table:download_link');
			downloadLink.href = dat.csvFileHref;
			util.hideE('export_table:progress');
			util.showE('export_table:complete');
		}
		else {
			// Repeat check 
			setTimeout("exportTable.checkExportComplete()", 500);
		}
	},
	
	close: function() {
		
		// exportTable.validator.reset();
		exportTable.panel.close();
	}
}
