//
// sessionPaths
//

var sessionPaths = {

	pathReferences: {}, // keeps any path reference, i.e. re0_9, re0_9_1_2, the pathReference name is the short report element ID followed by the path
	
	init: function(shortReportElementId) {
		
		// alert('sessionPaths.init()');
		
		// Build the root tree
		
		// var rootTree = _session_paths_test;
		
		var rootTree = reportInfo.sessionPaths[shortReportElementId];
		var totalRows = rootTree.totalRows;
		var endingRow = rootTree.endingRow;
		var nextPages = rootTree.nextPages;
		
		var containerElementId = shortReportElementId + ':session_paths_tree';
		var containerElement = util.getE(containerElementId);
		
		for (var i = 0; i < endingRow; i++) {
			
			var pathItemObj = nextPages[i];
			sessionPaths.createRootPageItem(shortReportElementId, containerElement, pathItemObj);
		}
		
		//
		// Add N more rows button
		//
		
		if (totalRows > endingRow) {
			sessionPaths.createRootRemainderRowItem(shortReportElementId, containerElement, totalRows - endingRow);
		}

		

	},
	
	reset: function() {
		
		// Collapse all and reset row numbers by
		// a.) removing all items in DOM
		// b.) updating the session paths tree object, set expanded=false and reset row numbers
		// c.) rebuilding the DOM via init
		
		var elementID = this.id;
		var dat = elementID.split(':');
		var shortReportElementId = dat[0];
		
		var numberOfRows = reportInfo.reportElements[util.h(shortReportElementId)].numberOfRows; // for root tree only
		
		sessionPaths.synchronizeReset(shortReportElementId, numberOfRows);
		
		var rootTree = reportInfo.sessionPaths[shortReportElementId];
		
		var containerElementId = shortReportElementId + ':session_paths_tree';
		var containerElement = util.getE(containerElementId);
		
		// Revome all items
		while (containerElement.lastChild != null) {
			var item = containerElement.lastChild;
			containerElement.removeChild(item);
		}
		
		
		sessionPaths.resetPathObject(rootTree, numberOfRows);
		sessionPaths.init(shortReportElementId);
	},
	
	resetPathObject: function(pathObject, numberOfRows) {
		
		pathObject.expanded = false;
		
		if (pathObject.nextPages != null) {
			
			var totalRows = pathObject.totalRows;
			pathObject.endingRow = (totalRows > numberOfRows) ? numberOfRows : totalRows;
			
			var nextPages = pathObject.nextPages;
			for (var i = 0; i < nextPages.length; i++) {
				sessionPaths.resetPathObject(nextPages[i], 10);
			}
		}
	},
	
	synchronizeExpanded: function(shortReportElementId, thePath, isExpanded) {
		
		var url = '?dp=statistics.session_paths.synchronize_session_paths';
		url += '&p=' + reportInfo.profileName;
		
		var dat = 'v.fp.page_token=' + reportInfo.pageToken + '&'
		dat += 'v.fp.report_element_id=' + reportInfo.reportElements[util.h(shortReportElementId)].id + '&';
		dat += 'v.fp.action=set_expanded&';
		dat += 'v.fp.the_path=' + thePath + '&';
		dat += 'v.fp.is_expanded=' + isExpanded;
	
		util.serverPost(url, dat);
	},
	
	synchronizeEndingRow: function(shortReportElementId, thePath, endingRow) {
		
		var url = '?dp=statistics.session_paths.synchronize_session_paths';
		url += '&p' + reportInfo.profileName;
		
		var dat = 'v.fp.page_token=' + reportInfo.pageToken + '&'
		dat += 'v.fp.report_element_id=' + reportInfo.reportElements[util.h(shortReportElementId)].id + '&';
		dat += 'v.fp.action=set_ending_row&';
		dat += 'v.fp.the_path=' + thePath + '&';
		dat += 'v.fp.ending_row=' + endingRow;
	
		util.serverPost(url, dat);
	},
	
	synchronizeReset: function(shortReportElementId, numberOfRows) {
		
		var url = '?dp=statistics.session_paths.synchronize_session_paths';
		url += '&p=' + reportInfo.profileName;
		
		var dat = 'v.fp.page_token=' + reportInfo.pageToken + '&'
		dat += 'v.fp.report_element_id=' + reportInfo.reportElements[util.h(shortReportElementId)].id + '&';
		dat += 'v.fp.action=reset&';
		dat += 'v.fp.number_of_rows=' + numberOfRows;
		
		util.serverPost(url, dat);
	},
	
	synchronizeResponse: function() {
		return false;
	},
	
	
	itemActivated: function(evt) {
		
		var element = evt.target || evt.srcElement;
		var elementId = element.id;
		
		if (elementId != '') {
			
			// Analyse the id
			var dat = elementId.split(':');
			var theKeyword = (dat.length >= 2) ? dat[2] : '';
			
			// alert('theKeyword: ' + theKeyword);
			
			if (theKeyword == 'tree' || theKeyword == 'add_rows') {
				
				var shortReportElementId = dat[0];
				var thePath = dat[1];
				var isRootItem = (thePath.indexOf('_') == -1) ? true : false;
				var pathInfoSplit = thePath.split('_');
				
				// alert('pathInfoSplit: ' + pathInfoSplit);
				// alert('elementId: ' + elementId);
				// alert('thePath: ' + thePath);
				
				// thePath is of format 9_12_14
				
				//
				// Check if a reference to this path already exists
				//
				
				var pathReferenceId = shortReportElementId + '_' + thePath;
				
				if (sessionPaths.pathReferences[pathReferenceId] == null) {
					
					// Get the path item object reference
					var rootTree = reportInfo.sessionPaths[shortReportElementId];
					
					if (thePath != 'root') {		
						sessionPaths.setPathReference(pathReferenceId, rootTree.nextPages, pathInfoSplit, 0);
					}
					else {
						// This is the root tree
						sessionPaths.pathReferences[pathReferenceId] = rootTree;
					}
				}
				
				// util.showObject(sessionPaths.pathReferences[pathReferenceId]);
				
				var pathItem = sessionPaths.pathReferences[pathReferenceId];
				
				if (theKeyword == 'tree') {
					
					// Expand or collapse the item
					
					if (pathItem.expanded) {
						
						// Collapse the path item and any expanded subitems
						sessionPaths.collapseItems(shortReportElementId, pathItem, thePath, isRootItem);
					}
					else {
						
						// Expand the path item
						
						// alert('Expand item');
						
						// If subitems already exist
						
						if (pathItem['nextPages'] != null) {
							
							// path item is already loaded, though check if it is also build
							
							// id="re0:9_5:_:ul"
							
							var ulId = shortReportElementId + ':' + thePath + ':_:ul';
							var ulElement = util.getE(ulId);
							
							// alert('ulElement: ' + ulElement);
							
							if (ulElement != null) {
							
								setTimeout("sessionPaths.expandCollapseSetter('" + shortReportElementId + "', '" + thePath + "', true, " + isRootItem + ")", 10);
								pathItem.expanded = true;
								sessionPaths.synchronizeExpanded(shortReportElementId, thePath, true);
							}
							else {
								
								sessionPaths.createExpandedSessionPaths(shortReportElementId, thePath, pathItem);
							}
						}
						else {
							
							//
							// Load new subitems
							//
							// alert('Load new subitems');
							
							var url = '?dp=statistics.session_paths.expand_session_paths';
							url += '&p=' + reportInfo.profileName;
							
							var reportElementId = reportInfo.reportElements[util.h(shortReportElementId)].id;
							
							var sysDat = 'v.fp.page_token=' + reportInfo.pageToken + '&';
							sysDat += 'v.fp.short_report_element_id=' + shortReportElementId + '&';
							sysDat += 'v.fp.report_element_id=' + reportElementId + '&';
							sysDat += 'v.fp.the_path=' + thePath;
							
							
							util.serverPost(url, sysDat);
						}
					}
				}
				else {
					
					// Add rows
					var numberOfRowsToAdd = parseInt(dat[3], 10);
					sessionPaths.addRows(shortReportElementId, thePath, pathItem, numberOfRowsToAdd);
				}
			}
		}
	},
	
	expandSessionPathsResponse: function(dat) {
		
		// Expand the specified path item
		
		// alert('response ok');
		// util.showObject(dat);
		
		var shortReportElementId = dat.sid;
		var thePath = dat.thePath;
		var totalRows = dat.totalRows;
		var endingRow = dat.endingRow;
		var nextPages = dat.nextPages;
				
		var pathReferenceId = shortReportElementId + '_' + thePath;
		var pathItem = sessionPaths.pathReferences[pathReferenceId];
		
		//
		// Update path item object
		//
		
		pathItem.totalRows = totalRows;
		pathItem.endingRow = endingRow;
		pathItem.nextPages = nextPages;
	
		// util.showObject(pathItem);
		
		sessionPaths.createExpandedSessionPaths(shortReportElementId, thePath, pathItem);
	},
	
	createExpandedSessionPaths: function(shortReportElementId, thePath, pathItem) {
		
		//
		// Expand/build the nextPages items
		//
		
		// util.showObject(pathItem);
		
		pathItem.expanded = true;
		
		sessionPaths.synchronizeExpanded(shortReportElementId, thePath, true);
		
		var totalRows = pathItem.totalRows;
		var endingRow = pathItem.endingRow;
		var hasRemainderRows = (totalRows > endingRow) ? true : false;
		var nextPages = pathItem.nextPages;
	
		var parentIsRootItem = (thePath.indexOf('_') == -1) ? true : false;
		var idPrefix = shortReportElementId + ':' + thePath + ':_';
		var parentId = parentIsRootItem ? idPrefix + ':div' : idPrefix + ':li';
		var parentElement = util.getE(parentId);
		
	
		// Set image to collapse state
		sessionPaths.expandCollapseImageSetter(shortReportElementId, thePath, true, parentIsRootItem);
		
		var ulElement = document.createElement('ul');
		var ulId = idPrefix + ':ul';
		ulElement.id = ulId;
		if (parentIsRootItem) {
			ulElement.className = 'root';
		}
		
		parentElement.appendChild(ulElement);
		
		//
		// Add the list item(s)
		//
		
		for (var i = 0; i < endingRow; i++) {
			
			var item = nextPages[i];
			var isLastItem = (!hasRemainderRows && (i + 1 == endingRow)) ? true : false;
			
			sessionPaths.createPageItem(shortReportElementId, ulElement, thePath, item, isLastItem);
		}
		
		//
		// Add N more rows button
		//
		
		if (hasRemainderRows) {
			
			sessionPaths.createRemainderRowItem(shortReportElementId, ulElement, thePath, totalRows - endingRow);
		}
	},
	
	collapseItems: function(shortReportElementId, pathItem, thePath, isRootItem) {
		
		// Collpase the given path item
		
		setTimeout("sessionPaths.expandCollapseSetter('" + shortReportElementId + "', '" + thePath + "', false, " + isRootItem + ")", 10)
		
		pathItem.expanded = false;
		
		sessionPaths.synchronizeExpanded(shortReportElementId, thePath, false);
				
		//
		// Collapse any expanded subitems
		//
		/*
		WE DON'T COLLAPSE ALL
		if (pathItem['nextPages'] != null) {
			
			var nextPages = pathItem['nextPages'];
			
			for (var i = 0; i < nextPages.length; i++) {
				
				var nextPathItem = nextPages[i];
				if (nextPathItem.expanded) {
					
					var nextThePath = thePath + '_' + nextPathItem.id;
					sessionPaths.collapseItems(shortReportElementId, nextPathItem, nextThePath, false, false);
				}
			}
		}
		*/
	},
	
	createRootPageItem: function(shortReportElementId, containerElement, pathItemObj) {
		
		var pathId = pathItemObj.id;
		var pageName = pathItemObj.page;
		var events = pathItemObj.events;
		
		var idPrefix = shortReportElementId + ':' + pathId;
		
		var div = document.createElement('div');
		div.id = idPrefix + ':_:div';
		div.className = 'session-paths';
		
		var img = document.createElement('img');
		img.id = idPrefix + ':tree:img';
		img.src = imgDb.spExpandRoot.src;
		img.width = 29;
		img.height = 24;
		img.alt = '';
		
		var span = document.createElement('span');
		span.id = idPrefix + ':tree:span';
		
		var YE = YAHOO.util.Event;
		YE.addListener(span, 'mouseover', sessionPaths.highlightTextOn);
		YE.addListener(span, 'mouseout', sessionPaths.highlightTextOff);
		
		var em = document.createElement('em');
		em.id = idPrefix + ':tree:em';
		
		var eventsTxt = document.createTextNode(events);
		var startedAtTxt = document.createTextNode(' ' + langVar('lang_stats.session_paths.started_at') + ' ');
		var pageTxt = document.createTextNode(pageName);
		
		em.appendChild(startedAtTxt);
		span.appendChild(eventsTxt);
		span.appendChild(em);
		span.appendChild(pageTxt);
		
		div.appendChild(img);
		div.appendChild(span);
		
		containerElement.appendChild(div);
	},
	
	createPageItem: function(shortReportElementId, ulElement, thePath, pathItemObj, isLastItem) {
		
		var YE = YAHOO.util.Event;
		var pathId = pathItemObj.id;
		var pageName = pathItemObj.page;
		var events = pathItemObj.events;
		var isExpanded = pathItemObj.expanded;
		var isExitPoint = (pageName == '_SESSION_EXIT_') ? true : false;
		
		var idPrefix = shortReportElementId + ':' + thePath + '_' + pathId;
		
		//
		// li
		//
		
		var li = document.createElement('li');
		li.id = idPrefix + ':_:li';
		if (isLastItem) {
			li.className = 'last';
		}
		
		//
		// img
		//
		
		var img = document.createElement('img');
		
		
		if (!isExitPoint) {
			
			img.id = idPrefix + ':tree:img';
			img.src = isExpanded ? imgDb.spCollapse.src : imgDb.spExpand.src;
		}
		else {
			img.src = imgDb.spExit.src;
		}
		
		img.width = 39;
		img.height = 24;
		img.alt = '';
		
		li.appendChild(img);
		
		//
		// txt
		//
		
		var span = document.createElement('span');
		var txt;
		
		if (!isExitPoint) {
			
			span.id = idPrefix + ':tree:span';
			
			var eventsTxt = document.createTextNode(events);
			
			var em = document.createElement('em');
			em.id = idPrefix + ':tree:em';
			var emTxt = document.createTextNode(' ' + langVar('lang_stats.session_paths.then_went_to') + ' ');
			
			var pageTxt = document.createTextNode(pageName);
			
			YE.addListener(span, 'mouseover', sessionPaths.highlightTextOn);
			YE.addListener(span, 'mouseout', sessionPaths.highlightTextOff);
			
			em.appendChild(emTxt);
			span.appendChild(eventsTxt);
			span.appendChild(em);
			span.appendChild(pageTxt);
			li.appendChild(span);
		}
		else {
			
			span.className = 'exit';
			txt = document.createTextNode(' ' + events + ' ' + langVar('lang_stats.session_paths.then_ended'));
			
			span.appendChild(txt);
			li.appendChild(span);
		}
		
		ulElement.appendChild(li);
	},
	
	createRootRemainderRowItem: function(shortReportElementId, container, remainderRows) {

		var div = document.createElement('div');
		// div.id = shortReportElementId + ':root:_';
		div.className = 'session-paths';
		div.style.marginLeft = '29px';
		div.style.marginTop = '8px';

		var span = document.createElement('span');
		span.id = shortReportElementId + ':root:_:span';
		// span.className = 'add-rows';
		var spanTxt = document.createTextNode(remainderRows + ' ' + langVar('lang_stats.session_paths.more_rows'));
		
		// YAHOO.util.EventaddListener(span, 'mouseover', sessionPaths.highlightTextOn);
		// YAHOO.util.Event.addListener(span, 'mouseout', sessionPaths.highlightTextOff);
			
		span.appendChild(spanTxt);
		div.appendChild(span);
		container.appendChild(div);
		
		if (remainderRows > 0) {
			
			var rowSequence = [];
			
			if (remainderRows <= 10) {
				rowSequence = [remainderRows];
			}
			else if (remainderRows <= 20) {
				rowSequence = [10, remainderRows];
			}
			else if (remainderRows <= 50) {
				rowSequence = [10, 20, remainderRows];
			}
			else if (remainderRows <= 100) {
				rowSequence = [10, 20, 50, remainderRows];
			}
			else if (remainderRows <= 200) {
				rowSequence = [10, 20, 50, 100, remainderRows];
			}
			else {
				rowSequence = [10, 20, 50, 100, 200];
			}
		
			sessionPaths.createRemainderRowButtons(shortReportElementId, div, 'root', remainderRows, rowSequence);
		}
	},
	
	createRemainderRowItem: function(shortReportElementId, ulElement, thePath, remainderRows) {
		
		var idPrefix = shortReportElementId + ':' + thePath;
		
		var li = document.createElement('li');
		li.id = idPrefix + ':_:li';
		li.className = 'last';
		
		var img = document.createElement('img');
		img.src = imgDb.spNmoreRows.src;
		img.width = 39;
		img.height = 24;
		
		var span = document.createElement('span');
		// span.className = 'add-rows';
		span.id = idPrefix + ':_:span';
		var spanTxt = document.createTextNode(remainderRows + ' ' + langVar('lang_stats.session_paths.more_rows'));
		
		// YAHOO.util.Event.addListener(span, 'mouseover', sessionPaths.highlightTextOn);
		// YAHOO.util.Event.addListener(span, 'mouseout', sessionPaths.highlightTextOff);
		
		span.appendChild(spanTxt);
		li.appendChild(img);
		li.appendChild(span);
		ulElement.appendChild(li);
		
		if (remainderRows > 0) {
			
			var rowSequence = [];
			
			if (remainderRows <= 10) {
				rowSequence = [remainderRows];
			}
			else if (remainderRows <= 20) {
				rowSequence = [10, remainderRows];
			}
			else if (remainderRows <= 50) {
				rowSequence = [10, 20, remainderRows];
			}
			else {
				rowSequence = [10, 20, 50];
			}
		
			sessionPaths.createRemainderRowButtons(shortReportElementId, li, thePath, remainderRows, rowSequence);
		}
	},
	
	createRemainderRowButtons: function(shortReportElementId, containerElement, thePath, remainderRows, rowSequence) {
		
		// Adds additional row numbers to add in braces next to the N more rows text.
		// I.e.:
		// -- 172 more rows (+50 +100 +172)
		// -- 350 more rows (+50 +100 +200)
		// The max number of rows we allow to add at once are 200!
		
		var YE = YAHOO.util.Event;
		
		var idPrefix = shortReportElementId + ':' + thePath;
		
		var emStart = document.createElement('em');
		emStart.style.marginLeft = '7px';
		var emStartTxt = document.createTextNode('(');
		emStart.appendChild(emStartTxt);
		
		containerElement.appendChild(emStart);
		
		var numberOfItems = rowSequence.length;
		
		for (var i = 0; i < numberOfItems; i++) {
			
			var numberOfRows = rowSequence[i];
			
			var span = document.createElement('span');
			span.className = 'add-rows';
			span.id = idPrefix + ':add_rows:' + numberOfRows;
			
			// Add some right space
			if (numberOfItems > 1 && ((i + 1) != numberOfItems)) {
				// span.style.paddingRight = '9px';
			}
			
			var spanTxt = document.createTextNode('+' + numberOfRows);
			
			YE.addListener(span, 'mouseover', sessionPaths.highlightTextOn);
			YE.addListener(span, 'mouseout', sessionPaths.highlightTextOff);
			
			span.appendChild(spanTxt);
			containerElement.appendChild(span);
		}
		
		var emEnd = document.createElement('em');
		var emEndTxt = document.createTextNode(')');
		emEnd.appendChild(emEndTxt);
		containerElement.appendChild(emEnd);
	},
	
	expandCollapseSetter: function(shortReportElementId, thePath, isExpanded, isRootItem) {
		
		sessionPaths.expandCollapseImageSetter(shortReportElementId, thePath, isExpanded, isRootItem);
		
		var ul_id = shortReportElementId + ':' + thePath + ':_:ul';
		util.showE(ul_id, isExpanded);
	},
	
	expandCollapseImageSetter: function(shortReportElementId, thePath, isExpanded, isRootItem) {
		
		var img_id =  shortReportElementId + ':' + thePath + ':tree:img';
		var img = util.getE(img_id);
		
		if (isExpanded) {
			img.src = isRootItem ? imgDb.spCollapseRoot.src : imgDb.spCollapse.src;
		}
		else {
			img.src = isRootItem ? imgDb.spExpandRoot.src : imgDb.spExpand.src;
		}
	},
	
	addRows: function(shortReportElementId, thePath, pathItem, numberOfRowsToAdd) {
		
		// alert('addRows()');
		
		// alert('numberOfRowsToAdd: ' + numberOfRowsToAdd);
		
		var totalRows = pathItem.totalRows;
		var endingRow = pathItem.endingRow;
		var newEndingRow = ((endingRow + numberOfRowsToAdd) <= totalRows) ? endingRow + numberOfRowsToAdd : totalRows;
		
		// Add newEndingRow property to pathItem object so that we get the value in createRows()
		pathItem.newEndingRow = newEndingRow;
		
		var nextPages = pathItem.nextPages;
		var numberOfRowsInClient = nextPages.length;
		
		if (newEndingRow > numberOfRowsInClient) {
			
			// Not all rows exist, get the missing rows(next_pages items) from the server (raw report element)
			
			var reportElementId = reportInfo.reportElements[util.h(shortReportElementId)].id;
			
			var url = '?dp=statistics.session_paths.get_session_paths_rows';
			url += '&p=' + reportInfo.profileName;
			
			var sysDat = 'v.fp.page_token=' + reportInfo.pageToken + '&';
			sysDat += 'v.fp.short_report_element_id=' + shortReportElementId + '&';
			sysDat += 'v.fp.report_element_id=' + reportElementId + '&';
			sysDat += 'v.fp.the_path=' + thePath + '&';
			sysDat += 'v.fp.starting_row=' + (numberOfRowsInClient + 1) + '&';
			sysDat += 'v.fp.ending_row=' + newEndingRow;
			
			util.serverPost(url, sysDat);
		}
		else {
			
			// Rows already exist, build the rows
			// alert('addRows(), rows already exist, build the rows');
			
			sessionPaths.createRows(shortReportElementId, thePath, pathItem);
		}
	},
	
	
	addRowsResponse: function(dat) {
		
		// alert('addRowsResponse()');
		// util.showObject(dat);
		
		var shortReportElementId = dat.sid;
		var thePath = dat.thePath;
		var pathReferenceId = shortReportElementId + '_' + thePath;
		var pathItem = sessionPaths.pathReferences[pathReferenceId];

		// Add new path items to nextPages
		var nextPages = pathItem.nextPages;
		var newNextPages = dat.nextPages;
				
		for (var i = 0; i < newNextPages.length; i++) {
			nextPages.splice(nextPages.length, 0, newNextPages[i]);
		}
		
		sessionPaths.createRows(shortReportElementId, thePath, pathItem);
	},
	
	createRows: function(shortReportElementId, thePath, pathItem) {
		
		// alert('createRows() thePath: ' + thePath);
		
		var endingRow = pathItem.endingRow;
		var totalRows = pathItem.totalRows;
		var newEndingRow = pathItem.newEndingRow;
		var hasRemainderRows = (totalRows > newEndingRow) ? true : false;
		
		pathItem.endingRow = newEndingRow;
		
		sessionPaths.synchronizeEndingRow(shortReportElementId, thePath, newEndingRow);
		
		var nextPages = pathItem.nextPages;
		
		var isRoot = (thePath == 'root') ? true : false;
		var containerId = isRoot ? shortReportElementId + ':session_paths_tree' : shortReportElementId + ':' + thePath + ':_:ul';
		var container = util.getE(containerId);
		
		//
		// Delete the N more rows button
		//
		var lastItem = container.lastChild;
		container.removeChild(lastItem);
		
		
		//
		// Add the rows
		//
		
		for (var i = endingRow; i < newEndingRow; i++) {
			
			if (!isRoot) {
				var isLastItem = (!hasRemainderRows && (i + 1 == newEndingRow)) ? true : false;
				sessionPaths.createPageItem(shortReportElementId, container, thePath, nextPages[i], isLastItem);
			}
			else {
				
				sessionPaths.createRootPageItem(shortReportElementId, container, nextPages[i]);
			}
		}
		
		if (hasRemainderRows) {
			
			var remainderRows = totalRows - newEndingRow;
			
			if (!isRoot) {
				sessionPaths.createRemainderRowItem(shortReportElementId, container, thePath, remainderRows);
			}
			else {
				sessionPaths.createRootRemainderRowItem(shortReportElementId, container, remainderRows);
			}
		}
		
		//
		// Synchronize server side
		//
		
	},
	
	setPathReference: function(pathReferenceId, nextPages, pathInfoSplit, activePathInfoIndex) {
		
		// get the pathId
		
		var pathId = pathInfoSplit[activePathInfoIndex];
		
		for (var i = 0; i < nextPages.length; i++) {
			
			var pathItem = nextPages[i];
			
			if (pathItem.id == pathId) {
				
				// Check if we need to get deeper or if we are at the end of the path
				
				if (pathInfoSplit.length == (activePathInfoIndex + 1)) {
					
					// alert('We have found the object');
					// util.showObject(pathItem);
					// Set the reference
					sessionPaths.pathReferences[pathReferenceId] = pathItem;
				}
				else {
					
					// Continue search in next level
					
					// alert('Continue Search in next level!');
					// util.showObject(pathItem.nextPages);
				
					sessionPaths.setPathReference(pathReferenceId, pathItem['nextPages'], pathInfoSplit, activePathInfoIndex + 1);
				}
			}
		}
	},
	
	highlightTextOn: function() {
		// alert('highlightTextOn: ' + this.id);
		// this.style.backgroundColor = '#EFEFEF';
		this.className = (this.className == '') ? 'highlight' : 'add-rows-highlight';
	},
	
	highlightTextOff: function() {
		// alert('highlightTextOff: ' + this.id);
		// this.style.backgroundColor = 'White';
		// this.style.backgroundColor = 'White';
		this.className = (this.className == 'highlight') ? '' : 'add-rows';
	}
}
