//
//
// standby.js
//
//


// reserved variables which are declared in html page!
// var reportInfo = {};
// var clientUrl = {};
// var lang = {};

// alert('standby loaded');

var standby = {
	
	init: function() {
	
		// Following actions can be taken:
		// - Show report progress
		// - Request a new report
		
		// The actions may be taken in sequence, i.e. Request a new report > Show report progress or Show Database progress
		
		// util.showObject(reportInfo);
		
		// Init admin drop down menu
		util.initAdminDropDownMenu();
		util.initBreadCrumbNav();
		
		var reportJobId = reportInfo.reportJobId;
		var reportTaskId = reportInfo.reportTaskId;
		
		//
		// Init progress (progress.js object)
		//
		
		progress.init({
				decimalDivider: reportInfo.decimalDivider,
				isCancelTaskPermission: reportInfo.isCancelTaskPermission,
				profileName: clientUrl.profileName,
				calleeListener: standby.progressListener
			});
		
		
		// Debug
		/*
		var s = 'standby.init() - reportInfo.reportJobId: ' + reportJobId;
		s += '\nstandby.init() - reportInfo.reportTaskId: ' + reportTaskId;
		alert(s);
		*/
		
		if (reportJobId != '' && reportTaskId != '') {
			
			// Show report progress
			// alert('Standby, show report progress');
			
			progress.startProgress({
				progressType: 'report',
				taskId: reportTaskId,
				reportJobId: reportJobId,
				mainLabel: langVar('lang_stats.progress.generating_report'),
				updateMainLabel: false,
				mainInfo: '',
				updateMainInfo: false
			});
		}
		else {
			
			// Request a new report for reportInfo.reportName or reportInfo.isCalendar and any url data specified in clientUrl
			// alert('Request report or calendar\nreportName: ' + reportInfo.reportName + '\nisCalendar: ' + reportInfo.isCalendar);
			standby.requestReport();
		}
	},
	
	progressListener: function(senderState) {
		
		// Called from progress object;
		// alert('standby.js - progressListener() - state: ' + senderState);
		
		if (senderState == 'report_progress_complete') {
			
			progress.close();
			standby.presetUrl(reportInfo.reportJobId);
		}
		else if (senderState == 'database_progress_complete' || senderState == 'database_task_not_active') {
			
			// Database progress completed or database is not anymore active, we request the report
			progress.startProgress({
				progressType: 'simple',
				taskId: '',
				reportJobId: '',
				mainLabel: langVar('lang_stats.progress.generating_report'),
				updateMainLabel: false,
				mainInfo: '',
				updateMainInfo: false
			});
			
			standby.requestReport();
		}
	},
	
	requestReport: function() {
		
		// alert('standby.request() - calls request_report.cfv');
		
		var url = '?dp=statistics.dynamic_reports.request_report';
		url += '&p=' + clientUrl.profileName;
	
		var dat = 'v.fp.page_token=' + reportInfo.pageToken;
		dat += '&v.fp.profile_name=' + clientUrl.profileName;
		dat += '&v.fp.report_name=' + reportInfo.reportName;
		dat += '&v.fp.is_calendar=' + reportInfo.isCalendar;
		dat += '&v.fp.date_filter=' + clientUrl.dateFilter;
		dat += '&v.fp.command_line_filter=' + clientUrl.commandLineFilter;
		dat += '&v.fp.command_line_filter_comment=' + clientUrl.commandLineFilterComment;
		dat += '&v.fp.filter_id=' + clientUrl.filterId;
		dat += '&v.fp.report_info_id=' + clientUrl.reportInfoId;
		dat += '&v.fp.is_update_report_info=false';
		dat += '&v.fp.caller_is_report_page=false';
		dat += '&v.fp.web_browser_session_id=' + clientUrl.webBrowserSessionId;
		dat += '&v.fp.skip_reset_row_numbers=false';
		
		util.serverPost(url, dat);
	},
	
	requestReportResponse: function(dat) {
		
		// util.showObject(dat);
		// alert('TEMP-standy.requestReportResponse() - isReadyDatabase: ' + dat.isReadyDatabase);
		
		if (clientUrl.webBrowserSessionId == '') {
			// No webBrowserSessionId exists yet, so use the one we get in request_report.cfv
			clientUrl.webBrowserSessionId = dat.webBrowserSessionId;
		}
		
		// var isRealTimeProcessing = dat.isRealTimeProcessing;
		// var databaseIsBuilding = dat.databaseIsBuilding;
		// var initialBuildDone = dat.initialBuildDone;
		
		var isReadyDatabase = dat.isReadyDatabase;
		
		/*
		alert('standby.requestReportResponse() - isRealTimeProcessing: ' + isRealTimeProcessing);
		alert('standby.requestReportResponse() - databaseIsBuilding: ' + databaseIsBuilding);
		alert('standby.requestReportResponse() - initialBuildDone: ' + initialBuildDone);
		*/
		
		// alert('standby.js - requestReportResponse() - isReadyDatabase:  ' + isReadyDatabase);
	
		// If the database is ready
		if (isReadyDatabase) {
			
			// alert('standby.requestReportResponse() --> database is ready');
						
			var reportJobId = dat.reportJobId;

			if (dat.isReadyReport) {
				
				// preset URL
				standby.presetUrl(reportJobId);
			}
			else {
				
				// Set the reportInfo.reportJobId!
				reportInfo.reportJobId = reportJobId;
				
				// Report is not ready, we show progress right away				
				progress.startProgress({
					progressType: 'report',
					taskId: dat.pid,
					reportJobId: reportJobId,
					mainLabel: 'Generating report',
					updateMainLabel: false,
					mainInfo: '',
					updateMainInfo: false
				});
			}
		}
		else {
			
			// Database is not ready, show database progress
			// alert('standby.requestReportResponse() --> progress.startDatabaseProgress()');
			progress.startProgress({
				progressType: 'database',
				mainLabel: langVar('lang_stats.database.database_operation_active'),
				updateMainLabel: true,
				mainInfo: langVar('lang_stats.progress.receiving_progress_information'),
				updateMainInfo: true
			});
		}
	},
	
	presetUrl: function(reportJobId) {
		
		var url = '?dp=statistics.dynamic_reports.preset_url';
		url += '&p=' + clientUrl.profileName;
	
		var dat = 'v.fp.page_token=' + reportInfo.pageToken;
		dat += '&v.fp.report_name=' + clientUrl.reportName;
		dat += '&v.fp.is_calendar=' + reportInfo.isCalendar;
		dat += '&v.fp.date_filter=' + encodeURIComponent(clientUrl.dateFilter);
		dat += '&v.fp.command_line_filter=' + encodeURIComponent(clientUrl.commandLineFilter);
		dat += '&v.fp.command_line_filter_comment=' + encodeURIComponent(clientUrl.commandLineFilterComment);
		dat += '&v.fp.filter_id=' + clientUrl.filterId;
		dat += '&v.fp.report_info_id=' + clientUrl.reportInfoId;
		dat += '&v.fp.report_job_id=' + reportJobId;
		dat += '&v.fp.report_task_id='; // no value required here because we are already in standby
		dat += '&v.fp.is_ready_report=true';
		dat += '&v.fp.caller_is_report_page=false';
		dat += '&v.fp.web_browser_session_id=' + clientUrl.webBrowserSessionId;
		
		util.serverPost(url, dat);
	},
	
	presetUrlResponse: function() {
		
		// alert('standby.js presetUrlResponse()');
		
		// Note, we always send the original URL to keep it in sync with the URL's in web browser history
		
		// location.reload(true); don't use reload because if there is some garbage in the URL the send URL will never match the preset URL
		
		var url = location.protocol + '//' + location.host + location.pathname + '?dp=reports';
		url += '&p=' + clientUrl.profileName;
		
		if (!reportInfo.isCalendar) {
			
			if (clientUrl.reportName != '') {
				url += '&rn=' + clientUrl.reportName;
			}
		}
		else {
			// We show the calendar
			url += '&calendar=true';
		}
		
		if (clientUrl.dateFilter != '') {
			url += '&df=' + encodeURIComponent(clientUrl.dateFilter);
		}
		
		if (clientUrl.commandLineFilter != '') {
			url += '&f=' + encodeURIComponent(clientUrl.commandLineFilter);
		}
		
		if (clientUrl.commandLineFilterComment != '') {
			url += '&fc=' + encodeURIComponent(clientUrl.commandLineFilterComment);
		}
		
		if (clientUrl.filterId != '') {
			url += '&fi=' + clientUrl.filterId;
		}
				
		if (clientUrl.reportInfoId != '') {
			url += '&rii=' + clientUrl.reportInfoId;
		}
		
		if (clientUrl.webBrowserSessionId != '') {
			url += '&wbsi=' + clientUrl.webBrowserSessionId;
		}
		
		location.href = url;
	}
}
