//
// matchingFiles
//

// This is the matchingFiles namespace
var matchingFiles = function() {
	
	var YE = YAHOO.util.Event,
        initDone = false,
        isNewProfileWizard = false,
        pageToken = '',
        profileName = '',
        cachedMatchingFilesNodeName = '',
        numberOfBuiltFiles = 0,
        numberOfMatchedFiles = 0,
        filesContainer = null,
        scrollControl = null,
        scrollResetAnim = null;



	function init() {
		
		// Set matching files panel size
		var e = util.getE('matching_files_section'),
            dd = new YAHOO.util.DD("matching_files_section"),
            attributes = {
            	scroll: {to:[0, 0]}
            };
		
		if (isNewProfileWizard) {

            pageToken = util.getF('page_token');
			e.style.top = '100px';
			e.style.left = '25%';
			e.style.width = '70%';
		}
		else {

            pageToken = pageInfo.pageToken;
            profileName = pageInfo.profileName;
			e.style.top = '310px';
			e.style.left = '210px';
			e.style.width = '600px';
		}
		
		e.style.display = 'block';
		
		YE.addListener('close_matching_files_btn', 'click', closePanel);
		
		// Handle drag drop
		dd.setHandleElId('matching_files_section:header');

        filesContainer = util.getE('matching_files_section:files');

        // Init the scrollControl
        scrollControl = new scrollUtil.Scroller('matching_files_section:body', 'matching_files_section:label_and_files', scrollingList);

        // Init scroll animation to reset scroll position to 0
        scrollResetAnim = new YAHOO.util.Scroll('matching_files_section:body', attributes, 0.1);
	}
	
	function openPanel() {
		
		if (!initDone) {
			init();
			initDone = true;
		}

		util.hideE('matching_files_section:label_and_files');
		util.showE('matching_files_section:loading');
		util.showE('matching_files_section');

		util.removeChildElements(filesContainer);
	}
	
	function openPanelFromNewProfileWizard() {
		
		isNewProfileWizard = true;
		openPanel();
	}
	
	function showFiles(dat) {

        // showFiles is called upon initial load
        // from New Profile Wizard or Log Source
        var files = dat.files,
            numberOfUnloadedFiles = 0,
            indexFrom = 0,
            indexTo = 0;

        // util.showObject(dat);
        cachedMatchingFilesNodeName = dat.cachedMatchingFilesNodeName;
        numberOfBuiltFiles = 0;
        numberOfMatchedFiles = dat.numberOfMatchedFiles;

		// Update the label
        util.updateT('matching_files_section:label', dat.label);

        // Create files
        addFiles(files, 0);

        // Automatically load more files, if any
//        console.log('showFiles - numberOfMatchedFiles: ' + numberOfMatchedFiles);
//        console.log('showFiles - numberOfBuiltFiles: ' + numberOfBuiltFiles);

        numberOfUnloadedFiles = numberOfMatchedFiles - numberOfBuiltFiles;

//        console.log('showFiles - numberOfUnloadedFiles: ' + numberOfUnloadedFiles);

        if (numberOfUnloadedFiles > 0) {

//            console.log('showFiles - LOAD ADDITIONAL FILES UPON INITIAL LOAD - NO SCROLL EVENT YET! ');

            // Start loading additional files after the first load regardless
            // of scrolling state. Load about the same number of files as already
            // loaded.

            indexFrom = numberOfBuiltFiles;

            if (numberOfUnloadedFiles < (numberOfBuiltFiles + (numberOfBuiltFiles / 2))) {
                // There are less than 1.5x of the already loaded files to load.
                // Load of them all
                indexTo = numberOfMatchedFiles - 1;
            }
            else {

                // Load just the same number of files as already loaded
                indexTo = (numberOfBuiltFiles * 2) - 1;
            }

            getCachedMatchingFiles(indexFrom, indexTo);
        }

		util.hideE('matching_files_section:loading');
        util.showE('matching_files_section:label_and_files');

         // Scroll to top
        scrollResetAnim.animate();
	}

    function addFiles(files, indexFrom) {

        // Adds a new div with the given files to the container element.
        // files only contains the loaded files from initial load or when loaded from cache.
        // Note, indexFrom is not really required, it just indicates
        // the start index from where we got the cached files, it is most useful
        // for debugging.

        // Adds files to the container Element
        var numberOfFiles = files.length,
            div = util.createE('div', {padding:0, margin:0}),
            fileNameLabel = '',
            fileNameText = null,
            br = null,
            i = 0,
            numberOfLoadedFiles = files.length;

        // Create files
        for (i = 0; i < numberOfFiles; i++) {

            fileNameLabel = files[i];

            // Debug only, this shows the actual file number
            // fileNameLabel = (indexFrom + i) + '. -- ' + fileNameLabel;

            fileNameText = document.createTextNode(fileNameLabel);

            br = document.createElement('br');
            div.appendChild(fileNameText);
            div.appendChild(br);
        }

        numberOfBuiltFiles = numberOfBuiltFiles + numberOfFiles;

        filesContainer.appendChild(div);
    }

    function getCachedMatchingFiles(indexFrom, indexTo) {

//        console.log('getCachedMatchingFiles - indexFrom: ' + indexFrom);
//        console.log('getCachedMatchingFiles - indexTo: ' + indexTo);

        var url = '?dp=util.matching_files.get_cached_matching_files',
            dat = '';

        // Show loading
        util.showE('matching_files_section:loading');

        dat = 'v.fp.page_token=' + pageToken;
        dat += '&v.fp.profile_name=' + profileName;
        dat += '&v.fp.cached_matching_files_node_name=' + cachedMatchingFilesNodeName;
        dat += '&v.fp.index_from=' + indexFrom;
        dat += '&v.fp.index_to=' + indexTo;

        util.serverPost(url, dat);
    }

    function getCachedMatchingFilesResponse(dat) {

        var indexFrom = dat.indexFrom,
            files = dat.files,
            scrollInfo = {},
            keepLoadingInfoActive = false,
            isValidCachedMatchingFilesNodeName = (dat.cachedMatchingFilesNodeName == cachedMatchingFilesNodeName),
            isValidIndexFrom = (dat.indexFrom == numberOfBuiltFiles),
            errorMsg = '';

        // util.showObject(dat);
        if (isValidCachedMatchingFilesNodeName && isValidIndexFrom) {

            // Add the files
            addFiles(files, indexFrom);

            // Activate the scrollControl if there are more files to load
            if (numberOfBuiltFiles < numberOfMatchedFiles) {

                scrollInfo = scrollControl.getScrollInfo();

                if (scrollInfo.isScrollingDown &&
                    scrollInfo.verticalScrollLevel > 80) {

                    // Load more files right away, simply call scrollingList
                    scrollingList(scrollInfo.verticalScrollLevel);
                    keepLoadingInfoActive = true;
                }
                else {
                    // Wait for scroll event to load more files
                    scrollControl.activate();
                }
            }
            else {
                // No more files to load
                scrollControl.deactivate();
            }
        }
        else {

            // An error occurred although this shouldn't be possible,
            errorMsg = 'Error in matchingFiles.getCachedMatchingFilesResponse().\n';
            errorMsg += 'is valid cachedMatchingFilesNodeName: ' + isValidCachedMatchingFilesNodeName + '\n';
            errorMsg += 'isValidIndexFrom: ' + isValidIndexFrom + '\n';
            alert(errorMsg);
        }

        // Hide loading info
        if (!keepLoadingInfoActive) {
            util.hideE('matching_files_section:loading');
        }
    }

    function scrollingList(verticalScrollLevel) {

//        console.log('scrollingList - VerticalScrollLevel: ' + verticalScrollLevel);
        // Scrolling down.
        // Get maxFiles depending on numberOfMatchedFiles and
        // verticalScrollLevel.

        var indexFrom = numberOfBuiltFiles,
            indexTo = 0,
            maxFiles = parseInt((numberOfMatchedFiles / 1000) * verticalScrollLevel);

//        console.log('scrollingList() - get files from server maxFiles: ' + maxFiles);

        if (maxFiles <= 0) {
            maxFiles = 10;
        }
        else if (maxFiles > 400) {
            maxFiles = 400;
        }

        indexTo = indexFrom + maxFiles;

        // Don't get more files than numberOfMatchedFiles
        if ((indexTo + 1) > numberOfMatchedFiles) {
            indexTo = numberOfMatchedFiles - 1;
        }

//        console.log('scrollingList() - get files from server indexFrom: ' + indexFrom);
//        console.log('scrollingList() - get files from server indexTo: ' + indexTo);

        getCachedMatchingFiles(indexFrom, indexTo);
    }
	
	function closePanel() {

		util.hideE('matching_files_section');
	}
	
	//
	//
	// Return global properties and methods
	//
	//
	
	return {
		openPanel: openPanel,
		openPanelFromNewProfileWizard: openPanelFromNewProfileWizard,
		showFiles: showFiles,
		closePanel: closePanel,
        scrollingList: scrollingList,
        getCachedMatchingFilesResponse: getCachedMatchingFilesResponse
	}
}();
