//
//
// usersUtil.js
//
//
var usersUtil = {
	//
	//
	// Access List Utilities
	//
	//
	// Element Id's used in access table rows
	// The baseId, i.e. "acc0" does not specify the row number, it is random!
	// We get the active row number by checking the rows array of tbody!
	// ":op:" within the id stands for operate, so upon click on a cell which contains :op: we do something, else not
	// <tr id="acc0:tr" --> Id of access table row
	// <td id ="acc0:op:edit_profiles" --> Edit Access with profiles tab as default
	// <td id ="acc0:op:edit_roles" --> Edit Access with roles tab as default
	// <td id ="acc0:info" --> Info cell which contains text like "(by user 2)" or ("Owned by other user")
	// <td id ="acc0:op:edit" --> Edit Access with profiles tab as default
	// <td id ="acc0:op:delete" --> Delete the access item
	accessListLinkActivated: function(evt) {
		// Note, we use the elementId to check if this is an operational button or link
		// and we use the className to check if the item is in enabled or disabled state!
		var element = evt.target || evt.srcElement;
		var elementId = element.id;
		var className = element.className;
		// alert('accessListLinkActivated - elementId: ' + elementId);
		if ((className.indexOf('disabled') == -1) && (elementId.indexOf(':op:') != -1)) {
			// alert('linkActivated - elementId: ' + elementId);
			var dat = elementId.split(':');
			var baseId = dat[0];
			var accessOperation = dat[2];
			var accessItemIndex = usersUtil.getRowNumberFromBaseId(baseId);
			// alert('accessListLinkActivated - accessItemIndex: ' + accessItemIndex);
			var activeAccess = users.activeAccess;
			//
			// Check if the user has permission to edit the item
			//
			var isPermission = (pageInfo.isRootAdmin || users.isUnlimitedGrants);
			if (!isPermission) {
				isPermission = (activeAccess[accessItemIndex].created_by_user == users.activeUserNodeName);
			}
			if (isPermission) {
				if (accessOperation != 'delete') {
					// alert('open access manager');
					var activeTabIsRoles = (accessOperation == 'edit_roles');
					var isNewAccessPair = false;
					var accessItem = util.cloneObject(activeAccess[accessItemIndex]);
					usersAM.open(accessItemIndex, accessItem, activeTabIsRoles, isNewAccessPair);
				}
				else {
					//
					// Delete item
					//
					// Delete item from activeAccess array
					activeAccess.splice(accessItemIndex, 1);
					// Delete last row (we have to update the rows anyway due delete button display, so we simply delete the last row)
					var tbody = util.getE('users:access:tbody');
					var lastTr = tbody.lastChild;
					tbody.removeChild(lastTr);
					// Update all rows
					var numberOfAccessItems = activeAccess.length;
					for (var i = 0; i < numberOfAccessItems; i++) {
						usersUtil.updateAccessRow(i, activeAccess[i], numberOfAccessItems);
					}
				}
			}
			else {
				alert(langVar('lang_admin.users.no_permission_msg'));
			}
		}
	},
	hoverAccessListItem: function(evt) {
		var element = evt.target || evt.srcElement;
		var elementId = element.id;
		var className = element.className;
		// Note, we use the elementId to check if this is an operational button or link
		// and we use the className to check if the item is in enabled or disabled state!
		// Hover off upon mouseout must be always possible, even if disabled because
		// it possible that we accidently hover a disabled item after delete.
		// alert('hoverAccessListItem - elementId: ' + elementId + '\nevt.type: ' + evt.type);
		if (elementId.indexOf(':op:') != -1) {
			var eventType = evt.type;
			var isMouseOver = (evt.type == 'mouseover');
			if (!isMouseOver || (className.indexOf('disabled') == -1)) {
				element.style.backgroundColor = isMouseOver ? '#F2F2F2' : 'White';
				element.style.cursor = isMouseOver ? 'pointer' : 'default';
			}
		}
	},
	getSortedAccessItemProfileLabels: function(numberOfProfiles, profiles) {
		var profilesDb = users.profilesDb;
		var a = [];
		for (var i = 0; i < numberOfProfiles; i++) {
			var profileName = profiles[i];
			var profileItem = profilesDb[util.h(profileName)];
			var profileLabel = (profileItem != null) ? profileItem.label : langVar('lang_admin.users.unknown_profile');
			a[i] = profileLabel;
		}
		// Sort a
		a.sort();
		return a;
	},
	cleanUpAccessCell: function(element) {
		// alert('cleanUpAccessCell - element: ' + element);
		while (element.lastChild != null) {
			var theChild = element.lastChild;
			element.removeChild(theChild);
		}
	},
	updateAccessRow: function(index, accessItem, numberOfAccessItems) {
		// alert('updateAccessRow()');
		// util.showObject(accessItem);
		var i;
		var br;
		var rolesDb = users.rolesDb;
		var isRootAdmin = pageInfo.isRootAdmin;
		var isUnlimitedGrants = users.isUnlimitedGrants;
		var activeUserNodeName = users.activeUserNodeName;
		var createdByUserNodeName = accessItem.created_by_user;
		var isOwnedByOtherUser = (!isRootAdmin && !isUnlimitedGrants && (activeUserNodeName != createdByUserNodeName));
		//
		// Get the baseId of the row
		// 
		var tbody = util.getE('users:access:tbody');
		var allRows = tbody.getElementsByTagName('tr');
		var trId = allRows[index].id;
		// alert('updateAccessRow - trId: ' + trId);
		var dat = trId.split(':');
		var baseId = dat[0];
		// alert('updateAccessRow - baseId: ' + baseId);
		//
		//
		// Handle Profiles cell
		//
		//
		var isAllProfiles = accessItem.all_profiles;
		var profiles = accessItem.profiles;
		var numberOfProfiles = profiles.length;
		var profileTd = util.getE(baseId + ':op:edit_profiles');
		profileTd.className = !isOwnedByOtherUser ? '' : 'disabled'; // Don't remove, the className is used to check hover and link activation,
																	 // both are ignored if the className contains disabled!
		// alert('updateAccessRow - profileTd: ' + profileTd);
		usersUtil.cleanUpAccessCell(profileTd);
		var profileLabel;
		var profileText;
		if (isAllProfiles || (numberOfProfiles == 0)) {
			profileLabel = isAllProfiles ? langVar('lang_admin.users.all_profiles') : '[ ' + langVar('lang_admin.users.no_profile_defined') + ' ]';
			profileText = document.createTextNode(profileLabel);
			profileTd.appendChild(profileText);
		}
		else {
			// One or more profiles in list
			// KHP 14/Sep/2010 - Make sure we get sorted labels
			var sortedProfileLabels = usersUtil.getSortedAccessItemProfileLabels(numberOfProfiles, profiles);
			for (i = 0; i < numberOfProfiles; i++) {
				profileText = document.createTextNode(sortedProfileLabels[i]);
				profileTd.appendChild(profileText);
				// Add br tag if this is not the last profile
				if (numberOfProfiles > 1 && i + 1 != numberOfProfiles) {
					br = document.createElement('br');
					profileTd.appendChild(br);
				}
			}
		}
		//
		//
		// Handle Roles cell
		//
		//
		var roleTd = util.getE(baseId + ':op:edit_roles');
		roleTd.className = !isOwnedByOtherUser ? '' : 'disabled';
		usersUtil.cleanUpAccessCell(roleTd);
		var roles = accessItem.roles;
		var numberOfRoles = roles.length;
		var roleName;
		var roleLabel;
		var roleText;
		if (numberOfRoles > 0) {
			for (i = 0; i < numberOfRoles; i++) {
				roleName = roles[i];
				roleLabel = rolesDb[util.h(roleName)].label;
				roleText = document.createTextNode(roleLabel);
				roleTd.appendChild(roleText);
				// Add br tag if this is not the last role
				if (numberOfRoles > 1 && i + 1 != numberOfRoles) {
					br = document.createElement('br');
					roleTd.appendChild(br);
				}
			}
		}
		else {
			// No role defined
			roleText = document.createTextNode('[ ' + langVar('lang_admin.users.no_role_defined') + ' ]');
			roleTd.appendChild(roleText);
		}
		//
		// Handle info cell
		//
		var infoTd = util.getE(baseId + ':info');
		usersUtil.cleanUpAccessCell(infoTd);
		var infoLabel = '';
		if (createdByUserNodeName == activeUserNodeName) {
			// No info, add &nbsp;
			infoLabel = '\u00a0';
		}
		else {
			if (!isOwnedByOtherUser) {
				// Add info by whom the access pair has been created
				var username = usersUtil.getUsernameByUserNodeName(createdByUserNodeName);
				infoLabel = '(' + langVar('lang_admin.general.by_user')  + ')';
				infoLabel = infoLabel.replace(/__PARAM__1/, username);
			}
			else {
				// This are limited grants, there is no permission to edit this item
				infoLabel = '(' + langVar('lang_admin.users.owned_by_other_user') + ')';
			}
		}
		var infoText = document.createTextNode(infoLabel);
		infoTd.appendChild(infoText);
		//
		// Handle edit cell
		//
		var editTd = util.getE(baseId + ':op:edit');
		editTd.className = !isOwnedByOtherUser ? 'link' : 'link-disabled';
		//
		// Handle delete cell
		//
		if (users.isEnterprise) {
			var deleteTd = util.getE(baseId + ':op:delete');
			deleteTd.className = (!isOwnedByOtherUser && numberOfAccessItems > 1) ? 'link' : 'link-disabled';
		}
	},
	addAccessCell: function(tr, elementId, className, label) {
		// type is: edit_profiles | edit_roles
		var td = document.createElement('td');
		if (className != '') {td.className = className}
		td.id = elementId;
		var text = document.createTextNode(label);
		td.appendChild(text);
		tr.appendChild(td);
	},
	createAccessRow: function(tbody) {
		// alert('createAccessRow);
		// Get new unique baseId (i.e. acc8)
		var idCount = 0;
		var isUniqueId = false;
		var baseId = '';
		while (!isUniqueId) {
			if (util.getE('acc' + idCount + ':tr') == null) {
				baseId = 'acc' + idCount;
				isUniqueId = true;
			}
			idCount++;
		}
		var tr = document.createElement('tr');
		tr.id = baseId + ':tr';
		usersUtil.addAccessCell(tr, baseId + ':op:edit_profiles', '', '-');
		usersUtil.addAccessCell(tr, baseId + ':op:edit_roles', '', '-');
		usersUtil.addAccessCell(tr, baseId + ':info', 'info', '-');
		usersUtil.addAccessCell(tr, baseId + ':op:edit', 'link', langVar('lang_stats.btn.edit'));
		if (users.isEnterprise) {
			usersUtil.addAccessCell(tr, baseId + ':op:delete', 'link', langVar('lang_stats.btn.delete'));
		}
		tbody.appendChild(tr);
	},
	updateAccessList: function() {
		// Updates the access list
		// var table = util.getE('users:access:container');
		var tbody = util.getE('users:access:tbody');
		// Get the number of existing rows
		var allRows = tbody.getElementsByTagName('tr');
		var numberOfExistingAccessRows = allRows.length;
		var access = users.activeAccess;
		var numberOfAccessItems = access.length;
		// alert('numberOfExistingAccessRows: ' + numberOfExistingAccessRows + '\nnumberOfAccessItems: ' + numberOfAccessItems);
		//
		// Create/remove access rows
		//
		if (numberOfExistingAccessRows != numberOfAccessItems) {
			if (numberOfExistingAccessRows < numberOfAccessItems) {
				// Add new rows
				// alert('Add new rows!');
				for (i = numberOfExistingAccessRows; i < numberOfAccessItems; i++) {
					usersUtil.createAccessRow(tbody);
				}
			}
			else {
				// Remove rows
				// alert('Remove rows!');
				for (i = numberOfExistingAccessRows; i > numberOfAccessItems; i--) {
					// alert('Remove row: ' + i);
					var tr = tbody.lastChild;
					tbody.removeChild(tr);
				}
			}
		}
		//
		// Update the access cells
		//
		var isUnlimitedGrants = users.isUnlimitedGrants;
		for (i = 0; i < numberOfAccessItems; i++) {
			var accessItem = access[i];
			usersUtil.updateAccessRow(i, accessItem, numberOfAccessItems);
		}
	},
	//
	//
	//
	// Miscellaneous utilities
	//
	//
	//
	getRowNumberFromBaseId: function(baseId) {
		var tbody = util.getE('users:access:tbody');
		var allRows = tbody.getElementsByTagName('tr');
		var trBaseId = baseId + ':tr';
		var rowNumberIndex = 0;
		for (var i = 0; i < allRows.length; i++) {
			if (trBaseId == allRows[i].id) {
				rowNumberIndex = i;
				break;
			}
		}
		return rowNumberIndex;
	},
	getUsernameByUserNodeName: function(userNodeName) {
		var usersDb = users.usersDb;
		var username = '';
		for (var i = 0; i < usersDb.length; i++) {
			if (userNodeName == usersDb[i].dat.node_name) {
				username = usersDb[i].dat.username;
				break;
			}
		}
		if (username == '') {
			username = langVar('lang_admin.users.unknown_user');
		}
		return username;
	},
	getNewUserNodeName: function(usersDb, deletedUsersDb) {
		// Returns a new unique node name (with timestamp) so that it
		// is unique forever.
		//
		// Create a node name lookup
		//
		var usedNodeNames = {};
		var nodeName;
		var i;
		for (i = 0; i < usersDb.length; i++) {
			nodeName = usersDb[i].dat.node_name;
			nodeName = '_' + nodeName.toLowerCase();
			usedNodeNames[nodeName] = true;
		}
		for (i = 0; i < deletedUsersDb.length; i++) {
			nodeName = deletedUsersDb[i];
			nodeName = '_' + nodeName.toLowerCase();
			usedNodeNames[nodeName] = true;
		}
		//
		// Create new node name
		//
		// KHP 05/Jan/2011 - use timestamp to ensure unique user node name forever,
		// it should not be possible to create the same user node name even after
		// deletion of the user because there might be references of the node name
		// in "created_by_user" nodes.
		var d = new Date();
		var timestamp = d.getTime();
		var newNodeName = 'user_' + timestamp;
		// util.showObject({newNodeName__1: newNodeName});
		if (usedNodeNames['_' + newNodeName] != null) {
			// A user node name with this timestamp already exists.
			// This case shouldn't be possible but we cover it
			// by some older code
			var isUniqueNodeName = false;
			var count = 1;
			while (!isUniqueNodeName) {
				newNodeName = 'user_' + timestamp + count;
				// util.showObject({newNodeName__2: newNodeName});
				if (usedNodeNames['_' + newNodeName] == null) {
					isUniqueNodeName = true;
				}
				count++;
			}
		}
		return newNodeName;
	}
}
//
//
// usersAM.js (handles the users Access Manager Panel
//
//
var usersAM = {
	panel: null,
	tabs: null,
	isNewAccessPair: false,
	activeAccessItemIndex: 0, // The index of the active access pair in users.activeAccess.
						// The index is only relevant when isNewAccessPair is false.
	activeCreatedByUser: '',
	init: function() {
		var YE = YAHOO.util.Event;
		//
		// Init the panel
		//
		var panelObj = {
			panelId: 'users:am:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 300,
			top: 160,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: usersAM.close
		};
		usersAM.panel = new util.Panel3(panelObj);
		//
		// Init the tabs
		//
		usersAM.tabs = new util.Tabs2(['users:am:profiles:tab', 'users:am:roles:tab'], usersAM.tabActivated);
		//
		//
		// Init form controls
		//
		//
		var isRootAdmin = pageInfo.isRootAdmin;
		var isUnlimitedGrants = users.isUnlimitedGrants;
		var isLimitedGrants = (!isRootAdmin && !isUnlimitedGrants);
		//
		//
		// Handle roles list first so that we can populate a profilesLookup if isLimitedGrants
		//
		//
		var rolesDb = users.rolesDb;
		var profilesDb = users.profilesDb;
		var rolesList = [];
		var profilesList = [];
		var profilesLookup = {};
		var isAllProfilesPermission = false;
		if (!isLimitedGrants) {
			rolesList = rolesDb;
			isAllProfilesPermission = true;
		}
		else {
			for (var i = 0; i < rolesDb.length; i++) {
				var roleItem = rolesDb[i];
				if (roleItem.isPermission) {
					rolesList[rolesList.length] = {name:roleItem.name, label:roleItem.label};
					if (roleItem.isAllProfiles) {
						isAllProfilesPermission = true;
					}
					else {
						// Remember any profile listed in profiles in profilesLookup
						for (var j = 0; j < roleItem.profiles.length; j++) {
							profilesLookup['_' + roleItem.profiles[j]] = true;
						}
					}
				}
			}
		}
		//
		//
		// Create profiles list
		//
		//
		if (isAllProfilesPermission) {
			profilesList[0] = {name: '__ALL__PROFILES__', label: langVar('lang_admin.users.all_profiles_accesses')};
		}
		for (var i = 0; i < profilesDb.length; i++) {
			var profileItem = profilesDb[i];
			var profileName = profileItem.name;
			if (isAllProfilesPermission || (profilesLookup['_' + profileName] != null)) {
				// We add a space to profile labels so that there is some offset from the All Profiles label
				var profileLabel = isAllProfilesPermission ? ' ' + profileItem.label : profileItem.label;
				profilesList[profilesList.length] = {name: profileName, label: profileLabel}; 
			}
		}
		util.populateSelect('users:am:profiles:select', profilesList, 'name', 'label');
		util.populateSelect('users:am:roles:select', rolesList, 'name', 'label');
		YE.addListener('users:am:okay', 'click', usersAM.saveAccessPair);
		YE.addListener('users:am:cancel', 'click', usersAM.close);
	},
	open: function(itemIndex, accessItem, activeTabIsRoles, isNewAccessPair) {
		// isNewAccessPair is true when Access Manager is opened via the New Access Pair button
		usersAM.isNewAccessPair = isNewAccessPair;
		// reset the form
		util.resetF('users_am_form');
		//
		//
		// Set form values according accessItem
		//
		//
		usersAM.activeAccessItemIndex = itemIndex;
		usersAM.isNewAccessPair = isNewAccessPair;
		usersAM.activeCreatedByUser = accessItem.created_by_user;
		var isAllProfiles = accessItem.all_profiles;
		var profiles = accessItem.profiles;
		var roles = accessItem.roles;
		var i;
		// var selectOptions;
		if (!isAllProfiles) { 
			// var profilesSelect = util.getE('users:am:profiles:select');
			for (i = 0; i < profiles.length; i++) {
				util.setF('users:am:profiles:select', profiles[i]);
			}
		}
		else {
			// Check the All profiles radio button
			// util.setF('users:am:all_profiles_btn', true);
			// Select All Profiles entry
			var profilesSelect = util.getE('users:am:profiles:select');
			// alert('profilesSelect: ' + profilesSelect);
			profilesSelect.selectedIndex = 0;
			// profilesSelect.options[0].selected = true;
		}
		for (i = 0; i < roles.length; i++) {
			util.setF('users:am:roles:select', roles[i]);
		}
		// Preset tabs
		var tabId = activeTabIsRoles ? 'users:am:roles:tab' : 'users:am:profiles:tab';
		usersAM.tabs.setActiveTab(tabId);
		usersAM.setDisplay(activeTabIsRoles);
		// Open panel
		var panelLabel = !isNewAccessPair ? langVar('lang_admin.users.edit_access_pair') : langVar('lang_admin.users.new_access_pair');
		usersAM.panel.open({label: panelLabel});
	},
	addNewAccessPair: function() {
		var itemIndex = 0; // is not relevant when adding a new item
		var isNewAccessPair = true;
		var activeTabIsRoles = false;
		var newAccessItem = {
			all_profiles: false,
			profiles: [],
			roles: []
			// created_by_user: users.activeUserNodeName
		};
		usersAM.open(itemIndex, newAccessItem, activeTabIsRoles, isNewAccessPair);
	},
	setDisplay: function(activeTabIsRoles) {
		if (activeTabIsRoles) {
			util.hideE('users:am:profiles:section');
			util.showE('users:am:roles_section');
		}
		else {
			util.hideE('users:am:roles_section');
			util.showE('users:am:profiles:section');
		}
	},
	tabActivated: function() {
		var tabId = this.id;
		var activeTabIsRoles = (tabId == 'users:am:roles:tab');
		usersAM.tabs.setActiveTab(tabId);
		usersAM.setDisplay(activeTabIsRoles);
	},
	getIsValidAccessPair: function(profiles, roles) {
		// Only used if there are no unlimited grants. It is
		// only relevant if there are different profiles with different role permissions,
		// i.e. different profile manager roles are assigned to different profiles.
		var allValid = true;
		var isValidRoleProfileRelation;
		var rolesDb = users.rolesDb;
		var profilesDb = users.profilesDb;
		var info = '';
		for (var i = 0; i < roles.length; i++) {
			var roleName = roles[i];
			var theRoleInDb = rolesDb[util.h(roleName)];
			var isAllProfiles = theRoleInDb.isAllProfiles;
			for (var j = 0; j < profiles.length; j++) {
				var profileName = profiles[j];
				isValidRoleProfileRelation = false;
				if (isAllProfiles) {
					isValidRoleProfileRelation = true;
				}
				else {
					// Check if the profile exists in theRoleInDb.profiles
					for (var k = 0; k < theRoleInDb.profiles.length; k++) {
						if (theRoleInDb.profiles[k] == profileName) {
							isValidRoleProfileRelation = true;
							break;
						}
					}
				}
				// We add any invalid profile/role relations to info
				// and show them in an alert.
				if (!isValidRoleProfileRelation) {
					allValid = false;
					var roleLabel = theRoleInDb.label;
					var profileLabel = profilesDb[util.h(profileName)].label;
					info += profileLabel + ' - ' + roleLabel + '\n';
				}
			}
		}
		if (!allValid) {
			alert(langVar('lang_admin.users.profiles_roles_assignment_conflict_msg') + '\n' + info);
		}
		return allValid;
	},
	saveAccessPair: function() {
		var profilesSelect = util.getE('users:am:profiles:select');
		var profilesOptions = profilesSelect.options;
		var isAllProfiles = ((profilesOptions[0].value == '__ALL__PROFILES__') && profilesOptions[0].selected);
		var profiles = [];
		var roles = [];
		var i;
		// alert('isAllProfiles: ' + isAllProfiles);
		if (!isAllProfiles) {
			for (i = 0; i < profilesOptions.length; i++) {
				if (profilesOptions[i].selected) {
					profiles[profiles.length] = profilesOptions[i].value;
				}
			}
		}
		var rolesSelect = util.getE('users:am:roles:select');
		var options = rolesSelect.options;
		for (i = 0; i < options.length; i++) {
			if (options[i].selected) {
				roles[roles.length] = options[i].value;
			}
		}
		var isValidAccessPair = (pageInfo.isRootAdmin || users.isUnlimitedGrants) ? true : usersAM.getIsValidAccessPair(profiles, roles);
		if (isValidAccessPair) {
			var accessItem;
			var accessItemIndex = 0;
			var activeAccess = users.activeAccess;
			var numberOfAccessItems = activeAccess.length;
			if (!usersAM.isNewAccessPair) {
				// Update the existing access object
				accessItemIndex = usersAM.activeAccessItemIndex;
				accessItem = activeAccess[accessItemIndex];
				accessItem.all_profiles = isAllProfiles;
				accessItem.profiles = profiles;
				accessItem.roles = roles;
				// Update the single row in access list
				usersUtil.updateAccessRow(accessItemIndex, accessItem, numberOfAccessItems);
			}
			else {
				// Add a new access item object
				numberOfAccessItems += 1;
				var accessItem = {
					all_profiles: isAllProfiles,
					profiles: profiles,
					roles: roles,
					created_by_user: users.activeUserNodeName
				};
				// Add new item to users.activeAccess
				accessItemIndex = activeAccess.length;
				activeAccess[accessItemIndex] = accessItem;
				// util.showObject(activeAccess);
				// Create a new row
				var tbody = util.getE('users:access:tbody');
				usersUtil.createAccessRow(tbody, accessItemIndex);
				// If the list already shows a delete button (final numberOfAccessItems > 2)
				// then we only need to update the last row, else we update all rows.
				if (numberOfAccessItems > 2) {
					// Update single row
					usersUtil.updateAccessRow(accessItemIndex, accessItem, numberOfAccessItems);
				}
				else {
					// Update all rows so that we get the delete button in every row
					for (i = 0; i < numberOfAccessItems; i++) {
						usersUtil.updateAccessRow(i, activeAccess[i], numberOfAccessItems);
					}
				}
			}
			// Close the panel
			usersAM.close();
		}
	},
	close: function() {
		usersAM.panel.close();
	}
}
//
//
// users.js
//
//
var users = {
	isEnterprise: false,
	isUnlimitedGrants: false,
	defaultDividerLabels: [],
	languageInPreferences: '',
	languageOfDividerLists: '',
	activeUserNodeName: '',
	rootAdminUsername: '', // Used to check for duplicate username because the rootAdmin is not part of usersDb
	usersDb: [],
	usersDbBackup: [],
	profilesDb: [],
	rolesDb: [], // Contains the role names, labels and profile access rights if there are no unlimited grants, format is:
				 // [{name:"role_1", label:"Administrator", isPermission:true, all_profiles:false, profiles:['profile_1', profile_2]}, ...]
				 // Note, rolesDb contains all roles even if unlimited_grants is equal false because we need all roles for display!
				 // We use the "isPermission" property to check whether or not a role is granted.
	deletedUsersDb: [], // Keeps the node names of any deleted user, i.e. ['user_1', 'user_12']
	theList: null,
	validator: null,
	// isModifiedUsers: false,
	saveChangesBtn: null,
	newUserBtn: null,
	deleteBtn: null,
	duplicateBtn: null,
	undoAllChangesBtn: null,
	noItemFormIsActive: false,
	// Active form data:
	changePasswordIsActive: false,
	newItemIsActive: false,
	activeItemNodeName: '',
	activeCreatedByUser: '',
	activeAccess: [],
	isSelectUserName: false, // used for username default selected upon new or duplicate
	isVisibleReportFilterExpressionField: false // is true if the report filter expression field is shown on the item form
}
function init() {
	//
	// Main init routine
	//
	var isEnterprise = (pageInfo.licensingTier == 'enterprise');
	var YE = YAHOO.util.Event;
	users.isUnlimitedGrants = pageInfo.permissions.isUnlimitedGrants;
	users.isEnterprise = isEnterprise;
	users.validator = new util.Validator();
	//
	// init toolbar buttons
	//
	users.saveChangesBtn = new util.ToolbarButton('save_changes', saveChanges, toolbarButtonsDb);		
	users.newUserBtn = new util.ToolbarButton('new_user', newUser, toolbarButtonsDb);
	users.duplicateBtn = new util.ToolbarButton('duplicate', duplicateUser, toolbarButtonsDb);
	users.deleteBtn = new util.ToolbarButton('delete', deleteUser, toolbarButtonsDb);
	users.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
	//
	// Ignore/Disable buttons according RBAC
	//
	var permissions = pageInfo.permissions;
	if (permissions.isEdit) {
		if (!permissions.isAdd) {
			users.newUserBtn.disableAndIgnore();
			users.duplicateBtn.disableAndIgnore();
		}
		if (!permissions.isDelete) {
			users.deleteBtn.disableAndIgnore();
		}
		// Register isModifiedPageHandler in adminConfig.js
		// (We don't check for modifications if there is no edit 
		// permission because there is no Save button anyway!)
		adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
	}
	else {
		users.saveChangesBtn.disableAndIgnore();
		users.newUserBtn.disableAndIgnore();
		users.duplicateBtn.disableAndIgnore();
		users.deleteBtn.disableAndIgnore();
		users.undoAllChangesBtn.disableAndIgnore();
	}
	// init OptionInfo
	optionInfo.init();
	// Init help
	util.helpWindow.init('');
	//
	// Create the theList object
	//
	users.theList = new listcontroller.List({
		containerElementId: 'item_list_body',
		itemEvent: itemActivated
	});
	// Add events
	YE.addListener('users:username', 'keyup', updateListAndFormLabel);
	YE.addListener('users:change_password_btn', 'click', changeCancelPassword);
	YE.addListener('users:cancel_change_password_btn', 'click', changeCancelPassword);
	YE.addListener('users:access:tbody', 'click', usersUtil.accessListLinkActivated);
	YE.addListener('users:access:tbody', 'mouseover', usersUtil.hoverAccessListItem);
	YE.addListener('users:access:tbody', 'mouseout', usersUtil.hoverAccessListItem);
	YE.addListener('users:language', 'change', languageActor);
	//
	// Handle enterprise specific features
	//
	if (isEnterprise) {
		YE.addListener('users:access:new_access_pair_btn', 'click', usersAM.addNewAccessPair);
		YE.addListener('users:add_report_filter:btn', 'click', addReportFilter);
		YE.addListener('users:report_filter_expression:view_help_btn', 'click', util.helpWindow.openGeneralHelp);
        util.showE('users:add_report_filter:section');
	}
	//
	// Init Access Manager Panel
	//
	usersAM.init();
}
function initMainDisplay() {
	// alert('initMainDisplay()');
	util.hideE(['form_section', 'users_form', 'no_item_form', 'loading_info', 'saving_info']);
	var firstItemId = users.theList.getFirstItemId();
	// alert('initMainDisplay() - firstItemId: ' + firstItemId);
	if (firstItemId != null) {
		// select the first item
		setItem(firstItemId);
		displayNoItemForm(false);
	}
	else {
		// no item exists
		displayNoItemForm(true);
	}
	util.showE('form_section');
}
function getUsersData() {
	if (!pageInfo.exitActive) {
		var url = '?dp=admin_pages.users.get_data';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		util.serverPost(url, dat);
	}
}
function getUsersDataResponse(dat) {
	if (!pageInfo.exitActive) {
		users.defaultDividerLabels = dat.defaultDividerLabels;
		users.languageInPreferences = dat.languageInPreferences;
		users.activeUserNodeName = dat.activeUserNodeName;
		users.rootAdminUsername = dat.rootAdminUsername;
		users.usersDb = dat.usersDb;
		users.usersDbBackup = util.cloneObject(dat.usersDb);
		users.profilesDb = dat.profilesDb;
		users.rolesDb = dat.rolesDb;
		// util.showObject(users.defaultDividerLabels);
		util.createHash(users.defaultDividerLabels, 'language');
		util.createHash(users.profilesDb, 'name');
		util.createHash(users.rolesDb, 'name');
		// util.showObject(users.profilesDb);
		// Init	
		if (!pageInfo.initComplete) {
			// This is the initial page load
			init();
			users.theList.init(users.usersDb);
			initMainDisplay();
			pageInfo.initComplete = true;
		}
		// Set final toolbar state
		users.saveChangesBtn.enable();
		users.undoAllChangesBtn.enable();
		users.newUserBtn.enable();
		updateToolbarButtons(); // handles Duplicate and Delete
		adminConfig.setItemListSize();
		YAHOO.util.Event.addListener(window, 'resize', adminConfig.setItemListSize);
	}
}
function displayNoItemForm(isDisplayNoItemForm) {
	if (isDisplayNoItemForm) {
		// util.updateT('item_form_label', '-');
		util.hideE('users_form');
		util.showE('no_item_form');
	}
	else {
		util.hideE('no_item_form');
		util.showE('users_form');
	}
	users.noItemFormIsActive = isDisplayNoItemForm;
}
function updateToolbarButtons() {
	var isItems = users.theList.isItems();
	users.deleteBtn.enable(isItems);
	users.duplicateBtn.enable(isItems);
}
function updateListAndFormLabel() {
	setTimeout('setListAndFormLabel()', 300);
}
function setListAndFormLabel() {
	var label = util.getF('users:username');
	if (label == '') {
		label = '-';
	}
	if (!pageInfo.isRootAdmin) {
		var item = users.theList.getSelectedItem();
		var userNodeName = item.dat.node_name;
		if (userNodeName == users.activeUserNodeName) {
			label += ' (' + langVar('lang_admin.users.logged_in') + ')';
		}
	}
	// util.updateT('item_form_label', label);
	users.theList.updateListLabel(label);
}
function changeCancelPassword() {
	var isChangePassword = !users.changePasswordIsActive;
	// util.showE('users:password_container', isChangePassword);
	// util.showE('users:change_password_btn', !isChangePassword);
	// util.showE('users:cancel_change_password_btn', isChangePassword);
	util.showE('users:password_section', isChangePassword);
	util.showE('users:change_password_section', !isChangePassword);
	users.changePasswordIsActive = isChangePassword;
	// Reset any errors
	users.validator.reset();
}
function languageActor() {
	var language = util.getF('users:language');
	updateLanguageOptions(language);
}
function updateLanguageOptions(language) {
	// language is the language of current user
	// This updates the select element label 
	// of number_thousands_divider and number_decimal_divider
	// so that the first list item shows the language specific
	// default dividers.
	function updateOptionText(elementId, label) {
		var element = util.getE(elementId);
		element.options[0].text = label;
	}
	if (language == '') {
		// Use default language as set it preferences
		language = users.languageInPreferences;
	}
	// Check if we need to update the default divider text
	if (language != users.languageOfDividerLists) {
		var dividerItem = users.defaultDividerLabels[util.h(language)];
		updateOptionText('users:number_thousands_divider', dividerItem.defaultThousandDividerLabel);
		updateOptionText('users:number_decimal_divider', dividerItem.defaultDecimalDividerLabel);
		// Remember the language of divider lists
		users.languageOfDividerLists = language;
	}
}
function addReportFilter() {
	util.hideE('users:add_report_filter:section');
	util.showE('users:report_filter_expression:section');
	users.isVisibleReportFilterExpressionField = true;
}
function itemActivated(itemId) {
	if (validateActiveItem()) {
		setItem(itemId);
	}
}
function setItem(itemId) {
	// selects active item in list and displays the form
	users.theList.selectItem(itemId);
	updateForm(itemId);
	//
	// set delete button
	//
	/*
	if (itemId != activeUserItemId) {
		deleteButton.enable();
	}
	else {
		deleteButton.disable();
	}
	*/
}
function newUser() {
	if (validateActiveItem()) {
		var theList = users.theList;
		var newItemId = theList.getNewItemId();
		var newNodeName = usersUtil.getNewUserNodeName(users.usersDb, users.deletedUsersDb);
		var activeUserNodeName = users.activeUserNodeName;
		// Give a default role in the pro version, the role_2 (Statistics visitor)
		var defaultRoles = users.isEnterprise ? [] : ['role_2'];
		var accessObj = [{
			all_profiles: false,
			profiles: [],
			roles: defaultRoles,
			created_by_user: activeUserNodeName
		}];
		var newUserLabel = langVar('lang_admin.users.new_user');
		var userObj = {
			id: newItemId,
			type: '',
			label: newUserLabel,
			dat: {
				is_new: true,
				node_name: newNodeName,
				username: newUserLabel,
				password: '',
				email_address: '',
				language: '',
				number_thousands_divider: '',
				number_decimal_divider: '',
				created_by_user: activeUserNodeName,
				access: accessObj,
				auto_direct_to_reports_after_login: false,
				report_filter_expression: ''
			}
		}
		theList.newItem(userObj);
		users.isSelectUserName = true;
		setItem(newItemId);
		updateToolbarButtons();
	}
}
function duplicateUser() {
	if (validateActiveItem()) {
		var theList = users.theList;
		var item = theList.getSelectedItem();
		var username = item.dat.username;
		// Get new node name
		var newNodeName = usersUtil.getNewUserNodeName(users.usersDb, users.deletedUsersDb);
		// var newUsername = username + ' ' + langVar('lang_admin.general.copy');
		var newUsername = langVar('lang_stats.general.item_copy');
		newUsername = newUsername.replace(/__PARAM__1/, username);
		// Clone item
		var clonedItemId = theList.cloneItem();
		//
		// Reset item data
		//
		theList.setItemDatValue(clonedItemId, 'is_new', true);
		theList.setItemDatValue(clonedItemId, 'node_name', newNodeName);
		theList.setItemDatValue(clonedItemId, 'username', newUsername);
		theList.setItemDatValue(clonedItemId, 'password', '');
		theList.setItemDatValue(clonedItemId, 'created_by_user', users.activeUserNodeName);
		users.isSelectUserName = true;
		setItem(clonedItemId);
	}
}
function deleteUser() {
	var theList = users.theList;
	var item = theList.getSelectedItem();
	var itemId = item.id;
	var itemNodeName = item.dat.node_name;
	var deletedUsersDb = users.deletedUsersDb;
	deletedUsersDb[deletedUsersDb.length] = itemNodeName;
	// alert('deleteRole(): ' + itemId);
	//
	// select the next item
	//
	var nextItemIdToBeSelected = theList.deleteItem();
	if (nextItemIdToBeSelected != null) {
		// reset the validator in case that the deleted an item with error indication
		users.validator.reset();
		setItem(nextItemIdToBeSelected);
	}
	else {
		// All items have been deleted
		// alert('Last item has been deleted, no more items to select.');
		displayNoItemForm(true);
		updateToolbarButtons();
	}
}
function updateForm(itemId) {
	// alert('updateForm()');
	var isRootAdmin = pageInfo.isRootAdmin;
	var item = users.theList.getSelectedItem();
	var itemDat = item.dat;
	// util.showObject(item);
	// util.showObject(itemDat);
	// util.updateT('item_form_label', itemDat.username);
	var isNewItem = itemDat.is_new;
	users.newItemIsActive = isNewItem;
	users.activeItemNodeName = itemDat.node_name;
	//
	// Handle username
	//
	util.setF('users:username', itemDat.username);
	// var isLoggedInUser = (itemDat.node_name == users.activeUserNodeName);
	// util.showE('users:active_user_info', isLoggedInUser);
	// 
	// Handle password
	//
	// util.hideE(['users:password_container', 'users:change_password_btn', 'users:cancel_change_password_btn']);
	util.hideE(['users:change_password_section', 'users:password_section']);
	var password = itemDat.password;
	var changePasswordIsActive = false;
	util.setF('users:password', password);
	// alert('password: ' + password);
	if (!itemDat.is_new) {
		// Existing user item
		if (password == '') {
			// util.hideE('users:password_container');
			// util.showE('users:change_password_btn');
			util.hideE('users:password_section');
			util.showE('users:change_password_section');
		}
		else {
			// password changed already, allow to cancel the change
			// util.showE('users:password_container');
			// util.showE('users:cancel_change_password_btn');
			util.showE('users:password_section');
			util.showE('users:cancel_change_password_btn');
			changePasswordIsActive = true;
		}
	}
	else {
		// New user item
		// util.showE('users:password_container');
		util.showE('users:password_section');
	}
	users.changePasswordIsActive = changePasswordIsActive;
	util.setF('users:email_address', itemDat.email_address);
	//
	// Handle language options & created_by_user
	//
	util.setF('users:language', itemDat.language);
	updateLanguageOptions(itemDat.language);
	util.setF('users:number_thousands_divider', itemDat.number_thousands_divider);
	util.setF('users:number_decimal_divider', itemDat.number_decimal_divider);
	users.activeCreatedByUser = itemDat.created_by_user;
	//
	//
	// Handle access
	//
	//
	// Clone the active access array to users.activeAccess, we use 
	// the users.activeAccess to create and manipulate the access list
	// per user item.
	users.activeAccess = util.cloneObject(itemDat.access);
	// util.showObject(users.activeAccess);
	usersUtil.updateAccessList();
	if (users.noItemFormIsActive) {
		displayNoItemForm(false);
	}
	// Set auto_direct_to_reports_after_login
	util.setF('users:auto_direct_to_reports_after_login', itemDat.auto_direct_to_reports_after_login);
	//
	//
	// Handle report filter
	//
	//
	if (users.isEnterprise) {
		var reportFilterExpression = itemDat.report_filter_expression;
		var reportFilterExpressionExists = (reportFilterExpression != '');
		util.setF('users:report_filter_expression', reportFilterExpression);
		if (reportFilterExpressionExists != users.isVisibleReportFilterExpressionField) {
			util.showE('users:add_report_filter:section', !reportFilterExpressionExists);
			util.showE('users:report_filter_expression:section', reportFilterExpressionExists);
			users.isVisibleReportFilterExpressionField = reportFilterExpressionExists;
		}
	}
	// Assign tabIndex (hard coded html tabindex has a problem with password field, hence we do via js!
	/*
	KHP 25/Nov/2010 - disabled because tabIndex looks to work  without js
	and it misses number_thousands_divider, number_decimal_divider and report filter
	anyway.
	var f1 = util.getE('users:username');
	var f2 = util.getE('users:password');
	var f3 = util.getE('users:access:container');
	var f4 = util.getE('users:language');
	f1.tabIndex = 1;
	f2.tabIndex = 2;
	f3.tabIndex = 3;
	f4.tabIndex = 4;
	if (users.isSelectUserName) {
		f1.select();
		// Reset isSelectUserName
		users.isSelectUserName = false;
	}
	*/
}
function validateActiveItem() {
	// Only validate if isEdit permission and if items
	var theList = users.theList;
	if (pageInfo.permissions.isEdit && theList.isItems()) {
		var validator = users.validator;
		validator.reset();
		var isNewItem = users.newItemIsActive;
		var o = {};
		// Transfer is_new and node_name from existing object
		o.is_new = isNewItem;
		o.node_name = users.activeItemNodeName;
		o.username = validator.isValue('users:username');
		// Make sure the username is not equal the rootAdmin username
		if (o.username != users.rootAdminUsername) {
			// The username is case sensitive, so "user a" is not equal "USER A", both are unique!
			o.username = validator.isUnique('users:username', theList.getLookupItems('username'));
		}
		else {
			// Same username as rootAdmin, we show a custom error
			var msg = '';
			if (pageInfo.isRootAdmin) {
				msg = langVar('lang_admin.users.is_root_admin_username_msg');
			}
			else {
				msg = langVar('lang_admin.users.is_reserved_username_msg');
			}
			validator.isCustom('users:username', msg); 
		}
		// alert('o.username: ' + o.username);
		if (isNewItem || users.changePasswordIsActive) {
			o.password = validator.isValue('users:password');
		}
		else {
			o.password = '';
		}
		o.email_address = util.getF('users:email_address');
		// Validate for valid email address if any is defined
		if (o.email_address != '') {
			validator.isEmailAddress('users:email_address');
		}
		o.language = util.getF('users:language');
		o.number_thousands_divider = util.getF('users:number_thousands_divider');
		o.number_decimal_divider = util.getF('users:number_decimal_divider');
		o.created_by_user = users.activeCreatedByUser;
		//
		// Handle access (get active access array from users.activeAccess, it is ready to go)
		//
		// Note, we allow zero profiles and zero roles, there is no validation for profiles and roles!
		o.access = util.cloneObject(users.activeAccess);
		o.auto_direct_to_reports_after_login = util.getF('users:auto_direct_to_reports_after_login');
		o.report_filter_expression = (users.isVisibleReportFilterExpressionField) ? util.getF('users:report_filter_expression') : '';
		if (validator.allValid()) {
			theList.saveItem(o);
			return true;
		}
		return false;
	}
	// No isEdit permission or no items
	return true;
}
function saveChanges() {
	if (validateActiveItem()) {
		var theList = users.theList;
		var isModified = theList.getIsModified();
		// alert('saveChanges() - isModified: ' + isModified);
		if (isModified) {
			util.hideE('form_section');
			util.showE('saving_info');
			var url = '?dp=admin_pages.users.save_data';
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			var i;
			//
			//
			// Handle deleted users
			//
			//
			var deletedUsersDb = users.deletedUsersDb;
			if (deletedUsersDb.length > 0) {
				for (i = 0; i < deletedUsersDb.length; i++) {
					dat += 'v.fp.deleted_users.' + deletedUsersDb[i] + '=true&';
				}
			}
			else {
				dat += 'v.fp.deleted_users=&';
			}
			//
			//
			// Handle users
			//
			//
			var usersDb = users.usersDb;
			var numOfUsers = usersDb.length;
			if (numOfUsers > 0) {
				for (i = 0; i < numOfUsers; i++) {
					var itemDat = usersDb[i].dat;
					var userPath = 'v.fp.users.' + itemDat.node_name;
					dat += userPath + '.is_new=' + itemDat.is_new + '&';
					dat += userPath + '.username=' + encodeURIComponent(itemDat.username) + '&';
					dat += userPath + '.password=' + encodeURIComponent(itemDat.password) + '&';
					dat += userPath + '.email_address=' + encodeURIComponent(itemDat.email_address) + '&';
					dat += userPath + '.language=' + itemDat.language + '&';
					dat += userPath + '.number_thousands_divider=' + encodeURIComponent(itemDat.number_thousands_divider) + '&';
					dat += userPath + '.number_decimal_divider=' + encodeURIComponent(itemDat.number_decimal_divider) + '&';
					dat += userPath + '.created_by_user=' + itemDat.created_by_user + '&';
					var access = itemDat.access;
					for (var j = 0; j < access.length; j++) {
						var accessItem = access[j];
						var accessItemPath = userPath + '.access.' + j;
						dat += accessItemPath + '.all_profiles=' + accessItem.all_profiles + '&';
						dat += accessItemPath + '.created_by_user=' + accessItem.created_by_user + '&';
						var accessProfiles = accessItem.profiles;
						var accessRoles = accessItem.roles;
						var k = 0;
						if (accessProfiles.length > 0) {
							for (k = 0; k < accessProfiles.length; k++) {
								dat += accessItemPath + '.profiles.' + k + '=' + accessProfiles[k] + '&';
							}
						}
						else {
							dat += accessItemPath + '.profiles=&';
						}
						if (accessRoles.length > 0) {
							for (k = 0; k < accessRoles.length; k++) {
								dat += accessItemPath + '.roles.' + k + '=' + accessRoles[k] + '&';
							}
						}
						else {
							dat += accessItemPath + '.roles=&';
						}
					}
					dat += userPath + '.auto_direct_to_reports_after_login=' + itemDat.auto_direct_to_reports_after_login + '&';
					// Add report_filter_expression
					dat += userPath + '.report_filters.all_profiles.filter_expression=' + encodeURIComponent(itemDat.report_filter_expression) + '&';
				}
			}
			else {
				dat += 'v.fp.users=&';
			}
			// Handle usersDbBackup
			var usersDbBackup = users.usersDbBackup;
			var numOfUsers2 = usersDbBackup.length;
			if (numOfUsers2 > 0) {
				for (i = 0; i < numOfUsers2; i++) {
					itemDat = usersDbBackup[i].dat;
					dat += 'v.fp.users_backup.' + i + '=' + encodeURIComponent(itemDat.username) + '&';
				}
			}
			else {
				dat += 'v.fp.users_backup=&';
			}
			dat = dat.replace(/&$/, '');
			util.serverPost(url, dat);
		}
		else {
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	}
}
function saveChangesResponse() {
	// alert('saveChangesResponse()');
	// Note, we keep the system at current state, we do not re-initialize theList
	users.usersDbBackup = util.cloneObject(users.usersDb);
	users.deletedUsersDb = [];
	users.theList.resetIsModified();
	util.hideE('saving_info');
	util.showE('form_section');
}
function undoAllChanges() {
	users.usersDb = util.cloneObject(users.usersDbBackup);
	users.deletedUsersDb = [];
	users.theList.init(users.usersDb);
	initMainDisplay();
	updateToolbarButtons();
}
function getIsModifiedPage() {
	// Note, isModified will be false if only the active item has been edited
	// but has an error, hence we also check "if (!validateActiveItem() ..."
	if (!validateActiveItem() || users.theList.getIsModified()) {
		return true;
	}
	return false;
}
