//
// admin import
//

var importData = {
	
	panel: null,
	validator: null,
	
	wizardPages: [ // contains the wizard pages but also any sub windows like loading_info
		'import_data:loading_info:page',
		'import_data:define_pathname:page',
		'import_data:choose_objects:page',
		'import_data:choose_databases:page',
		'import_data:override_objects_warning:page',
		'import_data:override_databases_warning:page',
		'import_data:final:page'
	],
	
	wizardPath: [], // Keeps the state of the wizard pages, i.e.: ['define_pathname', 'choose_objects', ...]
	
	pathname: '', // the version 7 LogAnalysisInfo directory
	
	isLoaded: false, // Set to true if initial data (v7profilesDb, v7numberOfSchedules, ...) are loaded
	
	v7profilesDb: [], // contains al version 7 profiles data
	v8profilesDb: [],
	
	v7numberOfSchedules: 0, // number of version 7 schedules
	v7numberOfUsers: 0, // number of version 7 users, the number does not include the current user and it does not include any root admin user
	isDuplicateUsers: false, // Indicates if version 8 already contains any version 7 username (current user username and root admin is excluded because they are not imported!)
	currentUserUsername: '', // the username of the current logged in user, it is required when importing users!
	
	isImportProfiles: false, // just used to check if any profile is selected so that we know when to enable the Next button
	isOverrideProfiles: false,
	isImportSchedules: false, 
	isImportUsers: false,
	isOverrideUsers: false,
	isOverrideDatabases: false, // This may also be true if no database is imported but is set because
								// the v7 and v8 profile have identical database data (same MySQL name or custom database directory)
		
	itemsDat: [] // contains the data which are finally imported
};

function initPage() {
	
	// Init help
	util.helpWindow.init('');

	initWizard();
	util.showE('form_section');
}
	
function initWizard() {
	
	var YE = YAHOO.util.Event;
	
	//
	// Init wizard panel
	//

	var panelObj = {
		panelId: 'import_data:panel',
		panelClassName: 'panel-50',
		panelHeaderLabel: langVar('lang_admin.import.import_wizard'),
		left: 20,
		top: 70,
		zIndex: 20,
		isCover: true,
		isSticky: true,
		closeEvent: closeWizard
	};
	
	
	
	importData.panel = new util.Panel3(panelObj);
	importData.validator = new util.Validator();
	
	YE.addListener('import_data:start_wizard_btn', 'click', openWizard);
	
	YE.addListener('import_data:browse_btn', 'click', browsePathname);
	
	YE.addListener('import_data:choose_objects:profiles:div', 'click', importProfilesActor);
	YE.addListener('import_data:choose_objects:schedules', 'click', importSchedulesActor);
	YE.addListener('import_data:choose_objects:users', 'click', importUsersActor);
	
	YE.addListener(['import_data:select_all_profiles_btn', 'import_data:deselect_all_profiles_btn'], 'click', selectDeselectAllProfiles);
	YE.addListener(['import_data:select_all_databases_btn', 'import_data:deselect_all_databases_btn'], 'click', selectDeselectAllDatabases);

	YE.addListener('import_data:override_databases_list:div', 'click', editDatabaseNameOrDirectory);
	
	YE.addListener('import_data:back_btn', 'click', goBack);
	YE.addListener('import_data:next_btn', 'click', goNext);
	YE.addListener('import_data:cancel_btn', 'click', closeWizard);
}
	
function openWizard() {
		
	// Reset the wizard
	util.updateT('import_data:final:statusline', '&nbsp;');
	util.updateT('import_data:cancel_btn', langVar('lang_stats.btn.cancel'));
	util.resetF('import_data:form');
	importData.wizardPath = [];
	importData.isLoaded = false; // We reload any data because the user could already have imported something
								// and hence we need to know the override info.
	importData.isImportProfiles = false;
	importData.isImportSchedules = false;
	importData.isImportUsers = false;
	
	// Set default pathname value
	util.setF('import_data:pathname', importData.pathname);
	
	setWizardPage('define_pathname');
	
	importData.panel.open();
}
	
function closeWizard() {
	
	// Stop importDataStack importing any data
	importDataStack.isCancel = true;
	importData.panel.close();
}

function getActivePageName() {
	
	var wizardPath = importData.wizardPath;
	return wizardPath[wizardPath.length - 1];
}

	
function setButtonState() {
	
	var wizardPath = importData.wizardPath;
	var activePageName = wizardPath[wizardPath.length - 1];
	
	var isEnbaledNext = true;
	var nextButtonLabel = langVar('lang_stats.btn.next') + ' >';
	
	if (activePageName == 'choose_objects') {
		isEnbaledNext = (importData.isImportProfiles || importData.isImportSchedules || importData.isImportUsers);
	}
	
	if (activePageName == 'final') {
		nextButtonLabel = langVar('lang_stats.btn.finish');
	}
	
	// Re-enable Next button because it could be disabled due loading state
	util.enableE('import_data:next_btn', isEnbaledNext);
	util.enableE('import_data:back_btn', (wizardPath.length > 1));
	
	util.updateT('import_data:next_btn', nextButtonLabel);
}

function setButtonImportingState() {
	// This state is set when import actually starts
	util.disableE('import_data:back_btn');
	util.disableE('import_data:next_btn');
}
	
function showLoadingInfo(showLoading) {
	
	var activePageName = getActivePageName();
	
	util.showE('import_data:loading_info:page', showLoading);
	util.showE('import_data:' + activePageName + ':page', !showLoading);
	
	if (showLoading) {
		util.disableE(['import_data:back_btn', 'import_data:next_btn']);
	}
	else {
		setButtonState();
	}
}
	
//
//
// Wizard - define v7 pathname
//
//
	
function checkoutPathnamePage() {
		
	// Validate the pathname
	var pathname = util.getF('import_data:pathname');
	var pathnamePattern = /^.{1,}LogAnalysisInfo[\\/]?$/;
	var isValidPathname = pathnamePattern.test(pathname);
	
	if (isValidPathname) {
		
		// We only load the data if they are not yet loaded or if the pathname changed
		if(importData.pathname == pathname && importData.isLoaded) {
			// Data already exist
			setWizardPage('choose_objects');
		}
		else {
			// Get the data
			showLoadingInfo(true);
			importData.pathname = pathname;
			
			var url = '?dp=admin_pages.import_data.check_pathname_and_data';
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			dat += 'v.fp.pathname=' + encodeURIComponent(pathname);
			util.serverPost(url, dat);
		}
	}
	else {
		
		// show custom error message
		var pathnameErrorMsg = 'Please define a valid pathname, i.e: C:\\Program Files\\Sawmill\\LogAnalysisInfo';
		importData.validator.isCustom('import_data:pathname', pathnameErrorMsg);
		importData.validator.allValid();
	}
}
	
function checkoutPathnameAndDataResponse(dat) {
	
	function compareProfileLabels(a, b) {
		var labelA = a.label.toLowerCase();
		var labelB = b.label.toLowerCase();
		if (labelA < labelB) {return -1}
		if (labelA > labelB) {return 1}
		return 0;
	}
	
	// util.showObject(dat);
	
	if (dat.isValid) {
		
		importData.isLoaded = true;
		
		var v7profilesDb = dat.v7profilesDb;
		
		// Sort by profile label
		v7profilesDb.sort(compareProfileLabels);
		
		// Add following properties to v7profilesDb:
		// isImportProfile
		// isImportDatabase
		// newMysqlDatabaseName
		// newCustomDatabaseDirectory
		// newV8profileName
		
		for (var i = 0; i < v7profilesDb.length; i++) {
			
			var theProfile = v7profilesDb[i];
			theProfile['isImportProfile'] = false;
			theProfile['isImportDatabase'] = false;
			theProfile['newMysqlDatabaseName'] = theProfile.mysqlDatabaseName; // The new default name is equal the existing name
			
			// Set newCustomDatabaseDirectory, default is the existing custom directory if isCustomDbDirectory is true
			theProfile['newCustomDatabaseDirectory'] = theProfile.isCustomDbDirectory ? theProfile.databaseDirectory : '';
			
			theProfile['newV8profileName'] = ''; // We get the new name upon importing the profile item, which is required in case that we import a database as well.
			
			// util.showObject(v7profilesDb[i]);
		}
		
		// util.showObject(v7profilesDb);
		
		var v7numberOfSchedules = dat.v7numberOfSchedules;
		var v7numberOfUsers = dat.v7numberOfUsers
		
		importData.v7profilesDb = v7profilesDb;
		importData.v8profilesDb = dat.v8profilesDb;
	
		importData.v7numberOfSchedules = v7numberOfSchedules;
		importData.v7numberOfUsers = v7numberOfUsers;
		importData.isDuplicateUsers = dat.isDuplicateUsers;
		importData.currentUserUsername = dat.currentUserUsername;
		
		// Create hash for v8profilesDb
		util.createHash(importData.v8profilesDb, 'name');
		
		// Setup profiles list
		importDataUtil.buildProfilesObjectList(importData.v7profilesDb);
		
		// Setup import schedules
		util.updateT('import_data:choose_objects:schedules:number', '(' + v7numberOfSchedules + ')');
		util.enableE('import_data:choose_objects:schedules', (v7numberOfSchedules > 0));
		
		// Setup import users
		util.updateT('import_data:choose_objects:users:number', '(' + v7numberOfUsers + ')');
		util.enableE('import_data:choose_objects:users', (v7numberOfUsers > 0));
		
		// Go to next wizard page
		setWizardPage('choose_objects');
	}
	else {
		
		// Show pathname error message (Invalid pathname, path not found or not version 7 path) 
		showLoadingInfo(false);
		importData.validator.isCustom('import_data:pathname', dat.errorMsg);
		importData.validator.allValid();
	}
}

//
//
// Wizard - choose objects
//
//

function importProfilesActor(evt) {
	
	// We only check if a profile is selected or not to check for enable/disable Next button
	var isCheckedProfile = false;
	var v7profilesDb = importData.v7profilesDb;
	
	for (var i = 0; i < v7profilesDb.length; i++) {
		var isChecked = util.getF('import_data_profile_object:' + i);
		if (isChecked) {
			isCheckedProfile = true;
			break;
		}
	}
	
	importData.isImportProfiles = isCheckedProfile;
	setButtonState();
}

function selectDeselectAllProfiles() {
	
	var isSelectAllProfiles = (this.id == 'import_data:select_all_profiles_btn');
	var v7profilesDb = importData.v7profilesDb;

	for (var i = 0; i < v7profilesDb.length; i++) {
		util.setF('import_data_profile_object:' + i, isSelectAllProfiles);
	}
	
	importData.isImportProfiles = isSelectAllProfiles;
	setButtonState();
}

function importSchedulesActor() {
		
	importData.isImportSchedules = this.checked;
	setButtonState();
}

function importUsersActor() {
		
	importData.isImportUsers = this.checked;
	setButtonState();
}

function selectDeselectAllDatabases() {
	
	var isSelectAllDatabases = (this.id == 'import_data:select_all_databases_btn');

	// We simply get all checkboxes which are currently build
	var container = util.getE('import_data:choose_databases:div');
	var checkboxes = container.getElementsByTagName('input');
	
	for (var i = 0; i < checkboxes.length; i++) {
		checkboxes[i].checked = isSelectAllDatabases;
	}
}

function resetV8profilesDb() {
	
	// add/reset the "profileBecomesOverriden" property
	// in importData.v8profilesDb. We check this property
	// again upon checkoutChooseObjectsPage. It is required
	// when checking for duplicate database names or directories,
	// at this checking version 8 profiles can be ignored when
	// profileBecomesOverriden is true because the profile becomes
	// replaced with a version 7 profile.
	
	var v8profilesDb = importData.v8profilesDb;
	
	for (var i = 0; i < v8profilesDb.length; i++) {
		var theProfile = v8profilesDb[i];
		theProfile['profileBecomesOverriden'] = false;
	}
}

function checkoutChooseObjectsPage() {
	
	// Check what the user checked to import
	var isImportProfiles = importData.isImportProfiles;
	var isImportSchedules = importData.isImportSchedules;
	var isImportUsers = importData.isImportUsers;
	
	var numberOfImportProfilesWithHasDatabase = 0;
	var isOverrideProfiles = false;
	var isOverrideDatabases = false;
	
	if (isImportProfiles) {
		
		// Reset v8profilesDb
		resetV8profilesDb();
		
		// Check if we import a profile which has a database
		// and reset the isImportProfile and isImportDatabase properties.
	
		var v7profilesDb = importData.v7profilesDb;
		var v8profilesDb = importData.v8profilesDb;
		
		for (var i = 0; i < v7profilesDb.length; i++) {
			
			var isChecked = util.getF('import_data_profile_object:' + i);
			var theProfile = v7profilesDb[i];
			
			// util.showObject(theProfile);
			
			theProfile.isImportProfile = isChecked;
			theProfile.isImportDatabase = false;
			
			if (isChecked) {
				
				if (theProfile.hasDatabase) {
					numberOfImportProfilesWithHasDatabase++;
				}
				
				if (theProfile.profileExistsInV8) {
					
					// Mark the version 8 profiles so that we know
					// it becomes overriden.
					var v8profileName = theProfile.existingV8profileName;
					var theV8profile = v8profilesDb[util.h(v8profileName)];
					theV8profile['profileBecomesOverriden'] = true;
					
					isOverrideProfiles = true;
				}
				
				if (theProfile.isMysql || theProfile.isCustomDbDirectory) {
					// isOverrideDatabases is set regardless if the database is actually imported
					// because a user may want to use v7 and v8, which we don't know. To avoid any
					// conflicts we have to warn the user if v7 and v8 tries to share the same
					// database, it doesn't matter if the database is already built or not.
					isOverrideDatabases = true;
				}
			}
		}
	}
	
	// Set isOverrideProfiles, isOverrideUsers, isOverrideDatabases in global object for later use
	
	var isOverrideUsers = (importData.isImportUsers && importData.isDuplicateUsers);

	importData.isOverrideProfiles = isOverrideProfiles;
	importData.isOverrideUsers = isOverrideUsers;
	importData.isOverrideDatabases = isOverrideDatabases; 

	// alert('numberOfImportProfilesWithHasDatabase: ' + numberOfImportProfilesWithHasDatabase);
	
	if (numberOfImportProfilesWithHasDatabase > 0) {
		
		importDataUtil.buildDatabasesObjectList(v7profilesDb);
		setWizardPage('choose_databases');
	}
	else if (isOverrideProfiles || isOverrideUsers) {
		
		goToOverrideObjectsWarningPage();
	}
	else if (isOverrideDatabases) {
		goToOverrideDatabasesWarningPage();
	}
	else {
	
		goToFinalWizardPage();
	}
}

//
//
// Wizard - choose databases
//
//

function checkoutChooseDatabasesPage() {
	
	var v7profilesDb = importData.v7profilesDb;
	
	var isImportMySqlDatabase = false;
	var isCustomDbDirectory = false;
	
	for (var i = 0; i < v7profilesDb.length; i++) {
		
		var theProfile = v7profilesDb[i];
		
		if (theProfile.isImportProfile && theProfile.hasDatabase) {
			
			var isImportDatabase = util.getF('import_data_profile_db_object:' + i);
			theProfile.isImportDatabase = isImportDatabase;
		}
	}
	
	if (importData.isOverrideProfiles || importData.isOverrideUsers) {
		goToOverrideObjectsWarningPage();
	}
	else if (importData.isOverrideDatabases) {
		// isOverrideDatabases is already set upon the profiles object page because
		// we show the override warning also for un-build v7 databases!
		goToOverrideDatabasesWarningPage();
	}
	else {
		goToFinalWizardPage();
	}
}

//
//
// Override objects warning page
//
//

function goToOverrideObjectsWarningPage() {
	
	// alert('goToOverrideObjectsWarningPage()');
	
	var wizardLabel = '';
	var isOverrideProfiles = importData.isOverrideProfiles;
	var isOverrideUsers = importData.isOverrideUsers;
	
	if (isOverrideProfiles && isOverrideUsers) {
		wizardLabel = langVar('lang_admin.import.override_profiles_and_users_warning');
	}
	else if (isOverrideProfiles) {
		wizardLabel = langVar('lang_admin.import.override_profiles_warning');
	}
	else {
		wizardLabel = langVar('lang_admin.import.override_users_warning');
	}
	
	util.updateT('import_data:override_info:wizard_label', wizardLabel);
	
	util.showE('import_data:override_info:profiles', isOverrideProfiles);
	util.showE('import_data:override_info:users', isOverrideUsers);
	setWizardPage('override_objects_warning');
}


//
//
//
// Override databases warning page handling
//
//
//

function goToOverrideDatabasesWarningPage() {
	
	importDataUtil.buildOverrideDatabasesList(importData.v7profilesDb);
	setWizardPage('override_databases_warning');
}

function checkoutOverrideDatabasesWarningPage() {
	
	goToFinalWizardPage();
}

function editDatabaseNameOrDirectory(evt) {
	
	var element = evt.target || evt.srcElement;
	var tagName = element.nodeName;
	
	if (tagName == 'A') {
		
		// Get itemIndex from elementId
		var elementId = element.id;
		var dat = elementId.split(':');
		var itemIndex = parseInt(dat[2], 10);
		importDataEditDb.open(itemIndex);
	}
}


//
//
// Final wizard page
//
//

function goToFinalWizardPage() {
	
	// alert('goToFinalWizardPage()');
	
	// Build final import list
	importDataUtil.buildFinalImportList();
	
	// Set final wizard page
	setWizardPage('final');
}

	
//
// General wizard handling
//


function goBack() {
	
	// Activated when clicking the Back button
	var wizardPath = importData.wizardPath;
	var currentPageIndex = wizardPath.length - 1;
	var currentPageName = wizardPath[currentPageIndex];
	var previousPageName = wizardPath[currentPageIndex - 1];
	
	
	/*
	if (currentPageName == 'define_mysql_names') {
		// Remember the new mySQL names if any are defined
		// so that the user must not re-type any new name
		// when re-entering this page
		var v7profilesDb = importData.v7profilesDb;
		for (var i = 0; i < v7profilesDb.length; i++) {
			var theProfile = v7profilesDb[i];
			if (theProfile.isImportDatabase && theProfile.isMysql) {
				theProfile.newMysqlDatabaseName = util.getF('import_data_new_mysql_database_name:' + i);
			}
		}
	}
	*/
	
	// Remove current page from array
	wizardPath.splice(currentPageIndex, 1);
	
	// alert('goBack() - wizardPath: ' + wizardPath);
	
	util.hideE('import_data:' + currentPageName + ':page');
	util.showE('import_data:' + previousPageName + ':page');
	
	setButtonState();
}

function goNext() {
	
	// Activated when clicking the Next button
	
	var activePageName = getActivePageName();
	
	// alert('goNext() - currentPageName: ' + currentPageName);
	
	switch (activePageName) {
		
		case 'define_pathname':
		
			checkoutPathnamePage();
			break;
		
		case 'choose_objects':
			
			checkoutChooseObjectsPage();
			break;
			
		case 'choose_databases':
			
			checkoutChooseDatabasesPage();
			break;
			
		case 'override_objects_warning':
		
			if (importData.isOverrideDatabases) {
				goToOverrideDatabasesWarningPage();
			}
			else {
				goToFinalWizardPage();
			}
		
			break;
			
		case 'override_databases_warning':
		
			checkoutOverrideDatabasesWarningPage();
			break;
			
		case 'final':

			setButtonImportingState();
			importDataStack.start();

			break;
	}
}

function setWizardPage(pageName) {
	
	util.hideE(importData.wizardPages);
	
	var wizardPath = importData.wizardPath;
	wizardPath[wizardPath.length] = pageName;
	util.showE('import_data:' + pageName + ':page');
	
	setButtonState();
}

function browsePathname() {
	util.fileManagerWindow.open('import_data:pathname');
}
