//
// admin licenseEditor
//


var licenseEditor = (function() {

    var YE = YAHOO.util.Event,
        panel = null,
	    validator = null,
	    isCollapsedLicenseKey = true,
		existingLicenseKeys = {};

	function init() {

		var panelObj = {
			panelId: 'edit_license:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.licensing.add_or_change_license_key'),
			left: 200,
			top: 100,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: licenseEditor.closePanel
		};

		panel = new util.Panel3(panelObj);
		validator = new util.Validator();

		YE.addListener('edit_license:expand_collapse_license_key_field_btn', 'click', licenseEditor.toggleLicenseKeyFieldHeight);

		YE.addListener('edit_license:save_btn', 'click', licenseEditor.saveLicense);
		YE.addListener('edit_license:cancel_btn', 'click', licenseEditor.closePanel);
	}

	function setSavingState(isValidationState) {

		util.showEV('edit_license:saving_info', isValidationState);
		util.disableE(['edit_license:key', 'edit_license:save_btn', 'edit_license:cancel_btn'], isValidationState);
	}

	function toggleLicenseKeyFieldHeight() {

        var textarea = util.getE('edit_license:key');

        textarea.rows = isCollapsedLicenseKey ? 13 : 2;
        var buttonLabel = isCollapsedLicenseKey ? langVar('lang_admin.licensing.collapse_license_field') : langVar('lang_admin.licensing.expand_license_field');
        util.updateT('edit_license:expand_collapse_license_key_field_btn', buttonLabel);

        isCollapsedLicenseKey = !isCollapsedLicenseKey;
    }

	function openPanel(installedKeys) {

		if (!panel) {
			init();
		}
		
		existingLicenseKeys = installedKeys;
		
		// Reset form
		setSavingState(false);
		validator.reset();

		util.setF('edit_license:key', '');

		panel.open();

		var element = util.getE('edit_license:key');
		element.focus();
	}

	function closePanel() {
		panel.close();
	}

	function saveLicense() {

		var licenseKey = validator.isValue('edit_license:key');
			dat = '',
			url = '?dp=admin_pages.licensing.save_license';


		// Check if key already exists
		if (licenseKey !== '' && existingLicenseKeys[licenseKey]) {
			validator.isCustom('edit_license:key', langVar('lang_admin.licensing.duplicate_license_message'));
		}

		if (validator.allValid()) {

			setSavingState(true);

			dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			dat += 'v.fp.license_key=' + encodeURIComponent(licenseKey);

			util.serverPost(url, dat);
		}
	}

	function saveLicenseResponse(dat) {

		if (dat.isValid) {
			
			// Reload licensing page
			location.reload(true);
		}
		else {

			// Show error
			setSavingState(false);
			// Show custom error message and invoke allValid(), else the error isn't shown
			validator.isCustom('edit_license:key', dat.errorMsg);
			validator.allValid();
		}
	}

    return {
        openPanel: openPanel,
        closePanel: closePanel,
        saveLicense: saveLicense,
        toggleLicenseKeyFieldHeight: toggleLicenseKeyFieldHeight,
        saveLicenseResponse: saveLicenseResponse
    }
    
}());