//
// logFilterComment.js
//

var logFilterComment = {
	
	panel: null,
	saveCommentHandler: null,
	
	init: function(saveCommentHandlerFunction) {
		
		logFilterComment.saveCommentHandler = saveCommentHandlerFunction;
		
		var panelObj = {
			panelId: 'log_filter_comment:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.btn.comment'),
			left: 316,
			top: 160,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: logFilterComment.close
		};
		
		logFilterComment.panel = new util.Panel3(panelObj);
		
		var YE = YAHOO.util.Event;
		YE.addListener('log_filter_comment:ok_btn', 'click', logFilterComment.save);
		YE.addListener('log_filter_comment:cancel_btn', 'click', logFilterComment.close);
	},

	open: function(comment) {
		
		// Convert <br /> tags to new line
		comment = comment.replace(/<br\s\/>/g, '\n');
		
		util.setF('log_filter_comment:comment', comment);
		logFilterComment.fixDivOverflow(true);
		logFilterComment.panel.open();
	},
	
	close: function() {
		
		logFilterComment.fixDivOverflow(false);
		logFilterComment.panel.close();
	},
	
	save: function() {
		
		var comment = util.getF('log_filter_comment:comment');
		
		// Escape newline and carriage return with <br /> tags
		comment = comment.replace(/\n/g, '<br />'); // newline
		comment = comment.replace(/\r/g, '<br />'); // carriage return
		
		logFilterComment.close();
		
		// Return to calle
		logFilterComment.saveCommentHandler(comment);
	},
	
	fixDivOverflow: function(isFix) {
		
		// Firefox has a problem with the underlying filter item div's.
		// The problem is caused by the div overflow setting where form fields
		// above the div don't anymore show focus on form fields. We solve this
		// by setting the div overflow to 'hidden' while a subform is open.
		
		var element = util.getE('log_filters:structured:list:div');
		
		// Element does not exist in logParsingFilters form, so check for element
		if (element) {
			element.style.overflow = isFix ? 'hidden' : 'scroll';
		}
	}
};


