//
// reportFieldsUtil.js
//

var reportFieldsUtil = {
	
	//
	// tabs
	//
	
	tabActivated: function(tabId) {
		
		if (!util.isObject(tabId)) { // isObject has be addded due an IE problem, see customizeRE.js for details
			reportFieldsUtil.setTabPanel(tabId);
		}
	},
	
	setTabPanel: function(tabId) {
		
		reportFields.tabs.setActiveTab(tabId);
		
		var tabIds = reportFields.tabIds;
		for (var i = 0; i < tabIds.length; i++) {
			util.hideE('report_fields:' + tabIds[i] + ':panel');
		}
		
		util.showE('report_fields:' + tabId + ':panel');
		
		// Kepp track of the active tabId
		// reportFields.activeForm.tabId = tabId;
	},
	
	verifyAndSetFormDisplay: function(isDatabaseField, isExpression, isAggregatingField, isHierarchicalField) {
		
		// alert('verifyAndSetFormDisplay()');
		
		var activeForm = reportFields.activeForm;

        // Change settings if current form does not match the activeForm
		
		if (activeForm.isDatabaseField != isDatabaseField || 
			activeForm.isExpression != isExpression ||
			activeForm.isAggregatingField != isAggregatingField ||
			activeForm.isHierarchicalField != isHierarchicalField) {
				
			var showTabBarAndPanels = true; 
				
			util.hideE(['report_fields:override_category_section', 'report_fields:category_section']);
				
			// The tab sequnce changes		
			var tabSequnce = [];
			
			if (isDatabaseField && !isExpression) {
				
				if (isAggregatingField) {
					util.showE('report_fields:average_denominator_field_section');
					tabSequnce = ['general', 'numerical_options', 'column_info'];
				}
				else if (isHierarchicalField) {
					tabSequnce = ['general', 'hierarchical_field_options', 'column_info'];
				}
				else {
					tabSequnce = ['general', 'column_info'];
				}
				
				util.showE('report_fields:override_category_section');
			}
			else if (isExpression && !isDatabaseField) {
				
				if (!isAggregatingField) {
					tabSequnce = ['general', 'expression', 'column_info'];
				}
				else {
					util.hideE('report_fields:average_denominator_field_section');
					tabSequnce = ['general', 'expression', 'numerical_options', 'column_info'];
				}
				
				util.showE('report_fields:category_section');
			}
			else {
				// No source is selected, so we set the minimum tabs
				tabSequnce = ['general'];
				showTabBarAndPanels = false;
			}

            util.showE('report_fields:skip_escaping_section', !isAggregatingField);
			
			reportFields.tabs.setSequence(tabSequnce, 'general');
			
			// Set an initial tab so that all other tab panels are hidden
			reportFieldsUtil.setTabPanel('general');
			
			util.showEV(['report_fields:tab_bar', 'report_fields:tab_panels'], showTabBarAndPanels);

			
			//
			// Update activeForm state
			//
			
			activeForm.isDatabaseField = isDatabaseField;
			activeForm.isExpression = isExpression;
			activeForm.isAggregatingField = isAggregatingField;
			activeForm.isHierarchicalField = isHierarchicalField;
		}
	},
	
	
	//
	// Change source handling
	//
	
	sourceActor: function() {
		
		// The source has changed.
		// We may need to update the tab sequence
		var isDatabaseField = false;
		var isExpression = false;
		var isAggregatingField = false;
		var isHierarchicalField = false;
		
		var source = util.getF('report_fields:source');
		
		var isEnabledTypeList = false;
		
		if (source != '') {
			
			if (source != '__EXPRESSION__') {
				
				isDatabaseField = true;
				
				var dbFieldName = source;
				var dbFieldItem = reportFields.databaseFieldsDb[util.h(dbFieldName)];
				
				// util.showObject(dbFieldItem);
				
				isAggregatingField = dbFieldItem.isAggregatingField;
				isHierarchicalField = dbFieldItem.isHierarchicalField;
				
				// Update the type list
				util.setF('report_fields:type', dbFieldItem.type);
				
				
				// Update the database field category label
				reportFieldsUtil.updateDatabaseFieldCategoryLabel(dbFieldItem.category);
			}
			else {

				isExpression = true;
				isEnabledTypeList = true;
                isAggregatingField = true;
				
				// Reset type to int
				util.setF('report_fields:type', 'int');
			}
		}
		
		util.enableE('report_fields:type', isEnabledTypeList);
		
		reportFieldsUtil.verifyAndSetFormDisplay(isDatabaseField, isExpression, isAggregatingField, isHierarchicalField);
	},
	
	//
	// Change type handling
	//
	
	typeActor: function() {
		
		// The type changes, this is only possible if the selected source is set to Use Expression
		
		var type = util.getF('report_fields:type');
		
		var isDatabaseField = false;
		var isExpression = true;
		var isAggregatingField = (type != 'string');
		var isHierarchicalField = false;
		
		reportFieldsUtil.verifyAndSetFormDisplay(isDatabaseField, isExpression, isAggregatingField, isHierarchicalField);
	},
	
	
	overrideCategoryActor: function() {
		
		var isOverride = this.checked;
		util.enableE('report_fields:override_category', isOverride);
	},
	
	updateDatabaseFieldCategoryLabel: function(category) {
		
		var h = util.h;
		var label;
			
		if (category != '' && reportFields.fieldCategoriesDb[h(category)]) {
			var categoryItem = reportFields.fieldCategoriesDb[h(category)];
			label = categoryItem.label;
		}
		else {
			label = 'None';
		}
			
		util.updateT('report_fields:db_field_category_label', '(' + label + ')');
	},
	
	displayFormatTypeActor: function() {
		
		var displayFormatType = util.getF('report_fields:display_format_type');
		var isCustom = (displayFormatType == 'custom');
		util.showE('report_fields:custom_display_format_type_section', isCustom);
	},

	displayFormatTypeExportActor: function() {

		var displayFormatType = util.getF('report_fields:display_format_type_export');
		var isCustom = (displayFormatType == 'custom');
		util.showE('report_fields:custom_display_format_type_export_section', isCustom);
	},
		

	subitemsLevelActor: function() {
		
		var isSpecificSubitemsLevel = (this.id == 'subitems_type:specific_level');
		util.enableE('subitems_level', isSpecificSubitemsLevel);
	},
	
	toggleSortBeforeExpressionEvaluation: function() {
		
		var makeEnabled = this.checked;
		
		// Get current selected reportField which is set again so that
		// the selected report field remains selected, regardless if checked or unchecked
		var selectedReportFieldName = util.getF('report_fields:sort_by_before_expression_evaluation');
		
		if (makeEnabled) {
			// Update the sort by list because the report field names/labels could have been changed
			reportFieldsUtil.updateSortBeforeExpressionEvaluationList();
		}
		
		// Set the list
		reportFieldsUtil.setSortBeforeExpressionEvaluation(selectedReportFieldName, makeEnabled);
	},
	
	setSortBeforeExpressionEvaluation: function(reportFieldName, makeEnabled) {
		
		util.setF('report_fields:sort_by_before_expression_evaluation', reportFieldName);
		util.enableE('report_fields:sort_by_before_expression_evaluation', makeEnabled);
		util.enableE('report_fields:sort_direction_before_expression_evaluation', makeEnabled);
	},
	
	updateSortBeforeExpressionEvaluationList: function() {
		
		// Populates the list with up to date report fields data
		var itemsDb = reportFields.itemsDb;
		var reportFieldsListItems = [];
		reportFieldsListItems[0] = {name:'', label:langVar('lang_admin.report_fields.select_report_field')};
		
		for (var i = 0; i < itemsDb.length; i++) {
			
			var itemDat = itemsDb[i].dat;
			reportFieldsListItems[reportFieldsListItems.length] = {name:itemDat.nodeName, label:itemDat.label};
		}
		
		util.populateSelect('report_fields:sort_by_before_expression_evaluation', reportFieldsListItems, 'name', 'label');
	},
	
	//
	// updateListLabel
	//
	
	updateListLabelActor: function() {
		
		setTimeout('reportFieldsUtil.updateListLabel()', 300);
	},
	
	updateListLabel: function() {
		
		var label =  util.getF('report_fields:label');
		
		if (label == '') {
			label = '-';
		}
		
		reportFields.theList.updateListLabel(label);
	},
	
	//
	// View available expression fields
	//
	
	viewAvailableExpressionFields: {
		
		fieldsPanel: null,
		
		init: function() {
			
			var viewExprFieldsObj = {
				panelId: 'view_custom_expression_fields:panel',
				tbodyId: 'view_custom_expression_fields:tbody',
				panelLabel: langVar('lang_admin.available_expression_fields.available_fields'),
				availableExpressionFieldsDb: [] // empty array because report fields could change, so we update the list each time the window is opened
				// left: 0
			};
			
			reportFieldsUtil.viewAvailableExpressionFields.fieldsPanel = new AvailableExprFields(viewExprFieldsObj);
			
			YAHOO.util.Event.addListener('view_custom_expression_fields:close_btn', 'click', reportFieldsUtil.viewAvailableExpressionFields.close);
		},
		
		open: function() {
			
			// We create a fresh report fields list prior open the available fields panel
			
			var theList = reportFields.theList;
			var selectedItemId = theList.selectedItemId;
			
			var itemsDb = reportFields.itemsDb;
			var availableFields = [];
			
			for (var i = 0; i < itemsDb.length; i++) {
				
				var item = itemsDb[i];
				var itemDat = item.dat;
				
				/*
				if (i == 0) {
					util.showObject(item);
				}
				*/
				
				if (item.id != selectedItemId && itemDat.isDatabaseField) {
					availableFields[availableFields.length] = {label:itemDat.label, name:itemDat.nodeName};
				}
			}
			
			// util.showObject(availableFields);
			
			reportFieldsUtil.viewAvailableExpressionFields.fieldsPanel.updateList(availableFields);
			reportFieldsUtil.viewAvailableExpressionFields.fieldsPanel.open();
		},
		
		close: function() {
			reportFieldsUtil.viewAvailableExpressionFields.fieldsPanel.close();
		}
	}
};
