//
// reportsUtil.js
//

reportsUtil = {
	
	initViewAvailableFields: function() {
		
		// This inits viewAvailableReportFilterFields and viewAvailableReportTableFilterFields
		
		// Create avaialble expression fields arrays, then init the view panels
	
		var queryFieldsDb = reports.queryFieldsDb;
		var reportFilterFields = [];
		var customFilterFields = [];
		
		for (var i = 0; i < queryFieldsDb.length; i++) {
			
			var item = queryFieldsDb[i];
			
			if (!item.isExpression) {
				
				var reportFieldLabel = item.label;
				var reportFieldName = item.name;
				
				if (!item.isAggregatingField) {
					
					var dbFieldName = item.dbFieldName;
					reportFilterFields[reportFilterFields.length] = {label:reportFieldLabel, name:dbFieldName};
				}
				
				customFilterFields[customFilterFields.length] = {label:reportFieldLabel, name:reportFieldName};
			}
		}
		
		reportsUtil.viewAvailableReportFilterFields.init(reportFilterFields);
		reportsUtil.viewAvailableReportTableFilterFields.init(customFilterFields);
	},
	
	viewAvailableReportFilterFields: {
		
		fieldsPanel: null,
		
		init: function(availableExpressionFieldsDb) {
			
			var viewExprFieldsObj = {
				panelId: 'view_report_filter_expression_fields:panel',
				tbodyId: 'view_report_filter_expression_fields:tbody',
				panelLabel: langVar('lang_admin.available_expression_fields.available_fields'),
				availableExpressionFieldsDb: availableExpressionFieldsDb
			};
	
			reportsUtil.viewAvailableReportFilterFields.fieldsPanel = new AvailableExprFields(viewExprFieldsObj);
			
			YAHOO.util.Event.addListener('view_report_filter_expression_fields:close_btn', 'click', reportsUtil.viewAvailableReportFilterFields.close);
		},
		
		open: function() {
			reportsUtil.viewAvailableReportFilterFields.fieldsPanel.open();
		},
		
		close: function() {
			reportsUtil.viewAvailableReportFilterFields.fieldsPanel.close();
		}
	},
	
	viewAvailableReportTableFilterFields: {
		
		fieldsPanel: null,
		
		init: function(availableExpressionFieldsDb) {
			
			var viewExprFieldsObj = {
				panelId: 'view_custom_expression_fields:panel',
				tbodyId: 'view_custom_expression_fields:tbody',
				panelLabel: langVar('lang_admin.available_expression_fields.available_fields'),
				availableExpressionFieldsDb: availableExpressionFieldsDb
			};
			
			reportsUtil.viewAvailableReportTableFilterFields.fieldsPanel = new AvailableExprFields(viewExprFieldsObj);
			
			YAHOO.util.Event.addListener('view_custom_expression_fields:close_btn', 'click', reportsUtil.viewAvailableReportTableFilterFields.close);
		},
		
		open: function() {
			reportsUtil.viewAvailableReportTableFilterFields.fieldsPanel.open();
		},
		
		close: function() {
			reportsUtil.viewAvailableReportTableFilterFields.fieldsPanel.close();
		}
	}
};
