//
// xrefs.js
//


var xrefs = {
	
	validator: null,
	
	theList: null,
	
	databaseFieldsDb: [],
	itemsDb: [], // items work array
	itemsDbBackup: [], // items array in the state when first loaded or last saved, it is used upon Undo Changes
	
	saveChangesBtn: null,
	newItemBtn: null,
	deleteBtn: null,
	duplicateBtn: null,
	undoAllChangesBtn: null,
	
	activeFormElementId: '', // no_item_form | xrefs_form
	
	isEditMode: false
}

function init() {
	
	xrefs.validator = new util.Validator();
	
	//
	// init toolbar buttons
	//
	
	xrefs.saveChangesBtn = new util.ToolbarButton('save_changes', saveXrefs, toolbarButtonsDb);		
	xrefs.newItemBtn = new util.ToolbarButton('new_xref_group', newItem, toolbarButtonsDb);
	xrefs.duplicateBtn = new util.ToolbarButton('duplicate', duplicateItem, toolbarButtonsDb);
	xrefs.deleteBtn = new util.ToolbarButton('delete', deleteItem, toolbarButtonsDb);
	xrefs.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
	
	var permissions = pageInfo.permissions;
	
	if (permissions.isEdit) {
		
		if (!permissions.isAdd) {
			xrefs.newItemBtn.disableAndIgnore();
			xrefs.duplicateBtn.disableAndIgnore();
		}
		
		if (!permissions.isDelete) {
			xrefs.deleteBtn.disableAndIgnore();
		}
		
		// Register isModifiedPageHandler in adminConfig.js
		// (We don't check for modifications if there is no edit 
		// permission because there is no Save button anyway!)
		adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
	}
	else {
		
		xrefs.saveChangesBtn.disableAndIgnore();
		xrefs.newItemBtn.disableAndIgnore();
		xrefs.duplicateBtn.disableAndIgnore();
		xrefs.deleteBtn.disableAndIgnore();
		xrefs.undoAllChangesBtn.disableAndIgnore();
	}
	
	YAHOO.util.Event.addListener('xrefs:group_label', 'keyup', updateItemListLabelActor);
	
	// Init xrefsList
	xrefsList.init();
			
	//
	// Create theList object
	//
	
	xrefs.theList = new listcontroller.List({
		containerElementId: 'item_list_body',
		itemEvent: itemActivated,
		isSwitch1: true,
		isMoveControl: true
	});
	
	// init OptionInfo
	optionInfo.init();
}

function initItemList() {
	
	var theList = xrefs.theList;
	
	// Init the item list
	xrefs.theList.init(xrefs.itemsDb);
	
	// select the first item
	var firstItemId = theList.getFirstItemId();
	if (firstItemId) {
		var isEditMode = false;
		setItem(firstItemId, isEditMode);
	}
}

function setMainDisplay() {
	
	var isItems = xrefs.theList.isItems();
	
	xrefs.deleteBtn.enable(isItems);
	xrefs.duplicateBtn.enable(isItems);
	
	var formElementId = isItems ? 'xrefs_form' : 'no_item_form';
	
	if (xrefs.activeFormElementId != formElementId) {
		
		util.hideE(['xrefs_form', 'no_item_form']);
		util.showE(formElementId);
		xrefs.activeFormElementId = formElementId;
	}
}

function getXrefsData() {

	if (!pageInfo.exitActive) {

	var url = '?dp=config_pages.xrefs.get_xrefs_data';
	url += '&p=' + pageInfo.profileName;
	var dat = 'v.fp.page_token=' + pageInfo.pageToken;

		
		util.helpWindow.init('');
		util.serverPost(url, dat);
	}
}

function getXrefsDataResponse(dat) {
	
	if (!pageInfo.exitActive) {
		
		// Handle database fields
		
		xrefs.databaseFieldsDb = dat.databaseFieldsDb;
		var databaseFieldsDb = xrefs.databaseFieldsDb
		
		// Add isActiveField property to databaseFieldsDb
		// for (var i = 0; i < databaseFieldsDb.length; i++) {
		//	databaseFieldsDb[i]['isActiveField'] = false;
		// }
		
		// Create databaseFieldsDb hash
		util.createHash(databaseFieldsDb, 'id');
		
		xrefs.itemsDb = dat.xrefsDb;
		xrefs.itemsDbBackup = util.cloneObject(dat.xrefsDb);
		
		init();
		initItemList();

		// Set final toolbar state
		xrefs.saveChangesBtn.enable();
		xrefs.undoAllChangesBtn.enable();
		xrefs.newItemBtn.enable();
		xrefs.duplicateBtn.enable();
		
		// Init main display
		setMainDisplay();
		
		util.showE('form_section');
		
		adminConfig.setItemListSize();
		YAHOO.util.Event.addListener(window, 'resize', adminConfig.setItemListSize);
		
		pageInfo.initComplete = true;
	}
}

function updateItemListLabelActor() {
	setTimeout('updateItemListLabel()', 300);
}

function updateItemListLabel() {
	
	var label = util.getF('xrefs:group_label');
	if (label == '') {label = '-';}
	xrefs.theList.updateListLabel(label);
}


function itemActivated(itemId) {
	
	if (validateActiveItem()) {
		var isEditMode = false;
		setItem(itemId, isEditMode);
	}
}

function setItem(itemId, isEditMode) {
	
	// Select active item in list and displays the form	
	xrefs.theList.selectItem(itemId);
	updateForm(isEditMode);
	
	// Set delete button
	// var makeEnabled = (theList.getNumberOfItems() > 1);
	// logSource.deleteBtn.enable(makeEnabled);
}

function newItem() {
	
	if (validateActiveItem()) {
		
		var theList = xrefs.theList;
	
		var newItemId = theList.getNewItemId();
		var label = langVar('lang_admin.cross_reference_groups.new_cross_reference_group');
		
		var obj = {
			id: newItemId,
			type: '',
			switch1: true,
			label: label,
			dat: {
				label: label,
				use_flat_table: false,
				fields: []
			}
		}
		
		theList.newItem(obj);
		
		var isEditMode = true;
		setItem(newItemId, isEditMode);
		
		setMainDisplay();
	}
}

function duplicateItem() {
		
	if (validateActiveItem()) {

		var clonedItemId = xrefs.theList.cloneItem();
		
		var isEditMode = true;
		setItem(clonedItemId, isEditMode);
	}
}

function deleteItem() {
	
	var nextItemIdToBeSelected = xrefs.theList.deleteItem();
	
	if (nextItemIdToBeSelected) {
	
		xrefs.validator.reset();
		resetFieldsError();
		var isEditMode = false;
		setItem(nextItemIdToBeSelected, isEditMode);
	}
	else {
		// No item exists
		setMainDisplay();
	}
}


function updateForm(isEditMode) {
	
	// isEditMode UPDATE
	// We always use isEditMode because I think its confusing otherwise!
	// So we override isEditMode here
	isEditMode = true;
	
	var item = xrefs.theList.getSelectedItem();
	var itemDat = item.dat;
	
	util.setF('xrefs:group_label', itemDat.label);
	util.setF('xrefs:use_flat_table', itemDat.use_flat_table);

	// util.showObject(itemDat);
	
	// Update xrefsList
	xrefsList.updateForm(itemDat.fields, itemDat.sort_by, itemDat.sort_direction, isEditMode);
}

function updateFormLabel() {
		
	var item = theList.getSelectedItem();
	var itemLabel = item.dat.label;
	var formFieldLabel = util.getF('label');

	if (itemLabel != formFieldLabel) {
		// update item list label and form label
		// util.updateT('item_form_label', formFieldLabel);
		theList.updateListLabel(formFieldLabel);
	}
}

function resetFieldsError() {
	
	// The xrefs:active_fields_list:error is not handled via validator()!
	
	util.hideE('xrefs:active_fields_list:error');
}

function validateActiveItem() {
	
	// Only validate if isEdit permission and if items
	
	var theList = xrefs.theList;
	
	if (pageInfo.permissions.isEdit && theList.isItems()) {
	
		var validator = xrefs.validator;
		
		validator.reset();
		var o = {};
		o.label = validator.isValue('xrefs:group_label');
		o.label = validator.isUnique('xrefs:group_label', theList.getLookupItems('label'));
		o.use_flat_table = util.getF('xrefs:use_flat_table');
		
		// Check the field items
		// A cross-reference group must contain at least one non-aggregating field and one aggregating field
		var fields = xrefsList.activeFieldsDb;
		var numberNoneAggregatingFields = 0;
		var numberAggregatingFields = 0;
		
		for (var i = 0; i < fields.length; i++) {
			var fieldId = fields[i];
			var fieldItem = xrefs.databaseFieldsDb[util.h(fieldId)];
			
			if (fieldItem.isAggregatingField) {
				numberAggregatingFields++;
			}
			else {
				numberNoneAggregatingFields++;
			}
		}
		
		var isValidFields = (numberNoneAggregatingFields > 0 && numberAggregatingFields > 0);
		
		if (isValidFields) {
			
			// Is valid xrefs group
			o.fields = util.cloneObject(fields);

			// Het sortBy
			o.sort_by = xrefsList.activeSortBy;
			o.sort_direction = o.sort_by != '' ? util.getF('xrefs:sort_direction') : '';
		}
		else {
			
			// Throw custom error message
			util.showE('xrefs:active_fields_list:error');
		}
		
		
		if (validator.allValid() && isValidFields) {
			theList.saveItem(o);
			return true;
		}
		
		return false;
	}
	
	// No isEdit permission or no items
	return true;
}

function saveXrefs() {
	
	if (validateActiveItem()) {
		
		var isModified = xrefs.theList.getIsModified();
		// alert('saveChanges() - isModified: ' + isModified);
		
		if (isModified) {
			
			if (pageInfo.showRebuildDbAdvice) {
					
				rebuildDbAdvice.open(processSaveXrefs);
			}
			else {
				processSaveXrefs();
			}
		}
		else {
			
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	}
}

function processSaveXrefs(isHideRebuildDbAdviceMessage) {
	
	// This function may be invoked from rebuildDbAdvice.
	// The argument isHideRebuildDbAdviceMessage only exists if invoked from rebuildDbAdvice
	
	util.hideE('form_section');
	util.showE('saving_info');
	
	var setHideRebuildDbAdviceMessage = (arguments.length == 1) ? isHideRebuildDbAdviceMessage : false;
	
	var itemsDb = xrefs.itemsDb;
	var databaseFieldsDb = xrefs.databaseFieldsDb;
	
var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
	dat += 'v.fp.set_hide_rebuild_db_advice_message=' + setHideRebuildDbAdviceMessage + '&';
	var xrefsDat = '';
	
	for (var i = 0; i < itemsDb.length; i++) {

		var item = itemsDb[i];
		var itemDat = item.dat;
		var fields = itemDat.fields;
		
		var path = 'v.fp.xrefs.' + i;
		
		xrefsDat += path + '.position=' + i + '&';
		xrefsDat += path + '.disabled=' + !item.switch1 + '&';
		xrefsDat += path + '.label=' + util.getEncodedURIComponent(itemDat.label) + '&';
		xrefsDat += path + '.use_flat_table=' + itemDat.use_flat_table + '&';
		
		for (var j = 0; j < fields.length; j++) {
			
			var fieldId = fields[j];
			var fieldItem = databaseFieldsDb[util.h(fieldId)];
			var fieldName = fieldItem.name;
			
			// The field value j is only used to maintain field order on server side,
			// it will be deleted after sorting the fields on server (same as position value).
			xrefsDat += path + '.fields.' + fieldName + '=' + j + '&';
		}

		xrefsDat += path + '.sort_by=' + itemDat.sort_by + '&';
		xrefsDat += path + '.sort_direction=' + itemDat.sort_direction + '&';
	}
	
	if (xrefsDat != '') {
		xrefsDat = xrefsDat.replace(/&$/, '');
	}
	else {
		// No xrefs
		xrefsDat = 'v.fp.xrefs=';
	}
	
	dat += xrefsDat;
	
	var url = '?dp=config_pages.xrefs.save_xrefs_data';
	url += '&p=' + pageInfo.profileName;
	util.serverPost(url, dat);
}

function processSaveXrefsResponse() {
	
	// reset isModified
	xrefs.theList.resetIsModified();
	
	// the saved work itemsDb becomes now the itemsDbBackup
	xrefs.itemsDbBackup = util.cloneObject(xrefs.itemsDb);
	
	util.hideE('saving_info');
	util.showE('form_section');
}

function undoAllChanges() {
	
	xrefs.itemsDb = util.cloneObject(xrefs.itemsDbBackup);
	initItemList();
	setMainDisplay();
	
	resetFieldsError();
}

function getIsModifiedPage() {
	
	if (!validateActiveItem() || xrefs.theList.getIsModified()) {
		return true;
	}
	return false;
}
