//
//
//
// newProfileWizard.js
//
//
//

var newProfileWizard = function() {

	var YE = YAHOO.util.Event;
	var YD = YAHOO.util.Dom;

	var GD = { // Global Data

		licensingTier: '',
		isLite: false,
		haveMYSQL: true,
		haveODBC: true,

		pageToken: '',

		wizard_labels: {},

		profilesDb: [],
		profileNodeNames: null,

		wizard_path: [], // defines the taken wizard path, on back the last entry will be removed

		validator: null,

		log_format_db: [], // array of objects with all log formats
		syslog_format_db: [],
		syslog_required_format_db: [],
		log_format_db_loaded: false,

		multiple_match_list: null,

		all_log_formats_list: null,
		all_syslog_formats_list: null,
		all_syslog_required_formats_list: null,

		defaultLogSource: {},
		is_active_log_source_file_mask: false,

		log_source: {},
		autodetecting_log_format_start_time: 0,
		log_format_progress_timer: null,
		log_format_autodetecting_id: '',
		log_format_autodetection_task_id: '',

		detected_log_formats_db: [], // array of auto-detected log formats
		num_detected_standalone_formats: 0,
		num_detected_syslog_formats: 0,
		num_detected_syslog_required_formats: 0,
		num_detected_syslog_optional_formats: 0,

		final_log_format_id: '', // used for standalone, syslog_required and syslog_optional
		final_syslog_id: '', // used for syslog format only
		final_log_format_string: '', // log format string, the variable is set when log format is apache_custom or blue_coat_custom

		numerical_fields_db: [],

		dbServer: { // Set defaults for non-enterprise users!
			type: 'internal_sql',
			database_directory: '',
			hostname: '',
			dsn: '',
			username: '',
			password: '',
			database_name: '',
			server_socket: '',
			bulk_import_method: '',
			load_data_directory: '',
			load_data_directory_on_server: '',
			sql_table_name_prefix: '',
			sql_table_name_suffix: ''
		},

		turnOnDatabaseFieldsIndices: true,
		turnOnCrossReferenceGroups: true,
		// turnOnSessionTracking: true,

		snapons: [], // Basic snapons info only, parametersForm objects are moved to a single snaponsParamatersForm
		snaponsParametersForm:[], // Contains parametersForm objects of one or multiple snapons

		profileLabel: '',
		profileNodeName: '',
		confirmDatabaseSharingPanel: null,

		timeoutId: 0
	};

	// Log data type Lookup table
	var LDT = {
		apache_custom: 'Apache custom',
		application: 'Application',
		beatbox_hits: 'Beatbox hits',
		bluecoat_custom: 'Bluecoat custom',
		csv: 'CSV',
		csv_generic: 'CSV generic',
		error: 'Error',
		ez_proxy_custom: 'EZ Proxy custom',
		firewall: 'Firewall',
		firewall1_ng: 'Firewall',
		ftp: 'FTP',
		ftp_server: 'FTP server',
		general: 'Generic',
		generic: 'Generic',
		generic_w3c: 'W3C', // KHP 09/May/2012, show "W3C" only
		http: 'HTP',
		http_access: 'HTTP access',
		http_proxy: 'HTTP proxy',
		http_referrer: 'HTTP referrer',
		http_server: 'HTTP server',
		internet_device: 'Internet device',
		mail: 'Mail',
		mail_pop: 'Mail POP',
		mail_server: 'Mail server',
		mail_smtp: 'Mail SMTP',
		media_server: 'Media server',
		netscape_http: 'Netscape HTTP',
		netscreen_ssg: 'Netscreen SSG',
		network: 'Network',
		network_device: 'Network device',
		other: '', // ignore
		proxy: 'Proxy',
		proxy_server: 'Proxy server',
		server: 'Server',
		smtp: 'SMTP',
		smtp_server: 'SMTP server',
		syslog: 'Syslog',
		syslog_optional: 'Logging device',
		syslog_required: 'Logging device',
		syslog_server: 'Syslog server',
		tcp_proxy: 'TCP proxy',
		virus: 'Virus',
		w3c: 'W3C',
		web_server: 'Web server',
		webstar: 'Webstar'
	};

	function init() {

		// alert('GD.init()');

		GD.validator = new util.Validator();

		var licensingTier = GD.licensingTier;
		GD.isLite = (licensingTier == 'lite');

		GD.wizard_labels = {
			log_source_page: langVar('lang_admin.new_profile_wizard.log_source_page.label'),
			log_format_no_match_page: langVar('lang_admin.new_profile_wizard.log_format_no_match_page.label'),
			log_format_direct_match_page: langVar('lang_admin.new_profile_wizard.log_format_direct_match_page.label'),
			log_format_multiple_match_page: langVar('lang_admin.new_profile_wizard.log_format_multiple_match_page.label'),
			log_format_all_page: langVar('lang_admin.new_profile_wizard.log_format_all_page.label'),
			syslog_no_match_page: langVar('lang_admin.new_profile_wizard.syslog_no_match_page.label'),
			syslog_direct_match_page: langVar('lang_admin.new_profile_wizard.syslog_direct_match_page.label'),
			syslog_multiple_match_page: langVar('lang_admin.new_profile_wizard.syslog_multiple_match_page.label'),
			syslog_all_page: langVar('lang_admin.new_profile_wizard.syslog_all_page.label'),
			syslog_required_direct_match_page: langVar('lang_admin.new_profile_wizard.syslog_required_direct_match_page.label'),
			syslog_required_multiple_match_page: langVar('lang_admin.new_profile_wizard.syslog_required_multiple_match_page.label'),
			syslog_required_all_page: langVar('lang_admin.new_profile_wizard.syslog_required_all_page.label'),
			log_format_not_supported_page: langVar('lang_admin.new_profile_wizard.log_format_options_not_supported_page.label'),
			db_server_page: langVar('lang_admin.new_profile_wizard.database_options_page.label'),
            db_warning_page: langVar('lang_admin.new_profile_wizard.database_warning_page.label'),
            db_performance_page: langVar('lang_admin.new_profile_wizard.database_performance_page.label'),
            log_format_options_page: langVar('lang_admin.new_profile_wizard.log_format_options_page.label'),
            snapons_page: langVar('lang_admin.new_profile_wizard.snapons_page.label'),
			profile_name_page: langVar('lang_admin.new_profile_wizard.profile_name_page.label')
		};

		// alert('GD.licensingTier: ' + GD.licensingTier);

		YE.addListener('back_btn', 'click', back_wizard);
		YE.addListener('next_btn', 'click', next_wizard);
		YE.addListener('cancel_btn', 'click', close_wizard);
		YE.addListener('show_more_info_btn', 'click', newProfileWizardUtil.toggleInfoSection);
		YE.addListener('log_source:show_matching_files_btn', 'click', show_matching_files);
		YE.addListener(['log_format_multiple_match_list', 'log_format_all_list'], 'change', check_and_display_log_format_description);

		GD.multiple_log_format_match_list = new logFormatsList.list(GD.isLite, 'log_format_multiple_match_container', langVar('lang_admin.new_profile_wizard.log_format_multiple_match_page.show_all_log_formats_label'));
		GD.multiple_syslog_required_match_list = new logFormatsList.list(GD.isLite, 'syslog_required_multiple_match_container', langVar('lang_admin.new_profile_wizard.syslog_required_multiple_match_page.show_all_devices_label'));
		GD.multiple_syslog_match_list = new logFormatsList.list(GD.isLite, 'syslog_multiple_match_container', langVar('lang_admin.new_profile_wizard.syslog_multiple_match_page.show_all_syslogs_label'));

		GD.all_log_formats_list = new allLogFormatsList.list('log_format_all_list');
		GD.all_syslog_formats_list = new allLogFormatsList.list('syslog_all_list');
		GD.all_syslog_required_formats_list = new allLogFormatsList.list('syslog_required_all_list');

		// Init database options
		if (licensingTier == 'enterprise' && (GD.haveMYSQL || GD.haveODBC)) {

			YE.addListener('db_server:type', 'change', toggleDatabaseType);
			YE.addListener('db_server:mysql_bulk_import_method', 'change', toggleMysqlBulkImportMethod);
			YE.addListener('db_server:mssql_bulk_import_method', 'change', toggleMssqlBulkImportMethod);

			util.setF('db_server:type', 'internal_sql');
		}

        var a = [
            'log_format_options_page:select_all_btn',
            'log_format_options_page:deselect_all_btn',
            'snapons_page:select_all_btn',
            'snapons_page:deselect_all_btn'];

		YE.addListener(a, 'click', selectDeselectAll);

		YE.addListener('profile_name', 'keypress', finish_wizard_via_enter_key);

		// alert('GD.isLite: ' + GD.isLite);

		// Init optionInfo
		optionInfo.init();

		// Init and set default log_source
		var isConfig = false;
		logSourceUtil.init(GD.isLite, isConfig);
		util.setF('log_source:type', 'local');
		util.setF('log_source:pathname', GD.defaultLogSource.pathname);
		logSourceUtil.setLogSourceDisplay();                                               

		goto_wizard('log_source_page');
	}

	function getBasicData() {

		GD.pageToken = util.getF('page_token');
		var url = '?dp=new_profile_wizard.get_basic_data';
		var dat = 'v.fp.page_token=' + GD.pageToken;
		util.serverPost(url, dat);
	}

	function getBasicDataResponse(dat) {

		// util.showObject(dat, 'getBasicDataResponse()');
		GD.licensingTier = dat.licensingTier;
		GD.isLite = (dat.licensingTier == 'lite');
		GD.haveMYSQL= dat.haveMYSQL;
		GD.haveODBC = dat.haveODBC;
		GD.profilesDb = dat.profilesDb;
		GD.defaultLogSource = dat.defaultLogSource;

		// Sort profilesDb
		GD.profilesDb.sort(compare_labels);

		// util.showObject(GD.profilesDb);

		init();
		newProfileWizardUtil.init(dat.haveMYSQL, dat.haveODBC);
	}

	//
	//
	// log source
	//
	//

	function validate_log_source() {

		/* This validates the log source and saves the active log source data
		in the global _log_source object.
		*/

		var validator = GD.validator;
		validator.reset();

		var obj = logSourceUtil.getValidatedLogSourceObject(validator);

		if (validator.allValid()) {

			GD.log_source = obj;
			return true;
		}

		GD.log_source = {};
		return false;
	}

	function get_log_source_dat() {

		var log_source = GD.log_source;
		var dat = '';

		for (prop in log_source) {

			// if (typeof(_log_source[prop].value) == 'boolean' || _log_source[i].value != '') {

			// alert('name: ' + _log_source[i].name + '\nvalue: ' + _log_source[i].value);

			if (prop != 'server') {

				dat += 'volatile.new_profile.log_source.0.' + prop;
				dat += '=' + encodeURIComponent(log_source[prop]) + '&';
			}
			else {

				// add server properties

				var serverObj = log_source[prop];

				// util.showObject(serverObj);

				for (var subProp in serverObj) {

					dat += 'volatile.new_profile.log_source.0.server.' + subProp;
					dat += '=' + encodeURIComponent(serverObj[subProp]) + '&';
				}
			}
		}

		dat = dat.replace(/&$/, '');

		// alert(dat);

		return dat;
	}

	function checkLogSourceDbServerResponse(dat) {

		// util.showObject(dat);

		if (dat.isValidDatabase) {

			// start actual auto detection
			var url = '?dp=new_profile_wizard.check_log_source';

			var dat = 'v.fp.page_token=' + GD.pageToken + '&';
			dat += get_log_source_dat();
			util.serverPost(url, dat);
		}
		else {
			alert(dat.msg);
			show_log_format_progress(false);
		}
	}


	function server_response_invalid_log_source(error_msg) {

		var msg = langVar('lang_admin.new_profile_wizard.invalid_log_source_with_server_response_info') + '\n' + error_msg;

		stop_log_format_progress_elapsed_time();

		show_log_format_progress(false);

		// Fix up Windows backslashes in pathnames
		msg = msg.replace(/(\\\\)/g, "BACKSLASH");
		msg = msg.replace(/BACKSLASH/g, "\\");
		alert(msg);
	}

	// *********************************
	// log_source / detecting log format
	// *********************************


	function get_detect_log_format_result() {

		var url = '?dp=new_profile_wizard.detect_log_format_result';

		var dat = 'v.fp.page_token=' + GD.pageToken + '&';
		dat += 'v.fp.autodetecting_id=' + GD.log_format_autodetecting_id + '&';
		dat += 'v.fp.task_id=' + GD.log_format_autodetection_task_id;

		util.serverPost(url, dat);
	}

	function checkLogSourceServerResponse(dat) {

		// Called from check_log_source.cfv

		// util.showObject(dat);

		// alert('checkLogSourceServerResponse()');

		if (dat.task_id_exists) {

			GD.log_format_autodetecting_id = dat.autodetecting_id;
			GD.log_format_autodetection_task_id = dat.task_id;

			// alert('server_response_log_source \nautodetecting_id: ' + autodetecting_id + '\ntask_id: ' + task_id);

			// IMPOTANT, give autodection at least 3 seconds so that there is enough time
			// that autodection writes any log source error. If we fire get_detect_log_format_result()
			// too fast we may not yet have an autodection result which will start showing progress,
			// it is then progress which may contain a log source error message. Though if progress
			// contains an error message it will show the error on a new page and not in the intended alert! 

			setTimeout('newProfileWizard.get_detect_log_format_result()', 3500);
		}
		else {

			alert(dat.error_message);

			// Restore log source display
			show_log_format_progress(false);
		}
	}

	function server_response_autodetection_in_progess(dat) {

		// alert('server_response_autodetection_in_progess');

		// Display progress info

		util.updateT('log_format_progress_suboperation_description_label', dat.suboperation_description);
		util.updateT('log_format_progress_log_bytes_downloaded', dat.log_bytes_downloaded);

		// get_detect_log_format_result

		setTimeout('newProfileWizard.get_detect_log_format_result()', 600);
	}

	function server_response_detected_log_formats(dat) {

		// argument dat is an array of 0 to n log format objects (name, label and type)

		// util.showObject(dat, 'server_response_detected_log_formats()');

		// Don't split detected formats by label because we actually
		// want the correct number of detected types and we want
		// to show the format with different labels as one log format,
		// respectively as one detected item in the auto-detected list.

		set_auto_detected_log_format_properties(dat);

		var the_formats = GD.detected_log_formats_db,
			num_of_formats = the_formats.length,
			i = 0;

		// util.showObject(the_formats);

		if (num_of_formats > 0) {

			// Sort the detected formats

// Disabled because we have multiple formats
//			if (GD.detected_log_formats_db.length > 1) {
//
//				GD.detected_log_formats_db.sort(compare_labels);
//			}

			// Create a hash to access log formats by name
			util.createHash(GD.detected_log_formats_db, 'id'); // TODO - THIS MIGHT NOT ANYMORE WORK, id has not been set yet!

			// Check if we have a direct match or multiple log formats to choose from.
			// Note, treat a single syslog_required  or a single syslog as direct match!
			var standalone = GD.num_detected_standalone_formats,
				syslog = GD.num_detected_syslog_formats;
				// syslog_req = GD.num_detected_syslog_required_formats,
				// syslog_opt = GD.num_detected_syslog_optional_formats,

			// Check if we matched a single log format or a single valid pair (i.e. syslog_required plus syslog)
			if ((num_of_formats == 1) ||
				(num_of_formats == 2 && standalone == 0 && syslog == 1)) {

				// DIRECT MATCH
				// This should match a single format or a single valid pair

				// alert('log_format direct match!');
				set_log_format_direct_match_page();
				goto_wizard('log_format_direct_match_page');
			}
			else {

				// MULTIPLE MATCH, several log formats have been detected
				// alert('log_format multiple match!');
				set_log_format_multiple_match_page();
				goto_wizard('log_format_multiple_match_page');
			}
		}
		else {

			// show log_format_no_match_page
			// alert('log_format no match!');
			goto_wizard('log_format_no_match_page');
		}
	}

	function set_auto_detected_log_format_properties(dat) {

		// Sets the number of log format types and
		// returns the final auto-detected formats.

		// util.showObject(dat);

		var num_of_formats = dat.length,
			log_format_item = {},
			log_format_name = '',
			log_data_type = '',
			log_format_type = '',
			log_meta_type_label = '',
			num_standalone = 0,
			num_syslog_required = 0,
			num_syslog_optional = 0,
			num_syslog = 0,
			i = 0,
			a = [];

		if (num_of_formats > 0) {

			// Check the number of detected log format types
			// and add the id, isAutodetected and metaTypelabel to each log format item.

			for (i = 0; i < num_of_formats; i++) {

				log_format_item = dat[i];
				log_format_name = log_format_item.name;
				log_data_type = log_format_item.type;
				log_format_type = log_format_item.lfType;
				log_meta_type_label = get_log_format_meta_type_label(log_data_type, log_format_type);

				// Set id and metaTypeLabel. The id should be equal the node name!
				log_format_item.id = log_format_name;
				// log_format_item.isAutodetected = true;
				log_format_item.metaTypeLabel = log_meta_type_label;

				switch(log_data_type) {

					case 'syslog_required':
						num_syslog_required += 1;
						break;

					case 'syslog_optional':
						num_syslog_optional += 1;
						break;

					case 'syslog':
						num_syslog += 1;
						break;

					default:
						num_standalone += 1;
				}
			}

			// If lite tier then clean up auto-detected formats as follows
			// if only syslogs --> nothing detected
			// if only syslog_required --> nothing detected
			// if standalone plus syslogs but no syslog_required and no syslog_optional --> delete the syslogs and keep the standalone formats
			// if standalone plus syslog_required but no syslogs --> delete the syslog_required and keep the standalone formats

//			console.log('num_syslog_required: ' + num_syslog_required);
//			console.log('num_syslog_optional: ' + num_syslog_optional);
//			console.log('num_syslog: ' + num_syslog);

			if (GD.isLite) {

				// KHP 02/Mar/2012 - This case isn't possible because a syslog without
				// syslog_required detection automatically adds a syslog_required format
//				if (num_syslog_required == 0 && num_syslog_optional == 0 && num_syslog > 0) {
//
//					// remove all syslog formats
//					for (i = 0; i < dat.length; i++) {
//
//						if (dat[i].type == 'syslog') {
//							// Remove the item
//							dat.splice(i, 1);
//                            i--;
//						}
//					}
//
//					num_syslog = 0;
//				}

				if (num_syslog_required > 0 && num_syslog == 0) {

					// remove all syslog_required formats
					for (i = 0; i < num_of_formats; i++) {

						log_format_item = dat[i];

						// Keep log format if not of type syslog_required
						if (log_format_item.type != 'syslog_required') {

							a[a.length] = util.cloneObject(log_format_item);
						}
					}

					// Replace dat with new array
					dat = a;

					num_syslog_required = 0;
				}
			}

//			console.log('num_syslog_required 2: ' + num_syslog_required);
//			console.log('num_syslog_optional 2: ' + num_syslog_optional);
//			console.log('num_syslog 2: ' + num_syslog);
		}

		// Set detected numbers in global object
		GD.num_detected_standalone_formats = num_standalone;
		GD.num_detected_syslog_formats = num_syslog;
		GD.num_detected_syslog_required_formats = num_syslog_required;
		GD.num_detected_syslog_optional_formats = num_syslog_optional;

		GD.detected_log_formats_db = dat;

		// Index detected_log_formats_db by id
		util.createHash(GD.detected_log_formats_db, 'id');
	}

	// **********
	// log format
	// **********

	function hide_log_format_description() {
		util.hideE(['log_format_multiple_match_list:log_format_description', 'log_format_all_list:log_format_description']);
	}

	function check_and_display_log_format_description() {

		hide_log_format_description();

		var selectElementId = this.id;
		var log_formats_db = selectElementId != 'log_format_all_list' ? GD.detected_log_formats_db : GD.log_format_db;

		var id = util.getF(this.id);
		var log_format = log_formats_db[util.h(id)];
		var description = log_format.description;

		if (description != '') {

			// Show the description. Note, we create a new div so that we get the actual height.
			// If the description exceeds a certain height then we set a max height.

			var descriptionElementId = selectElementId + ':log_format_description';
			var descriptionElement = util.getE(descriptionElementId);

			// Clean up descriptionElement from any previus decsription
			util.removeChildElements(descriptionElement);

			// Create new wrapper div
			var div = util.createE('div', {margin:0,padding:0});

			util.chainE(descriptionElement, div);
			div.innerHTML = description;

			descriptionElement.style.visibility = 'hidden';
			descriptionElement.style.display = 'block';

			// Check height of div
			var region = YD.getRegion(div);
			var maxHeight = 120;

			if (region.height > maxHeight) {

				// Limit the height of the div
				div.style.height = maxHeight + 'px';
				div.style.overflow = 'scroll';
			}

			// Finally display the description
			descriptionElement.style.visibility = 'visible';
		}
	}

	function set_log_format_direct_match_page() {

		var detected_log_formats_db = GD.detected_log_formats_db;

		// util.showObject(detected_log_formats_db);

		if ((GD.num_detected_syslog_required_formats == 1 ||
			GD.num_detected_syslog_optional_formats == 1) &&
			GD.num_detected_syslog_formats == 1) {

			for (var i = 0; i < detected_log_formats_db.length; i++) {

				var log_format_item = detected_log_formats_db[i];

				if (log_format_item.type == 'syslog') {

					var syslog_item = log_format_item;
				}
				else {

					var syslog_required_item = log_format_item;
				}
			}

//            util.showObject(syslog_item, 'the syslog_item');
//            util.showObject(syslog_required_item, 'the syslog_required_item');

			// Add syslog labels
			create_log_format_item_label('log_format_direct_match_container_1', syslog_item);

			// Add syslog_required or syslog_optional labels
			create_log_format_item_label('log_format_direct_match_container_2', syslog_required_item);
			util.showE('log_format_direct_match_container_2');
		}
		else {

			// IMPORTANT, this case usually handles a single STANDALONE format
			// but it also handles the case if there is only one syslog,
			// one syslog_required or one syslog_optional format.

			// If only a syslog or syslog_required format has been detected,
			// show it as a standalone format, the missing of one log format pair
			// will be indicated on the next wizard page.

			create_log_format_item_label('log_format_direct_match_container_1', detected_log_formats_db[0]);
			util.hideE('log_format_direct_match_container_2');
		}

		// make detected checked (no radio button in Lite)
		if (!GD.isLite) {
			util.setF('log_format_direct_match_use_detected_btn', true);
		}
	}

	function set_log_format_multiple_match_page() {

		// populate detected log format list
		// util.showObject(detected_log_formats_db, 'set_log_format_multiple_match_page()');

		GD.multiple_log_format_match_list.createList(GD.detected_log_formats_db, "");

		// if detected log format list contains syslog and syslog_required formats
		// then show a More Information link

		util.hideE('log_format_multiple_match_instruction');
		util.hideE('log_format_multiple_match_syslog_instruction');

		// we need to reset the info box, simulate a show/hide operation
		// so that the label becomes "Show Information"
		util.showE('log_format_multiple_match_syslog_info_box');
		show_hide_info_section('log_format_multiple_match_syslog_info_box');

		if (GD.num_detected_syslog_formats > 0 && GD.num_detected_syslog_required_formats > 0) {

			util.showE('log_format_multiple_match_syslog_instruction');
		}
		else {

			util.showE('log_format_multiple_match_instruction');
		}
	}

	function set_and_goto_log_format_all_page() {

		if (GD.log_format_db_loaded) {

			// Handle the log format list
			GD.all_log_formats_list.prepareResetList(GD.log_format_db);


			goto_wizard('log_format_all_page');
		}
		else {

			// load the log formats first
			get_log_format_db(); // response will repeat next_wizard()!
		}
	}

	//
	// syslog_required
	//

//	function set_syslog_required_no_match_page() {
//
//		// Pro Enterprise only
//		// show text info that Sawmill detected a syslog but not syslog_required format
//		var syslog_item = get_log_format_item_by_id(GD.final_syslog_id);
//        var label = get_log_format_labels(syslog_item);
//		util.updateT('syslog_required_no_match_syslog_label', label);
//	}

	function set_syslog_required_direct_match_page() {

		// Get the syslog_required item
		for (var i = 0; i < GD.detected_log_formats_db.length; i++) {

			var item = GD.detected_log_formats_db[i];

			if (item.type == 'syslog_required') {
				var syslog_required_item = item;
				break;
			}
		}

		var syslog_item = get_log_format_item_by_id(GD.final_syslog_id);

		// Set false in syslog label to appear in lighter color
		create_log_format_item_label('syslog_required_direct_match_container_1', syslog_item, false);
		create_log_format_item_label('syslog_required_direct_match_container_2', syslog_required_item);
	}

	function set_syslog_required_multiple_match_page() {

		// Set syslog label for which the syslog_required format must be selected
		var syslog_item = get_log_format_item_by_id(GD.final_syslog_id);
		create_log_format_item_label('syslog_required_multiple_match_syslog_text_container', syslog_item, false);

		// Populate detected syslog_required list
		GD.multiple_syslog_required_match_list.createList(GD.detected_log_formats_db, 'syslog_required');
	}

	function set_and_goto_syslog_required_all_page() {

		if (GD.log_format_db_loaded) {

			// Create GD.all_syslog_formats_list if it doesn't yet exist

			if (GD.syslog_required_format_db.length == 0) {
				createSyslogFormatDb();
			}

			// Handle the syslog formats list
			GD.all_syslog_required_formats_list.prepareResetList(GD.syslog_required_format_db);

			// set the active syslog label above the syslog_required list
			var syslog_item = get_log_format_item_by_id(GD.final_syslog_id);
//          var label = get_log_format_labels(syslog_item);
//			util.updateT('syslog_required_all_syslog_label', label);
//          handle_log_format_beta_info(_show_syslog_required_all_beta_info, 'syslog_required_all_beta_info_section');
			create_log_format_item_label('syslog_required_all_page_syslog_text_container', syslog_item, false);

			goto_wizard('syslog_required_all_page');
		}
		else {

			// load the log formats first
			get_log_format_db(); // response will repeat next_wizard()!
		}
	}

	//
	// syslog
	//

	function set_syslog_no_match_page() {

		// Pro Enterprise only
		// show text info that Sawmill detected a syslog_required but not syslog format

		var syslog_required_item = get_log_format_item_by_id(GD.final_log_format_id);
		create_log_format_item_label('syslog_no_match_page_syslog_required_text_container', syslog_required_item, false);
		// var label = get_log_format_labels(syslog_required_item);
		// util.updateT('syslog_no_match_syslog_required_label', label);
	}

	function set_syslog_direct_match_page() {

		// Get the syslog item
		for (var i = 0; i < GD.detected_log_formats_db.length; i++) {

			var item = GD.detected_log_formats_db[i];

			if (item.type == 'syslog') {

				var syslog_item = item;
				break;
			}
		}

		var syslog_required_item = get_log_format_item_by_id(GD.final_log_format_id);

		// Set false in syslog_required label to appear in lighter color
		create_log_format_item_label('syslog_direct_match_container_1', syslog_required_item, false);
		create_log_format_item_label('syslog_direct_match_container_2', syslog_item);
	}

	function set_syslog_multiple_match_page() {

		// Set syslog_required label for which the syslog format must be selected
		var syslog_required_item = get_log_format_item_by_id(GD.final_log_format_id);
		create_log_format_item_label('syslog_multiple_match_syslog_required_text_container', syslog_required_item, false);

		// Populate detected syslog_required list
		GD.multiple_syslog_match_list.createList(GD.detected_log_formats_db, 'syslog');
	}

	function set_and_goto_syslog_all_page() {

		if (GD.log_format_db_loaded) {

			// Create GD.all_syslog_formats_list if it doesn't yet exist

			if (GD.syslog_format_db.length == 0) {
				createSyslogFormatDb();
			}

			// Handle the syslog formats list
			GD.all_syslog_formats_list.prepareResetList(GD.syslog_format_db);

			// Set the active syslog_required or syslog_optional instruction and label
			// above the syslog list
			var syslog_required_item = get_log_format_item_by_id(GD.final_log_format_id);
			var is_syslog_required = (syslog_required_item.type == 'syslog_required');
			util.showE('syslog_all_page_syslog_required_info', is_syslog_required);
			util.showE('syslog_all_page_syslog_optional_info', !is_syslog_required);

			// var label = get_log_format_labels(syslog_required_item);
			// util.updateT('syslog_all_syslog_required_label', label);

			// util.showObject(syslog_required_item);

			// Set false in syslog_required label to appear in lighter color
			create_log_format_item_label('syslog_all_page_syslog_required_text_container', syslog_required_item, false);

			// handle_log_format_beta_info(_show_syslog_all_beta_info, 'syslog_all_beta_info_section');
			goto_wizard('syslog_all_page');
		}
		else {

			// load the log formats first
			get_log_format_db(); // response will repeat next_wizard()!
		}
	}

	function createSyslogFormatDb() {

		// This creates the GD.syslog_format_db or GD.syslog_required_format_db

		var all_log_formats = GD.log_format_db;
		var syslog_required_db = [];
		var syslog_db = [];

		var number_of_log_formats = GD.log_format_db.length;
		var syslog_required_count = 0;
		var syslog_count = 0;

		for (var i = 0; i < number_of_log_formats; i++) {

			var item = all_log_formats[i];
			var log_data_type = item.type;

			// KHP 16/Nov/2010 - Add only supported log formats to db
			// Note, this db is only used for the manual log formats lists
			// which shows all syslog or all syslog_required formats.

			if (item.notSupportedMessage == '') {

				if (log_data_type == 'syslog_required' ||
					log_data_type == 'syslog_optional') {

					// syslog_required_db[syslog_required_count] = util.cloneObject(item);
					syslog_required_db[syslog_required_count] = {id: item.id, label: item.label};
					syslog_required_count += 1;
				}
				else if (log_data_type == 'syslog') {

					// syslog_db[syslog_count] = util.cloneObject(item);
					syslog_db[syslog_count] = {id: item.id, label: item.label};
					syslog_count += 1;
				}
			}
		}

		GD.syslog_required_format_db = syslog_required_db;
		GD.syslog_format_db = syslog_db;
	}

	// ******************
	// log format options
	// ******************

	function checkForDatabaseAndLogFormatOptions() {

		// Check if the selected log format is supported or not

		var id = GD.final_log_format_id;

		// Get the logFormat item
		var logFormatObject = get_log_format_item_by_id(id);
//		var licensingTier = GD.licensingTier;

		// util.updateT('syslog_direct_match_syslog_required_label', GD.detected_log_formats_db[util.h(_final_syslog_required)].label);util.showObject(logFormatObject, 'logFormatObject');

		if (logFormatObject.isSupportedLogFormat) {

			// KHP 24/May/2013 - Michael notes
			// that no database page is shown in Pro.
			// Database page should be shown in Enterprise and Pro

			if (!GD.isLite) {
				goto_wizard('db_server_page');
			}
			else {
				// Lite only
				set_and_goto_log_format_options_page();
			}
		}
		else {

			//
			// The log format is not supported
			//

			var notSupportedMessage = logFormatObject.notSupportedMessage;

			if (notSupportedMessage == '') {
				notSupportedMessage = '-';
			}

			util.updateT('log_format_not_supported_message_container', notSupportedMessage);
			goto_wizard('log_format_not_supported_page');
		}
	}

	function set_and_goto_log_format_options_page() {

		show_mini_progress(langVar('lang_admin.new_profile_wizard.checking_for_log_format_options_info'));

		var id = GD.final_log_format_id;
		var log_format_item = get_log_format_item_by_id(id);
		var the_format = log_format_item.name;

		var url = '?dp=new_profile_wizard.get_log_format_options';
		var dat = 'v.fp.page_token=' + GD.pageToken + '&';
		dat += 'v.fp.log_format_name=' + the_format;

		util.serverPost(url, dat);
	}


	function get_log_format_options_response(dat) {

		// util.showObject(dat, "get_log_format_options_response() - dat");
		GD.numerical_fields_db = dat.numericalFieldsDb;

		// Set snapons
		GD.snapons = dat.snapons;

		// util.showObject(GD.numerical_fields_db, 'GD.numerical_fields_db');
		// util.showObject(snapons, 'GD.snapons');

		// Skip log_format_options_page in Lite or if there is only one 
		// or zero numerical field.

		if (GD.isLite || GD.numerical_fields_db.length <= 1) {

			// Automatically check all numerical fields
			for (var i = 0; i < GD.numerical_fields_db.length; i++) {
				GD.numerical_fields_db[i].add_field = true;
			}

            // Continue with snapons
            handleSnapons();
		}
		else {

			// prepare the numerical fields and show the log_format options page
			build_log_format_options_page();
			goto_wizard('log_format_options_page');
		}
	}

	function build_log_format_options_page() {

		// Build numerical field checkboxes
		var table = util.getE('log_format_options_numerical_field_container');

		// Clean up existing table
        util.removeChildElements(table);

		var tbody = util.createE('tbody');

		// build the checkbox rows
		var i;
        var fieldsDb = GD.numerical_fields_db;
        var max = fieldsDb.length;

		for (i = 0; i < max; i++) {

			var fieldName = fieldsDb[i].name;
            var fieldLabel = fieldsDb[i].label;
			var elementId = 'numerical_field:' + fieldName;

            addCheckboxRow(tbody, elementId, fieldLabel);
		}

        util.chainE(table, tbody);

		// Set checkbox state
		for (i = 0; i < max; i++) {
            util.setF('numerical_field:' + fieldsDb[i].name, fieldsDb[i].add_field);
		}
	}

//	function update_numerical_field_state() {
//
//		// update the GD.numerical_fields_db object
//
//		var element_id = this.id;
//		var dat = element_id.split(':');
//		var field_name = dat[1];
//
//		// GD.numerical_fields_db[field_name].add_field = this.checked;
//
//		// GD.numerical_fields_db is not anymore a hash due the possible
//		// name "length", so we loop through all objects to check which
//		// which one has been changed.
//
//		for (var i = 0; i < GD.numerical_fields_db.length; i++) {
//
//			if (field_name == GD.numerical_fields_db[i].name) {
//
//				GD.numerical_fields_db[i].add_field = this.checked;
//				break;
//			}
//		}
//	}

//	function check_all_numerical_fields() {
//		set_all_numerical_fields(true);
//	}
//
//	function uncheck_all_numerical_fields() {
//		set_all_numerical_fields(false);
//	}
//
//	function set_all_numerical_fields(checked_state) {
//
//		for (var i = 0; i < GD.numerical_fields_db.length; i++) {
//
//			var element = document.getElementById('numerical_field:' + GD.numerical_fields_db[i].name);
//
//			element.checked = checked_state;
//			GD.numerical_fields_db[i].add_field = checked_state;
//		}
//	}

    //
    //
    // Handle snapons
    //
    //

    function handleSnapons() {

        // This checks if we need to show a snapons page
        // or a snapon parameters form
        var snapons = GD.snapons;
        var isPromptToAttach = false;
        var snaponItem;

        if (snapons.length > 0) {

            for (var i = 0; i < snapons.length; i++) {

                snaponItem = snapons[i];

                if (snaponItem.promptToAttach) {
                    isPromptToAttach = true;
                }

                // Set default attach value, always true. This value may only
                // change for snapons which have promptToAttach set to true.
                snaponItem.attach = true;
            }

            if (isPromptToAttach && !GD.isLite) {

                // Show snapons page. In Lite the page isn't shown, it will
                // simply use the promptToAttachDefault value.
                buildSnaponsPage();
                goto_wizard('snapons_page');
            }
            else {

                // Check if we show any snapon parameters form
                setSnaponsParametersForm();
            }
        }
        else {
            set_and_goto_profile_name_page();
        }
    }

    function buildSnaponsPage() {

        var snapons = GD.snapons;
        var max = snapons.length;
        var snaponItem;
        var i;

        var table = util.getE('snapons_page:container');

        // Remove possible option_info event listener before
        // cleaning up the table element
        optionInfo.removeCustomItemsEventListener(table);

        // Clean up the table element
        util.removeChildElements(table);

        var tbody = util.createE('tbody');

        var elementId;
        var label;

        var customOtionInfoItems = [];
        var baseId = util.getUniqueElementId();
        var optionInfoIconId;
        var optionInfoText = '';
        var count = 0;

        for (i = 0; i < max; i++) {

            snaponItem = snapons[i];

            // util.showObject(snaponItem);

            if (snaponItem.promptToAttach) {

                elementId = 'attach_snapon:' +  snaponItem.logFormatSnaponName;
                optionInfoIconId = baseId + '_' + count;
                addCheckboxRow(tbody, elementId, snaponItem.label, optionInfoIconId);

                optionInfoText = '<h5>' + snaponItem.label + '</h5>' + snaponItem.comment;

                // Track custom option info items
                customOtionInfoItems[count] = {id:optionInfoIconId, text:optionInfoText};

                count += 1;
            }
        }

        util.chainE(table, tbody);

        // Update checkbox state
        for (i = 0; i < max; i++) {
            snaponItem = snapons[i];
            if (snaponItem.promptToAttach) {
                elementId = 'attach_snapon:' +  snaponItem.logFormatSnaponName;
                util.setF(elementId, snaponItem.promptToAttachDefault);
            }
        }

        // Handle option info icons which show the optionInfoText for snapons
        optionInfo.addCustomItems(customOtionInfoItems);
    }

    function setSnaponsParametersForm() {

        // util.showObject(GD.snapons, 'setSnaponsParametersForm()');

        var snaponsParametersForm = getCombinedSnaponsParametersForm(GD.snapons);
        GD.snaponsParametersForm = snaponsParametersForm;
        var numberOfSnaponParametersFormItems = snaponsParametersForm.length;

        // util.showObject(snaponsParametersForm, 'combined snaponsParametersForm');

        if (numberOfSnaponParametersFormItems == 0) {

            set_and_goto_profile_name_page();
        }
        else {

            // Create the snapon parameter forms

            // Init snaponParameters

            // Add "unknown" as default parameter fields, it is not supposed that
            // these fields are used in the new profile wizard.
            var default_snapon_parameter_fields = [{name:'unknown', label: 'Unknown'}];

            var obj = {
                containerElementId: 'snapon_parameters_pages_container',
                nextButtonElementId: 'next_btn',
                parametersForm: snaponsParametersForm,
                logFields: default_snapon_parameter_fields,
                databaseFields: default_snapon_parameter_fields,
                reportFields: default_snapon_parameter_fields,
                reports: default_snapon_parameter_fields,
                reportGroups: default_snapon_parameter_fields,
                attachedSnaponLabelsLookup: {}
            };

            snaponParameters.init(obj);

            // Show 1st snapon parameters page
            goto_wizard('snapon_parameters_page:0');
        }
    }

	//
	//
	// Handle snapon parameters
	//
	//

	function getCombinedSnaponsParametersForm(snapons) {

		// It is possible that the snapons argument contains multiple snapons,
		// though we require a single parametersForm object which may contain
		// forms of multiple snapons. We do this here by creating a combined
		// snaponsParametersForm array which contains a reference to 
		// all parametersForm objects of all snapons.

		var snaponsParametersForm = [];
		var numberOfTotalItems = 0;

		for (var i = 0, l = snapons.length; i < l; i++) {

			var theSnapon = snapons[i];
            var theSnaponParametersForm = theSnapon.parametersForm;
            var numberOfParametersFormItems = theSnaponParametersForm.length;

            if (theSnapon.attach && numberOfParametersFormItems > 0) {

                var label = theSnapon.label;

                // util.showObject({numberOfParametersFormItems__in_snapon: numberOfParametersFormItems});

                for (var j = 0; j < numberOfParametersFormItems; j++) {

                    // Add snapon label to each parameters form item so that we have easy access
                    // for wizard page labels
                    theSnaponParametersForm[j]['label'] = label;

                    // Add a reference in snaponsParametersForm to the parametersForm of the snapon
                    snaponsParametersForm[numberOfTotalItems] = theSnaponParametersForm[j];

                    numberOfTotalItems++;
                }
            }
		}

		// util.showObject({numberOfTotalItems_in_snaponsParametersForm: numberOfTotalItems});
		return snaponsParametersForm;
	}

	//
	//
	// Database
	//
	//

	function toggleDatabaseType() {

		// Get and set the serverType
		// var elementId = element.id;
		// var dat = elementId.split(':');	
		var serverType = util.getF('db_server:type');
		var dbServer = GD.dbServer;

		// alert('toggleDatabaseType - serverType: ' + serverType);

		util.hideE([
			'db_server:database_directory:box',
			'db_server:hostname:box',
			'db_server:dsn:box',
			'db_server:common:box',
            'db_server:database_name:box',
			'db_server:server_socket:box',
			'db_server:mysql_bulk_import_method:box',
			'db_server:mssql_bulk_import_method:box',
			'db_server:oracle_bulk_import_method:box',
			'db_server:load_data_directory:box',
			'db_server:load_data_directory_on_server:box',
			'db_server:sql_table_name:box'
		]);

		if (serverType == 'internal_sql') {

			util.showE('db_server:database_directory:box');
		}
		else {

            var showDatabaseNameBox = false;
            var defaultFocus;

			if (serverType == 'mysql') {

				util.showE('db_server:hostname:box');
				util.showE('db_server:server_socket:box');
				util.showE('db_server:mysql_bulk_import_method:box');

				// Check if we show the load_data_directory field
				toggleMysqlBulkImportMethod();

                showDatabaseNameBox = true;
				defaultFocus = 'db_server:hostname';
			}
			else {

				util.showE('db_server:dsn:box');

				if (serverType == 'odbc_mssql') {
					util.showE('db_server:mssql_bulk_import_method:box');
					toggleMssqlBulkImportMethod();
                    showDatabaseNameBox = true;
				}
				else {
					// odbc_oracle
					util.showE('db_server:oracle_bulk_import_method:box');
				}

				defaultFocus = 'db_server:dsn';
			}

			util.showE('db_server:common:box');
            util.showE('db_server:database_name:box', showDatabaseNameBox);
			util.showE('db_server:sql_table_name:box');

			var focusElement = util.getE(defaultFocus);
			focusElement.focus();
			focusElement.select();
		}
	}

	function toggleMysqlBulkImportMethod() {

		var bulkImportMethod = util.getF('db_server:mysql_bulk_import_method');
		var isLoadDataServerInfile = (bulkImportMethod == 'load_data_server_infile');
		util.showE('db_server:load_data_directory:box', isLoadDataServerInfile);
	}

	function toggleMssqlBulkImportMethod() {

		var bulkImportMethod = util.getF('db_server:mssql_bulk_import_method');
		var isBulkInsert = (bulkImportMethod == 'bulk_insert');
		util.showE('db_server:load_data_directory:box', isBulkInsert);
		util.showE('db_server:load_data_directory_on_server:box', isBulkInsert);
	}

	function validateDatabaseOptions() {

		// Set global dbServer variable which is used for further form processing!
		// Note, allow server password and database name to be empty!
		// If the database name is empty we use the profile node name as database_name!

		var validator = GD.validator;
		validator.reset();

		var dbServer = GD.dbServer;

		// Reset global dbServer object
		for (var prop in dbServer) {dbServer[prop] = '';}

		// util.showObject(GD.dbServer);

		var serverType = 'internal_sql'; // default

		if (GD.licensingTier == 'enterprise' && (GD.haveMYSQL || GD.haveODBC)) {
			serverType = util.getF('db_server:type');
		}

		dbServer.type = serverType;

		if (serverType == 'internal_sql') {

			// tHE OPTIONAL database_directory is validated on server side!
			dbServer.database_directory = util.getF('db_server:database_directory');
			dbServer.sql_table_name_prefix = '';
			dbServer.sql_table_name_suffix = '';
		}
		else {

            // KHP 21/May/2012 - Changed validation rules for database_name.
            // database_name is only required for mysql and odbc_mssql, it is optional on
			// the database server page.

            // If no database_name is specified then use the profile name as the database name
			// and validate the profile name to be a valid database name.

            // If the database_name is already used (for the same server_type) then
            // show a warning on a separate wizard page that the database will be shared
            // by the profiles which point to the same database_name.

			if (serverType == 'mysql' || serverType == 'odbc_mssql') {

				var databaseName = util.getF('db_server:database_name');
				// alert('databaseName.length: ' + databaseName.length);

				if (databaseName != '') {

					// validate database name
					var databaseNameVal = databaseUtil.getIsValidDatabaseName(serverType, databaseName);

					if (!databaseNameVal.isValid) {
						// Throw custom error
						validator.isCustom('db_server:database_name', databaseNameVal.errorMessage);
					}

					dbServer.database_name = databaseName;
				}

				if (serverType == 'mysql' ) {

					dbServer.hostname = validator.isValue('db_server:hostname');
					dbServer.server_socket = util.getF('db_server:server_socket');
					dbServer.bulk_import_method = util.getF('db_server:mysql_bulk_import_method');

					if (dbServer.bulk_import_method == 'load_data_server_infile') {
						dbServer.load_data_directory = validator.isValue('db_server:load_data_directory');
					}
				}
				else {

					// serverType is 'odbc_mssql'

					dbServer.dsn = validator.isValue('db_server:dsn');
					dbServer.bulk_import_method = util.getF('db_server:mssql_bulk_import_method');

					if (dbServer.bulk_import_method == 'bulk_insert') {

						dbServer.load_data_directory = validator.isValue('db_server:load_data_directory');
						dbServer.load_data_directory_on_server = validator.isValue('db_server:load_data_directory_on_server');
					}
				}
			}
			else {

				// serverType is 'odbc_oracle'
				dbServer.dsn = validator.isValue('db_server:dsn');
				dbServer.bulk_import_method = util.getF('db_server:oracle_bulk_import_method');
			}

			// Following values are all optional
			dbServer.username = util.getF('db_server:username');
			dbServer.password = util.getF('db_server:password');

            dbServer.sql_table_name_prefix = util.getF('db_server:sql_table_name_prefix');
            dbServer.sql_table_name_suffix = util.getF('db_server:sql_table_name_suffix');
		}

        return validator.allValid();
	}

	function validateDatabaseOptionsOnServerSide() {

		// Checks for a valid database server connection
		// Update 15/Feb/2009 - and checks
		// that no internal database exists for any given database directory
		// and for a unique database name if a database name is given.

		var dbServer = GD.dbServer;

		if (dbServer.type == 'internal_sql') {
			show_mini_progress(langVar('lang_admin.new_profile_wizard.checking_database_directory'));
		}
		else {
			show_mini_progress(langVar('lang_admin.new_profile_wizard.checking_database_server'));
		}

		var url = '?dp=new_profile_wizard.validate_database_options';
		var dat = 'v.fp.page_token=' + GD.pageToken + '&';

		for (var prop in dbServer) {

			var itemValue = dbServer[prop];
			if (itemValue != '') {
				itemValue = encodeURIComponent(itemValue);
			}

			dat += 'v.fp.db_server.' + prop + '=' + itemValue + '&';
		}

		dat = dat.replace(/&$/, '');

		util.serverPost(url, dat);
	}

	function validateDatabaseOptionsOnServerSideResponse(dat) {

		// util.showObject(dat);
		var isError = dat.isError;
		var isWarning = dat.isWarning;
		var message = dat.message;
		var dbServer = GD.dbServer;
		var dbServerType = dbServer.type;
		var databaseName = dbServer.database_name;

		// Validate for duplicate database_name if it has been defined
		// on database wizard page.
		if (!isError &&
			!isWarning &&
			(dbServerType == 'mysql' || dbServerType == 'odbc_mssql') &&
			databaseName != '') {

			var profilesWhichAlreadyUsesDbName = getProfilesWhichAlreadyUsesDbName(dbServerType, databaseName);

			if (profilesWhichAlreadyUsesDbName != '') {

				isWarning = true;

				message = '<p>' + langVar('lang_admin.new_profile_wizard.database_warning_page.db_name_in_use_info') + '</p>';
				message = message.replace(/__PARAM__1/, '<em class="db-warning">' + databaseName + '</em>');

				message += '<ul class="db-warning">' + profilesWhichAlreadyUsesDbName + '</ul>';
				message += '<div class="info-box">';
				message += '<p><strong>' + langVar('lang_admin.new_profile_wizard.database_warning_page.click_back_db_name_info') + '</strong></p>';
				message += '<p><strong>' + langVar('lang_admin.new_profile_wizard.database_warning_page.click_next_info') + '</strong></p>';
				message += '<p>' + langVar('lang_admin.new_profile_wizard.database_warning_page.share_db_info') + '</p>';
				message += '</div>';
			}
		}

		if (isError) {

			// hide mini progress
            util.hideE('mini_progress_section');
            set_wizard_buttons();
            show_wizard_page('db_server_page');
            alert(message);
		}
        else if (isWarning) {

            // Database directory or database_name is used
            // in another profile. Show warning page.
            var warningContainer = util.getE('db_warning_page');
            warningContainer.innerHTML = message;
            goto_wizard('db_warning_page');
        }
		else {
            goto_wizard('db_performance_page');
		}
	}

	function getProfilesWhichAlreadyUsesDbName(dbServerType, databaseName) {

		// Returns a string with profile labels if the database_name
		// is already used in the database of the specific server type.

		var profilesDb = GD.profilesDb;
		var theProfile;
		var maxProfiles = profilesDb.length;
		var profilesWhichAlreadyUsesDbName = '';

		for (var i = 0; i < maxProfiles; i++) {

			theProfile = profilesDb[i];

			if (theProfile.serverType == dbServerType &&
				theProfile.databaseName == databaseName) {

				profilesWhichAlreadyUsesDbName += '<li>' + theProfile.label + '</li>';
			}
		}

		return profilesWhichAlreadyUsesDbName;
	}

	//
	// profile_name_page
	//

	function set_and_goto_profile_name_page() {

		// Check if we need the profile node name as database name,
		// if so then display additional database name information.
		var dbServer = GD.dbServer;
		var dbServerType = dbServer.type;
		var createDatabaseNameFromProfileName = false;

		if ((dbServerType == 'mysql' || dbServerType == 'odbc_mssql') &&
			dbServer.database_name == '') {

			createDatabaseNameFromProfileName = true;

			// Attach event handler for profileNodeName creation to be displayed
			// as database name
			YE.addListener('profile_name', 'keyup', updateDatabaseNameOnProfileNamePage);
			YE.addListener('profile_name', 'paste', updateDatabaseNameOnProfileNamePage);


			// Set initial name (derived from default name)
			updateDatabaseNameOnProfileNamePage();
		}

		util.showE('profile_name_page:db_info_box', createDatabaseNameFromProfileName);

		// Show page
		goto_wizard('profile_name_page');
	}

	//
	//
	// wizard sequence
	//
	//

	function close_wizard() {

		window.close();
	}

	function next_wizard() {

		var active_wizard_page = GD.wizard_path[GD.wizard_path.length - 1];

		switch (active_wizard_page) {

			case 'log_source_page':
				next_on_log_source_page();
				break;

			case 'log_format_no_match_page':
				set_and_goto_log_format_all_page();
				break;

			case 'log_format_direct_match_page':
				next_on_log_format_direct_match_page();
				break;

			case 'log_format_multiple_match_page':
				next_on_log_format_multiple_match_page();
				break;

			case 'log_format_all_page':
				// Pro/Enterprise only
				next_on_log_format_all_page();
				break;

			case 'syslog_no_match_page':
				set_and_goto_syslog_all_page();
				break;

			case 'syslog_direct_match_page':
				next_on_syslog_direct_match_page();
				break;

			case 'syslog_multiple_match_page':
				next_on_syslog_multiple_match_page();
				break;

			case 'syslog_all_page':
				// Pro/Enterprise only
				next_on_syslog_all_page();
				break;

//			case 'syslog_required_no_match_page':
//				set_and_goto_syslog_required_all_page();
//				break;

			case 'syslog_required_direct_match_page':
				next_on_syslog_required_direct_match_page();		
				break;

			case 'syslog_required_multiple_match_page':
				next_on_syslog_required_multiple_match_page();
				break;

			case 'syslog_required_all_page':
				// Pro/Enterprise only
				next_on_syslog_required_all_page();
				break;

			case 'log_format_string_page':
				next_on_log_format_string_page();
				break;

			case 'db_server_page':
				next_on_db_server_page();
				break;

            case 'db_warning_page':
                goto_wizard('db_performance_page');
                break;

			case 'db_performance_page':
				next_on_db_performance_page();
				break;

			case 'log_format_options_page':
				next_on_log_format_options_page();
				break;

            case 'snapons_page':
                next_on_snapons_page();
                break;

			case 'profile_name_page':
				finishWizard();
				break;

			default:
				// This must be snapon parameters page
				next_on_snapon_parameters_page(active_wizard_page);
				break;
		}
	}

	function next_on_log_source_page() {

		if (validate_log_source()) {

			// disable log source window and show message 'detecting log format'
			show_log_format_progress(true);

			var url;

			if (GD.log_source.type != 'odbc') {

				url = '?dp=new_profile_wizard.check_log_source';
			}
			else {

				// check the database server prior detecting the log format
				url = '?dp=new_profile_wizard.check_log_source_db_server';
			}

			var dat = 'v.fp.page_token=' + GD.pageToken + '&';
			dat += get_log_source_dat();

			util.serverPost(url, dat);
		}
		else {
			return false;
		}
	}

	function next_on_log_format_direct_match_page() {

		GD.final_log_format_id = '';
		GD.final_syslog_id = '';

		if (GD.isLite || util.getF('log_format_direct_match_use_detected_btn')) {

			// set the active log format for form processing and to receive the log format options

			// Note, we handle detected log formats, so apache_custom and blue_coat_custom formats are not possible!

			// Note, it is possible that the direct match page displays a single syslog or
			// a single syslog_required format, in this case we have to show a syslog or syslog_required no match page!

			// Single standalone format or syslog_optional format without syslog
			if (GD.num_detected_standalone_formats == 1 ||
			   (GD.num_detected_syslog_formats == 0 &&
				GD.num_detected_syslog_required_formats == 0 &&
				GD.num_detected_syslog_optional_formats == 1)) {

				GD.final_log_format_id = GD.detected_log_formats_db[0].id;
				checkForDatabaseAndLogFormatOptions();
			}
			else if (GD.num_detected_syslog_formats == 1 &&
				(GD.num_detected_syslog_required_formats == 1 ||
				 GD.num_detected_syslog_optional_formats == 1)) {

				// Direct match of syslog_required/_optional and syslog

				for (var i = 0; i < GD.detected_log_formats_db.length; i++) {

					if (GD.detected_log_formats_db[i].type == 'syslog') {

						GD.final_syslog_id = GD.detected_log_formats_db[i].id;
					}
					else {

						GD.final_log_format_id = GD.detected_log_formats_db[i].id;
					}
				}

				checkForDatabaseAndLogFormatOptions();
			}
			else if (GD.num_detected_syslog_required_formats == 1) {

				// No syslog detected
				GD.final_log_format_id = GD.detected_log_formats_db[0].id;
				set_syslog_no_match_page();
				goto_wizard('syslog_no_match_page');
			}

			// KHP 02/Mar/2012 - Not required because a syslog_required format is automatically added when missing
			// syslog_required is missing
			// GD.final_syslog_id = GD.detected_log_formats_db[0].id;
			// set_syslog_required_no_match_page();
			// goto_wizard('syslog_required_no_match_page');
		}
		else {

			// Pro/Enterprise only, show all log formats page
			set_and_goto_log_format_all_page();
		}
	}

	function next_on_log_format_multiple_match_page() {

		GD.final_log_format_id = '';
		GD.final_syslog_id = '';

		var selected_log_format_id = GD.multiple_log_format_match_list.getSelectedId();

		if (selected_log_format_id != '') {

			if (selected_log_format_id == '__SHOW__ALL__') {

				// Show all log formats (Pro/Enterprise only)
				set_and_goto_log_format_all_page();
			}
			else {

				var selected_log_format_item = get_log_format_item_by_id(selected_log_format_id);
				var selected_log_data_type = selected_log_format_item.type;

				// alert('selected_log_format: ' + selected_log_format + '\nselected_log_data_type: ' + selected_log_data_type);

				if (selected_log_data_type == 'syslog') {

					GD.final_syslog_id = selected_log_format_id;

					// KHP 02/Mar/2012 - Not required because a syslog_required format is automatically added when missing
					// if (GD.num_detected_syslog_required_formats == 0 &&
					//     GD.num_detected_syslog_optional_formats == 0) {
					//
					//          set_syslog_required_no_match_page();
					//			goto_wizard('syslog_required_no_match_page');
					// }

					if ((GD.num_detected_syslog_required_formats == 1 &&
						GD.num_detected_syslog_optional_formats == 0) ||
						(GD.num_detected_syslog_required_formats == 0 &&
						GD.num_detected_syslog_optional_formats == 1)){

						set_syslog_required_direct_match_page();

						goto_wizard('syslog_required_direct_match_page');
						goto_wizard('syslog_required_direct_match_page');
					}
					else {

						set_syslog_required_multiple_match_page();
						goto_wizard('syslog_required_multiple_match_page');
					}
				}
				else if (selected_log_data_type == 'syslog_required' ||
						 (selected_log_data_type == 'syslog_optional' &&
						 GD.num_detected_syslog_formats > 0)) {

					GD.final_log_format_id = selected_log_format_id;

					if (GD.num_detected_syslog_formats == 0) {

						// This case is not possible in Lite, as there is no syslog_required format detected any
						// syslog format would have been removed from the GD.detected_log_formats_db
						// The Pro/Enterprise user can continue the wizard but gets a warning!

						set_syslog_no_match_page();
						goto_wizard('syslog_no_match_page');

					}
					else if (GD.num_detected_syslog_formats == 1) {

						set_syslog_direct_match_page();
						goto_wizard('syslog_direct_match_page');
					}
					else {

						set_syslog_multiple_match_page();
						goto_wizard('syslog_multiple_match_page');
					}
				}
				else {

					// This is a standalone format or a syslog_optional format with
					// zero syslogs detected.

					// Note, apache_custom and blue_coat_custom formats are only possible in this case!
					// These two formats are never auto detected!

					GD.final_log_format_id = selected_log_format_id;
					checkForDatabaseAndLogFormatOptions();
				}
			}
		}
		else {
			// Nothing selected
			alert(langVar('lang_admin.new_profile_wizard.no_log_format_selected'));
		}
	}

	function next_on_log_format_all_page() {

		GD.final_log_format_id = '';
		GD.final_syslog_id = '';

		var log_format_all_list = document.getElementById('log_format_all_list');
		var log_format_all_list_index = log_format_all_list.selectedIndex;

		if (log_format_all_list_index >= 0) {

			// var selected_log_format = log_format_all_list.options[log_format_all_list_index].value;
			var selected_log_format_id = log_format_all_list.options[log_format_all_list_index].value;
			var selected_log_format_item = get_log_format_item_by_id(selected_log_format_id);
			var selected_log_data_type = selected_log_format_item.type;

			// alert('selected_log_format: ' + selected_log_format + '\nselected_log_data_type: ' + selected_log_data_type);

			if (selected_log_data_type == 'syslog') {

				GD.final_syslog_id = selected_log_format_id;
				set_and_goto_syslog_required_all_page();
			}
			else {

				GD.final_log_format_id = selected_log_format_id;

				if (selected_log_data_type == 'syslog_required' ||
					selected_log_data_type == 'syslog_optional') {

					set_and_goto_syslog_all_page();
				}
				else {

					// This is a standalone format

					// Note, apache_custom, blue_coat_custom and ez_proxy_custom formats are only possible in this case!
					// These formats are never auto-detected!

					GD.final_log_format_id = selected_log_format_id;

					var selected_log_format_name = selected_log_format_item.name;

					if (selected_log_format_name == 'apache_custom' ||
						selected_log_format_name == 'blue_coat_custom' ||
						selected_log_format_name == 'ez_proxy_custom') {

						// set the log format string instruction
						util.hideE(['log_format_string_instruction:apache_custom', 'log_format_string_instruction:ez_proxy_custom']);

						if (selected_log_format_name == 'apache_custom') {
							util.showE('log_format_string_instruction:apache_custom');
						}
						else if (selected_log_format_name == 'ez_proxy_custom') {
							util.showE('log_format_string_instruction:ez_proxy_custom');
						}

						goto_wizard('log_format_string_page');
					}
					else {

						checkForDatabaseAndLogFormatOptions();
					}
				}
			}
		}
		else {

			alert(langVar('lang_admin.new_profile_wizard.no_log_format_selected'));
		}
	}

	function next_on_syslog_direct_match_page() {

		var use_direct_match = true;

		if (!GD.isLite && util.getF('syslog_direct_match_use_manual_btn')) {

			use_direct_match = false;
		}

		if (use_direct_match) {

			// only one syslog exists, set it as the final syslog_required format

			for (var i = 0; i < GD.detected_log_formats_db.length; i++) {

				if (GD.detected_log_formats_db[i].type == 'syslog') {

					GD.final_syslog_id = GD.detected_log_formats_db[i].id;
					break;
				}
			}

			checkForDatabaseAndLogFormatOptions();
		}
		else {

			set_and_goto_syslog_all_page();
		}
	}

	function next_on_syslog_multiple_match_page() {

		var selected_syslog_id = GD.multiple_syslog_match_list.getSelectedId();

		if (selected_syslog_id != '') {

			if (selected_syslog_id == '__SHOW__ALL__') {

				set_and_goto_syslog_all_page();
			}
			else {

				GD.final_syslog_id = selected_syslog_id;
				checkForDatabaseAndLogFormatOptions();
			}
		}
		else {

			alert(langVar('lang_admin.new_profile_wizard.no_syslog_selected'));
		}
	}

	function next_on_syslog_all_page() {

		var syslog_all_list = document.getElementById('syslog_all_list');
		var syslog_all_list_index = syslog_all_list.selectedIndex;

		if (syslog_all_list_index >= 0) {

			GD.final_syslog_id = syslog_all_list.options[syslog_all_list_index].value;

			checkForDatabaseAndLogFormatOptions();
		}
		else {

			alert(langVar('lang_admin.new_profile_wizard.no_syslog_selected'));
		}
	}

	function next_on_syslog_required_direct_match_page() {

		var use_direct_match = true;

		if (!GD.isLite && util.getF('syslog_required_direct_match_use_manual_btn')) {
			use_direct_match = false;
		}

		if (use_direct_match) {

			// only one syslog_required exists, set it as the final syslog_required format

			for (var i = 0; i < GD.detected_log_formats_db.length; i++) {

				if (GD.detected_log_formats_db[i].type == 'syslog_required') {

					GD.final_log_format_id = GD.detected_log_formats_db[i].id;
					break;
				}
			}

			checkForDatabaseAndLogFormatOptions();
		}
		else {

			set_and_goto_syslog_required_all_page();
		}
	}

	function next_on_syslog_required_multiple_match_page() {

		var selected_syslog_required_id = GD.multiple_syslog_required_match_list.getSelectedId();

		if (selected_syslog_required_id != '') {

			if (selected_syslog_required_id == '__SHOW__ALL__') {

				set_and_goto_syslog_required_all_page();
			}
			else {

				GD.final_log_format_id = selected_syslog_required_id;
				checkForDatabaseAndLogFormatOptions();
			}
		}
		else {
			alert(langVar('lang_admin.new_profile_wizard.no_syslog_required_selected'));
		}
	}

	function next_on_syslog_required_all_page() {

		var syslog_required_all_list = document.getElementById('syslog_required_all_list');
		var syslog_required_all_list_index = syslog_required_all_list.selectedIndex;

		if (syslog_required_all_list_index >= 0) {

			GD.final_log_format_id = syslog_required_all_list.options[syslog_required_all_list_index].value;
			checkForDatabaseAndLogFormatOptions();
		}
		else {

			alert(langVar('lang_admin.new_profile_wizard.no_syslog_required_selected'));
		}
	}

	function next_on_log_format_string_page() {

		var validator = GD.validator;
		validator.reset();

		// The log format string must support leading or trailing spaces!
		GD.final_log_format_string = validator.isValue('log_format_string_value', false);
		// alert('GD.log_format_string_value: ' + GD.log_format_string_value);

		if (validator.allValid()) {
			checkForDatabaseAndLogFormatOptions();
		}
	}

	function next_on_db_server_page() {

		if (validateDatabaseOptions()) {

			// util.showObject(GD.dbServer);

			if (GD.dbServer.type == 'internal_sql' && GD.dbServer.database_directory == '') {

				goto_wizard('db_performance_page');
			}
			else {
				validateDatabaseOptionsOnServerSide();  // Server response handles further actions
			}
		}
	}


	function next_on_db_performance_page() {

		GD.turnOnDatabaseFieldsIndices = util.getF('db_performance:turn_on_database_fields_indices');
		GD.turnOnCrossReferenceGroups = util.getF('db_performance:turn_on_cross_reference_groups');
		// GD.turnOnSessionTracking = util.getF('db_performance:turn_on_session_tracking');

		set_and_goto_log_format_options_page();
	}

	function next_on_log_format_options_page() {

		var isCheckedNumericalField = false;

        var fieldsDb = GD.numerical_fields_db;
        var max = fieldsDb.length;
        var isChecked;

		for (var i = 0; i < max; i++) {

            isChecked = util.getF('numerical_field:' + fieldsDb[i].name);

            // Set  active checkbox value
            fieldsDb[i].add_field = isChecked;

			if (isChecked) {
				isCheckedNumericalField = true;
			}
		}

		if (isCheckedNumericalField) {
            handleSnapons();
		}
		else {
			alert(langVar('lang_admin.new_profile_wizard.log_format_options_numerical_field_nothing_checked'));
		}
	}

    function next_on_snapons_page() {

        // Check snapon state for all snapons where prompt_to_attach is true
        var snapons = GD.snapons;
        var max = snapons.length;
        var snaponItem;

        for (var i = 0; i < max; i++) {

            snaponItem = snapons[i];

            if (snaponItem.promptToAttach) {
                snaponItem.attach = util.getF('attach_snapon:' +  snaponItem.logFormatSnaponName);
            }
        }

        // Check if we need to show any snapon parameters form
        setSnaponsParametersForm();
    }

	function next_on_snapon_parameters_page(active_wizard_page) {

		// Validate current parameters page
		// alert('Clicked NEXT! Current page is snapon parameters form page : ' + active_wizard_page);

		var parametersFormIndex = getParametersFormIndexFromElementId(active_wizard_page);

		if (snaponParameters.getIsValidWizardPage(parametersFormIndex)) {

			var numberOfSnaponParametersFormItems = GD.snaponsParametersForm.length;

			if (parametersFormIndex < (numberOfSnaponParametersFormItems - 1)) {

				// There is another snapon parameters page
				goto_wizard('snapon_parameters_page:' + (parametersFormIndex + 1));
			}
			else {
				// No more parameters page, go to profile_name_page
				set_and_goto_profile_name_page();
			}
		}
	}

	function goto_wizard(page_name) { // hide active wizard and show next wizard as in argument

		// util.showObject(GD.wizard_path, 'goto_wizard() - GD.wizard_path');

		var wizard_position = GD.wizard_path.length; // position to which the next wizard will be set

		if (wizard_position != 0) {
			hide_wizard_page(GD.wizard_path[wizard_position - 1]); // hide the active wizard
		}

		// hide mini progress section
		if (document.getElementById('mini_progress_section').style.display == 'block') {
			util.hideE('mini_progress_section');
		}

		show_wizard_page(page_name);
		GD.wizard_path[GD.wizard_path.length] = page_name;

		set_wizard_buttons();
	}

	function show_wizard_page(page_name) { // shows the wizard

		// alert('page_name: ' + page_name);
		// util.showObject({page_name:page_name}, 'show_wizard_page()');

		var wizard_page = document.getElementById(page_name);
		var wizard_label;

		// set the wizard number
		// var wizard_number = GD.wizard_path.length > 0 ? GD.wizard_path.length : 1; 
		// util.updateT('wizard_number', wizard_number);

		// Update More Info system
		newProfileWizardUtil.updateMoreInfoSystem(page_name);

		// set the wizard label
		if (page_name == 'log_format_string_page') {

			// use the log format label, i.e. Apache Custom Log Format
			var log_format_item = get_log_format_item_by_id(GD.final_log_format_id);
			wizard_label = log_format_item.label;
		}
		else if (page_name.indexOf('snapon_parameters_page:') != -1) {

			// This is a snapon parameters page, get label from parameters form
			var parametersFormIndex = getParametersFormIndexFromElementId(page_name);
			wizard_label = GD.snaponsParametersForm[parametersFormIndex].label;
		}
		else {

			// Default
			wizard_label = GD.wizard_labels[page_name];
		}

		util.updateT('wizard_label', wizard_label);

		// alert('page_name: ' + page_name + '\nwizard_page: ' + wizard_page + '\nwizard_page_label: ' + wizard_page_label);

		document.getElementById('wizard_label').style.visibility = 'visible';
		wizard_page.style.display = 'block';

		if (page_name == 'profile_name_page') {

			document.getElementById('profile_name').focus();
			document.getElementById('profile_name').select();
		}
	}

	function hide_wizard_page(page_name) {

		var wizard_page = document.getElementById(page_name);

		wizard_page.style.display = 'none';
		document.getElementById('wizard_label').style.visibility = 'hidden';

		if (page_name == 'log_source_page') {

			document.getElementById('log_format_progress_section').style.display = 'none';

			// Close matching files panel, if any
			matchingFiles.closePanel();
		}

         // Hide any open option_info
        optionInfo.close();
	}

	function back_wizard() {

		// get the current wizard position

		var wizard_to_hide = GD.wizard_path[GD.wizard_path.length - 1]
		var wizard_to_show = GD.wizard_path[GD.wizard_path.length - 2]
		// var array_length_before = GD.wizard_path.length;

		GD.wizard_path.pop(); //removes the wizard_to_hide from the GD.wizard_path array


		// Remove event listener from profile_name page
		if (wizard_to_hide == 'profile_name_page') {

			YE.removeListener('profile_name', 'keyup', updateDatabaseNameOnProfileNamePage);
			YE.removeListener('profile_name', 'paste', updateDatabaseNameOnProfileNamePage);
		}

		hide_wizard_page(wizard_to_hide);
		set_wizard_buttons();

		show_wizard_page(wizard_to_show);
	}

	function disable_wizard_buttons() {

		document.getElementById('back_btn').disabled = true;
		document.getElementById('next_btn').disabled = true;
	}

	function set_wizard_buttons() {

		var back_btn = document.getElementById('back_btn');
		var next_btn = document.getElementById('next_btn');

		var active_wizard_page = GD.wizard_path[GD.wizard_path.length - 1];

		if (active_wizard_page == 'log_source_page') { // set to first

			back_btn.disabled = true;
			next_btn.disabled = false;

		}
		else if (active_wizard_page == 'profile_name_page') { //set to last

			back_btn.disabled = false;
			next_btn.disabled = false;

			next_btn.value = langVar('lang_stats.btn.finish');
		}
		else if (active_wizard_page == 'log_format_not_supported_page') {

			back_btn.disabled = false;
			next_btn.disabled = true;
		}
		else { // set to between

			back_btn.disabled = false;
			next_btn.disabled = false;
			next_btn.value = langVar('lang_stats.btn.next');

			if (GD.isLite && active_wizard_page == 'log_format_no_match_page') {

				next_btn.disabled = true;
			}
			else {

				next_btn.disabled = false;
			}
		}
	}



	//
	//
	// Confirm database sharing
	// Confirmation is used when database_name is equal profile label
	// but profile label is already used as database name
	//

	function openConfirmDatabaseSharing(databaseName, profilesWhichAlreadyUsesDbName) {

		// databaseName is equal the actual profile label!

		if (!GD.confirmDatabaseSharingPanel) {

			// Init the panel
			var panelObj = {
				panelId: 'confirm_database_sharing:panel',
				panelClassName: 'panel-50',
				panelHeaderLabel: langVar('lang_admin.new_profile_wizard.confirm_database_sharing.label'),
				left: 80,
				top: 40,
				zIndex: 20,
				isCover: true,
				closeEvent: newProfileWizard.cancelConfirmDatabaseSharing
			};

			GD.confirmDatabaseSharingPanel = new util.Panel3(panelObj);

			YE.addListener('confirm_database_sharing:cancel_btn', 'click', cancelConfirmDatabaseSharing);
			YE.addListener('confirm_database_sharing:continue_btn', 'click', confirmDatabaseSharing);
		}

		// Compose message
		var message = '<p>' + langVar('lang_admin.new_profile_wizard.confirm_database_sharing.db_name_in_use_info') + '</p>';
		message = message.replace(/__PARAM__1/, '<em class="db-warning">' + databaseName + '</em>');

		message += '<ul class="db-warning">' + profilesWhichAlreadyUsesDbName + '</ul>';
		message += '<div class="info-box">';
		message += '<p><strong>' + langVar('lang_admin.new_profile_wizard.confirm_database_sharing.click_cancel_info') + '</strong></p>';
		message += '<p><strong>' + langVar('lang_admin.new_profile_wizard.confirm_database_sharing.click_continue_info') + '</strong></p>';
		message += '<p>' + langVar('lang_admin.new_profile_wizard.confirm_database_sharing.share_db_info') + '</p>';
		message += '</div>';

		var container = util.getE('confirm_database_sharing:container');
		container.innerHTML = message;

		GD.confirmDatabaseSharingPanel.open();
	}

	function confirmDatabaseSharing() {

		// Sharing confirmed, close confirm panel
		GD.confirmDatabaseSharingPanel.close();

		// Set database_name because it is still blank
		GD.dbServer.database_name = GD.profileLabel;
		finishWizardFinal();
	}

	function cancelConfirmDatabaseSharing() {

		GD.confirmDatabaseSharingPanel.close();
	}

	//
	//
	// finish wizard
	//
	//

	function updateDatabaseNameOnProfileNamePage(evt) {

		// User types (pastes) new profile name.
		// Create database name from profileNodeName and update display.
		GD.timeoutId = GD.timeoutId + 1;
		setTimeout('newProfileWizard.createDatabaseNameOnProfileNamePage(' + GD.timeoutId + ')', 100);
	}

	function createDatabaseNameOnProfileNamePage(timeoutId) {

		// Don't create the profileNodeName on every key press (while typing),
		// this is achieved by checking for the latest timeoutId.

		// util.showObject({timeoutId_1:timeoutId});

		if (timeoutId == GD.timeoutId) {

			// Get database name from unique ProfileNodeName and update display.
			// util.showObject({timeoutId_2:timeoutId});

			var profileLabel = util.getF('profile_name');
			var profileNodeName = '';

			if (profileLabel != '') {
				profileNodeName = getProfileNodeName(profileLabel);
			}
			else {
				profileNodeName = '&nbsp;';
			}

			// util.updateT('profile_name_page:derived_database_name', profileNodeName);
			util.setF('profile_name_page:derived_database_name', profileNodeName);

			// Reset the validator since there is no other way to reset any
			// possible error indication on the disabled input field for the database name.
			GD.validator.reset();

			// util.showObject({profileNodeName:profileNodeName});
		}
	}

	function getProfileNodeName(profileLabel) {

		// Creates a unique profileNodeName from the profile label

		// Create profile node name array
		if (!GD.profileNodeNames) {
			var a = [];
			var profilesDb = GD.profilesDb;
			var len = profilesDb.length;

			for (var i = 0; i < len; i++) {
				a[i] = profilesDb[i].name;
			}

			// util.showObject({"generated_profile_node_names":a});
		}

		return util.labelToUniqueNodeName(profileLabel, a, '_profile');
	}

	function finish_wizard_via_enter_key(evt) {

		var key_code = (evt.which) ? evt.which : evt.keyCode;

		// alert(key_code);

		if (key_code == 13 || key_code == 3) {
			finishWizard();
		}
	}

	function finishWizard() {

		var validator = GD.validator;
		validator.reset();

		var profileLabel = validator.isValue('profile_name');
		var profileNodeName = '';
		GD.profileLabel = profileLabel;

		var isDuplicateProfileLabel = false;
		var profilesDb = GD.profilesDb;
		var dbServer = GD.dbServer;
		var dbServerType = dbServer.type;

		var databaseNameIsProfileNodeName = false;

		if (profileLabel != '') {

			// Check for unique profile label
			for (var i = 0, numOfProfiles = profilesDb.length; i < numOfProfiles; i++) {

				if (profilesDb[i].label == profileLabel) {

					// Show custom error message
					var msg = langVar('lang_admin.new_profile_wizard.profile_name_already_exist');
					msg = msg.replace(/__PARAM__1/, '"' + profileLabel + '"');
					validator.isCustom('profile_name', msg);
					isDuplicateProfileLabel = true;
					break;
				}
			}

			profileNodeName = getProfileNodeName(profileLabel);
			GD.profileNodeName = profileNodeName;

			// Validate database_name if server is MySQL or MS SQL
			// and if the database name has not been defined on the database page.
			if (!isDuplicateProfileLabel &&
				(dbServerType == 'mysql' || dbServerType == 'odbc_mssql') &&
				dbServer.database_name == '') {

				databaseNameIsProfileNodeName = true;

				// validate the profileNodeName to be a valid database name
				// Although the database is a node_name it could still be an invalid
				// database name. I.e. 123 is not a valid MS SQL database name.
				// So we validate the node_name to be a valid database name.

				var databaseNameVal = databaseUtil.getIsValidDatabaseName(dbServerType, profileNodeName);

				if (!databaseNameVal.isValid) {
					// Throw custom error
					validator.isCustom('profile_name_page:derived_database_name', databaseNameVal.errorMessage);
				}
			}
		}

		if (validator.allValid()) {

			if (!databaseNameIsProfileNodeName) {

				finishWizardFinal();
			}
			else {

				// Check if the derived database name from profileNodeName is already used
				// in the database server.
				var profilesWhichAlreadyUsesDbName = getProfilesWhichAlreadyUsesDbName(dbServerType, profileNodeName);

				if (profilesWhichAlreadyUsesDbName == '') {

					// The derived database name is not used for another profile.
					// Note, don't set the name here because we may need to re-validate
					// the profile label upon server response, so dbServer.database_name
					// must remain empty. The database name will be set on server side by
					// the given profileNodeName.
//					dbServer.database_name = profileLabel; <= database_name must be empty!
					finishWizardFinal();
				}
				else {
					// Confirm that the derived database name will be shared among two or more profiles.
					openConfirmDatabaseSharing(profileLabel, profilesWhichAlreadyUsesDbName);
				}
			}
		}
	}

	function finishWizardFinal() {

		// disable the cancel button
		util.disableE('cancel_btn');

		show_mini_progress(langVar('lang_admin.new_profile_wizard.saving_new_profile_info'));

		var url = '?dp=new_profile_wizard.finish_wizard';
		var dat = 'v.fp.page_token=' + GD.pageToken + '&';
		dat += process_form();
		util.serverPost(url, dat);
	}

	function finishWizardResponse(dat) {

		// alert('response received, dat is: ' + dat);

		util.hideE('mini_progress_section');

		if (dat.isUniqueProfileNodeName) {

			util.showE('profile_saved_info_section');

			// Profile has been saved
			if (opener) {

				// Note, if the opener is yet open we close the window
				// in newProfileCreatedInfo()

				opener.newProfileInfo.openViaNewProfileWizard(dat.newProfileName, dat.numberOfAllProfiles, dat.profilesDb);
			}
			else {
				window.close();
			}
		}
		else {

			// No unique profile node name. Someone else
			// may have created a profile with the node_name
			// of this profile.
			// util.showObject(dat.allProfilesDb);

			// Set up to date profilesDb
			GD.profilesDb = dat.allProfilesDb;

			// Reset profileNodeNames
			GD.profileNodeNames = null;

			// If the profile has a database name derived from the profile name
			// then update the profile node name now.
			var dbServer = GD.dbServer;
			var dbServerType = dbServer.type;

			if ((dbServerType == 'mysql' || dbServerType == 'odbc_mssql') &&
				dbServer.database_name == '') {

				updateDatabaseNameOnProfileNamePage();
			}

			show_wizard_page('profile_name_page');
			util.enableE('cancel_btn');
			set_wizard_buttons();

			alert(langVar('lang_admin.new_profile_wizard.profile_name_page.profile_not_created_message'));
		}
	}

	//
	//
	// get_snaposn_dat
	//
	//

	function get_snapons_dat() {

		var snapons = GD.snapons;
		var dat = '';

		for (var i = 0, max = snapons.length; i < max; i++) {

			var theSnapon = snapons[i];
			var logFormatSnaponName = theSnapon.logFormatSnaponName;

			// 2012-10-02 - GMF - Get the snapon instance name
			var logFormatSnaponInstanceName = theSnapon.logFormatSnaponInstanceName;

			var parametersForm = theSnapon.parametersForm;

			// 2012-10-02 - GMF - Use the instannce name (not the snapon name) to set attach=true
            var path = 'volatile.new_profile.snapons.' + logFormatSnaponInstanceName;

            dat += path + '.attach=' + theSnapon.attach + '&';

            if (theSnapon.attach && parametersForm.length > 0) {

                for (var j = 0, parametersFormMax = parametersForm.length; j < parametersFormMax; j++) {

                    var parameters = parametersForm[j].parameters;

                    // util.showObject(parameters, 'parameters');

                    for (var k = 0, parametersMax = parameters.length; k < parametersMax; k++) {

                        var parameterItem = parameters[k];
                        dat += path + '.parameters.' + parameterItem.name + '.parameter_value=' + encodeURIComponent(parameterItem.finalValue) + '&';
                    }
                }
            }
		}

		return dat;
	}


	//
	//
	// process_form
	//
	//

	function process_form() {

		var dat = '';

		// send _autodetecting_id
		// dat += 'volatile.new_profile.autodetecting_id=' + GD.log_format_autodetecting_id + '&';

		//
		// log source
		//

		dat += get_log_source_dat() + '&';

		//
		// if real time processing is enabled then send it
		//

		// if (_real_time_processing) {
		//	dat += 'volatile.new_profile.real_time_processing=true&'
		// }

		//
		// log format
		//

		var log_format_item = get_log_format_item_by_id(GD.final_log_format_id);
		var log_data_type = log_format_item.type;

		if (log_data_type == 'syslog_required' || log_data_type == 'syslog_optional') {

			// Note, the syslog is optional if log_data_type is syslog_optional,
			// if not defined we must set "no_syslog" as the syslog.
			var syslog_name = '';

			if (GD.final_syslog_id != '') {

				var syslog_item = get_log_format_item_by_id(GD.final_syslog_id);
				syslog_name = syslog_item.name;
			}
			else {
				syslog_name = 'no_syslog';
			}

			dat += 'volatile.new_profile.log_format_type=syslog&';

			// syslog_required_format is also used for syslog_optional!
			dat += 'volatile.new_profile.syslog_required_format=' + log_format_item.name + '&';
			dat += 'volatile.new_profile.syslog_format=' + syslog_name + '&';
		}
		else {

			// Standalone format
			var log_format_name = log_format_item.name;

			dat += 'volatile.new_profile.log_format_type=standalone&';
			dat += 'volatile.new_profile.log_format=' + log_format_name + '&';

			// if the log format is apache_custom blue_coat_custom or ez_proxy_custom add the _log_format_string

			if (log_format_name == 'apache_custom' ||
				log_format_name == 'blue_coat_custom' ||
				log_format_name == 'ez_proxy_custom') {

				dat += 'volatile.new_profile.log_format_string=' + encodeURIComponent(GD.final_log_format_string) + '&';
			}
		}

		//
		// database server
		//

		var db_path = 'volatile.new_profile.database.server.';
		var dbServer = GD.dbServer;

		for (var prop in dbServer) {

			dat += db_path + prop + '=' + encodeURIComponent(dbServer[prop]) + '&';
		}

		//
		// database performance
		//

		dat += 'volatile.new_profile.turn_on_database_fields_indices=' + GD.turnOnDatabaseFieldsIndices + '&';
		dat += 'volatile.new_profile.turn_on_cross_reference_groups=' + GD.turnOnCrossReferenceGroups + '&';
		// dat += 'volatile.new_profile.turn_on_session_tracking=' + GD.turnOnSessionTracking + '&';

		//
		// log format options - numerical fields
		//

		for (var i = 0; i < GD.numerical_fields_db.length; i++) {

			if (GD.numerical_fields_db[i].add_field) {

				dat += 'volatile.new_profile.numerical_fields.' + GD.numerical_fields_db[i].name + '=true&';
			}
		}

		//
		// snapons
		//

		if (GD.snapons.length > 0) {

			// util.showObject(GD.snapons);
			dat += get_snapons_dat();
		}

		//
		// profile name
		//

		dat += 'volatile.new_profile.profile_name=' + encodeURIComponent(GD.profileLabel) + '&';
		dat += 'volatile.new_profile.profile_node_name=' + encodeURIComponent(GD.profileNodeName);

		return dat;
	}

	// ===================
	// log source progress
	// ===================

	function show_log_format_progress(show_log_format_progress) {

		// hides the log source wizard and shows log format progress

		var log_format_progress_section = document.getElementById('log_format_progress_section');

		if (show_log_format_progress) {

			// hide infoPanel
			newProfileWizardUtil.updateMoreInfoSystem('');

			disable_wizard_buttons();
			hide_wizard_page('log_source_page');

			adjust_log_format_progress();

			log_format_progress_section.style.display = 'block';

			var start_date = new Date();
			GD.autodetecting_log_format_start_time = start_date.getTime();

			// alert(GD.autodetecting_log_format_start_time);

			GD.log_format_progress_timer = setInterval('newProfileWizard.set_log_format_progress_elapsed_time()', 1000);

		}
		else {

			// return to log source view

			set_wizard_buttons();
			log_format_progress_section.style.display = 'none';
			show_wizard_page('log_source_page');
		}
	}

	function adjust_log_format_progress() {

		var log_format_progress_log_bytes_downloaded_row = document.getElementById('log_format_progress_log_bytes_downloaded_row');
		var log_format_progress_download_info_row = document.getElementById('log_format_progress_download_info_row');

		// check the log source type

		var log_source_type;
		var log_source = GD.log_source;

		for (var i = 0; i < log_source.length; i++) {

			if (_log_source[i].name == 'type') {

				log_source_type = log_source[i].value;
			}
		}

		// alert('log_source_type: ' + log_source_type);

		util.updateT('log_format_progress_suboperation_description_label', '-');
		util.updateT('log_format_progress_elapsed_time', '00:00:00');

		if (log_source_type == 'ftp' || log_source_type == 'http') {

			util.updateT('log_format_progress_log_bytes_downloaded', '-');
			log_format_progress_download_info_row.style.display = '';
			log_format_progress_log_bytes_downloaded_row.style.display = '';
		}
		else {

			log_format_progress_download_info_row.style.display = 'none';
			log_format_progress_log_bytes_downloaded_row.style.display = 'none';
		}	
	}

	function set_log_format_progress_elapsed_time() {

		var current_date = new Date();
		var current_time = current_date.getTime();

		var elapsed_time = Math.round((current_time - GD.autodetecting_log_format_start_time) / 1000);

		var remainder = 0;
		var hours = 0;
		var minutes = 0;
		var seconds = 0;

		if (elapsed_time >= 3600) {

			remainder = elapsed_time % 3600;
			hours = (elapsed_time - remainder) / 3600;

			elapsed_time = remainder;
		}

		if (elapsed_time >= 60) {

			remainder = elapsed_time % 60;
			minutes = (elapsed_time - remainder) / 60;

			elapsed_time = remainder;
		}

		seconds = elapsed_time;

		hours = (hours > 9) ? hours : '0' + hours;
		minutes = (minutes > 9) ? minutes : '0' + minutes;
		seconds = (seconds > 9) ? seconds : '0' + seconds;

		var elapsed_time_text = hours + ':' + minutes + ':' + seconds;

		util.updateT('log_format_progress_elapsed_time', elapsed_time_text);
	}

	function stop_log_format_progress_elapsed_time() {

		clearInterval(GD.log_format_progress_timer);
	}

	//
	// log format utilities
	//

	function get_log_format_db() {

		show_mini_progress(langVar('lang_admin.new_profile_wizard.loading_log_format_list'));

		var url = '?dp=new_profile_wizard.get_log_format_db';
		var dat = 'v.fp.page_token=' + GD.pageToken;

		util.serverPost(url, dat);
	}

	function server_response_get_log_format_db(dat) {

		GD.log_format_db = get_modified_log_formats_db(dat);

		//
		// sort the array
		//

		GD.log_format_db.sort(compare_labels);

		//
		// create hash
		//

		util.createHash(GD.log_format_db, 'id');

		GD.log_format_db_loaded = true;

		// simply repeat next_wizard();

		next_wizard();
	}

	function get_modified_log_formats_db(log_formats) {

		// This returns a new log format array where each log format has
		// exactly one label. Log formats with multiple labels in the labels array
		// are split into separate log formats.
		// This requires the addition of a separate log format ID due
		// the possibility of identical log format names and to distinguish
		// this array from the auto detected.

		// The object of each item should match the autodetected item format
		// so that the log_format_db and detected_log_formats_db can be used
		// interchangeably.

		var a = [];

		var num_of_log_formats = log_formats.length;
		var number_of_new_items = 0;
		var base_id = util.getUniqueElementId();

		for (var i = 0; i < num_of_log_formats; i++) {

			var item = log_formats[i];
			var item_labels = item.labels;
			var log_format_name = item.name;
			var log_data_type = item.type;
			var log_format_type = item.lfType;
			var meta_type_label = get_log_format_meta_type_label(log_data_type, log_format_type);

			// Add individual log format item for each label in item_labels

			for (var j = 0; j < item_labels.length; j++) {

				// Compose unique ID, this ID should not be interchangeable with
				// ID's used in detected_log_formats_db. The ID in detected_log_formats_db
				// is equal the log format name.

				var id = base_id + '_' + log_format_name + '_' + j;

				var new_item = {};
				new_item.id = id;
				// The label property is also used to distinguish manual items from auto-detected items,
				// the latter has no label property!
				new_item.label = item_labels[j];
				new_item.labels = item_labels; // We still require the labels array per log format item!
				new_item.name = log_format_name;
				new_item.description = item.description;
				new_item.type = log_data_type;
				// new_item.lfType = log_format_type;
				new_item.metaTypeLabel = meta_type_label;
				new_item.isSupportedLogFormat = item.isSupportedLogFormat;
				new_item.notSupportedMessage = item.notSupportedMessage;

				a[number_of_new_items] = new_item;

				number_of_new_items++;
			}
		}

		// Clear log_formats
		log_formats = [];

		return a;
	}

	function get_log_format_item_by_id(id) {

		// Returns the log format item of the given id
		// First always try if the id exists if
		// GD.detected_log_formats_db.

		// Note, the same log format has a different id in
		// detected_log_formats_db and log_format_db, that's
		// why we must always look in detected_log_formats_db,
		// even if log_format_db is loaded.

		var item = GD.detected_log_formats_db[util.h(id)];

		if (GD.log_format_db_loaded && item == null) {

			// This must be an id from log_format_db
			item = GD.log_format_db[util.h(id)];
		}

		// util.showObject(item, "get_log_format_item_by_id()");

		return item;
	}

	function get_log_format_meta_type_label(log_data_type, log_format_type) {

		// This creates a meta type label from log_data_type and log_format_type

		var type_label = (typeof LDT[log_data_type] != 'undefined')  ? LDT[log_data_type] : log_data_type;
		var format_label = (typeof LDT[log_format_type] != 'undefined')  ? LDT[log_format_type] : log_format_type;
		var meta_type_label = '';

		if (type_label == '' || format_label == '') {

			if (type_label == '' && format_label == '') {
				meta_type_label = '-';
			}
			else if (type_label == '') {
				meta_type_label = format_label;
			}
			else {
				meta_type_label = type_label;
			}
		}
		else if (type_label == format_label) {

			meta_type_label = type_label;
		}
		else {
			meta_type_label = type_label + ' / ' + format_label
		}

		return meta_type_label;
	}

	function get_log_format_labels(log_format_item) {

		// Returns multiple labels for autodetected items
		// and a single label for log_format_db items
		var label = '';

		if (log_format_item['labels'] != null) {

			var the_labels = log_format_item.labels;
			var number_of_labels = the_labels.length;

			for (var i = 0; i < number_of_labels; i++) {

				label += the_labels[i];

				// Add comma if not last item
				if (i + 1 < number_of_labels) {
					label += ', ';
				}
			}
		}
		else {
			label = log_format_item.label;
		}

		return label;
	}

	function create_log_format_item_label(container_element_id, log_format_item, is_strong_label) {

		// This creates a log format item text

		// is_strong_label is optional, default is true.
		var is_strong_label = (typeof is_strong_label != 'undefined') ? is_strong_label : true;

		var container_element = util.getE(container_element_id);

		// Clean up container element
		util.removeChildElements(container_element);

		var meta_type_label = log_format_item.metaTypeLabel;
		var div = util.createE('div');
		var em = util.createE('em');
		var emText = util.createT(meta_type_label);
		var br;
		var strongTagName;
		var strong;
		var text;
		var labels = [];
		var i;
		var number_of_labels = 0;

		// Don't use multiple labels for display if the item has been
		// chosen manually where it is indicated by a single label.
		// We recognize manual items by the "label" property, auto-detected
		// items have only a "labels" property.

		if (log_format_item.hasOwnProperty('label')) {

			// This is a log format item from a manual list.
			// We want the item to display only a single label.
			labels[0] = log_format_item.label;
			number_of_labels = 1;
		}
		else {
			// This is a auto-detected log format item,
			// in this case we want to display all available labels
			// of the log format item.
			labels = log_format_item.labels;
			labels.sort();
			number_of_labels = labels.length;
		}

		util.chainE(div, em, emText);

		for (i = 0; i < number_of_labels; i++) {

			br = util.createE('br');
			strongTagName = is_strong_label ? 'strong' : 'span';
			strong = util.createE(strongTagName);
			text = util.createT(labels[i]);
			util.chainE([div, br, [strong, text]]);
		}

		util.chainE(container_element, div);
	}

	//
	//
	// restoreNewProfileWizardPageAfterError
	//
	//

	function restoreNewProfileWizardPageAfterError() {

		// restoreNewProfileWizardPageAfterError is called from util.closeServerBackgroundCallAlertInfo
		// to restore the wizard page after any alert window becomes closed. This is in particular
		// important for final step so that log format developers must not start over from the beginning.

		var active_wizard_page = GD.wizard_path[GD.wizard_path.length - 1];

		// alert('active_wizard_page: ' + active_wizard_page);

		util.hideE('mini_progress_section');

		// resore the wizard page
		show_wizard_page(active_wizard_page);

		set_wizard_buttons();
		util.enableE('cancel_btn');
	}


	// ==============
	// help utilities
	// ==============

	function show_hide_info_section(element_id) {

		// alert(element_id);
		var info_box_element = document.getElementById(element_id);
		info_box_element.style.display = (info_box_element.style.display == 'none') ? 'block' : 'none';
	}


	// =========
	// utilities
	// =========


//	function set_to_detected_btn_switch(element_id) {
//
//		// automatically checks a radio button 'use detected' if a detected list item becomes selected
//		// Note, in Lite the radio buttons do not exist!
//
//		var the_radio_button = document.getElementById(element_id);
//
//		if (the_radio_button != null && !the_radio_button.checked) {
//
//			the_radio_button.checked = true;
//		}
//	}

	function deselect_list(element_id) {

		// deselects any item in the specified list
		the_list = document.getElementById(element_id);
		the_list.selectedIndex = -1;

		// Hide any log format description
		hide_log_format_description();
	}

	function show_mini_progress(progress_text) {

		disable_wizard_buttons();

		// hide infoPanel
		newProfileWizardUtil.updateMoreInfoSystem('');

		// hide active wizard page
		hide_wizard_page(GD.wizard_path[GD.wizard_path.length - 1]);

		util.updateT('progress_info_text', progress_text);
		util.showE('mini_progress_section');
	}

	function compare_labels(a, b) {
		// sorts the log format arrays by label
		var a_label = a.label.toLowerCase();
		var b_label = b.label.toLowerCase();

		if (a_label < b_label) {
			return -1;
		}
		else if (a_label > b_label) {
			return 1;
		}
		else {
			return 0;
		}
	}

	function value_is_not_empty_msg(value, msg) { // checks if a field value is empty or not and also shows the corresponding alert message
		var match_char = value.match(/.+/);
		if (match_char != null) {
			return true;
		}
		alert(msg);
		return false;	
	}

	//
	// show matching files of log source
	// 
	function show_matching_files() {

		if (validate_log_source()) {

			matchingFiles.openPanelFromNewProfileWizard();
			var url = '?dp=new_profile_wizard.get_matching_files';
			var dat = 'v.fp.page_token=' + GD.pageToken + '&';
			dat += get_log_source_dat();
			util.serverPost(url, dat);
		}

		return false;
	}

	function show_matching_files_response(dat) {

		// util.showObject(dat);
		matchingFiles.showFiles(dat);
	}

	function getParametersFormIndexFromElementId(parametersFormElementId) {

		// This returns the index of the parameters form
		var dat = parametersFormElementId.split(':');
		var index = parseInt(dat[1], 10);
		return index;
	}

    function addCheckboxRow(tbody, elementId, label, optionInfoIconId) {

        // optionInfoIconId is optional. Add info icon if optionInfoIconId is defined

        var tr = util.createE('tr');
        var th = util.createE('th');
        var td = util.createE('td');
        var input = util.createE('input', {type:'checkbox', id: elementId});
        var labelElement = util.createE('label', {htmlFor: elementId});
        var labelText = util.createT(label);

        util.chainE(td, [labelElement, labelText]);

        // Add option info icon
        if (optionInfoIconId) {

            var imgSrc = imgDb.optionInfo.src;
            var img = util.createE('img', {src:imgSrc, id:optionInfoIconId, className:'option-info', width:'18', height:'18'});

            if (util.userAgent.isIE6) {
                // IE6 only
                img.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + imgSrc + "', sizingMethod='scale')";
            }

            util.chainE(td, img);
        }

        util.chainE(tbody, [tr, [th, input], td]);
    }

   	function selectDeselectAll(evt) {

        var element = evt.target || evt.srcElement;
        var elementId = element.id;
        var containerId = '';
        var makeChecked = elementId.indexOf('deselect_all_btn') == -1 ? true : false;

        if (elementId.indexOf('log_format_options_page') != -1) {
            containerId = 'log_format_options_numerical_field_container';
        }
        else {
            containerId = 'snapons_page:container';
        }

        var containerElement = util.getE(containerId);
        var checkboxes = containerElement.getElementsByTagName('input');

        for (var i = 0, max = checkboxes.length; i < max; i++) {
            checkboxes[i].checked = makeChecked;
        }
   	}


	//
	//
	// Return global properties and methods
	//
	//

	return {

		getBasicData: getBasicData,
		getBasicDataResponse: getBasicDataResponse,

		checkLogSourceServerResponse: checkLogSourceServerResponse,
		checkLogSourceDbServerResponse: checkLogSourceDbServerResponse,

		server_response_detected_log_formats: server_response_detected_log_formats,
		server_response_invalid_log_source: server_response_invalid_log_source,
		server_response_autodetection_in_progess: server_response_autodetection_in_progess,

		set_log_format_progress_elapsed_time: set_log_format_progress_elapsed_time,
		get_detect_log_format_result: get_detect_log_format_result,

		server_response_get_log_format_db: server_response_get_log_format_db,
		validateDatabaseOptionsOnServerSideResponse: validateDatabaseOptionsOnServerSideResponse,
		get_log_format_options_response: get_log_format_options_response,
		finishWizardResponse: finishWizardResponse,

		show_matching_files_response: show_matching_files_response,

//		set_to_detected_btn_switch: set_to_detected_btn_switch,
		deselect_list: deselect_list,

		show_hide_info_section: show_hide_info_section,

		cancelConfirmDatabaseSharing: cancelConfirmDatabaseSharing,

		createDatabaseNameOnProfileNamePage: createDatabaseNameOnProfileNamePage
	}
}();
