//
// zoomInfo.js
//

var zoomInfo = {
	
	// zoomInfo is used by zoomControl & calendarControl
	
	isOpenPanel: false,
	isBuild: false,
	// top: 140, // top position of zoomInfo box
	// initialLoadDone: false, // initial load is displayed after opening the zoom panel (if initated by zoomControl only)
	
	update: function(isDateFilter, isFiltersItems, showAddBuildInReportFilters) {
		
		if (!zoomInfo.isOpenPanel) {
			zoomInfo.open();
		}
		
		var showDate = (isDateFilter && !isFiltersItems);
	
		util.showE('zoom_info:date_items:box', showDate);
		util.showE('zoom_info:filter_items:box', isFiltersItems);
		util.showE('zoom_info:build_in_filters:box', showAddBuildInReportFilters);
	},
	
	open: function() {
		
		if (!zoomInfo.isBuild) {
			// build the html
			zoomInfo.build();
		}
		util.showE('zoom_info:panel');
		zoomInfo.setPosition();
		YAHOO.util.Event.addListener(window, 'scroll', zoomInfo.setPositionByEvent);
		zoomInfo.isOpenPanel = true;
	},
	
	close: function() {
				
		if (zoomInfo.isOpenPanel) {
			
			YAHOO.util.Event.removeListener(window, 'scroll', zoomInfo.setPositionByEvent);
			
			util.hideE('zoom_info:panel');
		
			// Uncheck the Add build-in report filters checkbox
			// util.setF('zoom_info:add_build_in_report_filter:btn', false);
			
			zoomInfo.isOpenPanel = false;
		}
	},
	
	
	build: function() {
		
		// builds the html zoom filter panel
		
		var container = util.getE('reports_menu_and_report_section');
	
		// Create content of round box
		var table = util.createE('table', {className:'zoom-info'});
		var tbody = util.createE('tbody');
		var tr = util.createE('tr');
		var tdLeft = util.createE('td');
		var tdMiddle = util.createE('td');
		var tdRight = util.createE('td');
		zoomInfo.buildLeftColumn(tdLeft);
		zoomInfo.buildMiddleColumn(tdMiddle);
		zoomInfo.buildRightColumn(tdRight);
		util.chainE(table, tbody, [tr, tdLeft, tdMiddle, tdRight]);
		
		// Create the round box
		var div = util.getRoundBox('zoom_info:panel', 20, table);
		
		// Add round box
		util.chainE(container, div);
		
		// IE requires to add any event after the new DOM is part of the document!
		var cancelZoomEvent = !reportInfo.isCalendar ? zoomControl.cancelZoom : calendarControl.cancelZoom;
		YAHOO.util.Event.addListener('zoom_info:cancel_btn', 'click', cancelZoomEvent);
		
		zoomInfo.isBuild = true;
	},
	
	buildLeftColumn: function(td) {
		
		var src = imgDb.zoomLarge.src;
		var img = util.createE('img', {src:src, width:23, height:23, alt:''});
		
		util.chainE(td, img);
	},
	
	buildMiddleColumn: function(td) {
		
		var div = util.createE('div', {paddingRight:'200px', paddingBottom:'6px', fontWeight:'bold'});
		var text = util.createT(langVar('lang_stats.zoom.zoom_active'));
		
		var dateDiv = util.createE('div', {id:'zoom_info:date_items:box'});
		var dateMessage = reportInfo.isCalendar ? langVar('lang_stats.zoom.zoom_to_date_in_calendar_info') : langVar('lang_stats.zoom.zoom_to_date_items_info');
		var dateText = util.createT(dateMessage);
		
		var itemsDiv = util.createE('div', {id:'zoom_info:filter_items:box'});
		var itemsText = util.createT(langVar('lang_stats.zoom.zoom_selected_items_info'));
		
		var buildInFiltersDiv = util.createE('div', {id:'zoom_info:build_in_filters:box', paddingTop:'11px'});
		var input = util.createE('input', {id:'zoom_info:add_build_in_filters', type:'checkbox'});
		var label = util.createE('label', {htmlFor:'zoom_info:add_build_in_filters'});
		var labelText = util.createT(' ' + langVar('lang_stats.zoom.add_build_in_report_filters'));
		
		util.chainE(label, labelText);
		util.chainE([td, [div, text], [dateDiv, dateText], [itemsDiv, itemsText], [buildInFiltersDiv, input, label]]);
	},
	
	buildRightColumn: function(td) {
		
		var button = util.createE('button', {id:'zoom_info:cancel_btn', marginBottom:'24px'}); // margin keeps some default height
		var text = util.createT(langVar('lang_stats.btn.cancel_zoom'));
		
		util.chainE(td, button, text);
	},
	
	setPositionByEvent: function() {
		
		setTimeout('zoomInfo.setPosition()', 400);
	},
	
	setPosition: function() {
		
		var YD = YAHOO.util.Dom;
		
		var reg = YD.getRegion('report_section');
		
		// util.showObject(reg);
		
		var left = reg.left + 10;
		var top = reportInfo.isCalendar ? reg.top - 40 : reg.top + 10;
		
		var yOffset = YD.getDocumentScrollTop();
		var element = util.getE('zoom_info:panel');
		element.style.left = left + 'px';
		element.style.top = (yOffset + top) + 'px';
	}
}
