var optionInfo = function() {
	
	var YE = YAHOO.util.Event;
	var YD = YAHOO.util.Dom;
	
	var GD = {
		isOpen: false,
		activeElementId: '',
		items: {} // saved/already loaded optionInfo items
	};
	
	function init() {
		
		// The elementId of an option info icon has the format "option info path" followed by ":option_info",
		// i.e. "profile.database.fields.suppress_top:option_info"
		
		// Add event listener to all images where elementId ends with ":option_info"
		
		var images = document.getElementsByTagName('img');
		var pattern = /:option_info/;
		
		YE.addListener('close_option_info_btn', 'click', optionInfo.close);
		
		for (var i = 0, max = images.length; i < max; i++) {
			
			var img = images[i];
			var elementId = img.id;
			
			if (pattern.test(elementId)) {
				
				// Make sure we have unique element ID's by adding the index
				// due possible duplicate option info items.
				var newElementId = elementId + ':' + i;
				img.id = newElementId;
			
				YE.addListener(img, 'click', optionInfo.display);
			}
		}
		
		//
		// handle external help in option_info display
		//
		
		YE.addListener('option_info_body_section', 'click', optionInfo.displayExternalHelp);
		
		//
		// Handle dragdrop
		//
		var dd = new YAHOO.util.DD("option_info_section");
		dd.setHandleElId('option_info_section:header');
	}

    function addCustomItems(theItems) {

        // This initializes additional info icons which have been dynamically generated
        // after init(). Element Id's of the icons and the info text are already known and
        // given in theItems. The text may not be an option_info at all, it can be from any
        // other source such as a snapon comment or whatever.

        // Note, delegating the event doesn't work, so we need to attach an event listener
        // per icon. Use removeCustomItems() to remove the event listeners before the containerElement
        // becomes cleaned up.

        var savedItems = GD.items;

        for (var i = 0, max = theItems.length; i < max; i++) {

            var item = theItems[i];

            // Add item to GD.items
            savedItems[item.id] = item.text;

            // Add event listener
            YE.addListener(item.id, 'click', optionInfo.display);
        }
    }

    function removeCustomItemsEventListener(containerElement) {

        // This removes any attached custom event listeners from the info icons which
        // are children of the containerElement.
        var images = containerElement.getElementsByTagName('img');
        for (var i = 0, max = images.length; i < max; i++) {
            YE.removeListener(images[i], 'click', optionInfo.display);
        }
    }
	
	function open(infoIconElement) { // opens optionInfo window
		
		// alert('optionInfo.open()');
		// set OptionInfo window position and size
		
		var infoIconReg = YD.getRegion(infoIconElement);
		
		// util.showObject(infoIconReg);
		
		var someSpace = 10;
		var left = 0
		var top = 0;
		var width = 272;
		var minHeight = 245;
		var maxHeight = 400;
		var viewportWidth = YD.getViewportWidth();
		var viewportHeight = YD.getViewportHeight();
		
		// Get left optionInfo position
		var rightSpace = viewportWidth - (infoIconReg.right + someSpace);
		var leftSpace = viewportWidth - infoIconReg.left - someSpace;
		
		if (rightSpace >= width || rightSpace > leftSpace) {
			
			//Display optionInfo on right of info icon
			left = infoIconReg.right + someSpace;
		}
		else {
			
			// Display optionInfo on left of info icon
			left = infoIconReg.left - width - someSpace;
			
			// Make sure left is greater than 0
			if (left < 0) {left = 0;}
		}
		
		
		// Get height of optionInfo
		var height = parseInt((viewportHeight / 3) * 2);
		
		if (height > maxHeight) {
			// limit height to maxHeight
			height = maxHeight
		}
		else if (height < minHeight) {
			// set height to minHeight
			height = minHeight;
		}
		
		// Get top optionInfo position
		top = infoIconReg.top - parseInt(height / 3);
		
		if (top + height + 40 > viewportHeight) {
			top = viewportHeight - height - 40;
		}
	
		// Make sure top is greater than 40
		if (top < 40) {top = 40;}
		
		var option_info_section = util.getE('option_info_section');
		var option_info_body_section = util.getE('option_info_body_section');
		option_info_section.style.top = top + 'px';
		option_info_section.style.left = left + 'px';
		option_info_section.style.width = width + 'px';
		option_info_body_section.style.height = height + 'px';
		util.showE('option_info_section');
		
		GD.isOpen = true;
	}
	
	function display(evt) {

        var element = evt.target || evt.srcElement;
        var elementId = element.id;
        var dat = '';

		if (GD.isOpen && elementId == GD.activeElementId) {
			// We close the already open option info window
			close();
		}
		else {
		
			if (GD.isOpen) {
				
				// mark item as inactive
				toggleImage(GD.activeElementId, false);
			}
			else {
				// open optionInfo window
				open(element);
			}
			
			// mark icon as active
			toggleImage(elementId, true);
			
			GD.activeElementId = elementId;

            // Get optionInfoPathId and optionInfoPath
            var optionInfoPath = '';
            var optionInfoPathId = '';

            if (elementId.indexOf(':option_info') != -1) {

                dat = elementId.split(':');
                optionInfoPath = dat[0];
                optionInfoPathId = '_' + optionInfoPath.replace(/\./g, '_');
            }
            else {
                // This is a custom item which has no option_info path
                optionInfoPathId = elementId;
            }

			if (GD.items.hasOwnProperty(optionInfoPathId)) {

                // Already loaded, display optionInfo
				setOptionInfoDisplayTo(GD.items[optionInfoPathId]);
			}
			else {

				// Load optionInfo from server

				// Reset current display
				setOptionInfoDisplayTo(' ... ');

				var url = '?dp=util.option_info.get_option_info';
				dat = 'v.fp.option_info_path=' + optionInfoPath;
				dat += '&v.fp.option_info_path_id=' + optionInfoPathId;

				util.serverPost(url, dat);
			}
		}
	}
	
	function displayResponse(dat) { // server response
		
		// alert(dat);
		
		var optionInfoPathId = dat.optionInfoPathId;
		var optionInfoText = dat.optionInfoText;
		
		// Save optionInfoText in GD.items for later use
		GD.items[optionInfoPathId] = optionInfoText;
		
		// Display optionInfoText
		setOptionInfoDisplayTo(optionInfoText);
	}
	
	function setOptionInfoDisplayTo(optionInfoText) {
		
		var optionInfoBodySection = util.getE('option_info_body_section');
		optionInfoBodySection.innerHTML = optionInfoText;
	}
	
	function displayExternalHelp(evt) {
		
		// User clicked in option info window.
		// If this is an anchor then open an external help window, else ignore the event.
		
		YE.preventDefault(evt);
		
		var element = evt.target || evt.srcElement;
		var tagName = element.nodeName;
		
		if (tagName == 'A') {
			
			var url = element.href;
				
			var width = YD.getViewportWidth() - 40;
			var height = YD.getViewportHeight() - 40;
			var features = 'width=' + width + ',height=' + height + ',menubar=yes,toolbar=yes,status=yes,scrollbars=yes,resizable=yes';
			
			var theWindow = window.open(url, 'help', features);
			theWindow.focus();
		}
	}
	
	function close() {

        if (GD.isOpen) {

            util.hideE('option_info_section');

            // unmark active option icon
            toggleImage(GD.activeElementId, false);

            GD.isOpen = false;
        }
	}
	
	function toggleImage(elementId, isActive) {
		
		var isIE6 = util.userAgent.isIE6;
		var img = util.getE(elementId);
		var imgSrc = isActive ? imgDb.optionInfoActive.src : imgDb.optionInfo.src;
		
		if (!isIE6) {
			img.src = imgSrc;
		}
		else {
			// IE6 only
			img.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + imgSrc + "', sizingMethod='scale')";
		}
	}

	//
	//
	// Return global properties and methods
	//
	//
	
	return {
		init: init,
        addCustomItems: addCustomItems,
        removeCustomItemsEventListener: removeCustomItemsEventListener,
		close: close,
        display: display,
		displayResponse: displayResponse,
		displayExternalHelp: displayExternalHelp
	}
}();
