// util_7.js

// KHP-RC, clean up depending js files from old version 7 functions so that we can remove util_7.js

var ua_ie, ua_ie6_min, os_win; // user system

var _form_window; // reference to open form window
var _form_window_closed_poll; // polls the form winodw if it has been closed

var _file_manager_window; // reference to open file manager window 
var _log_source_matching_files_window; // reference to open log source matching file window 

var _debug_window; // reference to open debug window 

var _temp_disabled_links; // array of temporary disabled links which are below the transparent cover
var _temp_disabled_form_elements; // array of temporary disabled input elements which are below the transparent cover

window.onunload = init_unload;

function init_unload() {
	
      // close any open form window
      if (_form_window != null) {
            _form_window.close();
      }
}

function user_system() {
	
	os_win = (navigator.userAgent.indexOf('Win') != -1) ? true : false;
	ua_ie = (navigator.appName == 'Microsoft Internet Explorer') && !(navigator.userAgent.indexOf('Opera') != -1) ? true : false;	
	ua_ie6_min = (ua_ie && (ie_ver_num() >= 6)) ? true : false; // MSIE 6+
	// alert('os_win: ' + os_win + '\n ua_ie: ' + ua_ie + '\n ua_ie6_min: ' + ua_ie6_min);
}

function ie_ver_num() { // internet explorer version number
	
	var ua = navigator.userAgent;
	var msie_offset = ua.indexOf('MSIE ');
	if (msie_offset == -1) {
		return 0;
	}
	else {
		return parseFloat(ua.substring(msie_offset + 5, ua.indexOf(';', msie_offset)));
	}
}

function get_user_agent() {
	
	// returns the user agent brand
	
	var user_agent_string = navigator.userAgent.toLowerCase();
	var user_agent_app_name = navigator.appName.toLowerCase();
	var user_agent;
	
	if (user_agent_string.indexOf('safari') != -1) {
		user_agent = 'safari';
	}
	else if (user_agent_string.indexOf('opera') != -1) {
		user_agent = 'opera';
	}
	else if (user_agent_app_name == 'netscape') {
		user_agent = 'netscape';
	}
	else if (user_agent_app_name == 'microsoft internet explorer') {
		user_agent = 'msie';
	}
	else {
		user_agent = 'unknown';
	}
	
	return user_agent;
}

function document_width() { // available document/window width
	
	if (ua_ie6_min) {
		return document.body.parentElement.clientWidth;
	}
	else if (window.innerWidth) {
		return window.innerWidth;
	}
	else if (document.body && document.body.clientWidth) {
		return document.body.clientWidth;
	}
	return 0;
}

function scroll_top() { // scroll top position
	
	if (window.innerHeight) {
		return window.pageYOffset;
	}
	else if (document.documentElement && document.documentElement.scrollTop) {
		return document.documentElement.scrollTop;
	}
	else if (document.body) {
		return document.body.scrollTop;
	}
	else {
		return 0;
	}
}


// -------------
// get user name
// -------------

function get_user_name() {

	var user_name;
	var cookie_string = document.cookie;
	var cookie_dat = cookie_string.split(';');

	for (var i = 0; i < cookie_dat.length; i++) {

		var match_user = cookie_dat[i].match(/authuser/);

		if (match_user != null) {
			var user_dat = cookie_dat[i].split('=');
			user_name = user_dat[1];
			return user_name;
		}
	}
}

// -----------------------------
// form window
// -----------------------------
function open_form_window(url, window_name, width, height) {
	
	disable_opener_window();
	var content = document.getElementById('content');
	content.onclick = set_focus_on_form_window;
	
	var left = parseInt((screen.availWidth/2) - (width/2));
    var top = parseInt((screen.availHeight/2) - (height/2));
	_form_window = window.open(url,window_name,'width=' + width + ',height=' + height + ',left=' + left + ',top=' + top + ',status=yes,scrollbars=yes,resizable=yes');
    _form_window.focus();
	
	_form_window_closed_poll = setInterval('check_if_form_window_closed()', 200);
}

function check_if_form_window_closed() {

	if (_form_window.closed) {
		clearInterval(_form_window_closed_poll);
		content.onclick = null;
		restore_opener_window();	
	}
}

function set_focus_on_form_window() {
	_form_window.focus();
}

function disable_opener_window() {
	_temp_disabled_links = new Array();
	_temp_disabled_form_elements = new Array();

	//disable all input form elements
	var input_elements = document.getElementsByTagName('input')
	for (var i = 0; i < input_elements.length; i++) {		
		var id_value = input_elements[i].id;
		if (id_value == '') {
			id_value = 'input_num' + [i];
			input_elements[i].id = id_value;
		}
		var disabled_value = input_elements[i].disabled;
		_temp_disabled_form_elements[i] = {id:id_value, disabled: disabled_value};

		input_elements[i].disabled = 'true';
	}

	//disbale all links which are covered by the transparent cover
	var links_to_disable = document.getElementById('content')
	var links = links_to_disable.getElementsByTagName('a');

	for (var i = 0; i < links.length; i++) {
		var id_value = links[i].id;
		if (id_value == '') {
			id_value = 'link_num' + [i];
			links[i].id = id_value;
		}
		
		var onclick_value = links[i].onclick;

		_temp_disabled_links[i] = {id:id_value, onclick:onclick_value};
	
		links[i].onclick = simulate_disabled_link;
	}
}

function simulate_disabled_link() {
	// function is invoded from a page with disabled links
	return false;
}

function restore_opener_window() {

	// restore disabled form elements
	for (var i = 0; i < _temp_disabled_form_elements.length; i++) {
		var id_value = _temp_disabled_form_elements[i].id;
		var disabled_value = _temp_disabled_form_elements[i].disabled;
		
		var element = document.getElementById(id_value);
		element.disabled = disabled_value;
	}
	_temp_disabled_form_elements.length = 0;

	// restore disabled links
	for (var i = 0; i < _temp_disabled_links.length; i++) {
		var id_value = _temp_disabled_links[i].id;
		var onclick_value = _temp_disabled_links[i].onclick;

		var element = document.getElementById(id_value);
		element.onclick = onclick_value;

		// links[i].onclick = _temp_disabled_links[i];
	}
	_temp_disabled_links.length = 0;
}

// ===============
// form processing
// ===============
function strip_whitespace(value) { // strips leading and trailing whitespace
	value = value.replace(/^\s+/, '');
	value = value.replace(/\s+$/, '');
	return value;	
}

function value_is_not_empty(value) { // checks if a field value is empty or not
	var match_char = value.match(/.+/);
	if (match_char != null) {
		return true;
	}
	return false;
}

function value_is_not_empty_msg(value, msg) { // checks if a field value is empty or not and also shows the corresponding alert message
	var match_char = value.match(/.+/);
	if (match_char != null) {
		return true;
	}
	alert(msg);
	return false;	
}

function value_has_no_leading_or_trailing_space_msg(value, msg) { // checks if a field value starts or ends with a space
	
	if (value.charAt(0) != ' ' && value.charAt(value.length - 1) != ' ') {
		return true;
	}
	alert(msg);
	return false;
}

function value_is_integer_min_msg(value, min, msg) {
	// validates for integer greater or equal min value
	var match_int = value.match(/^[-]?\d+$/); // matches a positiv and negative integer
	if ((match_int != null) && (parseInt(value) >= min)) {
		return true;
	}
	alert(msg);
	return false;
}

function value_is_integer_min_max_msg(value, min, max, msg) {
	// validates if integer is between min max value

	var match_int = value.match(/^[-]?\d+$/); // matches a positiv and negative integer
	if ((match_int != null) && (parseInt(value) >= min) && (parseInt(value) <= max)) {
		return true;
	}
	alert(msg);
	return false;
}

function value_is_integer(value) { // matches a positiv and negative integer
	var match_int = value.match(/^[-]?\d+$/);
	if (match_int != null) {
		return true;
	}
	return false;
}

function value_is_number(value) { // matches any positiv and negative number (float, integer)
	var match_int = value.match(/^[-]?\d*\.?\d*$/);
	if (match_int != null) {
		return true;
	}
	return false;
}

function validate_mysql_database_name_msg(mysql_database_name, msg) {
	// for mysql database names allow alphanumeric characters and underscore only
	var match_invalid_character = mysql_database_name.match(/[^a-zA-Z0-9_]/);
	if (!match_invalid_character) {
		return true;
	}
	alert(msg);
	return false;
}


// -----------------------------
// png image handling
// -----------------------------

function fix_png_images(_blank_image_reference) {

	if (ua_ie && os_win) {
		
		for (i = 0; i < document.images.length; i++) {
			if (document.images[i].src.match(/\.png$/i) != null) {
				var img = document.images[i];
				var src = img.src;
				var width = img.width;
				var height = img.height;
				
				// alert('height: ' + height + '\nwidth: ' + width);
				
				/*

				// then fetch the correct image size from the img_ref object
				// required for IE if style.display is set to 'none'

				if (width <= 0) { 
					var img_split = src.split('/');
					var img_name_with_ext = img_split[img_split.length - 1];
					var img_name = img_name_with_ext.match(/\w+(?=\.png)/i);
					var width = img_ref[img_name].width;
					var height = img_ref[img_name].height;
				}
				*/
				
				// alert(document.images[i].id + '\n' + width + ', ' + height);
				// img.src = 'picts/blank.gif';
				img.src = _blank_image_reference;
				img.style.width = width + 'px';
				img.style.height = height + 'px';
				img.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(src='" + src + "', sizingMethod='scale')";
				img.style.visibility = 'visible';
			}
		}
	}
	else {
		// make png images visible
		for (i = 0; i < document.images.length; i++) {
			if (document.images[i].src.match(/\.png$/i) != null) {
				var img = document.images[i];
				img.style.visibility = 'visible';
			}
		}
	}
}
