//
// log source
//
var theList;
var itemsDb = [];  // items work array
var itemsDbBackup = []; // items array in the state when first loaded or last saved, it is used upon Undo Changes
var validator = new util.Validator();
var logSource = {
	saveChangesBtn: null,
	newItemBtn: null,
	deleteBtn: null,
	duplicateBtn: null,
	undoAllChangesBtn: null,
	isEditPermission: false
}
function init() {
	var YE = YAHOO.util.Event;
	var permissions = pageInfo.permissions;
	var isEdit = permissions.isEdit;
	var isAdd = permissions.isAdd;
	var isDelete = permissions.isDelete;
	// init toolbar buttons
	logSource.saveChangesBtn = new util.ToolbarButton('save_changes', saveChanges, toolbarButtonsDb);		
	logSource.newItemBtn = new util.ToolbarButton('new_log_source', newItem, toolbarButtonsDb);
	logSource.duplicateBtn = new util.ToolbarButton('duplicate', duplicateItem, toolbarButtonsDb);
	logSource.deleteBtn = new util.ToolbarButton('delete', deleteItem, toolbarButtonsDb);
	logSource.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
	var permissions = pageInfo.permissions;
	if (permissions.isEdit) {
		if (!permissions.isAdd) {
			logSource.newItemBtn.disableAndIgnore();
			logSource.duplicateBtn.disableAndIgnore();
		}
		if (!permissions.isDelete) {
			logSource.deleteBtn.disableAndIgnore();
		}
		// Register isModifiedPageHandler in adminConfig.js
		// (We don't check for modifications if there is no edit 
		// permission because there is no Save button anyway!)
		adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
	}
	else {
		logSource.saveChangesBtn.disableAndIgnore();
		logSource.newItemBtn.disableAndIgnore();
		logSource.duplicateBtn.disableAndIgnore();
		logSource.deleteBtn.disableAndIgnore();
		logSource.undoAllChangesBtn.disableAndIgnore();
	}
	//
	// Create theList object
	//
	theList = new listcontroller.List({
		containerElementId: 'item_list_body',
		itemEvent: itemActivated,
		isSwitch1: true,
		isMoveControl: true
	});
	//
	// misc
	//
	YE.addListener('log_source:label', 'blur', updateFormLabel);
	YE.addListener('log_source:show_matching_files_btn', 'click', showMatchingFiles);
	// Init and log_source
	var isConfig = true;
	var isLite = (pageInfo.licensingTier == 'lite');
	logSourceUtil.init(isLite, isConfig);
	// init OptionInfo
	optionInfo.init();
}
function initItemList() {
	theList.init(itemsDb);
	// select the first item
	var firstItemId = theList.getFirstItemId();
	setItem(firstItemId);
}
function getLogSourceData() {
	if (!pageInfo.exitActive) {
		var url = '?dp=config_pages.log_source.get_data';
		url += '&p=' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		util.helpWindow.init('');
		util.serverPost(url, dat);
	}
}
function getLogSourceDataResponse(dat) {
	if (!pageInfo.exitActive) {
		itemsDb = dat;
		itemsDbBackup = util.cloneObject(dat);
		// util.showObject(dat);
		init();
		initItemList();
		// Set final toolbar state
		logSource.saveChangesBtn.enable();
		logSource.undoAllChangesBtn.enable();
		logSource.newItemBtn.enable();
		logSource.duplicateBtn.enable();
		util.showE('form_section');
		// IE 7 the form_section to be displayed for setItemListSize()
		adminConfig.setItemListSize();
		YAHOO.util.Event.addListener(window, 'resize', adminConfig.setItemListSize);
		pageInfo.initComplete = true;
	}
}
function itemActivated(itemId) {
	if (validateActiveItem()) {
		setItem(itemId);
	}
}
function setItem(itemId) {
	matchingFiles.closePanel();
	// Select active item in list and displays the form	
	theList.selectItem(itemId);
	updateForm(itemId);
	// Set delete button
	var makeEnabled = (theList.getNumberOfItems() > 1);
	logSource.deleteBtn.enable(makeEnabled);
}
function newItem() {
	if (validateActiveItem()) {
		var newItemId = theList.getNewItemId();
		var label = langVar('lang_admin.general.new_log_source');
		var newLogSource = {
			id: newItemId,
			type: '',
			switch1: true,
			label: label,
			dat: {
				label: label,
				type: 'local',
				pathname: '',
				file_mask: '',
				pattern_is_regular_expression: false,
				process_subdirectories: false
			}
		}
		theList.newItem(newLogSource);
		setItem(newItemId);
	}
}
function duplicateItem() {
	if (validateActiveItem()) {
		var clonedItemId = theList.cloneItem();
		setItem(clonedItemId);
	}
}
function deleteItem() {
	var nextItemIdToBeSelected = theList.deleteItem();
	validator.reset();
	setItem(nextItemIdToBeSelected);
}
function updateForm(itemId) {
	util.resetF('log_source_form');
	var item = theList.getSelectedItem();
	var itemDat = item.dat;
	logSourceUtil.updateForm(itemDat);
	// Set display
	logSourceUtil.setLogSourceDisplay();
}
function updateFormLabel() {
	var item = theList.getSelectedItem();
	var itemLabel = item.dat.label;
	var formFieldLabel = util.getF('log_source:label');
	if (itemLabel != formFieldLabel) {
		// update item list label and form label
		// util.updateT('item_form_label', formFieldLabel);
		theList.updateListLabel(formFieldLabel);
	}
}
function validateActiveItem() {
	// Don't validate if there is no edit permission
	if (pageInfo.permissions.isEdit) {
		validator.reset();
		var obj = logSourceUtil.getValidatedLogSourceObject(validator);
		if (validator.allValid()) {
			theList.saveItem(obj);
			return true;
		}
		return false;
	}
	// No edit permission, don't validate at all
	return true;
}
function saveChanges() {
	if (validateActiveItem()) {
		var isModified = theList.getIsModified();
		// alert('saveChanges() - isModified: ' + isModified);
		if (isModified) {
			var atLeastOneLogSourceActive = false;
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			dat += 'v.fp.profiles_list_checksum=' + profilesStorage.get('profilesListChecksum') + '&';
			for (var i = 0; i < itemsDb.length; i++) {
				var item = itemsDb[i];
				var itemDat = item.dat;
				var prop;
				var path = 'v.fp.source.' + i + '.';
				dat += path + 'position=' + i + '&';
				dat += path + 'disabled=' + !item.switch1 + '&';
				if (itemDat.type != 'odbc') {
					for (prop in itemDat) {
						dat += path + prop + '=' + encodeURIComponent(itemDat[prop]) + '&';
					}
				}
				else {
					// odbc log source
					dat += path + 'label=' + encodeURIComponent(itemDat.label) + '&';
					dat += path + 'type=odbc&';
					dat += path + 'query=' + encodeURIComponent(itemDat.query) + '&';
					var serverDat = itemDat.server;
					for (prop in serverDat) {
						dat += path + 'server.' + prop + '=' + encodeURIComponent(serverDat[prop]) + '&';
					}
				}
				if (item.switch1) {atLeastOneLogSourceActive = true;}
			}
			dat = dat.replace(/&$/, '');
			if (atLeastOneLogSourceActive) {
				util.hideE('form_section');
				util.showE('saving_info');
				var url = '?dp=config_pages.log_source.save_data';
				url += '&p=' + pageInfo.profileName;
				pageInfo.saveActive = true;
				util.serverPost(url, dat);
			}
			else {
				alert(langVar('lang_admin.log_source.no_log_source_active'));
			}
		}
		else {
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	}
}
function saveChangesResponse(dat) {
	// reset isModified
	theList.resetIsModified();
	// the saved work itemsDb becomes now the itemsDbBackup
	itemsDbBackup = util.cloneObject(itemsDb);
	pageInfo.saveActive = false;
	// Update profilesListChecksum checksum
	profilesStorage.update(dat.profileChanges);
	util.hideE('saving_info');
	util.showE('form_section');
}
function undoAllChanges() {
	itemsDb = util.cloneObject(itemsDbBackup);
	initItemList();
	validator.reset();
}
function getIsModifiedPage() {
	if (!validateActiveItem() || theList.getIsModified()) {
		return true;
	}
	return false;
}
/*
	Show matching files
*/
function showMatchingFiles() {
	if (validateActiveItem()) {
//		pageToken = pageInfo.pageToken;
//        profileName = pageInfo.profileName;
			// TODO - Re-STYLE
//			e.style.top = '310px';
//			e.style.left = '210px';
//			e.style.width = '600px';
		var pageToken = pageInfo.pageToken;
		var profileName = pageInfo.profileName;
		var panelTop = 310;
		var panelLeft = 310;
		matchingFiles.openPanel(
			pageToken,
			profileName,
			panelTop,
			panelLeft);
		var item = theList.getSelectedItem();
		var itemDat = item.dat;
		var itemValue;
		var url = '?dp=config_pages.log_source.get_matching_files';
		url += '&p=' + profileName;
		var dat = 'v.fp.page_token=' + pageToken + '&';
		var path = 'v.fp.log_source.0.';
		var pattern = /\W/; // The pattern /\W/ is equal [^a-zA-Z0-9_]
		// dat += path + 'type=' + item.type + '&';
		for (var prop in itemDat) {
			itemValue = itemDat[prop];
			if (pattern.test(itemValue)) {
				itemValue = encodeURIComponent(itemValue);
			}
			dat += path + prop + '=' + itemValue + '&';
		}
		dat = dat.replace(/&$/, '');
		util.serverPost(url, dat);
	}
}
function showMatchingFilesResponse(dat) {
	matchingFiles.showFiles(dat);
}
//
// matchingFiles
//
// This is the matchingFiles namespace
var matchingFiles = function() {
	var YE = YAHOO.util.Event,
		panel = null,
        initDone = false,
//      isNewProfileWizard = false,
        pageToken = '',
        profileName = '',
        cachedMatchingFilesNodeName = '',
        numberOfBuiltFiles = 0,
        numberOfMatchedFiles = 0,
        filesContainer = null,
        scrollControl = null,
        scrollResetAnim = null;
	function initPanel(panelTop, panelLeft) {
		var panelObj = {
			panelId: 'matching_files:panel',
			panelClassName: 'panel-30',
			panelHeaderLabel: langVar('lang_admin.log_source_matching_files.matching_files'),
			top: panelTop,
			left: panelLeft,
			zIndex: 40,
			isCover: false,
			closeEvent: matchingFiles.closePanel
		};
		panel = new util.Panel3(panelObj);
	}
	function init(_pageToken, _profileName) {
		// Note, init() may be called from pages with an integrated matching files list
		// such as in Process Logs.
		pageToken = _pageToken;
		profileName = _profileName;
        var attributes = {
			scroll: {to:[0, 0]}
		};
        filesContainer = util.getE('matching_files:files');
        // Init the scrollControl
        scrollControl = new scrollUtil.Scroller('matching_files:box', 'matching_files:label_and_files', scrollingList);
        // Init scroll animation to reset scroll position to 0
        scrollResetAnim = new YAHOO.util.Scroll('matching_files:box', attributes, 0.1);
		initDone = true;
	}
	function openPanel(_pageToken, _profileName, panelTop, panelLeft) {
		if (!initDone) {
			initPanel(panelTop, panelLeft);
			init(_pageToken, _profileName);
		}
		util.hideE('matching_files:label_and_files');
		util.showE('matching_files:loading');
//		util.showE('matching_files_section');
		util.removeChildElements(filesContainer);
		panel.open();
	}
//	function openPanelFromNewProfileWizard() {
//
//		isNewProfileWizard = true;
//		openPanel();
//	}
	function closePanel() {
		// Note, closePanel may be called from log source or new profile wizard
		if (initDone) {
			panel.close();
		}
	}
	function showFiles(dat) {
        // showFiles is called upon initial load
        // from New Profile Wizard or Log Source
        var files = dat.files,
            numberOfUnloadedFiles = 0,
            indexFrom = 0,
            indexTo = 0;
        // util.showObject(dat);
        cachedMatchingFilesNodeName = dat.cachedMatchingFilesNodeName;
        numberOfBuiltFiles = 0;
        numberOfMatchedFiles = dat.numberOfMatchedFiles;
		// Update the label
        util.updateT('matching_files:label', dat.label);
        // Create files
        addFiles(files, 0);
        // Automatically load more files, if any
//        console.log('showFiles - numberOfMatchedFiles: ' + numberOfMatchedFiles);
//        console.log('showFiles - numberOfBuiltFiles: ' + numberOfBuiltFiles);
        numberOfUnloadedFiles = numberOfMatchedFiles - numberOfBuiltFiles;
//        console.log('showFiles - numberOfUnloadedFiles: ' + numberOfUnloadedFiles);
        if (numberOfUnloadedFiles > 0) {
//            console.log('showFiles - LOAD ADDITIONAL FILES UPON INITIAL LOAD - NO SCROLL EVENT YET! ');
            // Start loading additional files after the first load regardless
            // of scrolling state. Load about the same number of files as already
            // loaded.
            indexFrom = numberOfBuiltFiles;
            if (numberOfUnloadedFiles < (numberOfBuiltFiles + (numberOfBuiltFiles / 2))) {
                // There are less than 1.5x of the already loaded files to load.
                // Load of them all
                indexTo = numberOfMatchedFiles - 1;
            }
            else {
                // Load just the same number of files as already loaded
                indexTo = (numberOfBuiltFiles * 2) - 1;
            }
            getCachedMatchingFiles(indexFrom, indexTo);
        }
		util.hideE('matching_files:loading');
        util.showE('matching_files:label_and_files');
         // Scroll to top
        scrollResetAnim.animate();
	}
    function addFiles(files, indexFrom) {
        // Adds a new div with the given files to the container element.
        // files only contains the loaded files from initial load or when loaded from cache.
        // Note, indexFrom is not really required, it just indicates
        // the start index from where we got the cached files, it is most useful
        // for debugging.
        // Adds files to the container Element
        var numberOfFiles = files.length,
            ul = util.createE('ul', {className: 'matching-files'}),
			li = null,
            fileNameLabel = '',
            fileNameText = null,
            i = 0,
            numberOfLoadedFiles = files.length;
        // Create files
        for (i = 0; i < numberOfFiles; i++) {
            fileNameLabel = files[i];
            // Debug only, this shows the actual file number
            // fileNameLabel = (indexFrom + i) + '. -- ' + fileNameLabel;
            fileNameText = document.createTextNode(fileNameLabel);
            li = util.createE('li');
            util.chainE(ul, li, fileNameText);
        }
        numberOfBuiltFiles = numberOfBuiltFiles + numberOfFiles;
        util.chainE(filesContainer, ul);
    }
    function getCachedMatchingFiles(indexFrom, indexTo) {
//        console.log('getCachedMatchingFiles - indexFrom: ' + indexFrom);
//        console.log('getCachedMatchingFiles - indexTo: ' + indexTo);
        var url = '?dp=util.matching_files.get_cached_matching_files',
            dat = '';
        // Show loading
        util.showE('matching_files:loading');
        dat = 'v.fp.page_token=' + pageToken;
        dat += '&v.fp.profile_name=' + profileName;
        dat += '&v.fp.cached_matching_files_node_name=' + cachedMatchingFilesNodeName;
        dat += '&v.fp.index_from=' + indexFrom;
        dat += '&v.fp.index_to=' + indexTo;
        util.serverPost(url, dat);
    }
    function getCachedMatchingFilesResponse(dat) {
        var indexFrom = dat.indexFrom,
            files = dat.files,
            scrollInfo = {},
            keepLoadingInfoActive = false,
            isValidCachedMatchingFilesNodeName = (dat.cachedMatchingFilesNodeName == cachedMatchingFilesNodeName),
            isValidIndexFrom = (dat.indexFrom == numberOfBuiltFiles),
            errorMsg = '';
        // util.showObject(dat);
        if (isValidCachedMatchingFilesNodeName && isValidIndexFrom) {
            // Add the files
            addFiles(files, indexFrom);
            // Activate the scrollControl if there are more files to load
            if (numberOfBuiltFiles < numberOfMatchedFiles) {
                scrollInfo = scrollControl.getScrollInfo();
                if (scrollInfo.isScrollingDown &&
                    scrollInfo.verticalScrollLevel > 80) {
                    // Load more files right away, simply call scrollingList
                    scrollingList(scrollInfo.verticalScrollLevel);
                    keepLoadingInfoActive = true;
                }
                else {
                    // Wait for scroll event to load more files
                    scrollControl.activate();
                }
            }
            else {
                // No more files to load
                scrollControl.deactivate();
            }
        }
        else {
            // An error occurred although this shouldn't be possible,
            errorMsg = 'Error in matchingFiles.getCachedMatchingFilesResponse().\n';
            errorMsg += 'is valid cachedMatchingFilesNodeName: ' + isValidCachedMatchingFilesNodeName + '\n';
            errorMsg += 'isValidIndexFrom: ' + isValidIndexFrom + '\n';
            alert(errorMsg);
        }
        // Hide loading info
        if (!keepLoadingInfoActive) {
            util.hideE('matching_files:loading');
        }
    }
    function scrollingList(verticalScrollLevel) {
//        console.log('scrollingList - VerticalScrollLevel: ' + verticalScrollLevel);
        // Scrolling down.
        // Get maxFiles depending on numberOfMatchedFiles and
        // verticalScrollLevel.
        var indexFrom = numberOfBuiltFiles,
            indexTo = 0,
            maxFiles = parseInt((numberOfMatchedFiles / 1000) * verticalScrollLevel);
//        console.log('scrollingList() - get files from server maxFiles: ' + maxFiles);
        if (maxFiles <= 0) {
            maxFiles = 10;
        }
        else if (maxFiles > 400) {
            maxFiles = 400;
        }
        indexTo = indexFrom + maxFiles;
        // Don't get more files than numberOfMatchedFiles
        if ((indexTo + 1) > numberOfMatchedFiles) {
            indexTo = numberOfMatchedFiles - 1;
        }
//        console.log('scrollingList() - get files from server indexFrom: ' + indexFrom);
//        console.log('scrollingList() - get files from server indexTo: ' + indexTo);
        getCachedMatchingFiles(indexFrom, indexTo);
    }
	//
	//
	// Return global properties and methods
	//
	//
	return {
		init: init,
		openPanel: openPanel,
//		openPanelFromNewProfileWizard: openPanelFromNewProfileWizard,
		showFiles: showFiles,
		closePanel: closePanel,
        scrollingList: scrollingList,
        getCachedMatchingFilesResponse: getCachedMatchingFilesResponse
	}
}();
