//
// importDataUtil.js
//


var importDataUtil = {
	
	overrideDatabaseListBaseId: '',
	
	//
	//
	// Profiles list builder
	//
	//
	
	buildProfilesObjectList: function(profiles) {
		
		var container = util.getE('import_data:choose_objects:profiles:div');
		
		var table = util.createE('table', {cellSpacing:0, className:'import-data-list'});
		var tbody = util.createE('tbody');
		
		// Clear existing list
		util.removeChildElements(container);
		
		if (profiles.length > 0) {
			
			for (var i = 0; i < profiles.length; i++) {
				
				importDataUtil.buildProfilesObjectListRow(tbody, i, profiles[i]);
			}
			
			util.chainE(container, table, tbody);
		}
		else {
			
			// No profiles exist
			var tr = util.createE('tr');
			var td = util.createE('td');
			var text = langVar('lang_admin.import.no_profiles_exist');
			
			util.chainE(container, table, tbody, tr, td, text);
		}
	},
	
	buildProfilesObjectListRow: function(tbody, index, item) {
		
		var tr = util.createE('tr');
		var td1 = util.createE('td');
		var td2 = util.createE('td', {width: '30%'});
		var td3 = util.createE('td', {width: '70%'});
		
		var inputId = 'import_data_profile_object:' + index;
		var input = util.createE('input', {id:inputId, type:'checkbox'});
		
		var label = util.createE('label', {htmlFor:inputId});
		var labelText = util.createT(item.label);
		util.chainE(label, labelText);
		
		var td3Text = item.profileExistsInV8 ? 'Profile already exists!' : '&nbsp;';
		var td3Label = util.createT(td3Text);
		
		util.chainE(tbody, [tr, [td1, input], [td2, label], [td3, td3Label]]);
	},
	
	//
	//
	// Profiles databases list builder
	//
	//
	
	buildDatabasesObjectList: function(profiles) {
		
		var container = util.getE('import_data:choose_databases:div');
		
		var table = util.createE('table', {cellSpacing:0, className:'import-data-list'});
		var tbody = util.createE('tbody');
		
		// Clear existing list
		util.removeChildElements(container);
		
		for (var i = 0; i < profiles.length; i++) {
			
			var theProfile = profiles[i];
			
			if (theProfile.isImportProfile && theProfile.hasDatabase) {
				importDataUtil.buildDatabasesObjectListRow(tbody, i, theProfile);
			}
		}
		
		util.chainE(container, table, tbody);
	
	},
	
	buildDatabasesObjectListRow: function(tbody, index, item) {
	
		var tr = util.createE('tr');
		var td1 = util.createE('td', {width:'1%'});
		var td2 = util.createE('td');
		
		var inputId = 'import_data_profile_db_object:' + index;
		var input = util.createE('input', {id:inputId, type:'checkbox'});
		
		var label = util.createE('label', {htmlFor:inputId});
		var labelText = util.createT(item.label);
		
		util.chainE(label, labelText);
		util.chainE(tbody, [tr, [td1, input], [td2, label]]);
	},
	
	//
	//
	// Override database list builder
	//
	//
	
	buildOverrideDatabasesList: function(v7profilesDb) {
		
		// util.showObject(v7profilesDb);
		
		var container = util.getE('import_data:override_databases_list:div');
		
		// Get the unique baseId
		var baseId = importDataUtil.overrideDatabaseListBaseId;
		
		if (baseId == '') {
			// Issue new baseId
			baseId = util.getUniqueElementId();
			importDataUtil.overrideDatabaseListBaseId = baseId;
		}
		
		// Clear existing list
		util.removeChildElements(container);

		for (var i = 0; i < v7profilesDb.length; i++) {
			
			var theProfile = v7profilesDb[i];
			var isMysql = theProfile.isMysql;
			var isCustomDbDirectory = theProfile.isCustomDbDirectory;
			
			// Note, we check for isImportProfile because the warning is shown
			// regardless of an existing v7 database build.
			
			if (theProfile.isImportProfile && (isMysql || isCustomDbDirectory)) {
				
				// util.showObject(theProfile);
				
				// We use two tables per items because the details table may extend the available
				// width which may causes a hidden link for editing the database name or directory.
				
				var table = util.createE('table', {cellSpacing:0, className:'import-data-override-list'});
				var tbody = util.createE('tbody');
				
				var detailsTable = util.createE('table', {cellSpacing:0, className:'import-data-override-list-details'});
				var detailsTbody = util.createE('tbody');
				
				var errorTable = util.createE('table', {cellSpacing:0, className:'import-data-override-list-error'});
				var errorTbody = util.createE('tbody');
				
				importDataUtil.buildOverrideDatabasesListMainRow(tbody, baseId, i, theProfile);
				
				var databaseLabel = langVar('lang_admin.import.database_type');
				var databaseTypeLabel; 
				var v7RowLabel;
				var v7RowValue;
				var v8RowLabel;
				var v8RowValue;
				var v8RowValueElementId = baseId + ':v8_value:' + i;
				
				if (isMysql) {
					databaseTypeLabel = langVar('lang_admin.import.mysql');
					v7RowLabel = langVar('lang_admin.import.v7_name');
					v7RowValue = theProfile.mysqlDatabaseName;
					v8RowLabel = langVar('lang_admin.import.v8_name');
					v8RowValue = theProfile.newMysqlDatabaseName;
					errorMessage = '';
				}
				else {
					// isCustomDbDirectory
					databaseTypeLabel = langVar('lang_admin.import.internal');
					v7RowLabel = langVar('lang_admin.import.v7_directory');
					v7RowValue = theProfile.databaseDirectory;
					v8RowLabel = langVar('lang_admin.import.v8_directory');
					v8RowValue = theProfile.newCustomDatabaseDirectory;
				}
				
				importDataUtil.buildOverrideDatabasesListSubRow(detailsTbody, databaseLabel, databaseTypeLabel);
				importDataUtil.buildOverrideDatabasesListSubRow(detailsTbody, v7RowLabel, v7RowValue);
				importDataUtil.buildOverrideDatabasesListSubRow(detailsTbody, v8RowLabel, v8RowValue, v8RowValueElementId);
				importDataUtil.buildOverrideDatabasesListErrorMessageRow(errorTbody, baseId, i);
				
				util.chainE([container, [table, tbody], [detailsTable, detailsTbody], [errorTable, errorTbody]]);
				
				// Set actual error message, if any
				importDataUtil.updateOverrideDatabasesListItem(i);
			}
		}
	},
	
	buildOverrideDatabasesListMainRow: function(tbody, baseId, index, item) {
		
		var tr = util.createE('tr');
		var td1 = util.createE('td', {className:'image'});
		var td2 = util.createE('td', {className:'profile-label'});
		var td3 = util.createE('td', {className:'link'});
		
		var imgId = baseId + ':img:' + index;
		var img =  util.createE('img', {id:imgId, src:imgDb.overrideWarning.scr, width:24, height:24, alt:''});
		
		var profileText = util.createT(item.label);
		
		var anchorLabel = item.isMysql ? langVar('lang_admin.import.change_database_name') : langVar('lang_admin.import.change_database_directory');
		var anchorText = util.createT(anchorLabel);
		var anchorId = baseId + ':a:' + index;
		var anchor = util.createE('a', {id:anchorId, href:'javascript:;'});
		
		util.chainE(tbody, [tr, [td1, img], [td2, profileText], [td3, [anchor, anchorText]]]);
	},
	
	buildOverrideDatabasesListSubRow: function(tbody, rowLabel, rowValue, elementId) {
		
		// elementId is optional. It is only required for the v8 database name or directory as 
		// this value might become modified.
		
		var tr = util.createE('tr');
		var th = util.createE('th');
		var td = util.createE('td');
		
		if (elementId != null) {
			td.id = elementId;
		}
		
		var thText = util.createT(rowLabel + ': ');
		var tdText = util.createT(rowValue);
		
		util.chainE(tbody, [tr, [th, thText], [td, tdText]]);
	},
	
	buildOverrideDatabasesListErrorMessageRow: function(tbody, baseId, index, errorMessage) {
	
		var trElementId = baseId + ':error_row:' + index;
		var tr = util.createE('tr', {id:trElementId});
		var tdElementId = baseId + ':error_message:' + index;
		var td = util.createE('td', {id:tdElementId});
		
		var tdText = util.createT('-');
		
		util.chainE(tbody, [tr, [td, tdText]]);
	},
	
	updateOverrideDatabasesListItem: function(itemIndex) {
		
		// The function is invoked after building the item list and
		// after a database name or directory has been edited.
	
		// It updates the image and error message in the list item
		// depending of the database type and any duplicate database name
		// or database directory.
		
		var v7profilesDb = importData.v7profilesDb;
		var theProfile = v7profilesDb[itemIndex];
		
		var v8Value = '';
		var isErrorMessage = false;
		var errorMessage = '-';
		
		var isMysql = theProfile.isMysql;
		
		if (isMysql) {
			
			var v7MySqlDbName = theProfile.mysqlDatabaseName;
			v8Value = theProfile.newMysqlDatabaseName;
			
			if (v7MySqlDbName == v8Value) {
				isErrorMessage = true;
				errorMessage = 'Identical database names, version 8 will override the version 7 database';
			}
		}
		else {
			
			// Custom database directory
			var v7DatabasePathname = theProfile.databaseDirectory;
			v8Value = theProfile.newCustomDatabaseDirectory;
			
			if (v7DatabasePathname == v8Value) {
				isErrorMessage = true;
				errorMessage = 'Identical database directories, version 8 will override the version 7 database';
			}
		}
		
		// Set the image
		var baseId = importDataUtil.overrideDatabaseListBaseId;
		var img = util.getE(baseId + ':img:' + itemIndex);
		var imgSrc = isErrorMessage ? imgDb.overrideWarning.scr : imgDb.overrideOkay.scr;
		img.src = imgSrc;
		
		// Update v8 database name or directory value
		util.updateT(baseId + ':v8_value:' + itemIndex, v8Value);
		
		// Set error message
		util.updateT(baseId + ':error_message:' + itemIndex, errorMessage);
		util.showE(baseId + ':error_row:' + itemIndex, isErrorMessage);
	},
	
	//
	//
	// Final import page
	//
	//
	
	buildFinalImportList: function() {
		
		var container = util.getE('import_data:final:div');
		
		var table = util.createE('table', {cellSpacing:0, className:'import-data-list'});
		var tbody = util.createE('tbody');
	
		importData.itemsDat = [];
		var itemsDat = importData.itemsDat;
		var itemsDatIndex = 0; // Used for element Id's
	
		var i;
		var theProfile;
		var importLabel;
		
		// Clear existing list
		util.removeChildElements(container);
		
		if (importData.isImportProfiles) {
			
			var profiles = importData.v7profilesDb;
			var profilesLen = profiles.length;

			// Get the profiles and database
			// KHP 15/Apr/2013 - Changed separate profile and database imports to single item
			// which prevents imports to fail on server side.
			
			for (i = 0; i < profilesLen; i++) {
				
				theProfile = profiles[i];
				
				if (theProfile.isImportProfile) {
					
					itemsDatIndex = itemsDat.length;
					itemsDat[itemsDatIndex] = {type:'profile', reference:theProfile};

					importLabel = theProfile.isImportDatabase ? langVar('lang_admin.import.profile_and_database') : langVar('lang_admin.import.profile');
					
					importDataUtil.buildFinalImportListRow(tbody, itemsDatIndex, importLabel + ':', theProfile.label);
				}
			}
			
			//
			// Get the databases
			//

//			for (i = 0; i < profiles.length; i++) {
//
//				theProfile = profiles[i];
//
//				if (theProfile.isImportProfile && theProfile.isImportDatabase) {
//
//					itemsDatIndex = itemsDat.length;
//					itemsDat[itemsDatIndex] = {type:'database', reference:theProfile};
//
//					importDataUtil.buildFinalImportListRow(tbody, itemsDatIndex, langVar('lang_admin.import.database') + ':', theProfile.label);
//				}
//			}
		}
		
		if (importData.isImportSchedules) {
			
			itemsDatIndex = itemsDat.length;
			itemsDat[itemsDatIndex] = {type:'schedules'};
			importDataUtil.buildFinalImportListRow(tbody, itemsDatIndex, langVar('lang_admin.import.schedules') + ':', importData.v7numberOfSchedules);
		}
		
		if (importData.isImportUsers) {
			
			itemsDatIndex = itemsDat.length;
			itemsDat[itemsDatIndex] = {type:'users'};
			importDataUtil.buildFinalImportListRow(tbody, itemsDatIndex, langVar('lang_admin.import.users') + ':', importData.v7numberOfUsers);
		}
		
		util.chainE(container, table, tbody);
	},
	
	buildFinalImportListRow: function(tbody, itemsDatIndex, label1, label2) {
		
		var tr = util.createE('tr');
		var td1 = util.createE('td', {width:'10%'});
		var td2 = util.createE('td', {width:'10%'});
		
		// td3 is used to indicate importing state (Importing, Completed)
		var td3Id = 'import_data:final:state:' + itemsDatIndex;
		var td3 = util.createE('td', {id:td3Id, width:'80%', whiteSpace:'normal'});
		
		var text1 = util.createT(label1);
		var text2 = util.createT(label2);
		var text3 = util.createT('&nbsp;');
		
		util.chainE(tbody, [tr, [td1, text1], [td2, text2], [td3, text3]]);
	}
};
