/* global profiles: false */

var deleteProfile = (function() {

	'use strict';

	var YE = YAHOO.util.Event;
	var panel = null;
	var busyPanel = null;
	var profileName = '';

	var savedProfileChanges = {};

	function init() {

		var panelObj = {
			panelId: 'delete_profile:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.profiles.delete_profile'),
			// left: 100,
			// top: 50,
			zIndex: 30,
			isCover: true,
			closeEvent: cancelDeleteProfile
		};

		panel = new util.Panel3(panelObj);
		busyPanel = new util.BusyPanel();

		YE.addListener('delete_profile:no_btn', 'click', cancelDeleteProfile);
		YE.addListener('delete_profile:yes_btn', 'click', deleteProfile);
	}

	function confirmDelete(theProfileName) {

		// TODO - change the theProfileName to profileItem

//		alert('confirmDelete: ' + theProfileName);
		profileName = theProfileName;
		var profileItem = profiles.getProfileItem(profileName);
		var profileLabel = profileItem.label;
		var databaseType = profileItem.databaseType;
		var databaseName = profileItem.databaseName;
		var message = '';
		var messageContainer = util.getE('delete_profile:confirm_msg');
		var dropDatabaseLabel = '';
		var dropDatabaseLabelContainer;
		var showDropDatabaseSection = false;
		var defaultDropDatabaseValue = false;

		// util.showObject(profileItem);

		if (panel === null) {
			init();
		}

		if (databaseType === 'mysql' || databaseType === 'odbc_mssql') {

			showDropDatabaseSection = true;

			if (databaseType === 'mysql') {

				message = langVar('lang_admin.profiles.confirm_delete_mysql_message');
				dropDatabaseLabel = langVar('lang_admin.profiles.drop_mysql_database');
			}
			else {

				message = langVar('lang_admin.profiles.confirm_delete_mssql_message');
				dropDatabaseLabel = langVar('lang_admin.profiles.drop_mssql_database');
			}

			dropDatabaseLabelContainer = util.getE('delete_profile:drop_database_label');
			dropDatabaseLabel = dropDatabaseLabel.replace(/__PARAM__1/, '<strong>' + databaseName + '</strong>');
			dropDatabaseLabelContainer.innerHTML = dropDatabaseLabel;

			// Check drop database checkbox if profile name matches the database name
			defaultDropDatabaseValue = (profileName === databaseName);
			util.setF('delete_profile:drop_database', defaultDropDatabaseValue);
		}
		else {
			// Internal database and Oracle database server
			message = langVar('lang_admin.profiles.confirm_delete_message');
		}

		message = message.replace(/__PARAM__1/, '<strong>' + profileLabel + '</strong>');
		messageContainer.innerHTML = message;

		util.showE('delete_profile:drop_database_section', showDropDatabaseSection);

		panel.prePositionAtCenter();
		panel.open();
	}

	function cancelDeleteProfile() {
		panel.close();
	}

	function deleteProfile() {

		// util.showObject(profilesDb);
		// make sure no profile conversion is active
		var profileItem = profiles.getProfileItem(profileName);
		var databaseType = profileItem.databaseType;
		var dropDatabase = false;

		if (databaseType === 'mysql' || databaseType === 'odbc_mssql') {
			dropDatabase = util.getF('delete_profile:drop_database');
		}

		panel.close();
		util.hideE('form_section');
		util.showE('deleting_info');

		var url = '?dp=admin_pages.profiles.delete_profile';

		// -p (profile name) is required by erase_database()!
		// Specify "-p" for valid profiles only, else we get a server error!
		if (profileItem.isValidProfile) {
			url += '&p=' + profileItem.name;
		}

		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.profiles_list_checksum=' + pageInfo.profilesListChecksum;
		dat += '&v.fp.profile_name=' + profileName;
		dat += '&v.fp.is_valid_profile=' + profileItem.isValidProfile;
		dat += '&v.fp.drop_database=' + dropDatabase;
		dat += '&v.fp.version=' + profileItem.version;

		util.serverPost(url, dat);
	}

	function deleteProfileResponse(dat) {

		// util.showObject(dat);
		var profileChanges = dat.profileChanges;

		if (!dat.dropDatabase) {

			profiles.handleDeleteProfileCompleted(profileChanges);
		}
		else {

			// Save profileChanges for later
			savedProfileChanges = util.cloneObject(profileChanges);

			// DROP DATABASE is active, show busy panel and
			// get simple progress
			busyPanel.showCustom(dat.activeTaskMessage);

			// Check task state
			setTimeout('deleteProfile.checkDeleteDatabaseState("' + dat.taskId + '")', 1500);
		}
	}

	function checkDeleteDatabaseState(taskId) {

		var url = '?dp=admin_pages.profiles.check_delete_database_state';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.task_id=' + taskId;

		util.serverPost(url, dat);
	}

	function checkDeleteDatabaseStateResponse(dat) {

		if (dat.isActiveTask) {
			// Re-check task state
			setTimeout('deleteProfile.checkDeleteDatabaseState("' + dat.taskId + '")', 1500);
		}
		else {

			busyPanel.stop();
			profiles.handleDeleteProfileCompleted(savedProfileChanges);

			// Reset savedProfileChanges
			savedProfileChanges = {};
		}
	}


	// Return global properties and methods
	return {
		confirmDelete: confirmDelete,
		deleteProfileResponse: deleteProfileResponse,
		checkDeleteDatabaseState: checkDeleteDatabaseState,
		checkDeleteDatabaseStateResponse: checkDeleteDatabaseStateResponse
	};
}());

