/* global
	profiles: false,
	deleteProfile: false,
	duplicateProfile: false,
	renameProfile: false
*/

var profilesUtil = (function() {

	'use strict';

	var YE = YAHOO.util.Event;
	var YD = YAHOO.util.Dom;

	var isRootAdmin = false;
	var allProfilesGrants = null;
	var profilesGrants = null;
	var superRoles = null;

	// Menu elements
	var profileOptionsMenu;
	var configOptionsMenu = null;
	var configOptionsMenuAnchorEl = null;
	var toolsMenu = null;
	var toolsMenuAnchorEl = null;


	// activeProfile is the profile of the active menu
	var activeProfile = '';

	// activeSubmenu is the displayed Config Options or Tools menu.
	var activeSubmenu = '';

	var isMouseleave = false;
	var lastMouseLeaveEventCount = 0;

	function init() {

		isRootAdmin = pageInfo.isRootAdmin;
		initUserGrants();

		profileOptionsMenu = util.getE('profile_options_menu');

		configOptionsMenu = util.getE('profile_config_options_menu');
		configOptionsMenuAnchorEl = util.getE('profiles:config_options_btn');

		toolsMenu = util.getE('profile_tools_menu');
		toolsMenuAnchorEl = util.getE('profiles:tools_btn');

		// Create configOptionsMenu
		createMenu(configOptionsMenu, pageInfo.configOptionsMenuItems);

		// Create toolsMenu
		createMenu(toolsMenu, pageInfo.toolsMenuItems);


		YE.addListener([profileOptionsMenu, configOptionsMenu, toolsMenu], 'mouseenter', function(evt) {

			// Reset isMouseleave
//			console.log('mouseenter');
			isMouseleave = false;
		});

		YE.addListener([profileOptionsMenu, configOptionsMenu, toolsMenu], 'mouseleave', function(evt) {

			// Reset isMouseleave
//			console.log('mouseleave');
			isMouseleave = true;

			lastMouseLeaveEventCount += 1;

			var lastCount = lastMouseLeaveEventCount;

//			console.log('lastMouseLeaveEventCount: ' + lastMouseLeaveEventCount);

			// If isMouseleave remains true then we close the menu.
			setTimeout(function() {

				checkMouseLeaveState(lastCount);

			}, 750);
		});


		YE.delegate('profile_options_menu', 'mouseover', function(evt) {

			var element = evt.target || evt.srcElement;

			// Get the li element
			if (element.nodeName !== 'LI') {
				element = element.parentNode;
			}

			var elementId = element.id;
//			console.log('mouseover: ' + elementId);
			var currentMenu = '';

			if (elementId.indexOf('config_options') !== -1) {
				currentMenu = 'config_options';
			}
			else if (elementId.indexOf('tools') !== -1) {
				currentMenu = 'tools';
			}

//			console.log('currentMenu: ' + currentMenu);

			if (currentMenu !== activeSubmenu) {

				// Hide displayed submenu
				if (activeSubmenu == 'config_options') {
					configOptionsMenu.style.display = 'none';
				}
				else if (activeSubmenu == 'tools') {
					toolsMenu.style.display = 'none';
				}

				// Display submenu

				if (currentMenu === 'config_options' ||
					currentMenu === 'tools') {

					var theMenu = null;

					if (currentMenu === 'config_options') {
						theMenu = configOptionsMenu;
					}
					else {
						theMenu = toolsMenu;
					}

					var region = YD.getRegion(element);
//					util.showObject(region);

					theMenu.style.top = region.top + 'px';
					theMenu.style.left = region.right + 'px';
					theMenu.style.display = 'block';
				}

				activeSubmenu = currentMenu;
			}

		}, 'li');


		YE.addListener('profile_options_menu', 'click', function(evt) {

			var element = evt.target || evt.srcElement;
			// Check if we need to handle the parent element,
			// for example multiple span elements within an anchor element
			// where id is defined on anchor element.
			if (element.id === '' && element.parentNode.id !== '') {
				element = element.parentNode;
			}

			var elementId = element.id;
			var profileItem;

			if (elementId.indexOf('delete_profile') !== -1) {

				deleteProfile.confirmDelete(activeProfile);
			}
			else if (elementId.indexOf('duplicate_profile') !== -1) {

				profileItem = profiles.getProfileItem(activeProfile);
				duplicateProfile.open(activeProfile, profileItem.label);
			}
			else if (elementId.indexOf('rename_profile') !== -1) {

				profileItem =  profiles.getProfileItem(activeProfile);
				renameProfile.open(activeProfile, profileItem.label);
			}

			closeProfileOptionsMenu();
		});
	}

	function initUserGrants() {

		if (!isRootAdmin) {

			allProfilesGrants = pageInfo.userGrants.allProfilesGrants;
			profilesGrants = pageInfo.userGrants.profilesGrants;
			superRoles = pageInfo.userGrants.superRoles;

			// Create hash lookup for profilesGrants
			util.createHash(profilesGrants, 'profile');

//			util.showObject(allProfilesGrants, allProfilesGrants);
//			util.showObject(profilesGrants, profilesGrants);
		}
	}

	function resetUserGrants(theUserGrants) {

		// This resets pageInfo.userGrants with up to date theUserGrants.
		// This is called for non-root-admins after profile creation
		// or upon duplicate, rename and delete profile.
		pageInfo.userGrants = theUserGrants;
		initUserGrants();
	}

	function checkMouseLeaveState(count) {

//		console.log('checkMouseLeaveState()');

//		console.log(' ');
//		console.log('count: ' + count);
//		console.log('lastMouseLeaveEventCount: ' + lastMouseLeaveEventCount);
//		console.log(' ');

		if (count === lastMouseLeaveEventCount && isMouseleave) {
			closeProfileOptionsMenu();
		}
	}

	function openProfileOptionsMenu(btnElement, profileName) {

		if (activeProfile === profileName) {
			// Toggle menu
			closeProfileOptionsMenu();
		}
		else {

			// Close any open menu
			closeProfileOptionsMenu();
			var isRootAdmin = pageInfo.isRootAdmin;

			// Handle permissions for non-root-admin users
			if (!isRootAdmin) {

//				var profileItem = profiles.getProfileItem(profileName);

				var theProfileGrants = getProfileGrants(profileName);

				util.showE('profiles:config_options:li', theProfileGrants.isViewConfig);
				util.showE('profiles:tools:li', theProfileGrants.isViewTools);

				util.showE('profiles:rename_profile:li', theProfileGrants.isRename);
				util.showE('profiles:duplicate_profile:li', pageInfo.permissions.isAdd);
				util.showE('profiles:delete_profile:li', theProfileGrants.isDelete);
			}

			// Set href of Config Options and Tools
			configOptionsMenuAnchorEl.href = '?dp=config&page=log_source&p=' + profileName;
			toolsMenuAnchorEl.href = '?dp=config&page=database_info&p=' + profileName;

			// Get superRole for non-admin-users so that we get the config grants.
			var theSuperRole = {};
			if (!isRootAdmin) {

				var theProfileGrants = getProfileGrantsObject(profileName);
				var superRoleName = theProfileGrants.superRole;
				theSuperRole = superRoles[superRoleName];
			}

			setMenuItems(pageInfo.configOptionsMenuItems, profileName, theSuperRole);
			setMenuItems(pageInfo.toolsMenuItems, profileName, theSuperRole);

			// Set position and show the menu
			positionAndShowMenuElement(btnElement);

 			activeProfile = profileName;
		}
	}

	function closeProfileOptionsMenu() {

		if (activeProfile !== '') {

			profileOptionsMenu.style.display = 'none';
			configOptionsMenu.style.display = 'none';
			toolsMenu.style.display = 'none';

			activeProfile = '';
			activeSubmenu = '';
		}
	}

	function positionAndShowMenuElement(btnElement) {

		var menuElement = profileOptionsMenu;

		// clientRegion.top is equal scrollTop!
		var clientRegion = YD.getClientRegion();

//		util.showObject(clientRegion);

		var btnRegion = YD.getRegion(btnElement);
		var btnTop = btnRegion.top
		var btnBottom = btnRegion.bottom;
		var btnLeft =  btnRegion.left;
		var btnRight =  btnRegion.right;

//			util.showObject(btnRegion);

		// Get region of drop down menu
		menuElement.style.visibility = 'hidden';
		menuElement.style.top = 0;
		menuElement.style.left = 0;
		menuElement.style.display = 'block';
		var menuRegion = YD.getRegion(menuElement);
//			util.showObject(menuRegion);
		var menuWidth = menuRegion.width;
		var menuHeight = menuRegion.height;

		var menuLeft = btnLeft;
		var menuTop = 0;

		// Check if we have enough bottom space for the menu
		if ((btnBottom + menuHeight) < clientRegion.bottom) {
			menuTop = btnBottom;
		}
		else {
			// Display menu on top
			menuTop = btnTop - menuHeight;
		}

		// Set final position
		menuElement.style.top = menuTop + 'px';
		menuElement.style.left = menuLeft + 'px';

		// Show the menu
		menuElement.style.visibility = 'visible';
	}

	function setMenuItems(menuItems, profileName, theSuperRole) {

		// This sets the href attribute and visibility according
		// user grants of the menuItems for the active profile.

		for (var i = 0, len = menuItems.length; i < len; i++) {

			var menuItem = menuItems[i];
			var page = menuItem.page;

			if (!isRootAdmin) {
				// Show/hide list element according theSuperRole config grants.
				var liElement = menuItem.liElement;
				liElement.style.display = theSuperRole.hasOwnProperty(page) ? '' : 'none';
			}

			var aElement = menuItem.aElement;
			aElement.href= '?dp=config&page=' + page + '&p=' + profileName;
		}
	}

	function createMenu(container, menuItems) {

//		util.showObject(menuItems);

		var list = '';
		var i = 0;
		var len =  menuItems.length;

		for (i = 0; i < len; i++) {

			var listItem = menuItems[i];
			var listClass = (listItem.separator) ? ' class="group"' : '';
			var label = listItem.label;

			list += '<li' + listClass + '><a href=""><span>' + label + '</span></a></li>';
		}

		container.innerHTML = list;

		// Create a reference for each anchor element so that we can set
		// the href attribute per profile
		var elements = container.getElementsByTagName('a');

		for (i = 0; i < len; i++) {

			var anchorElement = elements[i];

			menuItems[i].aElement = anchorElement;

			// Create a reference to the list element for
			// non-root-admins so that we can show/hide the list
			// elements according profile grants.
			if (!isRootAdmin) {
				menuItems[i].liElement = anchorElement.parentNode;
			}

//			console.log(elements[i].href);
		}
	}

	function getProfileGrants(profileName) {

		var theProfileGrants = isRootAdmin ? null : getProfileGrantsObject(profileName);

		return {
			viewProfilesDashboard: isRootAdmin || theProfileGrants.viewProfilesDashboard,
			editProfilesDashboard: isRootAdmin || theProfileGrants.editProfilesDashboard,
			isViewReports: isRootAdmin || theProfileGrants.accessReports,
			isViewConfig: isRootAdmin || theProfileGrants.accessConfig,
			isViewTools: isRootAdmin || theProfileGrants.accessTools,
			isRename: isRootAdmin || theProfileGrants.isRename,
			isDelete: isRootAdmin || theProfileGrants.isDelete
		};
	}

	function getProfileGrantsObject(profileName) {

		// Get user grants for the profile
		if (typeof profilesGrants[util.h(profileName)] !== 'undefined') {

			// This profile has individual profile grants
			return profilesGrants[util.h(profileName)];
		}
		else {

			// Individual profile grants don't exist, use the allProfilesGrants
			return allProfilesGrants;
		}
	}

	// Return global properties and methods
	return {
		init: init,
		resetUserGrants: resetUserGrants,
		openProfileOptionsMenu: openProfileOptionsMenu,
		checkMouseLeaveState: checkMouseLeaveState,
		getProfileGrants: getProfileGrants
	};

}());
