/* global
	profiles: false,
	renameProfile: false */


var renameProfileDb = (function() {
	
	var panel = null;
	var validator = null;
	
	var sourceProfileName = '';
	var sourceProfileDatabaseName = '';
	var newProfileName = '';
	
	function init() {
		
		var YE = YAHOO.util.Event;
		
		var panelObj = {
			panelId: 'rename_profile_db:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.profiles.rename_profile_database_title'),
			// left: 100,
			// top: 50,
			zIndex: 30,
			isCover: true,
			closeEvent: close
		};
		
		panel = new util.Panel3(panelObj);
		validator = new util.Validator();
		
		var dbNameButtons = ['rename_profile_db:use_profile_name_btn', 'rename_profile_db:keep_existing_name_btn', 'rename_profile_db:define_custom_name_btn'];
		
		YE.addListener(dbNameButtons, 'click', toggleDbNameSwitch);
		YE.addListener('rename_profile_db:ok_btn', 'click', rename);
		YE.addListener('rename_profile_db:cancel_btn', 'click', close);
	}
	
	function open(sourceProfileName, sourceProfileDatabaseName, newProfileName, newProfileLabel) {
		
		if (panel === null) {
			init();
		}
		
		// Set Db info
		var infoText = langVar('lang_admin.profiles.rename_profile_database_info');
		infoText = infoText.replace(/__PARAM__1/, '<strong>' + newProfileLabel + '</strong>');
		var containerElement = util.getE('rename_profile_db:rename_db_info');
		containerElement.innerHTML = infoText;
		
		// Set use profile name label
		var useProfileNameText = langVar('lang_admin.profiles.use_profile_name_for_db_name');
		useProfileNameText = useProfileNameText.replace(/__PARAM__1/, '<strong>' + newProfileName + '</strong>');
		var useProfileNameContainer = util.getE('rename_profile_db:use_profile_name_label');
		useProfileNameContainer.innerHTML = useProfileNameText;
		
		var keepExistingNameText = langVar('lang_admin.profiles.keep_existing_name_for_db_name');
		keepExistingNameText = keepExistingNameText.replace(/__PARAM__1/, '<strong>' + sourceProfileDatabaseName + '</strong>');
		var keepExistingNameContainer = util.getE('rename_profile_db:keep_existing_name_label');
		keepExistingNameContainer.innerHTML = keepExistingNameText;
		
		// Set default radio button and field values depending on source profile names
		
		if (sourceProfileName === sourceProfileDatabaseName) {
			util.setF('rename_profile_db:use_profile_name_btn', true);
		}
		else {
			util.setF('rename_profile_db:keep_existing_name_btn', true);
		}
		
		util.setF('rename_profile_db:database_name', '');
		toggleDbNameSwitch();
		
		panel.prePositionAtCenter();
		panel.open();
	}
	
	function close() {
		
		validator.reset();
		panel.close();
	}
	
	function toggleDbNameSwitch() {
		
		var isCustomDatabaseName = util.getF('rename_profile_db:define_custom_name_btn');
		util.enableE('rename_profile_db:database_name', isCustomDatabaseName);
		
		// Reset validator if we switch to non-custom database name
		if (!isCustomDatabaseName) {
			validator.reset();
		}
	}
	
	function getIsUniqueDatabaseName(newDatabaseName) {

		var profilesDb = profiles.getProfilesDb();
		var isUniqueDatabaseName = true;
		
		for (var i = 0; i < profilesDb.length; i++) {
			
			var profileItem = profiles.profileArrayItemToObject(profilesDb[i]);
			var profileName = profileItem.name;
			
			if (profileName !== sourceProfileName) {

				if (profileName === newDatabaseName ||
					profileItem.databaseName === newDatabaseName) {
					
					// util.showObject(profileItem);
					isUniqueDatabaseName = false;
					break;
				}
			}
		}
		
		return isUniqueDatabaseName;
	}

	function rename() {

		validator.reset();
		
		var newDatabaseName = '';
		var isValidated = false;
		
		// If we don't keep the existing name
		if (!util.getF('rename_profile_db:keep_existing_name_btn')) {
			
			var databaseName = '';
			
			if (util.getF('rename_profile_db:use_profile_name_btn')) {
				
				// We use the new profile node name as new database name
				
				databaseName = newProfileName;
				
				if (databaseName !== sourceProfileDatabaseName) {
					
					// alert('databaseName: ' + databaseName);
					
					// We still need to check if the new profile node name isn't already used as database name
					if (getIsUniqueDatabaseName(databaseName)) {
						
						// The databaseName is valid, assign it to newDatabaseName
						isValidated = true;
						newDatabaseName = databaseName;
					}
					else {
						// Show alert
						alert(langVar('lang_admin.database.database_name_already_exists'));
					}
				}
				else {
					
					// Unlikely but possible, the new profile node name matches the existing database name
					isValidated = true;
				}
			}
			else {
				
				// Custom database name
				databaseName = validator.isValue('rename_profile_db:database_name');
				
				if (databaseName !== '' && (databaseName === sourceProfileDatabaseName)) {
				
					// We keep the existing name, which has been defined manually
					isValidated = true;
				}
				else {
					
					if (databaseName !== '') {
						
						// Check for unique database name. The database name should be different than any existing profile name
						// or database name, even if the same name is used in a different database server type.
						
						if (getIsUniqueDatabaseName(databaseName)) {
							
							// The databaseName is valid, assign it to newDatabaseName
							newDatabaseName = databaseName;
							isValidated = true;
						}
						else {
							
							// Throw custom error message
							validator.isCustom('rename_profile_db:database_name', langVar('lang_admin.database.database_name_already_exists'));
						}
					}
					
					if (validator.allValid()) {

						isValidated = true;
					}
				}
			}
		}
		else {
			// Keep existing database name
			isValidated = true;
		}
		
		
		if (isValidated) {
		
			close();
			renameProfile.renameAndSaveProfileFinal(newDatabaseName);
		}
	}

	// Return global properties and methods
	return {
		open: open
	};

}());
