//
// Imports filter items and filter groups from scheduler actions and reports
// of the same profile and user.
//


/* global
	ReportFiltersPanel: false */


var importReportFilters = (function() {

	'use strict';
	
  	var YE = YAHOO.util.Event,
		YD = YAHOO.util.Dom,
		panel = null,

		// The filtersPanel which shows the items to import.
		filtersPanel = null,

		// A reference to filter items and groups which
		// already exist as saved items or items to be saved.
		// Note, this are saved items in scheduler actions,
		// not the once loaded from users_cache.

		filtersLookup = {},

		// Items to import which are not duplicates with
		// already saved items.
		filterItemsToImport = [],
		filterGroupsToImport = [],

		profileName = '',
		queryFieldsDb = [];

	function _init() {

		var panelObj = {
			panelId:"import_rf:panel",
			panelClassName: 'panel-50',
			panelHeaderLabel: 'Import Report Filters', //LM
			left: 70,
			top: 80,
			zIndex: 80,
			isCover: true,
			closeEvent: _close
		};

		panel = new util.Panel3(panelObj);

		// Create a minimalistic filters panel
		filtersPanel = new ReportFiltersPanel({
			containerId: 'import_rf:container',
			filterItemsSelectCallback: importReportFilters.filterItemsSelectionListener

		});

		YE.addListener('import_rf:import_btn', 'click', _import);
		YE.addListener('import_rf:cancel_btn', 'click', _close);
	}

	function open(_profileName, _queryFieldsDb, existingFilterItems) {

		// This is called via the main reportFiltersPanel

		// NOTE, WE GET ONLY filterItems which already includes the groups!

//		util.showObject(existingFilterItems, 'existingFilterItems');

		profileName = _profileName;
		queryFieldsDb = _queryFieldsDb;

		// Reset
		filtersLookup = {};
		filterItemsToImport = [];
		filterGroupsToImport = [];

		// Add filters which already exist to filtersLookup
		// so that we don't show duplicates to import.
		var filterId;
		for (var i = 0, numItems = existingFilterItems.length; i < numItems; i++) {

			var filterItem = existingFilterItems[i];

			if (!filterItem.hasOwnProperty('items')) {

				// This is a filterItem
				filterId = repFiltersUtil.getFilterItemAsString(filterItem);
			}
			else {

				// This is a filterGroup
				filterId = repFiltersUtil.getFilterGroupId(filterItem);
			}

			filtersLookup[filterId] = true;
		}

		// Open Import panel

		if (panel === null) {
			_init();
		}

		// Reset filtersPanel
		filtersPanel.initFilters(profileName, queryFieldsDb, [], []);

		// Set import panel position
		var region = YD.getRegion('sa:report_filters');
		var left = region.left;
		var top = region.top - 60;

		panel.open({
			left: left,
			top: top
		});

		// Get filter items and filter groups already used in scheduler
		var a = getUsedReportFiltersInScheduler();

//		util.showObject(a);

		_addToFilterItemsToImport(a.filterItems);
		_addToFilterGroupsToImport(a.filterGroups);

		// Get saved filter items and groups
		_getSavedReportFilters(profileName);
	}

	function _close() {

		panel.close();
	}

	function filterItemsSelectionListener(isSelectedItem) {

		// Enables/disables import button
		util.enableE('import_rf:import_btn', isSelectedItem);
	}

	function _import() {

		util.disableE('import_rf:import_btn');

		var activeFilterItemsAndGroups = filtersPanel.getActiveItems();
		schedulerActions.importReportFilterItemsAndGroups(activeFilterItemsAndGroups);

		// Close the Import panel.
		_close();
	}

	function _getSavedReportFilters(profileName) {

		var url = '?dp=admin_pages.scheduler.get_saved_report_filters';

		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.profile_name=' + profileName;
		util.serverPost(url, dat);
	}

	function getSavedReportFiltersResponse(dat) {

//		util.showObject(dat);
		_addToFilterItemsToImport(dat.filterItems);
		_addToFilterGroupsToImport(dat.filterGroups);

		// Show filters
		filtersPanel.initFilters(profileName, queryFieldsDb, filterItemsToImport, filterGroupsToImport);
	}


	function _addToFilterItemsToImport(filterItems) {

		// This adds non-duplicate filter items to filterItemsToImport
		for (var i = 0, len = filterItems.length; i < len; i++) {

			var filterItem = filterItems[i];
			var filterId = repFiltersUtil.getFilterItemAsString(filterItem);

			// Add filter item if it doesn't yet exist.
			if (!filtersLookup.hasOwnProperty(filterId)) {

				var clonedFilterItem = util.cloneObject(filterItem);
				clonedFilterItem.isActive = false;
				filterItemsToImport.push(clonedFilterItem);
			}
		}
	}

	function _addToFilterGroupsToImport(filterGroups) {

		// This adds non-duplicate filter groups to filterGroupsToImport
		for (var i = 0, len = filterGroups.length; i < len; i++) {

			var filterGroup = filterGroups[i];
			var groupId = repFiltersUtil.getFilterGroupId(filterGroup);

			// Add filter group if it doesn't yet exist.
			if (!filtersLookup.hasOwnProperty(groupId)) {

				var clonedGroupItem = util.cloneObject(filterGroup);
				clonedGroupItem.isActive = false;
				filterGroupsToImport.push(clonedGroupItem);
			}
		}
	}

	// Return global properties and methods
	return {
		open: open,
		filterItemsSelectionListener: filterItemsSelectionListener,
		getSavedReportFiltersResponse: getSavedReportFiltersResponse
	};

}());