//
// adminConfig.js
//

adminConfig = {
	
	// getIsModifiedPageHandler is set to a function in Admin and Config pages
	// which checks if a page has been modified or not.
	getIsModifiedPageHandler: null,
	
	init: function() {
		
		// alert('adminConfig.init() - pageInfo.isAdminPage: ' + pageInfo.isAdminPage);
		
		// Don't add product_bar to navElem but the logout button only
		var navElem = ['product_bar:index_btn', 'product_bar:logout_btn'];
		var YE = YAHOO.util.Event;
		YE.addListener(navElem, 'click', adminConfig.navigateToPage);
		
		// init admin drop down
		// util.initAdminDropDownMenu();
		
		if (pageInfo.isAdminPage) {

			// Init admin nav bar
			util.showE('admin_navbar');
			YE.addListener('product_support_btn', 'click', adminConfig.openSupportPage);

			// Handle navigateToPage
			YE.delegate('admin_navbar', 'click', adminConfig.navigateToPage, 'a');
		}
		else {

			// This is a config page, init config nav bar
			reportsConfigNavbar.init(false);

			// Handle navigateToPage
			YE.delegate('rc_nav_menus_container', 'click', adminConfig.navigateToPage, 'a');
			YE.addListener('rc_nav_view_reports:btn', 'click', adminConfig.navigateToPage);
		}
		
		// Assign exitPage event to all header links
		YE.addListener(navElem, 'click', adminConfig.navigateToPage);
	},
	
	navigateToPage: function(evt) {
		
		// User clicked a link an Admin or Config link to open a different page.
		// Check for unsaved changes!
		
//		alert('adminConfig.navigateToPage()');
		
		YAHOO.util.Event.preventDefault(evt);

		href = this.href;

		if (adminConfig.getIsExitPagePermission()) {

			// Follow the link
			location.href = href;
		}
		else {

			// Remove focus from links
			this.blur();
		}
	},
	
	getIsExitPagePermission: function() {
		
//		alert('adminConfig.getIsExitPagePermission()');

		// Note that we don't need to check for unsaved pages as long as
		// pageInfo.initComplete is set to false!
		
		var activePage = pageInfo.page;
		var exitThePage = true;
		
		if (!pageInfo.initComplete || pageInfo.saveActive) {
			
			// We assume that changes are saved in the background,
			// so we allow to exit the active page if saveActive is true
			exitThePage = true;
			
			// Set pageInfo.exitActive to true so that the page
			// knows it doesn't need to display anything in case
			// that page data are yet loading.
			pageInfo.exitActive = true;
		}
		else {
			
			// Check for unsaved page changes
			// KHP 27/April/2010, "pageInfo.isModified" is no longer available,
			// it has been replaced with the adminConfig.isModifiedPageHandler property
			// if (pageInfo.isModified != null && pageInfo.isModified()) {
			if (adminConfig.getIsModifiedPageHandler != null && adminConfig.getIsModifiedPageHandler()) {
				
				exitThePage = confirm(langVar('lang_admin.general.confirm_unsaved_page_exit'));
			}
			else {
				
				exitThePage = true;
			}
		}
		
		// alert("exitThePage: " + exitThePage);
		
		if (exitThePage) {
			
			var menuSectionId = 'admin_navbar';

			if (util.getE('admin_config_toolbar')) {util.hideEV('admin_config_toolbar');}
			if (util.userAgent.isIE6 && util.getE('config_nav:hidden_cover')) {util.hideE('config_nav:hidden_cover');}
			if (util.getE('config_nav')) {util.hideE('config_nav');}
			if (util.getE('form_section')) {util.hideE('form_section');}
			if (util.getE('loading_info')) {util.hideE('loading_info');}
			if (util.getE('saving_info')) {util.hideE('saving_info');}
			
			return true;
		}
		
		return false;
	},
	
	setItemListSize: function() {
		
		var activePage = pageInfo.page;
		
		var itemList = util.getE('item_list');
		var itemListBody = util.getE('item_list_body');
		var itemForm = util.getE('item_form');
		
		var clientHeight = YAHOO.util.Dom.getClientHeight();
		var itemFormPos = YAHOO.util.Dom.getXY(itemForm);
		var itemFormY = itemFormPos[1];
		var itemListHeight = clientHeight - itemFormY - 50; // 50 for 50px bottom space
		var itemListWidth = 254; // default
	
		var moveButtonsWidth = 13 + 23 + 13; // includes the margins
		
		// Pages with move buttons
		var pagesWithMoveButtons = {
			
			scheduler: '',
			log_parsing_filters: '',
			log_filters: '',
			log_source: '',
			database_filters: '',
			reports: {
				itemListWidth: 275
			},
			xrefs: '',
			report_fields: ''
		}
		
		var hasMoveControl = pagesWithMoveButtons[activePage] != null;
		
		if (hasMoveControl && pagesWithMoveButtons[activePage].itemListWidth != null) {
			itemListWidth = pagesWithMoveButtons[activePage].itemListWidth;
		}
		
		var itemListPos = YAHOO.util.Dom.getXY(itemList);
		var itemListBodyPos = YAHOO.util.Dom.getXY(itemListBody);
		var itemListHeaderHeight = itemListBodyPos[1] - itemListPos[1];
		
		// set itemForm left margin
		var itemFormLeftMargin = hasMoveControl ? moveButtonsWidth + itemListWidth + 20 : itemListWidth + 40; // 40 for 20px left margin and 20px right margin
		itemForm.style.marginLeft = itemFormLeftMargin + 'px';
		
		// set itemListMoveButtons size
		if (hasMoveControl) {
			var moveControl = util.getE('item_list_move_control');
			moveControl.style.left = '13px';
			moveControl.style.top = itemFormY + 'px';
		}
		
		// set itemList size
		var itemListLeft = hasMoveControl ? moveButtonsWidth : 20;
		itemList.style.left = itemListLeft + 'px';
		itemList.style.top = itemFormY + 'px';
		itemList.style.width = itemListWidth + 'px';
		itemList.style.height = itemListHeight + 'px';
		
		// alert('itemListHeight: ' + itemListHeight);
		// alert('itemListHeaderHeight: ' + itemListHeaderHeight);
		
		// set itemListBody height
		itemListBody.style.height = (itemListHeight - itemListHeaderHeight) + 'px';
		
		// adjust copyright_info position
		var copyright_info = util.getE('copyright_info');
		copyright_info.style.position = 'absolute';
		copyright_info.style.top = (clientHeight - 40) + 'px';
	},
	
	openSupportPage: function(evt) {
		
		YAHOO.util.Event.preventDefault(evt);
		
		// var url = '?dp=support';// does not work with preventDefault!
		var url = '?dp=admin_pages.support.support_page';
		
		var width = YAHOO.util.Dom.getViewportWidth() - 120;
		var height = YAHOO.util.Dom.getViewportHeight() - 60;
		var features = 'width=' + width + ',height=' + height + ',location=yes,menubar=yes,toolbar=yes,status=yes,scrollbars=yes,resizable=yes';
		
		var supportWindow = window.open(url, 'support', features);
		supportWindow.focus();
	}
}

window.onload = adminConfig.init;
