/* 
	convertCharset
	
	
	Used in "log processing" and "report options"
	
	Following elements/ids must exist in the respective form
	
	convert_charset (checkbox)
	convert_from_list:charset_group
	convert_from_list:charset
	convert_to_list:charset_group
	convert_to_list:charset
	
*/

convertCharset = {
	
	charsetDb: [],
	
	init: function(charsetDb) {
		
		convertCharset.charsetDb = charsetDb;
		
		// create hash to acccess charsets by group name
		util.createHash(convertCharset.charsetDb, 'name');
		
		// initialize the charset group and charset lists
		
		// alert('init charset');
		
		var groupList = [];
		groupList[0] = {name:'', label:langVar('lang_admin.charset_conversion.select_group')};
		
		for (var i = 0; i < charsetDb.length; i++) {
			groupList[groupList.length] = {name: charsetDb[i].name, label: charsetDb[i].label};
		}
		
		util.populateSelect('convert_from_list:charset_group', groupList, 'name', 'label');
		util.populateSelect('convert_to_list:charset_group', groupList, 'name', 'label');
		
		YAHOO.util.Event.addListener('convert_charset', 'click', convertCharset.toggleCharset);
		YAHOO.util.Event.addListener('convert_from_list:charset_group', 'change', convertCharset.groupActivated);
		YAHOO.util.Event.addListener('convert_to_list:charset_group', 'change', convertCharset.groupActivated);
	},
	
	update: function(convert_log_data_charset, convert_log_data_from_charset, convert_log_data_to_charset) {
		
		// similar to updateForm(), it updates the charset section to a given set of charset values,
		// it is also used upon Undo Changes.
		
		// alert('convert_log_data_charset: ' + convert_log_data_charset);
		
		// set checkbox
		util.setF('convert_charset', convert_log_data_charset);
		
		// set group lists
		var fromGroup = convertCharset.getGroup(convert_log_data_from_charset);
		var toGroup = convertCharset.getGroup(convert_log_data_to_charset);
		
		util.setF('convert_from_list:charset_group', fromGroup);
		util.setF('convert_to_list:charset_group', toGroup);
		util.enableE(['convert_from_list:charset_group', 'convert_to_list:charset_group'], convert_log_data_charset);
		
		// set charset lists
		convertCharset.setCharsetList(fromGroup, convert_log_data_from_charset, true);
		convertCharset.setCharsetList(toGroup, convert_log_data_to_charset, false);
	},
	
	getGroup: function(theCharset) {
		
		theCharset = theCharset.toLowerCase();
		
		var charsetGroup = '';
		
		if (theCharset != '') {
			
			var charsetDb = convertCharset.charsetDb;
			
			for (var i = 0; i < charsetDb.length; i++) {
	
				var charsets = charsetDb[i].charsets;
				
				for (var j = 0; j < charsets.length; j++) {
					if (charsets[j].toLowerCase() == theCharset) {
						charsetGroup = charsetDb[i].name;
						break;
					}
				}
			}
		}
		
		return charsetGroup;
	},
	
	groupActivated: function() {
		
		// invoked when charset group changes
		var elementId = this.id;
		var isFromList = (elementId == 'convert_from_list:charset_group');
		var charsetGroup = util.getF(elementId);
	
		// alert('elementId: ' + elementId + '\ncharsetGroup: ' + charsetGroup);
		
		// set the charset to '' upon group change
		convertCharset.setCharsetList(charsetGroup, '', isFromList);
	},
	
	setCharsetList: function(charsetGroup, charset, isFromList) {
		
		// alert('setCharsetList()');
		
		var elementId = isFromList ? 'convert_from_list:charset' : 'convert_to_list:charset';
		var groupIsSelected = (charsetGroup != '');
		
		var charsetList = [{name:'', label:langVar('lang_admin.charset_conversion.select_charset')}];
		
		if (groupIsSelected) {
			
			// populate charset list
			
			// util.showObject(convertCharset.charsetDb);
			
			var charsets = convertCharset.charsetDb[util.h(charsetGroup)]['charsets'];
			
			// alert('charsets: ' + charsets);
			
			for (var i = 0; i < charsets.length; i++) {
				
				var theCharset = charsets[i];
				
				charsetList[charsetList.length] = {name: theCharset, label: theCharset};
			}
		}
		
		util.populateSelect(elementId, charsetList, 'name', 'label');
		util.setF(elementId, charset);
		util.enableE(elementId, groupIsSelected); // charset list is only enabled if a charset group is selected
	},
	
	toggleCharset: function() {
		
		var enableGroupList = false;
		var enableCharsetFromList = false;
		var enableCharsetToList = false;
		
		if (this.checked) {
			
			enableGroupList = true;
			enableCharsetFromList = (util.getF('convert_from_list:charset_group') != '') ? true : false;
			enableCharsetToList = (util.getF('convert_to_list:charset_group') != '') ? true : false;
		}
		
		util.enableE(['convert_from_list:charset_group','convert_to_list:charset_group'], enableGroupList);
		util.enableE('convert_from_list:charset', enableCharsetFromList);
		util.enableE('convert_to_list:charset', enableCharsetToList);
	}
};
