//
//
// creTable.js (Customize Report Element Table Class, used in Reports and Reports Editor)
//
//

CreTable = function(queryFieldsDb, isCustomizeInReports, hideLogDetailSortingMessage) {
		
	// Manages the report fields list
	
	// this.containerElementId = containerElementId;
	
	var YE = YAHOO.util.Event;
	
	var tableFieldsContainerId = 'cre_obj:table:fields_container';
	this.tableFieldsContainerId = tableFieldsContainerId;
	
	this.queryFieldsDb = queryFieldsDb; // A reference to all report fields from where we get the Field labels
	this.isCustomizeInReports = isCustomizeInReports;
	this.hideLogDetailSortingMessage = hideLogDetailSortingMessage;
	this.reportElementDb = {}; // A reference to the active report element data.
							   // reportElementDb keeps the state of any action taken in the TableColumns
							   // The variable is set upon this.build()
							   
	this.sortByFirstListEntryLabel = ''; // Set upon init()
	this.totalRows = 0; // Set upon init(), it is used for the log detail warning message in the Reports GUI
	
	this.isTable = false;
	this.isOverview = false;
	this.isLogDetail = false; 
	
	var idPrefix = util.getUniqueElementId();
	this.idPrefix = idPrefix; // Used as prefix in all element Id's (checkboxes, etc.) and as self reference id
	
	// Populate sort direction list in Table Options
	creUtil.buildSortDirectionList('cre_obj:table:sort_direction');
	
	// util.showObject(this.reportElementDb);
	
	YE.addListener('cre_obj:table:sort_by', 'click', this.sortByActor, this);
	YE.addListener('cre_obj:table:sort_direction', 'click', this.sortDirectionActor, this);
	YE.addListener('cre_obj:table:select_deselect_all_btn', 'click', this.selectDeselectAllActor, this);
	
	// assign table event
	YE.addListener(tableFieldsContainerId, 'click', this.itemActivated, this);
};

CreTable.prototype = {
	
	init: function(reportElementDb, totalRows) {
		
		// Field list element ID scheme (prefix:index:type:elementName), index matches the array position
		// sort colum: ueid_20:0:sort:td --> should be an image!
		// label column: re_field_list:0:label:td --> used to set the sort direction
		
		// util.showObject(reportElementDb);
		
		//
		// Init
		//
		this.reportElementDb = reportElementDb;
		this.totalRows = totalRows;
		
	
		this.isTable = (reportElementDb.type == 'table');
		this.isOverview = (reportElementDb.type == 'overview');
		this.isLogDetail = (reportElementDb.type == 'log_detail');
		
		
		var queryFieldsDb = this.queryFieldsDb;
		var columns = reportElementDb.columns;
		
		var basicSortByFirstListEntryLabel = '(' + langVar('lang_stats.general.none') + ')'; // --> Label gets length of max column label to avoid GUI flicker
		this.sortByFirstListEntryLabel = creUtil.getSortByFirstListEntryLabel(queryFieldsDb, columns, basicSortByFirstListEntryLabel);
		
		this.buildTableFields(columns, queryFieldsDb);
		
		util.showEV('cre_obj:table:sort_by:div', !this.isOverview);
		util.disableE(['cre_obj:table:sort_by', 'cre_obj:table:sort_direction'], this.isOverview); // Disable so that we don't get focus on it if overview
		
		if (!this.isOverview) {
			
			this.updateSortBy();
			// Set initial sort direction
			util.setF('cre_obj:table:sort_direction', reportElementDb.sort_direction);
		}
	},
	
	itemActivated: function(evt, self) {
		
		var element = evt.target || evt.srcElement;
		var elementId = element.id;
		
		if (elementId != '') {
			
			// alert('creUtil.TableColumns.prototype.itemActivated(): ' + elementId);
			
			var dat = elementId.split(':');
			var idPrefix = dat[0];
			var objectIndex = parseInt(dat[1], 10);
			var type = dat[2];
			
			// alert('idPrefix: ' + idPrefix);
	
			// var self = creUtil.TableColumnsSelfReferences[idPrefix]; // self is equal this in terms of the TableColumns object!
			var reportElementDb = self.reportElementDb;
			var column = reportElementDb.columns[objectIndex];
			
			// alert('list.idPrefix: ' + list.idPrefix);
			// util.showObject(item);
			
			var isAggregatingField = (column.show_percent_column != null);
			
			// alert('isLogDetail: ' + isLogDetail);
			
			var isChecked;
			// var isUpdateSortBy = false;
	
			// if table report element
			if (self.isTable) {
			
				if (isAggregatingField) {
					
					if (type == 'table_label') {
					
						// We set the checkboxes depending on current state.
						// a.) If none is checked we check all
						// b.) If one or more are checked we uncheck all
						
						isChecked = column.show_column;
						column.show_column = !isChecked;
						column.show_percent_column = !isChecked;
						column.show_bar_column = !isChecked;
						
						// Update aggregating field state
						self.updateCheckboxState(objectIndex, column);
					}
					else {
						
						isChecked = util.getF(idPrefix + ':' + objectIndex + ':' + type);
						
						if (type == 'number') {
							
							column.show_column = isChecked;
							
							if (!isChecked) {
								column.show_percent_column = false;
								column.show_bar_column = false;
							}
							
							util.enableE(idPrefix + ':' + objectIndex + ':percent', isChecked);
							util.enableE(idPrefix + ':' + objectIndex + ':bar', isChecked);
							
							// util.showObject(column);
							
							// Update aggregating field state
							self.updateCheckboxState(objectIndex, column);
						}
						else if (type == 'percent') {
							column.show_percent_column = isChecked;
						}
						else if (type == 'bar') {
							column.show_bar_column = isChecked;
						}
					}
				}
			}
			else {
				
				// overview or log_detail report element which only has text and number
				// checkboxes and where text checkboxes are not disabled.
				// Note, a log_detail report element has show_percent_column and show_bar_column
				// nodes, though they are not in use, respectively always false.
				
				var typeDetail = isAggregatingField ? 'number' : 'text';
				var checkbox = util.getE(idPrefix + ':' + objectIndex + ':' + typeDetail);
				isChecked = checkbox.checked;
				
				if (type == 'table_label') {
					column.show_column = !isChecked;
					checkbox.checked = !isChecked;
				}
				else {
					column.show_column = isChecked;
				}
			}
			
			
			//
			// Handle sort_by
			// If a column becomes unchecked we have to remove it from
			// the sort_by list
			//
			
			if (!self.isOverview && !column.showColumn) {
				
				// Check if this is the active sort field
				if (column.report_field == reportElementDb.sort_by) {
					self.autoSortBy(objectIndex);
				}
				
				self.updateSortBy();
			}
		}
	},
	
	updateCheckboxState: function(objectIndex, column) {
		
		// Sets the checkbox state for the specified column item
	
		var isAggregatingField = (column.show_percent_column != null);
		
		var idPart = this.idPrefix + ':' + objectIndex + ':';
		
		// util.showObject(column);
		// alert('isAggregatingField: ' + isAggregatingField);
		
		var showColumn = column.show_column;
		
		if (!isAggregatingField) {
		
			util.setF(idPart + 'text', showColumn);
			
			if (this.isTable) {
				util.disableE(idPart + 'text');
			}
		}
		else {
			
			util.setF(idPart + 'number', showColumn);
			
			if (this.isTable) {
			
				var percentInput = util.getE(idPart + 'percent');
				var percentTd = percentInput.parentNode;
				var barInput = util.getE(idPart + 'bar');
				var barTd = barInput.parentNode;
				var className = showColumn ? '' : 'disabled';
				
				percentInput.checked = column.show_percent_column;
				percentInput.disabled = !showColumn;
				percentTd.className = className;
				
				barInput.checked = column.show_bar_column;
				barInput.disabled = !showColumn;
				barTd.className = className;
			}
		}
	},
	
	
	selectDeselectAllActor: function(evt, self) {
		
		var reportElementDb = self.reportElementDb;
		var columns = reportElementDb.columns;
	
		var isTable = self.isTable;
		var isOverview = self.isOverview;
		
		//
		// Check if we check or uncheck all fields
		//
		
		var makeAllChecked = false;
		var i;
		var column;
		var isAggregatingField;
		
		for (i = 0; i < columns.length; i++) {
			
			column = columns[i];
			// isAggregatingField = (column.show_percent_column != null);
			
			if (!column.show_column) {
				makeAllChecked = true;
				break;
			}
		}
		
		// alert('makeAllChecked: ' + makeAllChecked);
		
		
		//
		// Check or uncheck all fields
		//
		
		for (i = 0; i < columns.length; i++) {
			
			column = columns[i];
			isAggregatingField = (column.show_percent_column != null);
			
			// alert('isAggregatingField: ' + isAggregatingField);
			
			if (isTable) {
					
				if (isAggregatingField) {
						
					column.show_column = makeAllChecked;
					column.show_percent_column = makeAllChecked;
					column.show_bar_column = makeAllChecked;
					
					self.updateCheckboxState(i, column);
				}
			}
			else {
				
				column.show_column = makeAllChecked;
				self.updateCheckboxState(i, column);
			}
		}
		
		// Handle sort by
		
		if (!isOverview && !makeAllChecked) {
			reportElementDb.sort_by = '';
		}
		
		self.updateSortBy();
	},
	
	sortByActor: function(evt, self) {
		
		var previousSortByValue = self.reportElementDb.sort_by;
		var newSortByValue = util.getF('cre_obj:table:sort_by');
		
		// Set newSortByValue 
		self.reportElementDb.sort_by = newSortByValue;
		
		// Check if we need to show the log detail sorting message
		if (self.isLogDetail &&
			!self.hideLogDetailSortingMessage &&
			previousSortByValue == '' &&
			newSortByValue != '' &&
			(self.totalRows > 1000000 || !self.isCustomizeInReports)) {
		
			logDetailSortingMsg.openViaCustomizeReportElement(self.isCustomizeInReports);
		}
	},
	
	sortDirectionActor: function(evt, self) {
		
		self.reportElementDb.sort_direction = util.getF('cre_obj:table:sort_direction');
	},
	
	autoSortBy: function(objectIndex) {
		
		// The column of the given objectIndex has been unchecked, so the report_field
		// can't be used for sort_by, respectively it doesn't make sense.
		// In this case we automatically set set reportElementDb.sort_by to
		// the nearest checked column
		
		var reportElementDb = this.reportElementDb;
		var columns = reportElementDb.columns;
		var sortBy = '';
		var i;
		
		// we serach first upward and then downward for a checked column
		
		for (i = objectIndex + 1; i < columns.length; i++) {
			
			if (columns[i].show_column) {
				sortBy = columns[i].report_field;
				break;
			}
		}
		
		// If no sortBy has been found yet
		if (sortBy == '') {
			
			// Serach downward
			for (i = objectIndex - 1; i >= 0; i--) {
				if (columns[i].show_column) {
					sortBy = columns[i].report_field;
					break;
				}
			}
		}
		
		reportElementDb.sort_by = sortBy;
	},
	
	updateSortBy: function() {
		
		// Updates sort by fields list and selected item to the state
		// as in reportElementDb
		
		var queryFieldsDb = this.queryFieldsDb;
		var columns = this.reportElementDb.columns;
		var sortBy = this.reportElementDb.sort_by;
		
		var firstListLabel = this.sortByFirstListEntryLabel;
		var list = [{name:'', label:firstListLabel}];
		
		for (var i = 0; i < columns.length; i++) {
			
			var column = columns[i];
			
			if (column.show_column) {
				
				var name = column.report_field;
				var label = queryFieldsDb[util.h(name)].label;
				list[list.length] = {name:name, label:label};
			}
		}
		
		util.populateSelect('cre_obj:table:sort_by', list, 'name', 'label');
		util.setF('cre_obj:table:sort_by', sortBy);
	},
	
	buildTableFields: function(columns, queryFieldsDb) {

		var table = util.getE(this.tableFieldsContainerId);
		
		// Clean up the list
		while (table.firstChild != null) {
			var n = table.firstChild;
			table.removeChild(n);
		}
		
		var tbody = document.createElement('tbody');
		var i;
		
		for (i = 0; i < columns.length; i++) {
			
			var column = columns[i];
			var reportField = column.report_field;
			var reportFieldLabel = queryFieldsDb[util.h(reportField)].label;
			var isAggregatingField = (column.show_percent_column != null);
			
			var tr = document.createElement('tr');
			
			if (!isAggregatingField) {
					
				this.addCheckboxCell(tr, i, 'text', '');
				
				// if report element type table
				if (this.isTable) {
					this.addEmptyCell(tr);
					this.addEmptyCell(tr);
				}
			}
			else {
				
				this.addCheckboxCell(tr, i, 'number', '');
				
				// if report element type table
				if (this.isTable) {
					this.addCheckboxCell(tr, i, 'percent', '%');
					this.addCheckboxCell(tr, i, 'bar', langVar('lang_stats.customize_report_element.bar'));
				}
			}
			
			this.addLabelCell(tr, i, reportFieldLabel);
			tbody.appendChild(tr);
		}
		
		table.appendChild(tbody);
		
		// Upadate the checkbox state
		for (i = 0; i < columns.length; i++) {
			
			this.updateCheckboxState(i, columns[i]);
		}
	},
	
	addLabelCell: function(tr, index, label) {
		
		var td = document.createElement('td');
		td.id = this.idPrefix + ':' + index + ':table_label';
		td.className = 'label';
		
		if (this.isTable) {
			td.style.paddingLeft = '14px';
		}
		
		var text = document.createTextNode(label);
		
		util.chainE(tr, td, text);
	},
	
	
	addCheckboxCell: function(tr, index, type, label) {
		
		var td = document.createElement('td');
		
		var id = this.idPrefix + ':' + index + ':' + type;
		
		var input = document.createElement('input');
		input.id = id;
		input.type = 'checkbox';
		
		if (!util.userAgent.isIE) {
			// Give checkbox default margin
			input.style.margin = '3px';
		}
		
		td.appendChild(input);
		
		if (label != '') {
			
			var labelElement = document.createElement('label');
			labelElement.htmlFor = id;
			var text = document.createTextNode(' ' + label);
			labelElement.appendChild(text);
			
			td.appendChild(labelElement);
		}
	
		tr.appendChild(td);
	},
	
	addEmptyCell: function(tr) {
		
		var td = document.createElement('td');
		tr.appendChild(td);
	}
	
};









