/* global convertProfile: false */

var profilesFilter = (function() {

	'use strict';

	var YE = YAHOO.util.Event,

	 	profilesDb = [], // Reference to profiles.profilesDb
	 	searchElement = null,
	 	clearSearchBtnId = '',
	 	count = 0,

	 	onSearchCallback = null,

	 	searchResults = [],

	 	isVisiblePlaceholder = false,

		activeFilterResultId = '';

	function init(obj) {

		profilesDb = obj.profilesDb;
		searchElement = util.getE(obj.searchElementId);

		if (obj.hasOwnProperty('clearSearchBtnId')) {
			clearSearchBtnId = obj.clearSearchBtnId;
			YE.addListener(clearSearchBtnId, 'click', _clearSearch);
		}

		// Clear input field
		util.setF(searchElement, '');

		onSearchCallback = obj.onSearchCallback;

		YE.addListener(searchElement, 'focus', _handlePlaceholderFocus);
		YE.addListener(searchElement, 'blur', _handlePlaceholderBlur);
		YE.addListener(searchElement, 'keyup', _searchActivated);
		_setPlaceholder();
	}

	function _searchActivated(evt) {

		// Increment count
		var newCount = count + 1;
		count = newCount;

//		util.showObject({searchActivatedFun: count});
		setTimeout(function() {_search(newCount);}, 200);
	}

	function _search(newCount) {

		// Only update when typing is paused
		if (count === newCount) {

			var searchText = searchElement.value;
			searchText = searchText.toLowerCase();

			if (searchText.length > 0 && clearSearchBtnId !== '') {
				util.showE(clearSearchBtnId);
			}

			var searchResultId = '_' + searchText + '_';

			activeFilterResultId = searchResultId;

			var searchResult = searchResults[searchResultId];

			// Create new search result if it doesn't yet exist
			if (typeof searchResult === 'undefined') {

//				console.log(searchResultId + ': CREATE NEW SEARCH RESULT');
//				util.showObject({b: '_search() - count: ' + count + ' - searchText: ' + searchText + ' CREATE NEW SEARCH RESULT'});

				// Check from which list we start the search, i.e. a list with less items in it if the current searchText matches an existing searchText
				// Set temp sourceSearchResultId
				var sourceSearchResultId =_getSourceSearchId(searchText);
				searchResult = _getNewSearchResult(sourceSearchResultId, searchText);
				searchResults[searchResultId] = searchResult;
			}
//			else {
//
//				console.log(searchResultId + ': USE EXISTING SEARCH RESULT');
//			}

			onSearchCallback(searchResult);
		}
	}

	function _getSourceSearchId(searchText) {

		/* This checks if there is already a search result with less letters
		of the current searchText. I.e., if the searchText is "apache"
		then we check if there is already a search result as follows:
		check for "apach", if search result exists then use this as source for the next search
		else check for "apac", if search result exists then use this as source for the next search
		else check for "apa", if search result exists then use this as source for the next search
		else check for "ap", if search result exists then use this as source for the next search
		else check for "a", if search result exists then use this as source for the next search
		else use the initial search result in "__", which contains all formats.
		*/

		// util.showObject({__getSourceSearchId: 'searchText: ' + searchText});
		var sourceSearchResultId = "__"; // initial search result

		for (var i = searchText.length - 1; i > 0; i--) {

			var id = '_' + searchText.substring(0, i) + '_';
			// util.showObject({__id: 'checking search result for id: ' + id});

			if (searchResults[id] != null) {
				// Got an existing search result which we can use
				sourceSearchResultId = id;
				break;
			}
		}

		// util.showObject({__id: 'final sourceSearchResultId: ' + sourceSearchResultId});

		return sourceSearchResultId;
	}

	function _getNewSearchResult(sourceSearchResultId, searchText) {

		// sourceSearchResult is the search result from which we start the search.
		// It may contain all log formats or only a few onces if there exists
		// a search result which matches the current searchText.

		// alert('sourceSearchResultId: ' + sourceSearchResultId);

		var sourceItems;

		if (sourceSearchResultId === '__') {

			sourceItems = profilesDb;
		}
		else {

			sourceItems = searchResults[sourceSearchResultId];
		}

		// util.showObject(sourceSearchResult, 'IT FOLLOWS THE sourceSearchResult OBJECT'

		var searchResult = [];
		var numFoundItems = 0;

		for (var i = 0, len = sourceItems.length; i < len; i++) {

			var item = sourceItems[i];
			var label = item[1];
			var labelLowercase = label.toLowerCase();

			if (labelLowercase.indexOf(searchText) !== -1) {
				searchResult[numFoundItems] = item;
				numFoundItems++;
			}

//			var theLabel = sourceSearchResultLables[i];
//			var posOfSearchText = theLabel.indexOf(searchText);
//
//			if (posOfSearchText != -1) {
//
//				if (posOfSearchText === 0) {
//					// This log format starts with searchText
//					labelsA[numOfA] = theLabel;
//					indexesA[numOfA] = sourceSearchResultIndexes[i];
//					numOfA++;
//				}
//				else {
//					// This log format contains the searchText somewhere after the 1st character
//
//					labelsB[numOfB] = theLabel;
//					indexesB[numOfB] = sourceSearchResultIndexes[i];
//					numOfB++;
//				}
//			}
		}

//		var labels = labelsA.concat(labelsB);
//		var indexes = indexesA.concat(indexesB);
//		var numOfItems = numOfA + numOfB;
//		var searchResult = {labels: labels, indexes: indexes, numOfItems: numOfItems};

//		util.showObject(searchResult, 'searchResult');

		return searchResult;
	}

	function _clearSearch(evt) {

		activeFilterResultId = '';

		searchElement.value = '';
		searchElement.focus();

		onSearchCallback(profilesDb);
	}

	function _handlePlaceholderFocus(evt) {

		if (isVisiblePlaceholder) {

			// Clear placeholder
			this.value = '';
			this.className = '';
			isVisiblePlaceholder = false;
		}
	}

	function _handlePlaceholderBlur(evt) {

		if (this.value === '') {
			_setPlaceholder();
		}
	}

	function _setPlaceholder() {

		searchElement.className = 'placeholder';
		searchElement.value = langVar('lang_stats.general.filter_profiles_by');

		if (clearSearchBtnId !== '') {
			util.hideE(clearSearchBtnId);
		}

		isVisiblePlaceholder = true;
	}

	function getActiveFilterText() {
		return activeFilterText;
	}

	function getFilteredProfilesDb() {

		var isFilterd = (activeFilterResultId !== ''),
			filteredProfilesDb = isFilterd ? searchResults[activeFilterResultId] : [];

		return {
			isFiltered: isFilterd,
			filteredProfilesDb: filteredProfilesDb
		}
	}


	// Return global properties and methods
	return {
		init: init,
		getFilteredProfilesDb: getFilteredProfilesDb
	};

}());
