//
// filterGropup - global filter group handling and editor
// used in reports and in scheduler.
//

/* global
	globalFilter: false */


var filterGroupEditor = (function() {

	var YE = YAHOO.util.Event,
		YD = YAHOO.util.Dom,
		panel = null,
		validator = null,

		// The callee object
		calleeObj = null,
	
		// active filter group properties
		id = '',
		isNew = false,
		isSaveCheckedAsNewGroup = false;

	function init() {

		var panelObj = {
			panelId:'filter_group:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 70,
			top: 120,
			zIndex: 40,
			isCover: true,
			closeEvent: _close
		};

		panel = new util.Panel3(panelObj);
		validator = new util.Validator();

		YE.addListener('filter_group:label', 'keypress', _saveGroupViaEnter);

		YE.addListener('filter_group:ok_btn', 'click', _saveGroup);
		YE.addListener('filter_group:cancel_btn', 'click', _close);
	}

	function open(itemId, groupLabel, _isNew, _isSaveCheckedAsNewGroup, _calleeObj) {

		id = itemId;
		isNew = _isNew;
		isSaveCheckedAsNewGroup = _isSaveCheckedAsNewGroup;

		calleeObj = _calleeObj;

		var panelHeaderLabel;

		if (!isNew && !isSaveCheckedAsNewGroup) {
			panelHeaderLabel = langVar('lang_stats.global_filter.edit_group');
		}
		else if (isSaveCheckedAsNewGroup) {
			panelHeaderLabel = langVar('lang_stats.global_filter.save_checked_as_group');
		}
		else {
			panelHeaderLabel = langVar('lang_stats.global_filter.new_group');
		}

//		globalFilter.disableForm();

		// set the form
		util.setF('filter_group:label', groupLabel);

		// Get panel position (reports : scheduler)
		var region = YD.getRegion(calleeObj.container);
		var left = region.left + 60;
		var top = region.top - 45;

		panel.open({
			label: panelHeaderLabel,
			left: left,
			top: top
		});

		var element = util.getE('filter_group:label');
		element.focus();
	}


	function _close() {

		validator.reset();
		panel.close();

//		globalFilter.enableForm();
	}

	function _saveGroupViaEnter(event) {

		var keyCode = (event.which) ? event.which : event.keyCode;
		if (keyCode == 13 || keyCode == 3) {
			_saveGroup();
		}
	}

	function _saveGroup() {

		// alert('save group');

		// Validate group name
		var groupLabelItems = _getGroupValuesByKey('label', id);

		var groupLabel = validator.isValue('filter_group:label');
		groupLabel = validator.isUnique('filter_group:label', groupLabelItems);

		if (validator.allValid()) {

			// get unique node name
			var groupNameItems = _getGroupValuesByKey('name', id);
			var groupName = util.labelToUniqueNodeName(groupLabel, groupNameItems, 'filter_group');

			if (isSaveCheckedAsNewGroup) {

				calleeObj.saveCheckedAsNewGroupProcessing(groupName, groupLabel);

			}
			else {

				calleeObj.saveFilterGroup(id, groupName, groupLabel, isNew);
			}

			_close();
		}
	}

	function _getGroupValuesByKey(key, activeItemId) {

		// Create an array of group labels or group names with all labels/names, except for activeItemId.
		// activeItemId is empty '' for new groups

		var filterItems = calleeObj.filterItems;

		var a = [];

		for (var i = 0, len = filterItems.length; i < filterItems.length; i++) {

			var item = filterItems[i];

			if (item.isGroup && item.id !== activeItemId) {

				a.push(item[key]);
			}
		}

		return a;
	}

	// Return global properties and methods
	return {
		init: init,
		open: open
	};

}());


