/* global profilesStorage: false */

var reportsConfigNavbar = function() {
	
	var YE = YAHOO.util.Event;

	var isActiveProfilesMenu = false;
	var isReports = false;
	var pageToken = '';
	var activePage = '';
	var baseHref = '';
	var container = null;
	var profilesDb = [];
	var activeProfileName = '';

	function init(isReportsPage) {

		isReports = isReportsPage;

		var navInfo = {
			containerId: 'reports_config_navbar',
			btnActiveClassName: 'active',
			menuBaseIds: [
			'rc_nav_profiles',
			'rc_nav_config',
			'rc_nav_tools',
			'rc_nav_view_reports',
			'rc_nav_admin'],
			events: {
				rc_nav_profiles: reportsConfigNavbar.initProfilesMenu
			}
		};

		new util.NavGroup(navInfo);
	}

	function initProfilesMenu() {

		if (!isActiveProfilesMenu) {

			isActiveProfilesMenu = true;

			// Init the scrollControl
//			scrollControl = new scrollUtil.Scroller('rc_nav_profiles:container', 'rc_nav_profiles:profiles_container', reportsConfigNavbar.scrollingList);

			// Init scroll animation to reset scroll position to 0
			// scrollResetAnim = new YAHOO.util.Scroll('matching_files:box', attributes, 0.1);

			if (isReports) {

				pageToken = reportInfo.pageToken;
				activePage = 'statistics';
				activeProfileName = reportInfo.profileName;
				baseHref = '?dp=reports&p=';
			}
			else {
				pageToken = pageInfo.pageToken;
				activePage = pageInfo.page;
				activeProfileName = pageInfo.profileName;
				baseHref = '?dp=config&page=' + pageInfo.page + '&p=';
			}

			container = util.getE('rc_nav_profiles:profiles_container');

			// Get the profilesDb
			profilesDb = profilesStorage.get('profilesDb');

			if (typeof profilesDb !== 'undefined') {

				// Create the menu
				createProfilesList(profilesDb);

				// Set profileList to fixed width so that it doesn't
				// change upon search.
				var profilesMenuEl = util.getE('rc_nav_profiles:menu');
				var region = YAHOO.util.Dom.getRegion(profilesMenuEl);
				profilesMenuEl.style.width = region.width + 'px';
			}


			// Load fresh data in background if necessary
			if (!profilesStorage.getIsUpToDate() ||
				typeof profilesDb === 'undefined') {

				getProfileData();
			}

			// Init profilesFilter
			profilesFilter.init({
				profilesDb: profilesDb,
				searchElementId: 'rc_nav_profiles:search',
				clearSearchBtnId: '',
				onSearchCallback: reportsConfigNavbar.createProfilesList
			});
		}
	}

	function getProfileData() {

		var url = '?dp=util.profiles.get_profile_data';
		url += '&p=' + activeProfileName;

        var dat = 'v.fp.page_token=' + pageToken;
		dat += '&v.fp.active_page=' + activePage;
		dat += '&v.fp.response_function=reportsConfigNavbar.getProfileDataResponse';
		dat += '&v.fp.get_new_checksum=true';
        dat += '&v.fp.index_from=0';
        dat += '&v.fp.index_to=-1';

        util.serverPost(url, dat);
	}

	function getProfileDataResponse(dat) {

//		console.log('checkProfilesDataResponse()');
//		util.showObject(dat);

		var profilesDb = dat.profilesDb;

		profilesStorage.addNewProfilesDb(
			dat.profilesListChecksum,
			dat.numAllProfiles,
			dat.numPermittedProfiles,
			profilesDb);

		createProfilesList(profilesDb);
	}

	function createProfilesList(theProfiles) {

//		util.showObject(theProfiles);

		// Check whether the list is filtered.
		var isAllProfiles = theProfiles.length === profilesDb.length;

//		console.log('isAllProfiles: ' + isAllProfiles);

//		util.removeChildElements(container);

		var ul = util.createE('ul', {className:'drop-down-10 drop-down-10-inline'});

		var list = '<ul class="drop-down-10 drop-down-10-inline">';

		// Show Admin/Profiles link in profiles list when list is not filtered
		if (isAllProfiles) {

			list += '<li>';
			list += '<a href="?dp=index&page=profiles">' + langVar('lang_stats.btn.admin_profiles') + '</a>';
			list += '</li>';
		}

		for (var i = 0, len = theProfiles.length; i < len; i++) {

			var item =  profilesStorage.profileArrayItemToObject(theProfiles[i]);
			var profileName = item.name;
			var profileLabel = item.label;
			var defaultDateFilter = item.df;

			var href = baseHref + profileName;

			// Add default data filter in reports if defined

			if (isReports && defaultDateFilter !== '') {
				href += '&df=' + defaultDateFilter;
			}

//			var li = util.createE('li');
//			var a = util.createE('a', {href: href});
//			var txt = util.createT(profileLabel);
//			util.chainE(ul, li, a, txt);
			list += '<li>';
			list += '<a href="' + href + '">' + profileLabel + '</a>';
			list += '</li>';

		}

		list += '</ul>';

//		util.chainE(container, ul);

		container.innerHTML = list;
	}

	//
	//
	// Return global properties and methods
	//
	//
	
	return {
		init: init,
		initProfilesMenu: initProfilesMenu,
		getProfileDataResponse: getProfileDataResponse,
		createProfilesList: createProfilesList
	}
}();
