#!/usr/bin/perl
#
# This runs Sawmill tasks, N at a time, starting a new one when each one terminates.
# It is useful for building databases for multiple profiles quickly, on multiprocessor systems.

use strict;
use POSIX ":sys_wait_h";

# The location of LogAnalysisInfo
my $laidir = "LogAnalysisInfo";

# The pathname of Sawmill
my $sawmill = "./sawmill";

# Get the profiles list, by looking in the profiles directory
#my @profiles = ( `ls -1 $laidir/profiles | fgrep -v 'default_profile.cfg' | fgrep -v '~' | sed 's/\.cfg//g'` );
my @profiles = ( `$sawmill -a lp -v e` );

# Data of this script is written to this file.
my $logfile = "multisawmill.log";

# This is the maximum number of simultaneous processes.
my $max_threads = 4;

# Sawmill will be run with these options (e.g., "-a bd").
my $options = "-a pv";

##=================================================================
## It is probably not necessary to modify anything below this line

my $parentpid = $$;

open(LOGFILE, ">>$logfile") || die("Can't open $logfile: $!");

# This subroutine write a line to the log.
sub LOG {

    my ($line) = @_;
    my $timestamp = `date`;
    chomp $timestamp;
    my $loggedline;
    $loggedline .= $timestamp;
    $loggedline .= ": ";
    if ($$ == $parentpid) {
        $loggedline .= "[parent]: ";
    }
    else {
        $loggedline .= "[$$]: ";
    }
    $loggedline .= $line;
    print LOGFILE "$loggedline\n";
#    print "$loggedline\n";

} # LOG

# Display the profiles we're about to run
my $profile;
my $starting_line = "================= STARTING BUILDS OF XREF GROUPS: ";
foreach $profile ( @profiles ) {
    $starting_line .= " $profile";
}
LOG $starting_line;

# Keep the specified number of threads running.
my $active_threads = 0;
foreach $profile ( @profiles ) {

    chomp($profile);

    my $childpid = fork();

    # If we are the parent...
    if ($childpid) {

        # We now have another active thread.
        $active_threads++;

        # If there are too many active to start another one now, wait for one to complete.
        if ($active_threads >= $max_threads) {
            LOG "Too many threads active to start another; waiting for a child to complete...";
            my $waitret = wait();
            $active_threads--;
            LOG "Child $waitret has completed; now active_threads=$active_threads";
        }

        LOG "forked new process $childpid";
        next;

    } # if we are parent

    # If we are the child...
    else {

        # Run the command, and log its output
        LOG "Rebuilding profile $profile using process with pid=$$";
        my $command = "$sawmill -p $profile $options";
        LOG "Running: $command";
#        print "Running: $command\n";
        open(COMMAND, "$command|") || die("Can't run '$command': $!");
        while (<COMMAND>) {
            chomp $_;
            LOG "Command output: $_";
        }

	# Get and log the results
        my $command_result = close(COMMAND);
        LOG "Result of '$command': $command_result";

        LOG "DONE rebuilding profile $profile using process with pid=$$";

        exit();

    } # else

} # foreach profile

LOG "Done spawning all processes\n";

close LOGFILE;
