//
// updateBuildDatabase
//
var updateBuildDatabase = function() {
	var YE = YAHOO.util.Event;
	var GD = {
		confirmPanel: null,
		alertPanel: null,
		isUpdateDatabase: true,
		isRealTimeProcessing: false,
		initialBuildDone: false,
		databaseIsReadyForReporting: false,
		databaseInfoIsVisible: false
		/*
		isRealTimeProcessing: false,
		isActiveSnaponOperation: false,
		databaseIsBuilding: false,
		initialBuildDone: false,
		databaseIsReadyForReporting: false,
		lastDatabaseInfoTime: -1 // the time profile info data have been updated
		*/
	};
	function init() {
		util.showE('loading_info');
		GD.isUpdateDatabase = pageInfo.page == 'update_database';
		YE.addListener('start_database_operation_btn', 'click', updateBuildDatabase.prepareDatabaseOperation);
		// init progress.js
		progress.init({
			// decimalDivider: pageInfo.decimalDivider,
			isCancelTaskPermission: pageInfo.permissions.isCancelTask,
			profileName: pageInfo.profileName,
			calleeListener: updateBuildDatabase.progressListener,
			isPanel: true
		});
		// init confirmPanel
		var panelObj = {
			panelId: 'update_build_database:confirm_panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.database.confirm_build_database'), 
			left: 316,
			top: 160,
			zIndex: 40,
			isCover: true,
			// isSticky: true,
			closeEvent: updateBuildDatabase.cancelDatabaseOperation
		};
		GD.confirmPanel = new util.Panel3(panelObj);
		YE.addListener('update_build_database:confirm_panel:yes_btn', 'click', startDatabaseOperation);
		YE.addListener('update_build_database:confirm_panel:no_btn', 'click', cancelDatabaseOperation);
		getDatabaseInfoData();
	}
	function getDatabaseInfoData() {
		var url = '?dp=templates.util.database_info.get_database_info_data';
		url += '&p=' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.client_response_function=updateBuildDatabase.getDatabaseInfoDataResponse';
		util.serverPost(url, dat);
	}
	function getDatabaseInfoDataResponse(dat) {
		databaseInfoUtil.updateDatabaseInfo(dat);
		var isRealTimeProcessing = dat.isRealTimeProcessing;
		var isActiveSnaponOperation = dat.isActiveSnaponOperation;
		var databaseIsBuilding = dat.databaseIsBuilding;
		var initialBuildDone = dat.initialBuildDone;
		var databaseIsReadyForReporting = dat.databaseIsReadyForReporting;
		GD.isRealTimeProcessing = isRealTimeProcessing;
		GD.initialBuildDone = initialBuildDone;
		GD.databaseIsReadyForReporting = databaseIsReadyForReporting;
		var enableStartDatabaseOperationBtn = false;
		var showNoDatabaseBuildInfo = !isRealTimeProcessing  ? (!databaseIsBuilding && !initialBuildDone) : !databaseIsReadyForReporting;
		util.showE('update_build_database:no_database_build_info', showNoDatabaseBuildInfo);
		if (!GD.databaseInfoIsVisible) {
			util.hideE('loading_info');
			util.showE('update_build_database:box');
			GD.databaseInfoIsVisible = true;
		}
		if (!isRealTimeProcessing) {
			if (isActiveSnaponOperation || databaseIsBuilding) {
				// Start progress
				var progressType;
				var mainLabel;
				if (isActiveSnaponOperation) {
					progressType = 'snapon';
					mainLabel = langVar('lang_stats.database.snapon_operation_active');
				}
				else {
					progressType = 'database';
					mainLabel = langVar('lang_stats.database.database_operation_active');
				}
				// Start progress
				progress.startProgress({
					progressType: progressType,
					mainLabel: mainLabel,
					updateMainLabel: true,
					mainInfo: langVar('lang_stats.progress.receiving_progress_information'),
					updateMainInfo: true
				});
			}
			else {
				// Allow to build the database
			    enableStartDatabaseOperationBtn = true;
			}
		}
		else {
			// Realtime processing
			if (!databaseIsReadyForReporting || !GD.isUpdateDatabase) {
				// Enable Update/Build Database button
				enableStartDatabaseOperationBtn = true;
			}
			// Refresh Database Info every 10 seconds
			setTimeout('updateBuildDatabase.getDatabaseInfoData()', 5000);
		}
		util.enableE('start_database_operation_btn', enableStartDatabaseOperationBtn);
	}
	function prepareDatabaseOperation() {
		util.disableE('start_database_operation_btn');
		if (GD.isUpdateDatabase || 
			(!GD.isRealTimeProcessing && !GD.initialBuildDone) ||
			(GD.isRealTimeProcessing && !GD.databaseIsReadyForReporting)) {
			startDatabaseOperation();
		}
		else {
			// Confirm Build Database
			GD.confirmPanel.open();
		}
	}
	function cancelDatabaseOperation() {
		// Build database not confirmed
		GD.confirmPanel.close();
		util.enableE('start_database_operation_btn');
	}
	function startDatabaseOperation() {
		util.hideE('update_build_database:no_database_build_info');
		var mainLabel;
		var mainInfo;
		var url;
		if (GD.isUpdateDatabase) {
			url = '?dp=update_database.start_update_database';
			mainLabel = langVar('lang_stats.database.updating_database');
			mainInfo = langVar('lang_stats.database.updating_database_initiated_please_wait');
		}
		else {
			GD.confirmPanel.close();
			url = '?dp=build_database.start_build_database';
			mainLabel = langVar('lang_stats.database.building_database');
			mainInfo = langVar('lang_stats.database.building_database_initiated_please_wait');
		}
		// Start progress
		progress.startProgress({
			progressType: 'simple',
			mainLabel: mainLabel,
			updateMainLabel: false,
			mainInfo: mainInfo,
			updateMainInfo: false
		});
		url += '&p=' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.client_response_function=' + 'updateBuildDatabase.starDatabaseOperationResponse';
		util.serverPost(url, dat);
	}
	function starDatabaseOperationResponse(dat) {
		// util.showObject(dat);
		var errorMessage = dat.errorMessage;
		if (errorMessage == '') {
			var mainLabel;
			var mainInfo;
			if (GD.isUpdateDatabase) {
				mainLabel = langVar('lang_stats.database.updating_database');
				mainInfo = langVar('lang_stats.database.updating_the_database_please_wait');
			}
			else {
				mainLabel = langVar('lang_stats.database.building_database');
				mainInfo = langVar('lang_stats.database.building_the_database_please_wait');
			}
			// Start progress
			progress.startProgress({
				progressType: 'database',
				taskId: dat.taskId,
				mainLabel: mainLabel,
				updateMainLabel: false,
				mainInfo: mainInfo,
				updateMainInfo: false
			});
		}
		else {
			// show error message
			alert(errorMessage);
			progress.close();
		}
	}
	function progressListener(senderState) {
		// This is called from progress.js
		// alert('progressListener() senderState: ' + senderState);
		getDatabaseInfoData();
		progress.close();
	}
	//
	// Return global properties and methods
	//
	return {
		init: init,
		getDatabaseInfoData: getDatabaseInfoData,
		getDatabaseInfoDataResponse: getDatabaseInfoDataResponse,
		prepareDatabaseOperation: prepareDatabaseOperation,
		cancelDatabaseOperation: cancelDatabaseOperation,
		startDatabaseOperation: startDatabaseOperation,
		starDatabaseOperationResponse: starDatabaseOperationResponse,
		progressListener: progressListener
	}
}();
// KHP 31/Aug/2011 - moved onDOMReady to HTML so that init only runs when user has access rights
// YAHOO.util.Event.onDOMReady(updateBuildDatabase.init);
