/* global
	profilesDashboard: false */

var database = (function() {

	'use strict';

	var YE = YAHOO.util.Event,
		YD = YAHOO.util.Dom,

		databasePanel = null,
		panelHeader = null,
		panelBody = null,
		panelWidth = 450,

//		updateBtn = null,
//		buildBtn = null,
//		cancelTaskBtn = null,

		activeProfileName = '',
		activeTaskId = '',

		// activeOperation: update | build
		activeOperation = '',

		rowElement = null;

	function init() {

		databasePanel = util.getE('profiles_database_panel');
		databasePanel.style.width = panelWidth + 'px';

		panelHeader = util.getE('profiles_database_header');
		panelBody = util.getE('profiles_database_body');

//		updateBtn = util.getE('profiles:update_database_btn');
//		buildBtn = util.getE('profiles:build_database_btn');

		YE.delegate(panelHeader, 'click', function(evt) {

			var element = evt.target || evt.srcElement;
			var elementId = element.id;

			// console.log('elementId: ' + elementId);

			if (elementId === 'profiles:close_database_panel_btn') {
				closePanel();
			}
			else if (elementId === 'profiles:update_database_btn') {
				updateDatabase();
			}
			else {
				buildDatabase();
			}

		}, 'a');
	}

	function closePanel() {

		// This closes any active database info / progress panel.
		// It is called i.e. when editing the dashboard.

		if (activeProfileName !== '') {

			databasePanel.style.display = 'none';
			activeProfileName = '';
			activeOperation = '';
			rowElement.className = '';
		}
	}

	function toggleDatabaseMenu(btnElement, profileName) {

		// Init database
		if (databasePanel === null) {
			init();
		}

		if (profileName === activeProfileName) {

			// Close active panel
			closePanel();
		}
		else {

			// Close panel so that any selected row becomes deselected
			closePanel();

			// Select the table row

			// Get row
			rowElement = btnElement;

			while (rowElement.nodeName !== 'TR') {
				rowElement = rowElement.parentNode;
			}

			rowElement.className = 'active';

			// Show database panel for given profileName
			// Hide all buttons
//			updateBtn.style.display = 'none';
//			buildBtn.style.display = 'none';

			setPanelHeader();
			panelBody.innerHTML = '<p>Loading ...</p>';

			setPanelPosition(btnElement);

			getDatabaseInfo(profileName);

			databasePanel.style.display = 'block';

			activeProfileName = profileName;
		}
	}

	function getDatabaseInfo(profileName) {

		var url = '?dp=templates.util.database_info.get_database_info_data';
		url += '&p=' + profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.client_response_function=database.getDatabaseInfoResponse';
		util.serverPost(url, dat);
	}

	function getDatabaseInfoResponse(dat) {

//		util.showObject(dat);
		// Make sure that we are still on the same profile
		if (dat.profileName === activeProfileName) {

			var content = '';
			var	dbState = 0;
			var panelHeaderType = '';
			var dbOperationCompleted = false;

			if (dat.databaseIsBuilding) {

				activeTaskId = dat.taskId;
				getProgressState();

				// Get progress data
				content += '<p>' + langVar('lang_stats.database.database_is_updating_building') + '</p>';
				content += '<p>' + langVar('lang_stats.general.receiving_progress') + '</p>';

				dbState = 1;
			}
			else if (dat.dbBuilt) {

				// Show database info

//				updateBtn.style.display = (activeOperation === '') ? 'block' : '';
				if (activeOperation === '') {
					panelHeaderType = 'update';
				}
				else if (activeOperation === 'update') {
					// This must be a completed update
//					panelHeaderType = 'update_complete';
					content += '<p>' + langVar('lang_stats.database.update_completed') + '<p>';
					dbOperationCompleted = true;
				}
				else {
					// This must be a completed build
//					panelHeaderType = 'build_complete';
					content += '<p>' + langVar('lang_stats.build_completed') + '<p>';
					dbOperationCompleted = true;
				}

				content += '<p>' + langVar('lang_stats.database.database_last_modified') + ': ' + dat.dbLastModified + '<p>';
				content += '<p>' + dat.dbLastOperation + '</p>';
				content += '<p>' + langVar('lang_stats.database.earliest_log_entry') + ': ' + dat.dbErliestDateTime + '</p>';
				content += '<p>' + langVar('lang_stats.database.latest_log_entry') + ': ' + dat.dbLatestDateTime + '</p>';

				dbState = 2;
			}
			else {

				// Not yet built.

//				buildBtn.style.display = (activeOperation === '') ? 'block' : '';
				panelHeaderType = 'build';
				content += '<p>' + langVar('lang_stats.database.database_is_not_yet_built') + '</p>';

				dbState = 0;
			}

			setPanelHeader(panelHeaderType);
			panelBody.innerHTML = content;

			// Update dashboard
			profilesDashboard.updateDashboardItemDbState(
				activeProfileName,
				dbState,
				dat.dbLastModifiedEpoc,
				dbOperationCompleted);
		}
	}

	function updateDatabase() {

//		updateBtn.style.display = 'none';
		activeOperation = 'update';
		var url = '?dp=update_database.start_update_database';
		var text = langVar('lang_stats.database.updating_database_initiated_please_wait');
		updateBuildDatabase(url, text);
	}

	function buildDatabase() {

//		buildBtn.style.display = 'none';
		activeOperation = 'build';
		var url = '?dp=build_database.start_build_database';
		var text = langVar('lang_stats.database.building_database_initiated_please_wait');
		updateBuildDatabase(url, text);
	}

	function updateBuildDatabase(url, text) {

//		util.hideE('profiles:database_buttons');

		setPanelHeader();
		panelBody.innerHTML = '<p>' + text + '</p>';

		url += '&p=' + activeProfileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.client_response_function=' + 'database.updateBuildDatabaseResponse';

		util.serverPost(url, dat);

		// Update dashboard info
		profilesDashboard.updateDashboardItemDbState(activeProfileName, 1, 0, false);
	}

	function updateBuildDatabaseResponse(dat) {

		// Make sure that we are still on the same profile
		if (dat.profileName === activeProfileName) {

			if (dat.errorMessage === '') {

				// Get progress state
				activeTaskId = dat.taskId;
				getProgressState();
			}
			else {
				// An error occurred, show error message.
				// TODO - refine error handling
				panelBody.innerHTML = '<p>' + dat.errorMessage + '</p>';
			}
		}
	}

	function getProgressState() {

		// TODO - we may need to handle snapon progress too!

		var url = '?dp=progress.get_progress_state';
		url += '&p=' + activeProfileName;

		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.response_function=database.getProgressStateResponse';
		dat += '&v.fp.progress_type=database';
		dat += '&v.fp.task_id=' + activeTaskId;
		dat += '&v.fp.report_job_id=';

		// Use the profile_name for progress_id
		dat += '&v.fp.progress_id=' + activeProfileName;

		util.serverPost(url, dat);
	}

	function getProgressStateResponse(dat) {

		// Make sure that we are still on the same profile
		// Note, get_progress_state returns no profile_name
		// but we get it in progress_id.

		if (dat.progressId === activeProfileName) {

//			util.showObject(dat);

			var progressState = dat.progressState;

			switch (progressState) {

				case 'progress':

					// util.showE(['progress:step_label', 'progress:step_description']);

//					util.updateT('progress:main_label', dat.mainLabel);
//					util.updateT('progress:total_time_elapsed', dat.totalTimeElapsed);

					setProgressDisplay(dat.progress);

					// get progress state data
					setTimeout(function() {
						getProgressState();
					}, 1200);

					break;

				case 'progress_prediction':

					// get progress state data
					setTimeout(function() {
						getProgressState();
					}, 1200);

					break;

				case 'complete':

//					var content = '<p>Update/Build Database completed.</p>';
//					panelBody.innerHTML = content;

					// Get up to date database info data
					getDatabaseInfo(activeProfileName);
					break;

				case 'error':

					// Currently not active, the error is fired
					// by a Salang error() message right away in get_progress_state.cfv!
					alert('getProgressStateResponse() error');
					break;
			}
		}
	}

	function setProgressDisplay(dat) {

		// TODO - normalize progress data, i.e. handle subtasks
		// on server side response

		var content = '<p>' + dat.mainLabel + '</p>';
		content += '<p>' + langVar('lang_stats.progress.time_elapsed_label') + ': ' + dat.totalTimeElapsed + '</p>';

		if (dat.stepLabel !== '') {
			content += '<p>' + dat.stepLabel + '</p>';
		}

		if (dat.stepDescription !== '') {
			content += '<p>' + dat.stepDescription + '</p>';
		}

		panelBody.innerHTML = content;
	}

	function setPanelHeader(headerType) {

		headerType = headerType || '';

		var html = '<a id="profiles:close_database_panel_btn" href="javascript:;" class="database-panel-close">&times;</a>';

		if (headerType !== '') {

			if (headerType === 'update') {

				html += '<a id="profiles:update_database_btn" href="javascript:;">' + langVar('lang_stats.btn.update_database') + '</a>';
			}
			else if (headerType === 'build') {

				html += '<a id="profiles:build_database_btn" href="javascript:;">' + langVar('lang_stats.btn.build_database') + '</a>';
			}
		}

		panelHeader.innerHTML = html;
	}

	function setPanelPosition(btnElement) {

		// Set panel element position right or left from button element

		// clientRegion.top is equal scrollTop!
		var clientRegion = YD.getClientRegion();

//		util.showObject(clientRegion);

		var btnRegion = YD.getRegion(btnElement);
		var btnTop = btnRegion.top;
		var btnBottom = btnRegion.bottom;
		var btnLeft =  btnRegion.left;
		var btnRight =  btnRegion.right;

//		util.showObject(btnRegion);
		var panelTop = btnBottom + 5;
		var panelLeft = btnRight - panelWidth + 62;
		panelLeft = panelLeft > 70 ? panelLeft : 70;

//		if ((btnRight + panelWidth) <= clientRegion.right ||
//			(clientRegion.right - btnRight) >= btnLeft) {
//			// Position panel on right side of button
//			panelLeft = btnRight + 6;
//		}
//		else {
//			// Position panel on left side of button
//			panelLeft = btnLeft - panelWidth;
//			panelLeft = panelLeft >= 0 ? panelLeft : 0;
//		}

		databasePanel.style.top = panelTop + 'px';
		databasePanel.style.left = panelLeft + 'px';
//		databasePanel.style.right = panelRight + 'px';
	}

	// Return global properties and methods
	return {
		closePanel: closePanel,
		toggleDatabaseMenu: toggleDatabaseMenu,
		getDatabaseInfoResponse: getDatabaseInfoResponse,
		updateBuildDatabaseResponse: updateBuildDatabaseResponse,
		getProgressStateResponse: getProgressStateResponse
	};

}());
