/* global
	profiles: false,
	profilesStorage: false */

var duplicateProfile = (function() {

	'use strict';

	var panel = null;
	var validator = null;
	var sourceProfileName = '';
	var existingProfileLabels = [];
	var existingProfileNames = [];

	function init() {

		var YE = YAHOO.util.Event;

		var panelObj = {
			panelId: 'duplicate_profile:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_admin.profiles.duplicate_profile_title'),
			zIndex: 20,
			isCover: true,
			closeEvent: close
		};

		panel = new util.Panel3(panelObj);

		validator = new util.Validator();

		YE.addListener('duplicate_profile:ok_btn', 'click', duplicateAndSave);
		YE.addListener('duplicate_profile:cancel_btn', 'click', close);
	}

	function open(profileName, profileLabel) {

		if (panel === null) {
			init();
		}

		var profileInfoText = langVar('lang_admin.profiles.duplicate_profile_info') + ':';
		profileInfoText = profileInfoText.replace(/__PARAM__1/, profileLabel);

		util.updateT('duplicate_profile:info_text', profileInfoText);

		var defaultProfileLabel = langVar('lang_stats.general.item_copy');
		defaultProfileLabel = defaultProfileLabel.replace(/__PARAM__1/, profileLabel);
		util.setF('duplicate_profile:profile_label', defaultProfileLabel);

		// Set sourceProfileName
		sourceProfileName = profileName;

		// Reset existingProfileLabels and existingProfileNames
		existingProfileLabels = [];
		existingProfileNames = [];

		panel.prePositionAtCenter();
		panel.open();

		var inputElement = util.getE('duplicate_profile:profile_label');
		inputElement.focus();
	}

	function close() {

		validator.reset();
		panel.close();
	}

	function duplicateAndSave() {

		validator.reset();

		if (existingProfileLabels.length === 0) {

			// Get existingProfileLabels and existingProfileNames
			var profilesDb = profiles.getProfilesDb();
			for (var i = 0, len = profilesDb.length; i < len; i++) {
				var profileItem =  profilesStorage.profileArrayItemToObject(profilesDb[i]);
				existingProfileNames[i] = profileItem.name;
				existingProfileLabels[i] = profileItem.label;
			}
		}

//		util.showObject(existingProfileLabels);
//		util.showObject(existingProfileNames);

		var newProfileLabel = validator.isValue('duplicate_profile:profile_label');
		newProfileLabel = validator.isUnique('duplicate_profile:profile_label', existingProfileLabels);

		if (validator.allValid()) {

			close();
			util.hideE('profiles_profiles_list');
			util.showE('saving_info');

			var newProfileName = util.labelToUniqueNodeName(newProfileLabel, existingProfileNames, 'profile');

			// alert('newProfileName: ' + newProfileName);

			var url = '?dp=admin_pages.profiles.duplicate_profile';

			var dat = 'v.fp.page_token=' + pageInfo.pageToken;
			dat += '&v.fp.profiles_list_checksum=' + pageInfo.profilesListChecksum;
			dat += '&v.fp.source_profile_name=' + sourceProfileName;
			dat += '&v.fp.new_profile_name=' + newProfileName;
			dat += '&v.fp.new_profile_label=' + encodeURIComponent(newProfileLabel);

			util.serverPost(url, dat);
		}
	}

	function duplicateAndSaveResponse(dat) {

		// Reset userGrants
		profilesUtil.resetUserGrants(dat.userGrants);

		// util.showObject(dat);
		profiles.handleNewProfile(dat.profileChanges);

		var errorMessage = dat.errorMessage;

		if (errorMessage !== '') {
			alert(errorMessage);
		}
	}


	// Return global properties and methods
	return {
		open: open,
		duplicateAndSave: duplicateAndSave,
		close: close,
		duplicateAndSaveResponse: duplicateAndSaveResponse
	};

}());
