//
// logProcessing
//


var logProcessing = function() {

    var h = util.h;
    var YE = YAHOO.util.Event;
    var GD = { // General global data
	
        theList: null,
        itemsDb: [], // items work array
        itemsDbBackup: [], // items array in the state when first loaded or last saved, it is used upon Undo Changes

        validator: null,

        saveChangesBtn: null,
        undoAllChangesBtn: null,

        activeItemType: '',
        isPositionedDSListMoveControl: false
    };

    function init() {

        GD.validator = new util.Validator();

        // init distributed servers list and panel
        logProcessingDSList.init();
        logProcessingDS.init();

        // init toolbar buttons
       GD.saveChangesBtn = new util.ToolbarButton('save_changes', saveLogProcessing, toolbarButtonsDb);
       GD.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);

        var isEdit = pageInfo.permissions.isEdit;

        if (isEdit) {

            // Register isModifiedPageHandler in adminConfig.js
            // (We don't check for modifications if there is no edit
            // permission because there is no Save button anyway!)
            adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
        }
        else {

            GD.saveChangesBtn.disableAndIgnore();
            GD.undoAllChangesBtn.disableAndIgnore();
        }

        // Create theList object
        GD.theList = new listcontroller.List({
            containerElementId: 'item_list_body',
            itemEvent: itemActivated
        });

        // init OptionInfo
       optionInfo.init();

		YE.addListener('processing.skip_previously_seen_data_on_update', 'click', toggleSkipPreviouslySeenData);
        
        // toggleLogFieldSeparator
        YE.addListener(['format.field_separator:space', 'format.field_separator:tab', 'format.field_separator:custom'], 'click', toggleLogFieldSeparator);
        YE.addListener(['processing.output.field_delimiter:space', 'processing.output.field_delimiter:custom'], 'click', toggleOutputFieldDelimiter);
        
        // KHP 08/Dec/2010 - Distributed Processing exists only in enterprise
        if (pageInfo.licensingTier == 'enterprise') {
			YE.addListener('dlp:method', 'change', distributedMethodActor);
			YE.addListener('dlp:add_server_btn', 'click', logProcessingDS.newItem);
		}
    }

    function initMainItems() {

        // Sets all input controls to initial itemsDb values
        // Also used upon Undo Changes

        /*
            Init item list
        */

        var itemsDb = GD.itemsDb;

        // util.showObject(itemsDb);

        GD.theList.init(itemsDb);

        /*
            Init form data
        */

        for (var i = 0, l = itemsDb.length; i < l; i++) {

            var mainItem = itemsDb[i];
            var itemType = mainItem.type;
            var itemDat = mainItem.dat;

            // util.showObject(itemDat);

            switch (itemType) {

                case 'distributed_processing':

                    util.setF('dlp:method', itemDat.method);
                    util.setF('dlp:starting_port_auto', itemDat.starting_port_auto);
                    util.setF('dlp:number_of_servers', itemDat.number_of_servers);
                    util.setF('dlp:file_by_file', itemDat.file_by_file);

                    // Compose servers list
                    logProcessingDSList.list.compose(itemDat.servers);

                    setDistributedMethodDisplay(itemDat.method);
		
                    break;

                case 'charset_conversion':

                    convertCharset.update(
                        itemDat.convert_log_data_charset,
                        itemDat.convert_log_data_from_charset,
                        itemDat.convert_log_data_to_charset
                    );

                    break;

                default:
                    
                   setStandardItemDatValues(itemDat);
                   break;
            }
        }

		// Set initial processing.skip_processed_filenames state.
		toggleSkipPreviouslySeenData()

        setItem('i0');
    }
    
    
    function setStandardItemDatValues(itemDat) {
    	
    	// Sets standard itemDat form values per item
    	
    	 for (var i = 0, l = itemDat.length; i < l; i++) {

			// The itemPath is equal the item elementId

			var item = itemDat[i];
			var itemPath = item.itemPath;
			var itemValue = item.value;
			
			switch (itemPath) {
					
				case 'format.field_separator':

                    var pattern = /^\t$/; // tab
                    var elementId = '';
                    var isCustom = false;
                    var customValue = '';

					if (itemValue == '' || itemValue == ' ') {
						// Whitespace field_separator
                        elementId = 'format.field_separator:space';
					}
                    else if (pattern.test(itemValue)) {
                        // alert('format.field_separator is a tab!');
                        elementId = 'format.field_separator:tab';
                    }
					else {
						// Custom field_separator
                        elementId = 'format.field_separator:custom';
                        isCustom = true;
                        customValue = itemValue;
					}

                    util.setF(elementId, true);
                    util.setF('format.field_separator', customValue);
                    util.enableE('format.field_separator', isCustom);

					break;
					
				case 'processing.output.field_delimiter':
					
					 if (itemValue == ' ') {
					 	// Whitespace requires ' ', empty value shouldn't be possible
						util.setF('processing.output.field_delimiter:space', true);
						util.setF('processing.output.field_delimiter', '');
						util.disableE('processing.output.field_delimiter');
					 }
					 else {
					 	 // Custom field_separator
						util.setF('processing.output.field_delimiter:custom', true);
						util.setF('processing.output.field_delimiter', itemValue);
						util.enableE('processing.output.field_delimiter');
					 }
					
					break;
				
				default:
					
					util.setF(itemPath, itemValue);

					if (item.type == 'bytes') {

						// Set the bytes unit
						util.setF(itemPath + ':unit', item.bytesUnit);
					}

					break;
			}
		}
    }

    function initDistributedProcessingDisplay() {

        util.showE('dlp:listed:section');
        // Position the server list move control
        // We need to give it some time, else we don't get the right list position
        var s = 'dlp:server_list:div';
        setTimeout('logProcessingDSList.moveControl.setPosition("' + s + '")', 250);
    }
    
    function initLogFormatPluginInfo(pluginInfo) {
    	
    	var isStandaloneLogFormat = pluginInfo.type == 'standalone';
		
		function addLabels(elementId, item) {
			
			var mainLabel = item.label;
			util.updateT(elementId, mainLabel);
			
			var infoLabels = item.infoLabels;
			var numInfoLabels = infoLabels.length;
			
			if (numInfoLabels > 0) {
				
				// add one or more info labels in a lighter color
				infoLabels.sort();
				
				var element = util.getE(elementId);
				
				for (var i = 0; i < numInfoLabels; i++) {
					
					var br = util.createE('br');
					var span = util.createE('span', {color:'#666666'});
					var text = util.createT('- ' + infoLabels[i]);
					util.chainE([element, br, [span, text]]);
				}
			}
		}
		
		if (isStandaloneLogFormat) {
			
			addLabels('log_format_plugin_info:standalone', pluginInfo.standalone);
		}
		else {
			addLabels('log_format_plugin_info:syslog', pluginInfo.syslog);
			addLabels('log_format_plugin_info:syslog_required', pluginInfo.syslogRequired);
		};
		
		util.showE('log_format_plugin_info:standalone:tr', isStandaloneLogFormat);
		util.showE(['log_format_plugin_info:syslog:tr', 'log_format_plugin_info:syslog_required:tr'], !isStandaloneLogFormat);
    }

    function getLogProcessingData() {

        if (!pageInfo.exitActive) {

        	var url = '?dp=config_pages.log_processing.get_log_processing_data';
        	url += '&p=' + pageInfo.profileName;
        	var dat = 'v.fp.page_token=' + pageInfo.pageToken;

            util.helpWindow.init('');
		
            util.serverPost(url, dat);
        }
    }

    function getLogProcessingDataResponse(dat) {

        if (!pageInfo.exitActive) {

            // util.showObject(dat);

            // get itemsDb
            GD.itemsDb = dat.items;
            GD.itemsDbBackup = util.cloneObject(dat.items);

            init();
            convertCharset.init(dat.charset);
            initLogFormatPluginInfo(dat.logFormatPluginInfo);
            initMainItems();

            GD.saveChangesBtn.enable();
            GD.undoAllChangesBtn.enable();

            util.showE('form_section');
            // IE 7 requires the form_section to be displayed before setItemListSize()
			adminConfig.setItemListSize();
			YE.addListener(window, 'resize', adminConfig.setItemListSize);
			
			pageInfo.initComplete = true;
        }
    }

	function toggleSkipPreviouslySeenData() {

		// Enable processing.skip_processed_filenames_on_update only
		// if processing.skip_previously_seen_data_on_update is checked.

		var skipPreviouslySeenData = util.getF('processing.skip_previously_seen_data_on_update');

		if (!skipPreviouslySeenData) {
			// Make sure processing.skip_processed_filenames is not checked.
			util.setF('processing.skip_processed_filenames_on_update', false);
		}

		util.enableE('processing.skip_processed_filenames_on_update', skipPreviouslySeenData);
	}
    
    function toggleLogFieldSeparator() {
    	
    	var isCustom = util.getF('format.field_separator:custom');
    	util.enableE('format.field_separator', isCustom);
    	
    	if (isCustom) {
    		util.focusE('format.field_separator');
    	}
    }
    
    function toggleOutputFieldDelimiter() {
    	
    	var isCustom = util.getF('processing.output.field_delimiter:custom');
    	util.enableE('processing.output.field_delimiter', isCustom);
    	
    	if (isCustom) {
    		util.focusE('processing.output.field_delimiter');
    	}
    }
    
    function distributedMethodActor() {

        var method = util.getF('dlp:method');
        setDistributedMethodDisplay(method);
        checkDistributedMethodServerMoveControlPosition();
    }

    function setDistributedMethodDisplay(method) {

        // method is: one_processor | some_processors | all_processors | listed_servers

        // alert('setDistributedMethodDisplay() - method: ' + method);

        util.hideE(['dlp:starting_port_auto:section', 'dlp:number_of_servers:section', 'dlp:listed:section']);

        // Nothing is shown for one_processor!

        if (method == 'all_processors') {
            util.showE('dlp:starting_port_auto:section');
        }
        else if (method == 'some_processors') {
            util.showE('dlp:starting_port_auto:section');
            util.showE('dlp:number_of_servers:section');
        }
        else if (method == 'listed_servers') {
            util.showE('dlp:listed:section');
        }

        resetDistributedServerListError();
    }

    function checkDistributedMethodServerMoveControlPosition() {

        if (!GD.isPositionedDSListMoveControl &&
        (GD.activeItemType == 'distributed_processing') &&
        (util.getF('dlp:method') == 'listed_servers')) {

            // Position the server list move control
            // We need to give it some time, else we don't get the right list position
            var s = 'dlp:server_list:div';
            setTimeout('logProcessingDSList.moveControl.setPosition("' + s + '")', 250);
            GD.isPositionedDSListMoveControl = true;
        }
    }

    function resetDistributedServerListError() {

        util.hideE('dlp:server_list:error');
    }

    function itemActivated(itemId) {

        if (validateActiveItem()) {
            setItem(itemId);
        }
    }

    function setItem(itemId) {

        var theList = GD.theList;

        theList.selectItem(itemId);

        // display the form
        util.hideE([
            'log_processing:general:section',
            'log_processing:date_time:section',
            'log_processing:format_a:section',
            'log_processing:format_b:section',
            'log_processing:threads_and_sizes:section',
            'log_processing:output:section',
            'log_processing:distributed_processing:section',
            'log_processing:charset_conversion:section'
        ]);

        var item = theList.getSelectedItem();
        var itemType = item.type;
        util.updateT('item_form_label', item.label);

        GD.activeItemType = itemType;
        util.showE('log_processing:' + itemType + ':section');

        if (itemType == 'distributed_processing') {
            checkDistributedMethodServerMoveControlPosition();
        }
    }
    
    function validateActiveStandardItemDat(obj) {
    	
    	// obj is a clone of activeMainItemDat
    	
		var validator = GD.validator;
		
		for (var i = 0, l = obj.length; i < l; i++) {
                        
			var item = obj[i];
			// util.showObject(item);
			var itemPath = item.itemPath;
			var itemType = item.type;
			var itemValue;
			
			switch (itemPath) {

				case 'processing.skip_processed_filenames_on_update':

					// Checkbox is only enabled if 'processing.skip_previously_seen_data_on_update is true.
					itemValue = false;
					if (util.getF('processing.skip_previously_seen_data_on_update')) {
						itemValue = util.getF('processing.skip_processed_filenames_on_update');
					}

					break;
				
				case 'processing.date_offset':
					
					itemValue = util.getF('processing.date_offset');
					itemValue = (itemValue == 0 || itemValue == '') ? 0 : validator.isFloat('processing.date_offset', -23.9, 23.9);
					break;
					
				case 'format.field_separator':
					
					// Note, no value is equal space or any space
                    if (util.getF('format.field_separator:space')) {
                        itemValue = "";
                    }
                    else if (util.getF('format.field_separator:tab')) {
                        itemValue = "\t";
                    }
                    else {
                        itemValue = validator.isValue('format.field_separator');
                    }

					break;
					
				case 'processing.output.field_delimiter':
					
					// Output delimiter does not allow to be an empty value
					itemValue = util.getF('processing.output.field_delimiter:space') ? ' ' : validator.isValue('processing.output.field_delimiter');
					break;
				
				default:
					
					var isNumber = (itemType == 'integer' || itemType == 'float' || itemType == 'bytes');
					
					if (isNumber) {
						
						if (itemType == 'integer' || itemType == 'bytes') {
							
							// minValue and maxValue are optional, if not defined then they are simply ignored in isInteger()
							itemValue = validator.isInteger(itemPath, item.minValue, item.maxValue);
							
							if (itemType == 'bytes') {
								item.bytesUnit = util.getF(itemPath + ':unit');
							}
						}
						else {
							
							// minValue and maxValue are optional, if not defined then they are simply ignored in isFloat()
							itemValue = validator.isFloat(itemPath, item.minValue, item.maxValue);
						}
					}
					else {
						itemValue = util.getF(itemPath);
					}
					
					break;
			}
			
			item.value = itemValue;
		}
    }
    
    function validateDistributedProcOrCharsetCon(activeItemType, obj) {
    	
    	var validator = GD.validator;
    	var isDistributedServersListError = false;
    	
    	if (activeItemType == 'distributed_processing') {
    		
			// distributedMethod is: one_processor | some_processors | all_processors | listed_servers
	
			var distributedMethod = util.getF('dlp:method');
			var startingPortAuto = '';
			var numberOfServers = 2;
			var servers = logProcessingDSList.list.getItemsClone();
	
			// Keep the startingPortAuto value and numberOfServers value in all cases, if any, regardless of the distributedMethod
			if (distributedMethod == 'all_processors' || distributedMethod == 'some_processors') {
	
				startingPortAuto = validator.isValue('dlp:starting_port_auto');
	
				if (distributedMethod == 'some_processors') {
					// the minimum number_of_servers is 2
					numberOfServers = validator.isInteger('dlp:number_of_servers', 2);
				}
			}
			else {
	
				// Get startingPortAuto value
				startingPortAuto = util.getF('dlp:starting_port_auto');
	
				if (distributedMethod == 'listed_servers' && servers.length == 0) {
	
					// No servers defined, throw custom error message
					isDistributedServersListError = true;
					util.updateT('dlp:server_list:error', langVar('lang_admin.log_processing.distributed.no_server_defined_error_msg'));
					util.showE('dlp:server_list:error');
				}
			}
	
			obj.method = distributedMethod;
			obj.starting_port_auto = startingPortAuto;
			obj.number_of_servers = numberOfServers;
			obj.servers = servers;
			obj.file_by_file = util.getF('dlp:file_by_file');
				
    	}
    	else if (activeItemType == 'charset_conversion') {
    		
    		obj.convert_log_data_charset = util.getF('convert_charset');
			obj.convert_log_data_from_charset = util.getF('convert_from_list:charset');
			obj.convert_log_data_to_charset = util.getF('convert_to_list:charset');

			if (obj.convert_log_data_charset) {

				// validate charset

				if (obj.convert_log_data_from_charset == '' || obj.convert_log_data_to_charset == '') {

					validator.isCustom('convert_charset', langVar('lang_admin.charset_conversion.no_charsets_defined_msg'));
				}
				else if (obj.convert_log_data_from_charset == obj.convert_log_data_to_charset) {

					validator.isCustom('convert_charset', langVar('lang_admin.charset_conversion.duplicate_charset_msg'));
				}
			}
    	}
    	else {
    		// Just a reminder for dev
    		alert('Error in logProcessing.validateDistributedProcOrCharsetCon(), unkknown activeItemType: ' + activeItemType);
    	}
    	
    	return isDistributedServersListError;
    }

    function validateActiveItem() {

        // Only validate items if isEdit permission        
        
        if (pageInfo.permissions.isEdit) {

            var validator = GD.validator;
            validator.reset();
            resetDistributedServerListError();

            var theList = GD.theList;
            var activeMainItem = theList.getSelectedItem();
            var activeItemType = activeMainItem.type;
            var activeMainItemDat = activeMainItem.dat;
            var isDistributedServersListError = false;
            var obj;
            
            if (activeItemType != 'distributed_processing' && activeItemType != 'charset_conversion') {
            	
            	// Clone the active item dat and set its values. We do this due a different data structure,
				// respectively items are individual objects within an array.
				obj = util.cloneObject(activeMainItemDat);
//				util.showObject(obj);
            	validateActiveStandardItemDat(obj);
            }	
            else {
            	
				obj = {};
            	
            	isDistributedServersListError = validateDistributedProcOrCharsetCon(activeItemType, obj);
            }

            if (validator.allValid() && !isDistributedServersListError) {

                // util.showObject(o, 'validateActiveItem() before saveItem()');
                theList.saveItem(obj);
                return true;
            }

            return false;
        }
       
        // No edit permission
        return true;
    }

    function undoAllChanges() {

        GD.itemsDb = util.cloneObject(GD.itemsDbBackup);
        initMainItems();
    }

    function saveLogProcessing() {

        if (validateActiveItem()) {

            var isModified = GD.theList.getIsModified();

            if (isModified) {

                util.hideE('form_section');
                util.showE('saving_info');

                var itemsDb = GD.itemsDb;
                var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
				dat += 'v.fp.profiles_list_checksum=' + profilesStorage.get('profilesListChecksum') + '&';

                var j;

                for (var i = 0, l = itemsDb.length; i < l; i++) {

                    var mainItem = itemsDb[i];
                    var itemType = mainItem.type;
                    var itemDat = mainItem.dat;

                    switch(itemType) {

                        case 'distributed_processing':

                            // util.showObject(itemDat);

                            dat += 'v.fp.processing.distributed.method=' + itemDat.method + '&';
                            dat += 'v.fp.processing.distributed.starting_port_auto=' + encodeURIComponent(itemDat.starting_port_auto) + '&';
                            dat += 'v.fp.processing.distributed.number_of_servers=' + itemDat.number_of_servers + '&';
                            dat += 'v.fp.processing.distributed.file_by_file=' + itemDat.file_by_file + '&';

                            var distributedServers = itemDat.servers;

                            if (distributedServers.length > 0) {

                                var NumDistributedServers = distributedServers.length;

                                for (j = 0; j < NumDistributedServers; j++) {

                                    var distributedServerItem = distributedServers[j];

                                    dat += 'v.fp.processing.distributed.servers.' + j + '.position=' + j + '&';
                                    dat += 'v.fp.processing.distributed.servers.' + j + '.hostname=' + encodeURIComponent(distributedServerItem.hostname) + '&';
                                    dat += 'v.fp.processing.distributed.servers.' + j + '.port=' + encodeURIComponent(distributedServerItem.port) + '&';
                                    dat += 'v.fp.processing.distributed.servers.' + j + '.spawn=' + distributedServerItem.spawn + '&';
                                }
                            }
                            else {

                                dat += 'v.fp.processing.distributed.servers=&';
                            }

                            break;

                        case 'charset_conversion':

                            dat += 'v.fp.processing.convert_log_data_charset=' + itemDat.convert_log_data_charset + '&';
                            dat += 'v.fp.processing.convert_log_data_from_charset=' + itemDat.convert_log_data_from_charset + '&';
                            dat += 'v.fp.processing.convert_log_data_to_charset=' + itemDat.convert_log_data_to_charset + '&';

                            break;

                        default:

                            var numItems = itemDat.length;

                            for (j = 0; j < numItems; j++) {

                                var item = itemDat[j];
                                var itemValue = item.value;

                                if (item.type == 'string') {
                                    itemValue = encodeURIComponent(itemValue);
                                }
                                else if (item.type == 'bytes' && item.bytesUnit != 'bytes' ) {
                                	
                                    itemValue += item.bytesUnit;
                                }

								dat += 'v.fp.' + item.itemPath + '=' + itemValue + '&';
                            }

                            break;
                    }
                }

                dat = dat.replace(/&$/, '');

                var url = '?dp=config_pages.log_processing.save_log_processing_data';
                url += '&p=' + pageInfo.profileName;
                
                util.serverPost(url, dat);
                pageInfo.saveActive = true;
            }
            else {

                alert(langVar('lang_stats.general.no_changes_to_save'));
            }
        }
    }

    function saveLogProcessingResponse(dat) {

        // reset isModified
        GD.theList.resetIsModified();

        // the saved work itemsDb becomes now the itemsDbBackup
        GD.itemsDbBackup = util.cloneObject(GD.itemsDb);

		// Update profilesListChecksum checksum
		profilesStorage.update(dat.profileChanges);

        util.hideE('saving_info');
        util.showE('form_section');
    }

    function getIsModifiedPage() {

        // Before checking isModified we need to validate the form!
        if (!validateActiveItem() || GD.theList.getIsModified()) {
            return true;
        }
        return false;
    }

    //
	//
	// Return global properties and methods
	//
	//

	return {
        getLogProcessingData: getLogProcessingData,
        getLogProcessingDataResponse: getLogProcessingDataResponse,
        saveLogProcessing: saveLogProcessing,
        saveLogProcessingResponse: saveLogProcessingResponse,
        resetDistributedServerListError: resetDistributedServerListError
    }
}();
