//
// reportOptions
//

var reportOptions = {
	
	theList: null,
	availableExpressionFieldsDb: [],
	itemsDb: [],  // items work array
	itemsDbBackup: [],
	validator: null,
	
	reportFilterExprFieldsPanel: null,
		
	saveChangesBtn: null,
	undoAllChangesBtn: null,
	
	form: {
		
		init: function() {
			
			// Sets all input controls to initial itemsDb values
			// Also used upon Undo Changes
		
			//
			// Init form data
			//
			
			var itemsDb = reportOptions.itemsDb;
			
			for (var i = 0; i < itemsDb.length; i++) {
				
				var item = itemsDb[i];
				var itemDat = item.dat;
				// util.showObject(itemDat);
				
				for (var prop in itemDat) {
					
					var itemValue = itemDat[prop];
					
					switch (prop) {
						
						case 'csv_delimiter':
							reportOptions.form.setCvsDelimiter(itemValue);
							break;
							
						case 'sizes':
							reportOptions.form.setSizes(itemValue);
							break;
							
						case 'color_schemes':
						    reportOptions.form.setColorSchemes(itemValue);
							break;
							
						case 'convert_charset':
						 	reportOptions.form.setConvertCharset(itemValue);
							break;

						default:
							// alert(itemDat[prop]);
							util.setF('report_options:' + prop, itemValue);
							break;
					}
				}
				
			}
		},
		
		setCvsDelimiter: function(cvsDelimiter) {
			
			var cvsCustomDelimiter = '';
			var cvsType = '';
			
			if (cvsDelimiter == '' || cvsDelimiter == ',') {
				cvsType = 'comma';
			}
			else if (cvsDelimiter == ' ') {
				cvsType = 'space';
			}
			else {
				cvsType = 'custom';
				cvsCustomDelimiter = cvsDelimiter;
			}
			
			util.setF('report_options:csv_delimiter:' + cvsType, true);
			util.setF('report_options:csv_delimiter:custom_field', cvsCustomDelimiter);
		},
		
		setCvsDelimiterToCustom: function() {
			// Activate custom upon click in custom form field
			util.setF('report_options:csv_delimiter:custom', true);
		},
		
		setSizes: function(sizesDat) {
			
			// util.showObject(sizesDat);
			for (var prop in sizesDat) {
				
				var sizesObj = sizesDat[prop];
				var idPrefix = "report_options:" + prop;
				
				util.setF(idPrefix + ':maximum_text_length', sizesObj.maximum_text_length);
				util.setF(idPrefix + ':maximum_continuous_text_length', sizesObj.maximum_continuous_text_length);
				util.setF(idPrefix + ':maximum_continuous_text_length_offset', sizesObj.maximum_continuous_text_length_offset);
			}
		},
		
		setColorSchemes: function(colorSchemesDat) {
			
			for (var prop in colorSchemesDat) {
				var elementId = 'report_options:color_schemes:' + prop + ':' + colorSchemesDat[prop];
				util.setF(elementId, true);
			}
		},
		
		setConvertCharset: function(convertCharsetDat) {
			
			convertCharset.update(
				convertCharsetDat.convert_export_charset,
				convertCharsetDat.convert_export_from_charset,
				convertCharsetDat.convert_export_to_charset
			);
		}
	}
}

function init() {
	
	reportOptions.validator = new util.Validator();
	
	// init toolbar buttons
	
	reportOptions.saveChangesBtn = new util.ToolbarButton('save_changes', saveReportOptions, toolbarButtonsDb);		
	reportOptions.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
	
	var isEdit = pageInfo.permissions.isEdit;
	
	if (isEdit) {
		
		// Register isModifiedPageHandler in adminConfig.js
		// (We don't check for modifications if there is no edit 
		// permission because there is no Save button anyway!)
		adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
	}
	else {
		
		reportOptions.saveChangesBtn.disableAndIgnore();
		reportOptions.undoAllChangesBtn.disableAndIgnore();
	}
		
	// Create theList object
	reportOptions.theList = new listcontroller.List({
		containerElementId: 'item_list_body',
		itemEvent: itemActivated
	});
	
	// Init item list
	reportOptions.theList.init(reportOptions.itemsDb);
	
	// init OptionInfo
	optionInfo.init();
	
	// Init filter expression util
	
	var viewExprFieldsObj = {
		panelId: 'view_report_filter_expression_fields:panel',
		tbodyId: 'view_report_filter_expression_fields:tbody',
		panelLabel: langVar('lang_admin.available_expression_fields.available_fields'),
		availableExpressionFieldsDb: reportOptions.availableExpressionFieldsDb,
		left: 0
	};
	
	reportOptions.reportFilterExprFieldsPanel = new AvailableExprFields(viewExprFieldsObj);
	
	var YE = YAHOO.util.Event;
	YE.addListener('report_options:filter_expression:show_available_fields_btn', 'click', openAvailableReportFieldsPanel);
	YE.addListener('view_report_filter_expression_fields:close_btn', 'click',closeAvailableReportFieldsPanel);
	
	YE.addListener('report_options:filter_expression:view_help_btn', 'click', util.helpWindow.openGeneralHelp);
	
	YE.addListener('report_options:csv_delimiter:custom_field', 'keypress', reportOptions.form.setCvsDelimiterToCustom);
	
	// Init browse buttons
	YE.addListener('report_options:page_header_file:browse_btn', 'click', browsePageHeaderFile);
	YE.addListener('report_options:page_footer_file:browse_btn', 'click', browsePageFooterFile);
}

function getReportOptionsData() {
	
	if (!pageInfo.exitActive) {
	
	var url = '?dp=config_pages.report_options.get_data';
	url += '&p=' + pageInfo.profileName;
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;	
	
		util.helpWindow.init('');
		util.serverPost(url, dat);
	}
}

function getReportOptionsDataResponse(dat) {
		
	if (!pageInfo.exitActive) {
		
		// util.showObject(dat);
		
		// alert(dat);
		
		reportOptions.availableExpressionFieldsDb = dat.availableExpressionFieldsDb;
		
		// get itemsDb
		reportOptions.itemsDb = dat.items;
		reportOptions.itemsDbBackup = util.cloneObject(dat.items);
		
		// Init
		init();
		convertCharset.init(dat.charset);
		reportOptions.form.init();
		
		setItem('i0');
		
		reportOptions.saveChangesBtn.enable();
		reportOptions.undoAllChangesBtn.enable();

		util.showE('form_section');
		
		adminConfig.setItemListSize();
		YAHOO.util.Event.addListener(window, 'resize', adminConfig.setItemListSize);
		
		pageInfo.initComplete = true;
	}
}

function itemActivated(itemId) {
	
	if (validateActiveItem()) {		
		setItem(itemId);
	}
}

function setItem(itemId) {
	
	var theList = reportOptions.theList;
	
	theList.selectItem(itemId);
	
	// display the form
	util.hideE([
		'report_options:general:section',
		'report_options:filters:section',
		'report_options:numbers_and_text:section',
		'report_options:graphs:section',
		'report_options:page_header_footer:section',
		'report_options:session_reports:section',
		'report_options:csv_export:section'
	]);
	
	var item = theList.getSelectedItem();
	util.updateT('item_form_label', item.label);
	util.showE('report_options:' + item.type + ':section');
}

//
//
// Validation
//
//

function validateTextSizeItem(optionGroupName) {
	
	// Validates a text size item and returns a text size item object
	// optionGroupName is: table_cell | session_path | graph_legend_cell
	
	var validator = reportOptions.validator;
	var idPrefix = 'report_options:' + optionGroupName;
	
	var obj = {};
	// Allow 0 value for maximum_text_length and maximum_continuous_text_length_offset!
	obj.maximum_text_length = validator.isInteger(idPrefix + ':maximum_text_length', 0);
	obj.maximum_continuous_text_length = validator.isInteger(idPrefix + ':maximum_continuous_text_length', 1);
	obj.maximum_continuous_text_length_offset = validator.isInteger(idPrefix + ':maximum_continuous_text_length_offset', 0);
	
	return obj;
}

function getGraphColorSchemeValues(colorSchemeItems) {
	
	// colorSchemeItems is the original itemDat object. We used it here to
	// lookup property names only.
	
	var obj = {};
	
	for (var prop in colorSchemeItems) {
		
		var idPrefix = 'report_options:color_schemes:' + prop;
		var itemValue = '';
		
		if (util.getF(idPrefix + ':single')) {
			itemValue = 'single';
		}
		else if (util.getF(idPrefix + ':numerical')) {
			itemValue = 'numerical';
		}
		else {
			itemValue = 'mixed';
		}
	
		obj[prop] = itemValue;
	}
	
	return obj;
}

function validateActiveItem() {
	
	// Only validate if isEdit permission
	
	if (pageInfo.permissions.isEdit) {
	
		var theList = reportOptions.theList;
		var validator = reportOptions.validator;
		validator.reset();
	
		var activeItem = theList.getSelectedItem();
		var activeItemDat = activeItem.dat; // We use activeItemDat to lookup exitsing properties
		
		// util.showObject(activeItem);
		
		var obj = {};
		var prop;
		
		switch (activeItem.type) {
					
			case 'general':
				
				for (prop in activeItemDat) {
					obj[prop] = util.getF('report_options:' + prop);
				}
		
				break;
				
			case 'filters':
			
				obj.date_filter = util.getF('report_options:date_filter');
				obj.filter_expression = util.getF('report_options:filter_expression');
	
				break;
				
			case 'numbers_and_text':
				
				// KHP 10-Nov-2010, moved number_thousands_divider and number_decimal_divider to users
				// obj.number_thousands_divider = util.getF('report_options:number_thousands_divider');
				// obj.number_decimal_divider = util.getF('report_options:number_decimal_divider');
				
				obj.use_base_ten_for_byte_display = util.getF('report_options:use_base_ten_for_byte_display');
				
				// Validate text sizes
				obj.sizes = {};
				obj.sizes.table_cell = validateTextSizeItem('table_cell');
				obj.sizes.session_path = validateTextSizeItem('session_path');
				obj.sizes.graph_legend_cell = validateTextSizeItem('graph_legend_cell');
			
				break;
				
			case 'graphs':
			
				obj.color_schemes = getGraphColorSchemeValues(activeItemDat.color_schemes);
	
				break;
	
			case 'page_header_footer':
				
				obj.page_header = util.getF('report_options:page_header');
				obj.page_footer = util.getF('report_options:page_footer');
				obj.page_header_file = util.getF('report_options:page_header_file');
				obj.page_footer_file = util.getF('report_options:page_footer_file');
			
				break;
				
			case 'session_reports':
			
				obj.session_timeout = validator.isInteger('report_options:session_timeout', 0);
				// KHP 25/May/2010, maximum_session_duration is disabled because this option has no effect since version 8.0
				// obj.maximum_session_duration = validator.isInteger('report_options:maximum_session_duration', 0);
				obj.remove_reloads_from_sessions = util.getF('report_options:remove_reloads_from_sessions');
				
				break;
				
			case 'csv_export':
			
				//
				// CSV delimiter
				//
				
				if (util.getF('report_options:csv_delimiter:comma')) {
					// Comma
					obj.csv_delimiter = ',';
				}
				else if (util.getF('report_options:csv_delimiter:space')) {
					// Space
					obj.csv_delimiter = ' '; 
				}
				else {
					// Custom
					obj.csv_delimiter = validator.isValue('report_options:csv_delimiter:custom_field');
				}
				
				//
				// Charset conversion
				//
				
				var charsetObj = {};
				charsetObj.convert_export_charset = util.getF('convert_charset');
				charsetObj.convert_export_from_charset = util.getF('convert_from_list:charset');
				charsetObj.convert_export_to_charset = util.getF('convert_to_list:charset');
				
				if (charsetObj.convert_export_charset) {
					
					// Validate charset
					
					if (charsetObj.convert_export_from_charset == '' || charsetObj.convert_export_to_charset == '') {
						validator.isCustom('convert_charset', langVar('lang_admin.charset_conversion.no_charsets_defined_msg'));
					}
					else if (charsetObj.convert_export_from_charset == charsetObj.convert_export_to_charset) {
						validator.isCustom('convert_charset', langVar('lang_admin.charset_conversion.duplicate_charset_msg'));
					}
				}
				
				obj.convert_charset = charsetObj;
				
				break;
		}
		
		if (validator.allValid()) {
			
			// util.showObject(obj);
			theList.saveItem(obj);
			// alert('isModified: ' + reportOptions.theList.getIsModified());
			
			return true;
		}
		
		return false;
	}
	else {
		
		// No isEdit permission
		return true;	
	}
}

function undoAllChanges() {
	
	reportOptions.itemsDb = util.cloneObject(reportOptions.itemsDbBackup);
	reportOptions.form.init();
}

function saveReportOptions() {
	
	if (validateActiveItem()) {
		
		var isModified = reportOptions.theList.getIsModified();
		
		if (isModified) {
			
			util.hideE('form_section');
			util.showE('saving_info');
			
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			dat += 'v.fp.profiles_list_checksum=' + profilesStorage.get('profilesListChecksum') + '&';
			
			var miscPath = 'v.fp.statistics.miscellaneous';
			var sizesPath = 'v.fp.statistics.sizes';
			var graphsPath = 'v.fp.statistics.graphs';
			var outputPath = 'v.fp.output';
			
			var itemsDb = reportOptions.itemsDb;
			
			var prop;
			
			for (var i = 0; i < itemsDb.length; i++) {
				
				var item = itemsDb[i];
				var itemDat = item.dat;
				
				switch (item.type) {
					
					case 'general':
						
						dat += miscPath + '.enable_calendar_in_reports_menu=' + itemDat.enable_calendar_in_reports_menu + '&';
						dat += miscPath + '.first_weekday=' + itemDat.first_weekday + '&';
						dat += miscPath + '.marked_weekday=' + itemDat.marked_weekday + '&';
						dat += miscPath + '.show_http_link=' + itemDat.show_http_link + '&';
						dat += miscPath + '.server_root=' + itemDat.server_root + '&';
					
						break;
					
					case 'filters':
					
						dat += miscPath + '.date_filter.df=' + encodeURIComponent(itemDat.date_filter) + '&';
						dat += miscPath + '.filter.expression=' + encodeURIComponent(itemDat.filter_expression) + '&';
					
						break;
					
					case 'numbers_and_text':
					
						// KHP 10-Nov-2010, moved number_thousands_divider and number_decimal_divider to users
						// dat += outputPath + '.number_thousands_divider=' + encodeURIComponent(itemDat.number_thousands_divider) + '&';
						// dat += outputPath + '.number_decimal_divider=' + encodeURIComponent(itemDat.number_decimal_divider) + '&';
						dat += outputPath + '.use_base_ten_for_byte_display=' + itemDat.use_base_ten_for_byte_display + '&';
						
						// Get text sizes
						var sizesObj = itemDat.sizes;
						
						for (prop in sizesObj) {
							
							var sizesObjDat = sizesObj[prop];
							
							dat += sizesPath + '.' + prop + '.maximum_text_length=' + sizesObjDat.maximum_text_length + '&';
							dat += sizesPath + '.' + prop + '.maximum_continuous_text_length=' + sizesObjDat.maximum_continuous_text_length + '&';
							dat += sizesPath + '.' + prop + '.maximum_continuous_text_length_offset=' + sizesObjDat.maximum_continuous_text_length_offset + '&';
						}
					
						break;
						
					case 'graphs':
					
						var colorSchemesObj = itemDat.color_schemes;
						
						for (prop in colorSchemesObj) {
							dat += graphsPath + '.color_schemes.' + prop + '=' + colorSchemesObj[prop] + '&';
						}
					
						break;
					
					
					case 'page_header_footer':
					
						dat += miscPath + '.page_header=' + encodeURIComponent(itemDat.page_header) + '&';
						dat += miscPath + '.page_footer=' + encodeURIComponent(itemDat.page_footer) + '&';
						dat += miscPath + '.page_header_file=' + encodeURIComponent(itemDat.page_header_file) + '&';
						dat += miscPath + '.page_footer_file=' + encodeURIComponent(itemDat.page_footer_file) + '&';
					
						break;
						
					case 'session_reports':
					
						dat += miscPath + '.session_timeout=' + itemDat.session_timeout + '&';
						dat += miscPath + '.remove_reloads_from_sessions=' + itemDat.remove_reloads_from_sessions + '&';

						break;
					
					case 'csv_export':
					
						dat += miscPath + '.csv_delimiter=' + encodeURIComponent(itemDat.csv_delimiter) + '&';
						
						var charsetDat = itemDat.convert_charset;
						
						dat += outputPath + '.convert_export_charset=' + charsetDat.convert_export_charset + '&';
						dat += outputPath + '.convert_export_from_charset=' + encodeURIComponent(charsetDat.convert_export_from_charset) + '&';
						dat += outputPath + '.convert_export_to_charset=' + encodeURIComponent(charsetDat.convert_export_to_charset) + '&';
					
						break;
				}
			}
			
			dat = dat.replace(/&$/, '');
			
			var url = '?dp=config_pages.report_options.save_data';
			url += '&p=' + pageInfo.profileName;
			util.serverPost(url, dat);
			pageInfo.saveActive = true;
		}
		else {
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	}
}

function saveReportOptionsResponse(dat) {
	
	// reset isModified
	reportOptions.theList.resetIsModified();
	
	// the saved work itemsDb becomes now the itemsDbBackup
	reportOptions.itemsDbBackup = util.cloneObject(reportOptions.itemsDb);

	// Update default date filter in View Reports link if the link exists
	var theLinkElement = util.getE('rc_nav_view_reports:btn');
	
	if (theLinkElement != null) {
	
		var defaultDateFilter = util.getF('report_options:date_filter');
		
		// Set the link
		var href = '?dp=reports&p=' + pageInfo.profileName;
		
		if (defaultDateFilter != '') {
			href += '&df=' + defaultDateFilter;
		}
		
		theLinkElement.href = href;
	}

	// Update profilesListChecksum checksum
	profilesStorage.update(dat.profileChanges);

	util.hideE('saving_info');
	util.showE('form_section');
}

function openAvailableReportFieldsPanel() {
	reportOptions.reportFilterExprFieldsPanel.open();
}

function closeAvailableReportFieldsPanel() {
	reportOptions.reportFilterExprFieldsPanel.close();
}


function browsePageHeaderFile() {
	util.fileManagerWindow.open('report_options:page_header_file');
}

function browsePageFooterFile() {
	util.fileManagerWindow.open('report_options:page_footer_file');
}

function getIsModifiedPage() {
	
	// Before checking isModified we need to validate the form!
	if (!validateActiveItem() || reportOptions.theList.getIsModified()) {
		return true;
	}
	return false;
}
