//
// customizeRE.js - customize report element
//


var customizeRE = {
	
	panel: null,
	defaultTabId: '', // graphs | table
		
	// Active report element data
	shortReportElementId: '',
	reportElementName: '',
	reportElementType: '',
	totalRows: 0,
	reportElementDb: {}, // contains the active report element data
	
	initCreObjectDone: false
	
	// Quick access to check which panels are available
	// showGraphs: false,
	// isGraphOptions: false,
	// showTable: false,
	// isPivotTable: false
}

customizeRE.init = function() {

	var YE = YAHOO.util.Event;
	
	var panelObj = {
		panelId:"cre:panel",
		panelClassName: 'panel-50',
		panelHeaderLabel: langVar('lang_stats.customize_report_element.customize_report_element'),
		zIndex: 20,
		isCover: true,
		closeEvent: customizeRE.close
	};
			
	customizeRE.panel = new util.Panel3(panelObj);

	YE.addListener('cre:save_btn', 'click', customizeRE.save);
	YE.addListener('cre:cancel_btn', 'click', customizeRE.close);
}

customizeRE.open = function(e) {
	
	var id = e.currentTarget.id;
	var dat = id.split(':');
	var shortReportElementId = dat[0];
	var reportElement = reportInfo.reportElements[util.h(shortReportElementId)];
	var reportElementName = reportElement.name;
	var reportElementType = reportElement.reportElementType;

	// util.showObject(reportElement);

	// var defaultTabId = (dat[2] == 'table') ? 'table' : 'graphs'; // This parameter depends if the CRE panel has been opened within the graphs or table section
	var defaultTabId = (reportElementType == 'table' && reportElement.showGraphs) ? 'graphs' : 'table';

//	if (reportElementType == 'table' && !reportElement.showTable) {
//		// This must be a graph without table
//		defaultTabId = 'graphs';
//	}

	customizeRE.defaultTabId = defaultTabId;
	customizeRE.shortReportElementId = shortReportElementId;
	customizeRE.reportElementName = reportElementName;
	customizeRE.reportElementType = reportElementType;
	customizeRE.totalRows = reportElement.totalRows;
	
	// alert('shortReportElementId: ' + shortReportElementId + '\nreportElementName: ' + reportElementName);
		
	// Initialize panel
	if (customizeRE.panel == null) {
		customizeRE.init();
	}
	
	// util.hideE(['cre:tab_bar', 'cre:sub_panels']);
	util.hideE('cre:cre_forms_object');
	util.showE('cre:loading_info');
		
	customizeRE.getReportElementData(reportElementName);
	
	// Get position
	customizeRE.panel.prePositionAtCenter();
	customizeRE.panel.open();
}

customizeRE.close = function() {
	
	customizeRE.panel.close();
}

customizeRE.getReportElementData = function(reportElementName) {
	
	var url = '?dp=statistics.customize_report_element.get_report_element_data';
	url += '&p=' + reportInfo.profileName;
	
	var loadDefaultGraphsDb = !customizeRE.initCreObjectDone; // We load defaultGraphsDb only once!
	
	// KHP 10/Aug/2010 - Get session_id on server side!	
	// var dat = 'v.fp.session_id=' + reportInfo.sessionId;
	
	var dat = 'v.fp.page_token=' + reportInfo.pageToken;
	dat += '&v.fp.report_info_id=' + reportInfo.reportInfoId;
	dat += '&v.fp.report_name=' + reportInfo.reportName;
	dat += '&v.fp.report_element_name=' + reportElementName;
	dat += '&v.fp.load_default_graphs=' + loadDefaultGraphsDb;
	
	util.serverPost(url, dat);
}

customizeRE.getReportElementDataResponse = function(dat) {

	// alert('customizeRE.getReportElementDataResponse');
	// util.showObject(dat);
	
	// Verify if we got the right report element
	if (dat.reportInfoId == reportInfo.reportInfoId && dat.reportElementName == customizeRE.reportElementName) {
		
		var reportElementDb = dat.reportElementDb;
		customizeRE.reportElementDb = reportElementDb;
		
		if (!customizeRE.initCreObjectDone) {
			
			//
			//
			// Init Customize Report Element Object
			//
			//
			
			var defaultGraphsDb = dat.defaultGraphsDb;
			var queryFieldsDb = reportInfo.queryFieldsDb;
			var isCustomizeInReports = true;
			var isPivotTablePermission = reportInfo.permissions.isCREPivotTable;
			var isGraphOptionsPermission = reportInfo.permissions.isCREGraphOptions;
			var hideLogDetailSortingMessage = reportInfo.hideLogDetailSortingMessage;
			
			
			creControl.initCreObject(
				queryFieldsDb,
				defaultGraphsDb,
				isCustomizeInReports,
				isPivotTablePermission,
				isGraphOptionsPermission,
				hideLogDetailSortingMessage
			);

			customizeRE.initCreObjectDone = true;
		}
		
		//
		//
		// Init Report Element Db 
		//
		//
		
		var obj = {
			defaultTabId: customizeRE.defaultTabId,
			totalRows: customizeRE.totalRows
		};
		
		creControl.init(reportElementDb, obj);
		
		util.hideE('cre:loading_info');
		util.showE('cre:cre_forms_object');
	}
}

customizeRE.getTableReportElementDat = function(reportElementDb, rePath) {
	
	var permissions = reportInfo.permissions;
	
	var isGraphOptions = (reportElementDb.show_graphs && permissions.isCREGraphOptions);
	var showTable = reportElementDb.show_table;
	var reportElementType = reportElementDb.type;
	var isPivotTable = (showTable && permissions.isCREPivotTable && (reportElementType == 'table'));

	var dat = '';
		
	if (showTable) {
		
		var tableOptionsProp = [
			'show_remainder_row',
			'show_averages_row',
			'show_min_row',
			'show_max_row',
			'show_totals_row',
			'number_of_rows',
//			'display_graphs_table_side_by_side',
			'maximum_table_bar_graph_length'
		];
		
		for (var i = 0; i <  tableOptionsProp.length; i++) {
			prop = tableOptionsProp[i];
			dat += rePath + '.' + prop + '=' + reportElementDb[prop];
		}
	}
	
	
	// Always send sort_by and sort_direction because it can also be set if there are only graphs
	dat += rePath + '.sort_by=' + reportElementDb.sort_by;
	dat += rePath + '.sort_direction=' + reportElementDb.sort_direction;

	if (reportElementType == 'table') {

		dat += rePath + '.maximum_table_bar_graph_length=' + reportElementDb.maximum_table_bar_graph_length;
//		dat += rePath + '.display_graphs_table_side_by_side=' + reportElementDb.display_graphs_table_side_by_side;
		dat += rePath + '.display_graphs_side_by_side=' + reportElementDb.display_graphs_side_by_side;
	}

	if (isPivotTable) {
		
		var pivotTableObj = reportElementDb.pivot_table;
		// util.showObject(pivotTableObj);
		for (var prop in pivotTableObj) {
			dat += rePath + '.pivot_table.' + prop + '=' + pivotTableObj[prop];
		}
	}
	
	// alert('Revise customizeRE.isGraphOptions!');
	// return false;
	
	if (isGraphOptions) {
		
		var graphsObj = reportElementDb.graphs;
		// util.showObject(graphsObj);
		for (var graphsProp in graphsObj) {
			dat += rePath + '.graphs.' + graphsProp + '=' + graphsObj[graphsProp];
		}
	}
	
	return dat;
}

customizeRE.save = function() {
	
	// Note, save_re_data does not require that all report element data are send,
	// it is sufficient to send only data which have been manipulated.
	
	// Save changes to reportElementDb
	creControl.saveChanges();
	
	var url = '?dp=statistics.customize_report_element.save_re_data';
	url += '&p=' + reportInfo.profileName;
	
	var reportElementDb = customizeRE.reportElementDb;

	// util.showObject(reportElementDb);

	var reportElementType = reportElementDb.type;
	var isOverview = (reportElementType == 'overview');
	
	var showTable = false;
	var showGraphs = false;

	var dat = 'v.fp.page_token=' + reportInfo.pageToken;
	dat += '&v.fp.session_id=' + reportInfo.sessionId;
	dat += '&v.fp.web_browser_session_id=' + reportInfo.webBrowserSessionId;
	dat += '&v.fp.is_root_admin=' + reportInfo.isRootAdmin;
	dat += '&v.fp.report_info_id=' + reportInfo.reportInfoId;
	dat += '&v.fp.report_name=' + reportInfo.reportName;
	dat += '&v.fp.report_element_name=' + customizeRE.reportElementName;
	// dat += '&v.fp.report_element_type=' + reportElementType;
	// dat += '&v.fp.is_save_changes_persistent=' + util.getF('cre:save_changes_persistent');
	
	var rePath = '&v.fp.report_element';
	
	var startingRow = 1;
	var endingRow = 10;

	if (isOverview) {
		dat += '&v.fp.report_element.compact_view=' + reportElementDb.compact_view;
	}
	else {
		
		showTable = reportElementDb.show_table;
		showGraphs = reportElementDb.show_graphs;
		
		// Note, don't save starting_row and ending_row within report_element,
		// we save it in 'v.fp' because they are a session setting only!
		if (showTable) {
			startingRow = reportElementDb.starting_row;
			endingRow = reportElementDb.ending_row;
		}
		
		dat += customizeRE.getTableReportElementDat(reportElementDb, rePath);
	}

	
	// Use for graphs and table
	dat += '&v.fp.starting_row=' + startingRow;
	dat += '&v.fp.ending_row=' + endingRow;
	
	
	//
	//
	// Get column/fields data
	//
	//
	
	var columnIsChecked = false; // Required for log detail report because it allows to uncheck all text columns
	var graphColumnIsChecked = false; // Required if no table is active, in this case one graph must be checked
	var columns = reportElementDb.columns;
	
	for (var i = 0; i < columns.length; i++) {
		
		var columnItem = columns[i];
		var columnsPath = '&v.fp.report_element.columns.' + i;
		var showColumn = columnItem.show_column;
		
		if (showColumn) {columnIsChecked = true;}
		
		dat += columnsPath + '.position=' + i;
		dat += columnsPath + '.report_field=' + columnItem.report_field;
		dat += columnsPath + '.show_column=' + showColumn;
		
		if (!isOverview && columnItem['show_percent_column'] != null) {
			
			var showGraph = columnItem.show_graph;
			
			// This must be an aggregating field
			dat += columnsPath + '.show_percent_column=' + columnItem.show_percent_column;
			dat += columnsPath + '.show_bar_column=' + columnItem.show_bar_column;
			dat += columnsPath + '.show_graph=' + showGraph;
			
			if (showGraph) {graphColumnIsChecked = true;}
		}
	}
	
	if (((showTable || isOverview) && columnIsChecked) ||
		(showGraphs && graphColumnIsChecked)) {
		
		util.serverPost(url, dat);
	}
	else {
		alert(langVar('lang_stats.customize_report_element.no_column_checked_msg'));
	}
}

customizeRE.saveResponse = function() {

	customizeRE.close();
	newReport.getReportByCustomizeReportElement();
}


