//
// filterItem - global filter items editor
// used in reports and in scheduler.
//

var filterItemEditor = (function() {

	'use strict';
	
  	var YE = YAHOO.util.Event,
		YD = YAHOO.util.Dom,
		panel = null,
		validator = null,

		queryFieldsDb = null,
	
		// active filter item properties
		id = '',
		isActive = false,
		isNew = false,
		isItemInGroup = false,
		groupItemId = '',

		// The callee object
		calleeObj = null,

		// activeOperatorListType is text or numerical
		activeOperatorListType = '',

		textFieldItemOperators = [
			{
			name:'item_name',
			label:langVar('lang_stats.global_filter.is_item_name')
			},

			{
			name:'wildcard',
			label:langVar('lang_stats.global_filter.is_wildcard_expression')
			},

			{
			name:'regexp',
			label:langVar('lang_stats.global_filter.is_regular_expression')
			},

			{
			name:'not_item_name',
			label:langVar('lang_stats.global_filter.not_item_name')
			},

			{
			name:'not_wildcard',
			label:langVar('lang_stats.global_filter.not_wildcard_expression')
			},

			{
			name:'not_regexp',
			label:langVar('lang_stats.global_filter.not_regular_expression')
			}
		],

		numericalFieldItemOperators = [
			{
			name:'lt',
			label:langVar('lang_stats.global_filter.is_less_than')
			},

			{
			name:'gt',
			label:langVar('lang_stats.global_filter.is_greater_than')
			}
		];

	function init() {

		var panelObj = {
			panelId:"filter_item:panel",
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 70,
			top: 80,
			zIndex: 40,
			isCover: true,
			closeEvent: close
		};

		panel = new util.Panel3(panelObj);

		validator = new util.Validator();

		// Populate default operator list for text field items
		updateFieldItemOperatorList('text');

		var label = '';

		// Populate day of week list
		var weekdays = [{
			name:'',
			label:langVar('lang_stats.global_filter.select_day_of_week')
			}];
		for (var i = 1; i < 8; i++) {

			label = lang.weekdays[i - 1];
			weekdays[weekdays.length] = {
				name: i,
				label: label
			};
		}
		util.populateSelect('filter_item:day_of_week_list', weekdays, 'name', 'label');

		// Populate hour of day list
		var hours = [{
			name:'',
			label:langVar('lang_stats.global_filter.select_hour')
			}];
		for (var j = 0; j < 24; j++) {

			label = lang.hours[j];
			hours[hours.length] = {
				name: j,
				label: label
			};
		}
		util.populateSelect('filter_item:hour_of_day_list', hours, 'name', 'label');

		YE.addListener('filter_item:read_about_within_matches_btn', 'click', toggleInfoPanel);

		YE.addListener('filter_item:filter_item_type_list', 'change', typeActor);
		YE.addListener('filter_item:field_list', 'change', fieldActor);
		YE.addListener('filter_item:field_item_operator_list', 'change', operatorActor);

		YE.addListener('filter_item:ok_btn', 'click', saveItem);
		YE.addListener('filter_item:cancel_btn', 'click', close);
	}

	function setProfileSpecificData(_queryFieldsDb) {

		// This sets profile related data. This is required in scheduler
		// actions where profiles can be changed at any time.

		queryFieldsDb = _queryFieldsDb;

		// Create hash
//		util.createHash(queryFieldsDb);
//		util.showObject(queryFieldsDb);

		// Populate field item list
		// Note, we don't allow date_time fields in global filter! Date time is set via df only!

		var filterFieldsDb = [{
			name:'',
			label:langVar('lang_stats.global_filter.select_field')
		}];

		var nonAggregatingFilterFieldsDb = [{
			name: '',
			label:langVar('lang_stats.global_filter.select_field')
		}];

		for (var i = 0; i < queryFieldsDb.length; i++) {

			var queryField = queryFieldsDb[i];
			var isValidField = false;

			if (queryField.category !== 'date_time' && queryField.hasDbField) {

				var isAggregatingField = queryField.isAggregatingField;
				isValidField = (!isAggregatingField || (isAggregatingField && (queryField.aggregationMethod !== 'unique')));
			}

			if (isValidField) {

				filterFieldsDb[filterFieldsDb.length] = {
					name:queryField.name,
					label:queryField.label
				};

				if (!isAggregatingField) {

					nonAggregatingFilterFieldsDb[nonAggregatingFilterFieldsDb.length] = {
						name: queryField.name,
						label:queryField.label
					};
				}
			}
		}

		util.populateSelect('filter_item:field_list', filterFieldsDb, 'name', 'label');
		util.populateSelect('filter_item:within_matches:within_field', nonAggregatingFilterFieldsDb, 'name', 'label');
		util.populateSelect('filter_item:within_matches:matches_field', nonAggregatingFilterFieldsDb, 'name', 'label');
	}

	function open(item, _isActive, _isNew, _isItemInGroup, _groupItemId, _calleeObj) {

//		util.showObject(item);

		id = item.id;
		isActive = _isActive;
		isNew = _isNew;
		isItemInGroup = _isItemInGroup;
		groupItemId = _groupItemId;

		calleeObj = _calleeObj;

		updateForm(item);

		// Get position for filterItemEditor
		var region = YD.getRegion(calleeObj.container);
		var left = region.left < 120 ? region.left : region.left - 20;
		var top = region.top - 45;

		var panelHeaderLabel = isNew ? langVar('lang_stats.global_filter.new_item') : langVar('lang_stats.global_filter.edit_item');
		panel.open({
			label: panelHeaderLabel,
			left: left,
			top: top
		});
	}


	function close() {

		util.hideE('filter_item:info_panel');

		validator.reset();
		panel.close();
//		globalFilter.enableForm();
	}


	function updateFieldItemOperatorList(operatorListType) {

		// operatorListType is text | numerical

		if (activeOperatorListType !== operatorListType) {

			// Update operator list
			var theListItems = (operatorListType === 'text') ? textFieldItemOperators : numericalFieldItemOperators;
			util.populateSelect('filter_item:field_item_operator_list', theListItems, 'name', 'label');
			activeOperatorListType = operatorListType;
		}
	}

	function getFieldItemOperator() {

		// returns an object
		// o.isExpression = true | false
		// o.isNegated = true | false
		// o.expressionType = '' | 'wildcard' | 'regexp' | lt | gt

		// lt (less than) and gt (greater than) have been added for numerical fields

		var o = {};
		var operatorValue = util.getF('filter_item:field_item_operator_list');
		var isExpression = false;
		var isNegated = false;
		var expressionType = '';

		if (operatorValue.indexOf('wildcard') !== -1 || operatorValue.indexOf('regexp') !== -1) {
			isExpression = true;
			expressionType = (operatorValue.indexOf('wildcard') !== -1) ? 'wildcard' : 'regexp';
		}
		else if (operatorValue === 'lt' || operatorValue === 'gt') {
			expressionType = operatorValue;
		}

		if (operatorValue.indexOf('not_') !== -1) {
			isNegated = true;
		}

		o.isExpression = isExpression;
		o.isNegated = isNegated;
		o.expressionType = expressionType;

		return o;
	}

	//
	// filterItemType
	//

	function typeActor() {

		var filterType = util.getF('filter_item:filter_item_type_list');
		setType(filterType);
	}

	function setType(filterType) {

		util.hideE(['filter_item:form:field',
			// 'filter_item:form:session_start',
			'filter_item:form:within_matches',
			'filter_item:form:expression',
			'filter_item:read_about_within_matches_btn'
		]);

		util.showE('filter_item:form:' + filterType);

		if (filterType === 'within_matches') {
			util.showE('filter_item:read_about_within_matches_btn');
		}
	}

	//
	// filterItem - field, operator and item value handling
	//

	function fieldActor() {

		// Invoked upon field change
		var fieldName = util.getF('filter_item:field_list');

		if (fieldName !== '') {

			// Update the operator list (text or numerical)
			var queryField = queryFieldsDb[util.h(fieldName)];
			var isAggregatingField = queryField.isAggregatingField;

			var operatorListType = isAggregatingField ? 'numerical' : 'text';
			updateFieldItemOperatorList(operatorListType);

			var defaultOperator = isAggregatingField ? 'lt' : 'item_name';
			util.setF('filter_item:field_item_operator_list', defaultOperator);
		}

		// Check/update the item value section
		setFieldItemValueSection();
	}

	function operatorActor() {

		// Check/update the item value section
		setFieldItemValueSection();
	}

	function setFieldItemValueSection() {

		// This sets the item value section depending on the
		// selected field and the selected operator.

		util.hideE(['filter_item:field_item_value_row', 'filter_item:field_item_day_of_week_row', 'filter_item:field_item_hour_of_day_row']);

		var fieldName = util.getF('filter_item:field_list');

		if (fieldName !== '') {

			var queryField = queryFieldsDb[util.h(fieldName)];
			var fieldCategory = queryField.category;
			var isAggregatingField = queryField.isAggregatingField;

			var o = getFieldItemOperator();
			var isExpression = o.isExpression; // wildcard or regular expression

			if ( !isAggregatingField && !isExpression && (fieldCategory === 'day_of_week' || fieldCategory === 'hour_of_day')) {

				if (fieldCategory === 'day_of_week') {
					util.showE('filter_item:field_item_day_of_week_row');
				}
				else {
					util.showE('filter_item:field_item_hour_of_day_row');
				}
			}
			else {
				util.showE('filter_item:field_item_value_row');
			}
		}
		else {

			// No field selected, show field_item_value_row
			util.showE('filter_item:field_item_value_row');
		}
	}

	function toggleInfoPanel(evt) {

		var anchorElement = evt.target || evt.srcElement;

		var infoPanel = util.getE('filter_item:info_panel');

		if (infoPanel.style.display !== 'block') {

			// Handle top position
			var YD = YAHOO.util.Dom;
			var anchorRegion = YD.getRegion(anchorElement);
			// util.showObject(elementRegion);
			infoPanel.style.top = anchorRegion.bottom + 8 + 'px';

			// Handle left position and width
			var parentRegion = YD.getRegion('filter_item:panel');
			var parentWidth = parentRegion.width;
			var parentLeft = parentRegion.left;
			var offset = 10;

			// alert('parentWidth: ' + parentWidth);

			infoPanel.style.left = parentLeft + offset + 'px';
			infoPanel.style.width = parentWidth - (2 * offset) + 'px';
			infoPanel.style.zIndex = 50;

			// Display the panel
			infoPanel.style.display = 'block';
		}
		else {
		   infoPanel.style.display = 'none';
		}

		anchorElement.blur();
	}

	//
	// updateForm
	//

	function updateForm(item) {

//		util.showObject(queryFieldsDb);

		// Reset form
		util.resetF('filter_item:form');

		// The itemType is '' for unsaved filters and 'filter_item' for saved filters!

		var filterType = item.filterType;
		util.setF('filter_item:filter_item_type_list', filterType);

		switch (filterType) {

			case 'field':

				var fieldName = item.fieldName;

				util.setF('filter_item:field_list', fieldName);

				//
				// update operator list if we edit an existing field
				//

				if (fieldName !== '') {

					var queryField = queryFieldsDb[util.h(fieldName)];
					var isAggregatingField = queryField.isAggregatingField;

					var operatorListType = isAggregatingField ? 'numerical' : 'text';
					updateFieldItemOperatorList(operatorListType);
				}

				//
				// set operator value
				//

				var operatorValue;
				var expressionType = item.expressionType;

				if (expressionType === '') {
					operatorValue = 'item_name';
				}
				else {
					operatorValue = expressionType;
				}

				if (item.isNegated) {
					operatorValue = 'not_' + operatorValue;
				}

				util.setF('filter_item:field_item_operator_list', operatorValue);


				//
				// set item value
				//

				var valueElementId = 'filter_item:field_item_value';

				if (item.expressionType === '') {

					var fieldCategory = (fieldName !== '') ? queryFieldsDb[util.h(fieldName)].category : '';

					if (fieldCategory === 'day_of_week') {

						valueElementId = 'filter_item:day_of_week_list';
					}
					else if (fieldCategory === 'hour_of_day') {

						valueElementId = 'filter_item:hour_of_day_list';
					}
				}

				util.setF(valueElementId, item.itemValue);
				break;

			case 'within_matches':

				if (item.isNegated) {
					util.setF('filter_item:within_matches:use_not_operator', true);
				}

				util.setF('filter_item:within_matches:within_field', item.withinFieldName);
				util.setF('filter_item:within_matches:matches_field', item.matchesFieldName);
				util.setF('filter_item:within_matches:item_value', item.itemValue);

				break;

			case 'expression':

				util.setF('filter_item:expression_item_label', item.label);
				util.setF('filter_item:expression_item_value', item.itemValue);

				break;
		}

		setType(filterType);
		setFieldItemValueSection();
	}

	function saveItem() {

		var obj = {};

		var filterType = util.getF('filter_item:filter_item_type_list');

		obj.id = id;
		obj.isRootItem = !isItemInGroup;
		obj.isGroup = false;

		obj.filterType = filterType;

		if (!isItemInGroup) {
			obj.isActive = isActive;
		}

		switch (filterType) {

			case 'field':

				var fieldName = validator.isValue('filter_item:field_list');

				if (fieldName !== '') {

					obj.fieldName = fieldName;

					var queryField = queryFieldsDb[util.h(fieldName)];
					var isAggregatingField = queryField.isAggregatingField;
//					var operatorListType = isAggregatingField ? 'numerical' : 'text';

					var operatorObj = getFieldItemOperator();

					// util.showObject(operatorObj);

					obj.isNegated = operatorObj.isNegated;

					var expressionType = operatorObj.expressionType;

					if (!isAggregatingField) {

						var isWildcardExpression = (expressionType === 'wildcard');
						var isRegularExpression = (expressionType === 'regexp');

						if (!isWildcardExpression && !isRegularExpression) {

							// We need to get the fieldCategory to check if
							// we have a day_of_week or hour_of_day list active
							var fieldCategory = queryField.category;
							var valueElementId = 'filter_item:field_item_value';

							if (fieldCategory === 'day_of_week') {
								valueElementId = 'filter_item:day_of_week_list';
							}
							else if (fieldCategory === 'hour_of_day') {
								valueElementId = 'filter_item:hour_of_day_list';
							}

							obj.itemValue = validator.isValue(valueElementId);
						}
						else {

							obj.itemValue = validator.isValue('filter_item:field_item_value');

							if (isWildcardExpression) {
								expressionType = 'wildcard';
							}
							else {
								// isRegularExpression
								expressionType = 'regexp';
								obj.itemValue = validator.isRegularExpression('filter_item:field_item_value');
							}
						}
					}
					else {

						// Numerical field,
						// we allow int and float, so we just check for number
						obj.itemValue = validator.isNumber('filter_item:field_item_value');
					}

					obj.expressionType = expressionType;
				}

				break;

			case 'within_matches':

				obj.isNegated = util.getF('filter_item:within_matches:use_not_operator');
				obj.withinFieldName = validator.isValue('filter_item:within_matches:within_field');
				obj.matchesFieldName = validator.isValue('filter_item:within_matches:matches_field');
				obj.itemValue = validator.isValue('filter_item:within_matches:item_value');

				// Make sure the within field is different from the matches field
				if (obj.withinFieldName !== '' && (obj.withinFieldName === obj.matchesFieldName)) {
					validator.isCustom('filter_item:within_matches:matches_field', langVar('lang_stats.global_filter.equal_within_and_matches_field_message'));
				}

				/*
				  util.setF('filter_item:within_matches:use_not_operator', true);
				}

				util.setF('filter_item:within_matches:within_field', item.withinFieldName);
				util.setF('filter_item:within_matches:matches_field', item.matchesFieldName);
				util.setF('filter_item:within_matches:item_value', item.itemValue);
				*/
				break;

			case 'expression':

				obj.label = validator.isValue('filter_item:expression_item_label');

				// Check for duplicate names - We have a problem here because
				// the label only exists for expressions but not for any other FilterType,
				// so we simply allow duplicate expression labels!

				obj.itemValue = validator.isValue('filter_item:expression_item_value');

				break;
		}

		if (validator.allValid()) {

			// util.showObject(obj);
			close();
			calleeObj.saveFilterItem(obj, isNew, isItemInGroup, groupItemId);
		}
	}

	// Return global properties and methods
	return {
		init: init,
		setProfileSpecificData: setProfileSpecificData,
		open: open
	};

}());