//
//
// importDataEditDb.js
//
//

var importDataEditDb = {
	
	panel: null,
	validator: null,
	activeItemIndex: -1,
	
	init: function() {
		
		var YE = YAHOO.util.Event;
		
		var panelObj = {
			panelId: 'import_data_edit_db:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 75,
			top: 110,
			zIndex: 40,
			isCover: true,
			isSticky: true,
			closeEvent: importDataEditDb.close
		};
		
		importDataEditDb.panel = new util.Panel3(panelObj);
		importDataEditDb.validator = new util.Validator();
		
		YE.addListener('import_data_edit_db:okay_btn', 'click', importDataEditDb.saveItem);
		YE.addListener('import_data_edit_db:cancel_btn', 'click', importDataEditDb.close);
	},
	
	open: function(itemIndex) {
		
		// Keep track of the active itemIndex
		importDataEditDb.activeItemIndex = itemIndex;
		
		if (importDataEditDb.panel == null) {
			importDataEditDb.init();
		}
		else {
			// Reset the validator
			importDataEditDb.validator.reset();
		}
		
		var theProfile = importData.v7profilesDb[itemIndex];
		var isMysql = theProfile.isMysql;
		
		var panelLabel = '';
		
		util.updateT('import_data_edit_db:profile_label', theProfile.label);
		
		if (isMysql) {
			panelLabel = langVar('lang_admin.import.change_database_name');
			util.updateT('import_data_edit_db:v7_mysql_db_name', theProfile.mysqlDatabaseName);
			util.setF('import_data_edit_db:v8_mysql_db_name', theProfile.newMysqlDatabaseName);
		}
		else {
			// Custom directory
			panelLabel = langVar('lang_admin.import.change_database_directory');
			util.updateT('import_data_edit_db:v7_db_directory', theProfile.databaseDirectory);
			util.setF('import_data_edit_db:v8_db_directory', theProfile.newCustomDatabaseDirectory);
		}
		
		util.showE('import_data_edit_db:mysql_name_section', isMysql);
		util.showE('import_data_edit_db:directory_section', !isMysql);
	
		importDataEditDb.panel.open({label:panelLabel});
	},
	
	close: function() {
		
		importDataEditDb.panel.close();
	},
	
	validateAndGetMysqlDatabaseName: function(v7profilesDb, v8profilesDb, itemIndex) {
		
		var validator = importDataEditDb.validator;
		var isCustomErrorMessage = false;
		var errorMessage = '';
		var theProfile;
		var i;
		
		var v8mysqlDatabaseName = validator.isValue('import_data_edit_db:v8_mysql_db_name');
		
		if (v8mysqlDatabaseName != '') {
			
			//
			// Check if the MySQL database name is unique among all version 8 and version 7 profiles
			//
			
			// Check for unique MySQL name among version 8 profiles
			for (i = 0; i < v8profilesDb.length; i++) {
				
				theProfile = v8profilesDb[i];
				
				// Ignore v8 profile if it becomes overriden by a v7 profile!
				if (!theProfile.profileBecomesOverriden && (theProfile.mysqlDatabaseName == v8mysqlDatabaseName)) {
				
					// Throw custom error
					isCustomErrorMessage = true;
					errorMessage = langVar('lang_admin.import.mysql_name_already_exists_in_v8');
					break;
				}
			}
			
			if (!isCustomErrorMessage) {
				
				// Check for unique MySQL name among version 7 profiles, except the active v7 profile
				
				for (i = 0; i < v7profilesDb.length; i++) {
					
					theProfile = v7profilesDb[i];
				
					// if not the active profile and if is MySQL
					if ((itemIndex != i) && theProfile.isMysql) {
						var v7mysqlDatabaseName = theProfile.mysqlDatabaseName;
						if (v7mysqlDatabaseName == v8mysqlDatabaseName) {
							
							// Throw custom error
							isCustomErrorMessage = true;
							errorMessage = langVar('lang_admin.import.mysql_name_already_exists_in_v7');
							break;
						}
					}
				}
			}
			
			if (isCustomErrorMessage) {
				// Throw custom error message
				validator.isCustom('import_data_edit_db:v8_mysql_db_name', errorMessage);
			}
		}
		
		return v8mysqlDatabaseName;
	},
	
	validateAndGetDatabaseDirectory: function(v7profilesDb, v8profilesDb, itemIndex) {
		
		var validator = importDataEditDb.validator;
		var isCustomErrorMessage = false;
		var errorMessage = '';
		var theProfile;
		var i;
		
		var v8databaseDirectory = validator.isValue('import_data_edit_db:v8_db_directory');
		
		if (v8databaseDirectory != '') {
			
			//
			// Check if the database directory is unique among all version 8 and version 7 internal databases
			//
			
			// Check for unique directory among version 8 profiles
			for (i = 0; i < v8profilesDb.length; i++) {
				
				theProfile = v8profilesDb[i];
				
				// Ignore v8 profile if it becomes overriden by a v7 profile!
				if (!theProfile.profileBecomesOverriden && (theProfile.customDatabaseDirectory == v8databaseDirectory)) {
				
					// Throw custom error
					isCustomErrorMessage = true;
					errorMessage = langVar('lang_admin.import.db_directory_already_exists_in_v8');
					break;
				}
			}
			
			if (!isCustomErrorMessage) {
				
				// Check for unique directory among version 7 profiles, except the active v7 profile
				
				for (i = 0; i < v7profilesDb.length; i++) {
					
					theProfile = v7profilesDb[i];
				
					// if not the active profile
					if (itemIndex != i) {
						// We can apply this check also to MySQL databases
						var v7DatabaseDirectory = theProfile.databaseDirectory;
						if (v7DatabaseDirectory == v8databaseDirectory) {
							
							// Throw custom error
							isCustomErrorMessage = true;
							errorMessage = langVar('lang_admin.import.db_directory_already_exists_in_v7');
							break;
						}
					}
				}
			}
			
			if (isCustomErrorMessage) {
				// Throw custom error message
				validator.isCustom('import_data_edit_db:v8_db_directory', errorMessage);
			}
		}
		
		return v8databaseDirectory;
	},
	
	saveItem: function() {
		
		var validator = importDataEditDb.validator;
		validator.reset();
		
		var itemIndex = importDataEditDb.activeItemIndex;
		var v7profilesDb = importData.v7profilesDb;
		var theProfile = v7profilesDb[itemIndex];
		
		var v8profilesDb = importData.v8profilesDb;
		
		var isMysql = theProfile.isMysql;
		var i;
		
		if (isMysql) {
			
			var v8mysqlDatabaseName = importDataEditDb.validateAndGetMysqlDatabaseName(v7profilesDb, v8profilesDb, itemIndex);
		} 
		else {
			
			// Custom database directory
			var v8databaseDirectory = importDataEditDb.validateAndGetDatabaseDirectory(v7profilesDb, v8profilesDb, itemIndex);
		}
		
		if (validator.allValid()) {
			
			// Save data to theProfile
			if (isMysql) {
				theProfile.newMysqlDatabaseName = v8mysqlDatabaseName;
			}
			else {
				theProfile.newCustomDatabaseDirectory = v8databaseDirectory;
			}
			
			// Update list item
			importDataUtil.updateOverrideDatabasesListItem(itemIndex);
			
			// Close the panel
			importDataEditDb.close();
		}
	}
};
