//
// js
//

var schedulerActions = (function() {
	
	var YE = YAHOO.util.Event,
		YD = YAHOO.util.Dom,
		panel = null,
		validator = null,
		addressControl = null, // email address control for To, Cc and Bcc address

		//
		// Active form parameters
		//
		mode = '',// The active mode of an item is = new | edit | duplicate (We need to know the mode when saving the item back to the listcontrollerB.
		activeItemIndex = 0,// Refers to the active item index in listcontrollerB items array, respectively to the active row index.

		activeAction = '',
		isDatabaseAction = false,
		isProfileList = false,// No profile list has been populated yet.
		isExtendedProfilesList = false,// Specifies if the active profile list contains All profiles and Profile pattern list entry.
		isExtraOptions = false,// Specifies whether the extra options textarea element row is displayed.

		isUnlimitedGrants = false,

		activeReportsDb = [], // The active reportsDb of the selected profile

		activeDF = { // The active date filter object per action
			type: '', // none, relative | custom
			custom: '', // custom expression if type is custom
			relativePrefix: '', // none | recent || last
			relativeDateUnit: '', // year | quarter, month, ...
			relativeDateUnitCount: 1
		},


		reportFiltersPanel = null,
		initReportFiltersDone = false,
		isActiveReportFilters = false, // Specifies whether the report filters panel is displayed.

		reportFiltersOri = {
			// This is a backup of the original
			// report filters data. We need this to
			// save it back if report filters are
			// not modified.
			filterId: '',
			filterItems: [],
			filterGroups: []
		}

		reportFiltersId = '',
		reportFilterItems = [],
		reportFilterGroups = [],

		// profilesQueryFields contains loaded queryFieldsDb's per profile.
		// queryFieldsDb's are required for report filters.
		profilesQueryFields = {};
	
	function init() {

		isUnlimitedGrants = pageInfo.isRootAdmin || pageInfo.permissions.isUnlimitedGrants;
		validator = new util.Validator();
		
		//
		// Init the Action panel
		//
		
		var panelObj = {
			panelId: 'sa:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: closePanel
		};
		
		panel = new util.Panel3(panelObj);

		reportFiltersPanel = new ReportFiltersPanel({
			containerId: 'sa:report_filters',
			addItems: true,
			importItems: true,
			openImportPanelCallback: importReportFilters.open
		});

		
		// Create email addressControl
		addressControl = new emailUtil.AddressControl('sa:email_address_control:container', 360);
		
		//
		// Add events
		//
		
		YE.addListener('sa:action', 'change', selectActionActor);
		YE.addListener('sa:profile', 'change', selectProfileActor);
		YE.addListener('sa:report', 'change', selectReportActor);
		YE.addListener('sa:generate_report_files:output_format_type', 'change', setOutputFormatType);
		YE.addListener('sa:date_filter_text', 'click', openDateFilter);

		YE.addListener('sa:add_report_filters_btn', 'click', function() {
			setReportFilters(true);
		});

		YE.addListener('sa:remove_report_filters_btn', 'click', function() {
			setReportFilters(false);
		});

		YE.addListener(['sa:remove_db_data_by_number_of_days', 'sa:remove_db_data_by_filter_expression'], 'click', removeDatabaseDataEvent);
        YE.addListener('sa:export_csv_table:number_of_rows', 'keypress', setCvsExportNumberOfRowsToCustom);
		YE.addListener('sa:extra_options:toggle_btn', 'click', toggleExtraOptions);
		YE.addListener('sa:okay', 'click', saveItem);
		YE.addListener('sa:cancel', 'click', closePanel);
	}

	function selectActionActor() {

		var action = util.getF('sa:action');
		setActionByName(action);
	}

	function setActionByName(action) {

		// alert('setActionByName(): ' + action);

		var databaseTextPattern = /database/;

		activeAction = action;
		isDatabaseAction = databaseTextPattern.test(action);

		// Reset the validator
		validator.reset();


		// Reset the display
		var displayGroups = [
			'no_action_defined',
			'profile',
			'profile_pattern',
			'remove_database_data',
			'report',
			'export_csv_table',
			'generate_report_files',
			'generate_report_files_output_directory',
			'generate_report_files_output_file',
			'generate_report_files_pdf_not_supported',
			'email',
			'report_language',
			'extra_options',
			'execute_command_line',
			'vertical_spacer'
		];

		for (var i = 0; i < displayGroups.length; i++) {
			util.hideE('sa:' + displayGroups[i] + ':group');
		}

		var showExtendedProfileList = false;

		//
		// Handle the action
		//

		if (action != '') {

			if (action != 'execute_command_line') {

				util.showE('sa:profile:group');

				if (isDatabaseAction) {

					// database actions
					showExtendedProfileList = true;

					if (action == 'remove_database_data') {
						util.showE('sa:remove_database_data:group');
					}
					util.showE('sa:vertical_spacer:group');
				}
				else {

					// report actions
					util.showE('sa:report:group');

					if (action == 'generate_report_files') {
						util.showE('sa:generate_report_files:group');
						// initOutputFormatType();
						setOutputFormatType();
					}
					else if (action == 'export_csv_table') {
						util.showE('sa:export_csv_table:group');
					}
					else {
						util.showE('sa:email:group');
					}

					util.showE('sa:report_language:group');
				}

				// resetExtraOptions();
				util.showE('sa:extra_options:group');
			}
			else {
				util.showE('sa:execute_command_line:group');
			}
		}
		else {

			util.showE('sa:no_action_defined:group');
			util.showE('sa:vertical_spacer:group');
		}

		//
		//
		// Update the profile list
		//
		//

		var profilesDb = [];
		var baseDb = [];

		if (isUnlimitedGrants) {

			// Update profiles list if required

			if (showExtendedProfileList != isExtendedProfilesList || !isProfileList) {

				profilesDb = scheduler.profilesDb;
				baseDb[0] = {name:'', label:langVar('lang_admin.scheduler.select_profile_label')};

				if (showExtendedProfileList) {

					baseDb[1] = {name:'*', label:langVar('lang_admin.scheduler.all_profiles_label')};
					baseDb[2] = {name:'__PROFILE__PATTERN__', label:langVar('lang_admin.scheduler.use_profile_pattern')};
				}

				util.populateSelect('sa:profile', baseDb, 'name', 'label');
				util.extendSelect('sa:profile', profilesDb, 'name', 'label');

				isProfileList = true;
				isExtendedProfilesList = showExtendedProfileList;
			}
		}
		else if (action != '') {

			// The user has limited grants and profiles may vary per action, so we always
			// update the profiles list upon action change!
			// We also don't allow a profile pattern for limited grants

			// var actionsDb = scheduler.actionsDb;

			// util.showObject(scheduler.actionsDb);
			// alert('action: ' + action);

			var superAction = scheduler.actionsDb[util.h(action)];

			// util.showObject(superAction);

			var isAllProfiles = superAction.isAllProfiles;
			profilesDb = isAllProfiles ? scheduler.profilesDb : superAction.profiles;

			baseDb[0] = {name:'', label:langVar('lang_admin.scheduler.select_profile_label')};

			if (showExtendedProfileList && isAllProfiles) {
				baseDb[1] = {name:'*', label:langVar('lang_admin.scheduler.all_profiles_label')};
			}

			util.populateSelect('sa:profile', baseDb, 'name', 'label');
			util.extendSelect('sa:profile', profilesDb, 'name', 'label');
		}

		// Reset the profile list to Select Profile
		setProfileList('');
	}

	function setTabPane(tabId) {

		util.hideE(['sa:general:pane', 'sa:email:pane', 'sa:options:pane']);
		util.showE('sa:' + tabId + ':pane');
	}

	function selectProfileActor() {

		// activated upon onchange
		var profileName = util.getF('sa:profile');

		setProfileList(profileName);
	}

	function setProfileList(profileName) {

		if (profileName != '') {

			if (isDatabaseAction) {

				var profileIsPattern = (profileName == '__PROFILE__PATTERN__');
				util.showE('sa:profile_pattern:group', profileIsPattern);
			}
			else {
				// Report action, we need to update the report list
				setReportList(profileName);

				// TEMP TEST
//				getQueryFieldsData(profileName);
			}
		}
		else {
			setReportList('');
		}

		// We re-set the form value because setProfileList() could be invoked other than by event
		util.setF('sa:profile', profileName);
	}

	function selectReportActor() {

		if (activeAction == 'generate_report_files') {
			// initOutputFormatType();
			setOutputFormatType();
		}
	}

	function setReportList(profileName) {

		// util.disableE('sa:report');
		var disableSelect = false;

		var baseDb = [];
		baseDb[0] = {name:'', label:langVar('lang_admin.scheduler.select_report_label')};

		if (profileName != '') {

			activeReportsDb = getReportsDb(profileName); // in scheduler.js

			// Create hash for activeReportsDb report name
			util.createHash(activeReportsDb, 'name');

			if (activeAction == 'generate_report_files') {
				baseDb[1] = {name:'*', label:langVar('lang_admin.scheduler.all_reports_label')};
			}

			// util.showObject(reportsDb);
			util.populateSelect('sa:report', baseDb, 'name', 'label');
			util.extendSelect('sa:report', activeReportsDb, 'name', 'label');
		}
		else {
			// No profile selected
			util.populateSelect('sa:report', baseDb, 'name', 'label');
			disableSelect = true;
		}

		util.setF('sa:report', '');
		util.disableE('sa:report', disableSelect);
	}

	function setOutputFormatType() {

		// Note, PDF is only allowed if report is not "All Reports" and
		// if a report contains not more than one report element (due PDF performance)

		var outputFormatType = util.getF('sa:generate_report_files:output_format_type');

		// alert('setOutputFormatType() - outputFormatType: ' + outputFormatType);
		var isHTML = (outputFormatType == 'html');

		util.hideE(['sa:generate_report_files_output_directory:group',
			'sa:generate_report_files_output_file:group',
			'sa:generate_report_files_pdf_not_supported:group'
		]);


		if (isHTML) {

			util.showE('sa:generate_report_files_output_directory:group');
		}
		else {

			var isPDFSupport = false;
			var reportName = util.getF('sa:report');

			if (reportName == '') {

				// No report selected yet, assume we support it
				isPDFSupport = true;
			}
			else if (reportName == '*') {

				// 'All reports' selected, PDF output not supported
				isPDFSupport = false;
			}
			else {

				// Check number of report elements, only reports
				// with <= 1 report element are supported for PDF output.

				var reportItem = activeReportsDb[util.h(reportName)];
				// util.showObject(reportItem);
				if (reportItem.numberOfReportElements <= 1) {
					isPDFSupport = true;
				}
			}

			util.showE('sa:generate_report_files_output_file:group', isPDFSupport);
			util.showE('sa:generate_report_files_pdf_not_supported:group', !isPDFSupport);
		}
	}

	function openDateFilter() {

		schedulerDF.open(activeDF);
	}

	function setDateFilter(newDateFilter) {

		activeDF = util.cloneObject(newDateFilter);
	}

	function updateDateFilterText() {

		// Updates the date filter text according activeDF
		var type = activeDF.type;
		var text = '';

		if (type == 'none') {

			text = langVar('lang_admin.scheduler.date_filter.entire_date_range');
		}
		else if (type == 'relative') {

			var prefix = activeDF.relativePrefix;
			var dateUnit = activeDF.relativeDateUnit;
			var dateUnitCount = activeDF.relativeDateUnitCount;

			var param1Label = '';
			var param2Label = '';

			var dateUnitLabelsSingular = scheduler.dateUnitLabelsSingular;
			var dateUnitLabelsPlural = scheduler.dateUnitLabelsPlural;

			if (prefix != 'none') {

				if (prefix == 'recent') {
					// text = Last $param1 including $param2 of schedule execution date
					text = langVar('lang_admin.scheduler.date_filter.last_n_date_unit_including');
				}
				else {
					// text = Last $param1 excluding $param2 of schedule execution date
					text = langVar('lang_admin.scheduler.date_filter.last_n_date_unit_excluding');
				}

				param2Label = dateUnitLabelsSingular[dateUnit];
				text = text.replace(/__PARAM__2/, param2Label);
			}
			else {
				// text = Latest $param1 relative to end of log date
				text = langVar('lang_admin.scheduler.date_filter.latest_n_date_unit_relative');
			}

			// Handle param1Label

			if (dateUnitCount > 1) {
				param1Label = dateUnitCount + ' ' + dateUnitLabelsPlural[dateUnit];
			}
			else {
				param1Label = dateUnitCount + ' ' + dateUnitLabelsSingular[dateUnit];
			}

			text = text.replace(/__PARAM__1/, param1Label);
		}
		else {

			text = activeDF.custom;
		}

		util.updateT('sa:date_filter_text', text);
	}

	//
	// Handle report filters
	//

	function getQueryFieldsData(profileName) {

		var url = '?dp=admin_pages.scheduler.get_query_fields_data';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		dat += '&v.fp.profile_name=' + profileName;
		util.serverPost(url, dat);
	}

	function getQueryFieldsDataResponse(dat) {

//		util.showObject(dat);

		// Cache queryFieldsDb
		var profileName = dat.profileName;
		var queryFieldsDb = dat.queryFieldsDb;

		// Create hash
		util.createHash(queryFieldsDb, 'name');

		profilesQueryFields['_' + profileName] = queryFieldsDb;

		if (!initReportFiltersDone) {

			initReportFilters();
		}
		else {

			// Filters are already initialized but the profile and queryFieldsDb
			// changed. We must check filter item integrity for the new
			// queryFieldsDb.
			alert('Check filter item integrity for the new queryFieldsDb');
		}
	}

	function initReportFilters() {

		if (!initReportFiltersDone) {

			// Check if queryFieldsDb for active profile exists
			var profileName = util.getF('sa:profile');

			if (profileName !== '') {

				// If queryFieldsDb is loaded
				if (profilesQueryFields.hasOwnProperty('_' + profileName)) {

					var queryFieldsDb = profilesQueryFields['_' + profileName];

					// Init filters
					// Note, initFilters() should run only once.
					reportFiltersPanel.initFilters(
						profileName,
						queryFieldsDb,
						reportFiltersOri.filterItems,
						reportFiltersOri.filterGroups
					);

					initReportFiltersDone = true;
				}
				else {

					// Load queryFieldsDb
					getQueryFieldsData(profileName);

					// Disable filters while loading
					reportFiltersPanel.disableAll();
				}
			}
			else {

				// No profile selected, disable filters
				reportFiltersPanel.disableAll();
			}
		}
	}

	function setReportFilters(makeActive) {

		// This sets the report filters display

		isActiveReportFilters = makeActive;
		
		if (isActiveReportFilters && !initReportFiltersDone) {

			initReportFilters();
		}

		util.showE('sa:add_report_filters_row', !isActiveReportFilters);
		util.showE('sa:report_filters_row', isActiveReportFilters);
		util.showE('sa:report_filters', isActiveReportFilters);
		util.showE('sa:remove_report_filters_row', isActiveReportFilters);
	}

	function importReportFilterItemsAndGroups(items) {

		reportFiltersPanel.addNewItemsViaImport(items);
	}

	function handleReportFiltersState() {

		// This handles the reportFilters state.


	}

	//
	// Remove database data
	//

	function removeDatabaseDataEvent() {

		// Invoked by radio button event
		var isCustomFilterExpression = util.getF('sa:remove_db_data_by_filter_expression');
		setRemoveDatabaseData(isCustomFilterExpression);
	}

	function setRemoveDatabaseData(isCustomFilterExpression) {

		util.disableE('sa:remove_db_data_number_of_days', isCustomFilterExpression);
		util.disableE('sa:remove_db_data_filter_expression', !isCustomFilterExpression);
	}


	function setCvsExportNumberOfRowsToCustom() {
		// Makes custom radio button enabled when user types a row number
		util.setF('sa:export_csv_table:number_of_rows:custom', true);
	}

	function toggleExtraOptions() {
		setIsExtraOptions(!isExtraOptions);
	}

	function setIsExtraOptions(_isExtraOptions) {

		isExtraOptions = _isExtraOptions;
		util.showE('sa:extra_options:row', isExtraOptions);

		var linkText = isExtraOptions ? langVar('lang_admin.scheduler.remove_extra_options') : langVar('lang_admin.scheduler.add_extra_options');
		util.updateT('sa:extra_options:toggle_btn', linkText);
	}

	function newItem() {
		
		// invoked from scheduler.js
		mode = 'new';
		var panelLabel = langVar('lang_admin.scheduler.new_action');
		var newItemObj = {};
		openPanel(panelLabel, newItemObj);
	}
	
	function editItem(itemIndex, item) {

//		console.log('itemIndex I: ' + itemIndex);
		
		// invoked from listcontrollerB
		mode = 'edit';
		activeItemIndex = itemIndex;

//		console.log('activeItemIndex II: ' + activeItemIndex);

		var panelLabel = langVar('lang_admin.scheduler.edit_action');

		openPanel(panelLabel, item);
	}

	function duplicateItem(itemIndex, item) {
		
		// invoked from listcontrollerB
		// itemIndex is the index of the item we duplicate!
		// util.showObject(item);
		
		mode = 'duplicate';
		activeItemIndex = itemIndex;
		var panelLabel = langVar('lang_admin.scheduler.edit_duplicated_action');
		openPanel(panelLabel, item);
	}
	
	function openPanel(panelLabel, item) {
		
		// Note, the item may be an empty object, in this case we simply
		// set the initial Action form state to "Select Action"
		
		var sa = schedulerActions;
				
		// util.showObject(item);
		
		var isEmptyItem = (item.type == null || item.type == '');
		

		//
		// Reset Action form
		//
		
		util.resetF('sa:form');
		setActionByName('');


		// Reset df
		activeDF = {
			type: 'none',
			custom: '',
			relativePrefix: 'recent', // We set relative default date to init the date picker panel
			relativeDateUnit: 'year',
			relativeDateUnitCount: 1
		};


		// Reset report filters
		reportFiltersPanel.resetIsModified();
		initReportFiltersDone = false;
		setReportFilters(false);
		reportFiltersOri = {
			filterId: '',
			filterItems: [],
			filterGroups: []
		};


		setRemoveDatabaseData(false);
		setIsExtraOptions(false);

		
		//
		// Reset email addresses
		//
		
		addressControl.reset();
		
		//
		// Set data
		//
		
		if (!isEmptyItem) {
			updateForm(item);
		}
		
		//
		// Update date filter text
		//
	
		updateDateFilterText();
		
		//
		// Open the panel 
		//
		
		fixPanel(true);


		var viewportWidth = YD.getViewportWidth();

		// If small display
		if (viewportWidth > 1000) {

			panel.open({
				label: panelLabel,
				left: 316,
				top: 160
			});
		}
		else {

			panel.prePositionAtCenter();
			panel.open({label: panelLabel});
		}
	}

	function updateForm(item) {

//		util.showObject(item);
		var sa = schedulerActions;
		var action = item.type;

		setActionByName(action);
		util.setF('sa:action', action);

        if (action != 'execute_command_line') {

            var profile = item.profile;
            var profileIsPattern = item.profile_is_pattern;

            // alert('updateForm() - action: ' + action);

            if (isDatabaseAction) {

                if (profileIsPattern) {
                    profile = '__PROFILE__PATTERN__';
                    util.showE('sa:profile_pattern:group', profileIsPattern);
                    util.setF('sa:profile_pattern', item.profile);
                }

                util.setF('sa:profile', profile);

                if (action == 'remove_database_data') {

                    var filterInfo = item.filter_info;
                    var isCustomFilterExpression = !filterInfo.number_of_days_active;

                    if (!isCustomFilterExpression) {
                        util.setF('sa:remove_db_data_by_number_of_days', true);
                        util.setF('sa:remove_db_data_number_of_days', filterInfo.number_of_days);
                    }
                    else {
                        util.setF('sa:remove_db_data_by_filter_expression', true);
                        util.setF('sa:remove_db_data_filter_expression', item.options.f);
                    }

                    setRemoveDatabaseData(isCustomFilterExpression);
                }
            }
            else {

                //
                // Report action
                //

                util.setF('sa:profile', profile);

                var options = item.options;

                //
                // Set the report list
                //
                var reportName = options.rn;

                // Update the report list
                setReportList(profile);
                util.setF('sa:report', reportName);

                //
                // Set Date filter
                //

                var dfObj = item.date_filter;

                // util.showObject(dfObj);

                var dateFilterType = dfObj.type;

                if (dateFilterType != 'none') {

                    // Set activeDF which is then manipulated by schedulerDF.js
                    activeDF.type = dateFilterType;

                    if (dateFilterType == 'relative') {

                        activeDF.relativePrefix = dfObj.relative_prefix;
                        activeDF.relativeDateUnit = dfObj.relative_date_unit;
                        activeDF.relativeDateUnitCount = dfObj.relative_date_unit_count;
                    }
                    else {
                        activeDF.custom = dfObj.custom;
                    }
                }

				//
				// Set report filter
				//

				reportFiltersOri = {
					filterId: item.report_filters.filter_id,
					filterItems: item.report_filters.filter_items,
					filterGroups: item.report_filters.filter_groups
				};

				// Only init reportFilter items and groups if filter exists.
				if (reportFiltersOri.filterItems.length > 0 || reportFiltersOri.filterGroups.length > 0) {

					// Show/init filters
					setReportFilters(true);
				}

                //
                // Set misc. report action options
                //

                if (action == 'export_csv_table') {

                    util.setF('sa:export_csv_table:output_file', options.of);

                    var endingRow = options.er;
                    var endingRowText = '';

                    if (endingRow == 0) {
                        util.setF('sa:export_csv_table:number_of_rows:default', true);
                    }
                    else if (endingRow == -1) {
                        // All rows
                        util.setF('sa:export_csv_table:number_of_rows:all', true);
                    }
                    else {
                        // Custom row number
                        endingRowText = endingRow;
                        util.setF('sa:export_csv_table:number_of_rows:custom', true);
                    }

                    util.setF('sa:export_csv_table:number_of_rows', endingRowText);
                }
                else if (action == 'generate_report_files') {

                    var outputFormatType = options.oft;

                    if (outputFormatType == 'html') {
                        // HTML
                        util.setF('sa:generate_report_files:output_directory', options.od);
                    }
                    else {
                        // PDF
                        util.setF('sa:generate_report_files:output_file', options.of);
                    }

                    util.setF('sa:generate_report_files:output_format_type', outputFormatType);
                    // initOutputFormatType();
                    setOutputFormatType();
                }
                else {

                    // send report_by_email
                    util.setF('sa:return_address', options.rna);

                    var emailAddresses = schedulerUtil.actionsEmailToEmailAddressesObject(options);
                    addressControl.init(emailAddresses);

                    // util.setF('sa:recipient_address', options.rca);
                    // util.setF('sa:cc_address', options.ca);
                    // util.setF('sa:bcc_address', options.ba);

                    util.setF('sa:report_email_subject', options.res);
                }

                // Set language
                util.setF('sa:report_language', item.language);
            }

            if (item.extra_options != '') {

                setIsExtraOptions(true);
                util.setF('sa:extra_options', item.extra_options);
            }
        }
        else {

            // execute_command_line
            util.setF('sa:execute_command_line:command_line', item.command_line);
        }
	}
		
	function saveItem() {
		
		// We save the item object back to the items array in listcontrollerB
		// alert('saveItem()');

		var action = activeAction;
		var o = {};
        var isValidEmailAddresses = true;
		
		if (action != '') {
			
			o.type = action;

            if (action != 'execute_command_line') {

                var profileIsPattern = false;
                o.profile = validator.isValue('sa:profile');

                if (o.profile == '__PROFILE__PATTERN__') {
                    o.profile = validator.isValue('sa:profile_pattern');
                    profileIsPattern = true;
                }

                o.profile_is_pattern = profileIsPattern;

                if (isDatabaseAction) {

                    if (action == 'remove_database_data') {

                        var number_of_days_active = util.getF('sa:remove_db_data_by_number_of_days');
                        var number_of_days = 0;
                        var f_option;

                        if (number_of_days_active) {
                            // number of days
                            number_of_days = validator.isInteger('sa:remove_db_data_number_of_days', 1);
                            f_option = '(date_time < now() - 60*60*24*' + number_of_days + ')';
                        }
                        else {
                            // custom filter expression
                            f_option = validator.isValue('sa:remove_db_data_filter_expression');
                        }

                        o.options = {f: f_option};
                        o.filter_info = {
                            number_of_days_active: number_of_days_active,
                            number_of_days: number_of_days
                        }
                    }
                }
                else {

                    //
                    // This is a report action
                    //

                    o.options = {};

                    var reportName = validator.isValue('sa:report');
                    o.options.rn = reportName;

                    //
                    // Get the date filter
                    //

                    o.date_filter = {
						type: activeDF.type,
						custom: activeDF.custom,
						relative_prefix: activeDF.relativePrefix,
						relative_date_unit: activeDF.relativeDateUnit,
						relative_date_unit_count: activeDF.relativeDateUnitCount
					};

					//
					// Save report filters if modified or added.
					//

					// Set defaults for no report filters
					var filterId = '';
					var filterItems = [];
					var filterGroups = [];

					if (isActiveReportFilters) {

//						console.log('isModified reportFilters: ' + reportFiltersPanel.getIsModified());

						if (reportFiltersPanel.getIsModified())  {

							// Filters have been added or modified.
							// filterId remains empty string which
							// forces expression creation on server.
							filterItems = reportFiltersPanel.getFilterItems();
							filterGroups = reportFiltersPanel.getFilterGroups();
						}
						else {

							// Nothing modified, use original filter data
							filterId = reportFiltersOri.filterId;
							filterItems = reportFiltersOri.filterItems;
							filterGroups = reportFiltersOri.filterGroups;
						}
					}

					o.report_filters = {
						// Reset filter_id so that the filter becomes
						// re-created in filters_cache.
						filter_id: filterId,
						filter_items: filterItems,
						filter_groups: filterGroups
					};

//					util.showObject(o.report_filters);

                    //
                    // Handle misc. options
                    //

                    switch (action) {

                        case 'export_csv_table':

                            o.options.of = validator.isValue('sa:export_csv_table:output_file');

                            // Handle ending row
                            var endingRow;

                            if (util.getF('sa:export_csv_table:number_of_rows:default')) {
                                // default, use number of rows of report element
                                endingRow = 0;
                            }
                            else if (util.getF('sa:export_csv_table:number_of_rows:all')) {
                                // all rows
                                endingRow = -1;
                            }
                            else {
                                endingRow = validator.isInteger('sa:export_csv_table:number_of_rows', 1);
                            }

                            o.options.er = endingRow;
                            break;

                        case 'generate_report_files':

                            var ouputFormatType = util.getF('sa:generate_report_files:output_format_type');

                            o.options.oft = ouputFormatType;

                            if (ouputFormatType == 'html') {
                                o.options.od = validator.isValue('sa:generate_report_files:output_directory');
                            }
                            else {

                                // Output is PDF
                                // Make sure we throw a hidden error if output format is PDF but the selected report
                                // doesn't support it. Note, the error message is already displayed but we need to
                                // prevent the user from saving the form!
                                // We simply reset the 'sa:generate_report_files:output_file' field, which will fire an error anyway!

                                if (reportName != '') {

                                    isPDFOutputSupport = true;

                                    if (reportName == '*') {
                                        isPDFOutputSupport = false;
                                    }
                                    else {

                                        var reportItem = activeReportsDb[util.h(reportName)];
                                        isPDFOutputSupport = (reportItem.numberOfReportElements <= 1);
                                    }

                                    if (!isPDFOutputSupport) {

                                        // Reset the 'sa:generate_report_files:output_file' so that it throws an error and avoids saving the action
                                        util.setF('sa:generate_report_files:output_file', '');
                                    }
                                }

                                o.options.of = validator.isValue('sa:generate_report_files:output_file');
                            }

                            break;

                        case 'send_report_by_email':

                            o.options.rna = validator.isValue('sa:return_address');

                            isValidEmailAddresses = addressControl.validate();

                            if (isValidEmailAddresses) {

                                var addressControlAddresses = addressControl.getAddresses();

                                var rca = ''; // To
                                var ca = ''; // Cc
                                var ba = ''; // Bcc

                                for (var i = 0; i < addressControlAddresses.length; i++) {

                                    var addressItem = addressControlAddresses[i];
                                    var address = addressItem.address;

									// Separate multiple email addresses by
									// by comma only. A space after the comma
									// causes problems in some mail servers.

                                    if (addressItem.type == 'to') {
                                        rca += address + ',';
                                    }
                                    else if (addressItem.type == 'cc') {
                                        ca += address + ',';
                                    }
                                    else {
                                        ba += address + ',';
                                    }
                                }

                                // Add only defined addresses to options!

                                if (rca != '') {
                                    o.options.rca = rca.replace(/(,)$/, '');
                                }

                                if (ca != '') {
                                    o.options.ca = ca.replace(/(,)$/, '');
                                }

                                if (ba != '') {
                                    o.options.ba = ba.replace(/(,)$/, '');
                                }

                                // util.showObject(o.options);
                            }

                            o.options.res = validator.isValue('sa:report_email_subject');
                            break;
                    }

                    o.language = util.getF('sa:report_language');
                }

                // get extra options
                o.extra_options = isExtraOptions ? util.getF('sa:extra_options') : '';
            }
            else {

                // validate execute_command_line action
                o.command_line = validator.isValue('sa:execute_command_line:command_line');
            }
		}
		else {
			o.action = validator.isValue('sa:action');
		}
		
		if (validator.allValid() && isValidEmailAddresses) {
			
			// alert('all valid, save the item');
			
			// Save the item to the actions list (listcontrollerB handles save of the object)
			var sa = schedulerActions;

//			console.log('itemIndex III: ' + activeItemIndex);

			schedulerActionsList.list.saveItem(mode, activeItemIndex, o);
			closePanel();
			
			// Check SMTP server warning
			handleSmtpServerWarning();
		}
	}
	
	function closePanel() {
		
		var sa = schedulerActions;
		validator.reset();
		panel.close();
		fixPanel(false);
	}
	
	function fixPanel(isFix) {
		
		// IE 6 fix, show/hide select boxes in Scheduler form!
		util.showEV('schedule_date_time:tr', !isFix);
		
		// Firefox fix, change overlow property of underlying actions list to hidden (otherwise form field focus becomes lost!)
		var element = util.getE('scheduler:actions_list:div');
		element.style.overflow = isFix ? 'hidden' : 'scroll';
	}
	
	function getReportLabel(profile, reportName) {
		
		var profilesDb = scheduler.profilesDb;
		var profileItem = profilesDb[util.h(profile)];
		
		var reportLabel = '';
		
		if (profileItem != null) {
			var reportNames = profileItem.rN;
			var reportLabels = profileItem.rL;
			var reportNamesDb = scheduler.reportNamesDb;
			var reportLabelsDb =  scheduler.reportLabelsDb;
			
			// We need the index of the reportName in rN of the profile
			for (var i = 0; i < reportNames.length; i++) {
				
				var reportNameIndex = reportNames[i];
				if (reportNamesDb[reportNameIndex] == reportName) {
					
					var reportLabelIndex = reportLabels[i];
					reportLabel = reportLabelsDb[reportLabelIndex];
				}
			}
		}
		
		if (reportLabel == '') {
			reportLabel = langVar('lang_admin.scheduler.unknown_report');
		}
		
		return reportLabel;
		
	}
	
	function labelBuilder(actionItem) {
		
		// Invoked from listcontrollerB
		// Returns a text label with HTML markup
		
		// util.showObject(actionItem);
		
		var action = actionItem.type;
		var label = scheduler.actionsDb[util.h(action)].label;
        var finalLabel = '';
        var subLabel = '(';
		
		//
		// Create the label which is displayed within the span element
		//

        if (action != 'execute_command_line') {

            var profilesDb = scheduler.profilesDb;
            var profileItem = null;
            var profile = actionItem.profile;
            var profileLabel = '';

            if (profile != '*' && !actionItem.profile_is_pattern) {

                profileItem = profilesDb[util.h(profile)];
                profileLabel = (profileItem != null) ? profileItem.label : langVar('lang_admin.scheduler.unknown_profile');
            }
            else {

                if (!actionItem.profile_is_pattern) {

                    profileLabel = langVar('lang_admin.scheduler.all_profiles_label');
                }
                else {

                    profileLabel = profile;
                }
            }

            subLabel += profileLabel + ', ';

            if (action == 'export_csv_table' ||
                action == 'generate_report_files' ||
                action == 'send_report_by_email') {

                var reportName = actionItem.options.rn;
                var reportLabel = getReportLabel(profile, reportName);
                subLabel += reportLabel + ', ';

                // KHP-RC, show date filter label if any

                if (action == 'send_report_by_email') {

                    var recipientAddress = actionItem.options.rca;
                    subLabel += recipientAddress + ', ';
                }
            }

            subLabel = subLabel.replace(/(,\s)$/, ')');
            finalLabel = label + ' <span>' + subLabel + '</span>';
        }
        else {
            // execute_command_line
            // TODO - check if we should add a part of the command_line as sublabel
            finalLabel = label;
        }
		
		return finalLabel;
	}

	return {
		init: init,
		setDateFilter: setDateFilter,
		updateDateFilterText: updateDateFilterText,
		getQueryFieldsDataResponse: getQueryFieldsDataResponse,
		newItem: newItem,
		editItem: editItem,
		duplicateItem: duplicateItem,
		labelBuilder: labelBuilder,
		importReportFilterItemsAndGroups: importReportFilterItemsAndGroups
	}

}());
