//
//
// users.js
//
//


var users = {
	
	isEnterprise: false,
	isUnlimitedGrants: false,
	defaultDividerLabels: [],
	languageInPreferences: '',
	languageOfDividerLists: '',
	activeUserNodeName: '',
	rootAdminUsername: '', // Used to check for duplicate username because the rootAdmin is not part of usersDb
	usersDb: [],
	usersDbBackup: [],
	profilesDb: [],
	rolesDb: [], // Contains the role names, labels and profile access rights if there are no unlimited grants, format is:
				 // [{name:"role_1", label:"Administrator", isPermission:true, all_profiles:false, profiles:['profile_1', profile_2]}, ...]
				 // Note, rolesDb contains all roles even if unlimited_grants is equal false because we need all roles for display!
				 // We use the "isPermission" property to check whether or not a role is granted.
	
	deletedUsersDb: [], // Keeps the node names of any deleted user, i.e. ['user_1', 'user_12']
	theList: null,
	validator: null,
	// isModifiedUsers: false,
	saveChangesBtn: null,
	newUserBtn: null,
	deleteBtn: null,
	duplicateBtn: null,
	undoAllChangesBtn: null,
	
	noItemFormIsActive: false,
	// Active form data:
	changePasswordIsActive: false,
	newItemIsActive: false,
	activeItemNodeName: '',
	activeCreatedByUser: '',
	activeAccess: [],
	
	isSelectUserName: false, // used for username default selected upon new or duplicate
	
	isVisibleReportFilterExpressionField: false // is true if the report filter expression field is shown on the item form
}

function init() {
	
	//
	// Main init routine
	//
	
	var isEnterprise = (pageInfo.licensingTier == 'enterprise');
	var YE = YAHOO.util.Event;
	
	users.isUnlimitedGrants = pageInfo.permissions.isUnlimitedGrants;
	users.isEnterprise = isEnterprise;
	users.validator = new util.Validator();
	
	//
	// init toolbar buttons
	//
	
	users.saveChangesBtn = new util.ToolbarButton('save_changes', saveChanges, toolbarButtonsDb);		
	users.newUserBtn = new util.ToolbarButton('new_user', newUser, toolbarButtonsDb);
	users.duplicateBtn = new util.ToolbarButton('duplicate', duplicateUser, toolbarButtonsDb);
	users.deleteBtn = new util.ToolbarButton('delete', deleteUser, toolbarButtonsDb);
	users.undoAllChangesBtn = new util.ToolbarButton('undo_all_changes', undoAllChanges, toolbarButtonsDb);
	
	//
	// Ignore/Disable buttons according RBAC
	//
	
	var permissions = pageInfo.permissions;
	
	if (permissions.isEdit) {
		
		if (!permissions.isAdd) {
			users.newUserBtn.disableAndIgnore();
			users.duplicateBtn.disableAndIgnore();
		}
		
		if (!permissions.isDelete) {
			users.deleteBtn.disableAndIgnore();
		}
		
		// Register isModifiedPageHandler in adminConfig.js
		// (We don't check for modifications if there is no edit 
		// permission because there is no Save button anyway!)
		adminConfig.getIsModifiedPageHandler = getIsModifiedPage;
	}
	else {
		users.saveChangesBtn.disableAndIgnore();
		users.newUserBtn.disableAndIgnore();
		users.duplicateBtn.disableAndIgnore();
		users.deleteBtn.disableAndIgnore();
		users.undoAllChangesBtn.disableAndIgnore();
	}
	
	// init OptionInfo
	optionInfo.init();
	
	// Init help
	util.helpWindow.init('');

	//
	// Create the theList object
	//
	
	users.theList = new listcontroller.List({
		containerElementId: 'item_list_body',
		itemEvent: itemActivated
	});
	
	// Add events
	
	YE.addListener('users:username', 'keyup', updateListAndFormLabel);
	YE.addListener('users:change_password_btn', 'click', changeCancelPassword);
	YE.addListener('users:cancel_change_password_btn', 'click', changeCancelPassword);
	
	YE.addListener('users:access:tbody', 'click', usersUtil.accessListLinkActivated);
	YE.addListener('users:access:tbody', 'mouseover', usersUtil.hoverAccessListItem);
	YE.addListener('users:access:tbody', 'mouseout', usersUtil.hoverAccessListItem);
	
	
	YE.addListener('users:language', 'change', languageActor);
	
	//
	// Handle enterprise specific features
	//
	
	if (isEnterprise) {
		
		YE.addListener('users:access:new_access_pair_btn', 'click', usersAM.addNewAccessPair);
		YE.addListener('users:add_report_filter:btn', 'click', addReportFilter);
		YE.addListener('users:report_filter_expression:view_help_btn', 'click', util.helpWindow.openGeneralHelp);
		
        util.showE('users:add_report_filter:section');
	}
	
	//
	// Init Access Manager Panel
	//
	
	usersAM.init();
}


function initMainDisplay() {
	
	// alert('initMainDisplay()');
	
	util.hideE(['form_section', 'users_form', 'no_item_form', 'loading_info', 'saving_info']);
	
	var firstItemId = users.theList.getFirstItemId();
	
	// alert('initMainDisplay() - firstItemId: ' + firstItemId);
	
	if (firstItemId != null) {
		// select the first item
		setItem(firstItemId);
		displayNoItemForm(false);
	}
	else {
		// no item exists
		displayNoItemForm(true);
	}
	
	util.showE('form_section');
}

function getUsersData() {
	
	if (!pageInfo.exitActive) {
		
		var url = '?dp=admin_pages.users.get_data';
		var dat = 'v.fp.page_token=' + pageInfo.pageToken;
		util.serverPost(url, dat);
	}
}

function getUsersDataResponse(dat) {

//	util.showObject(dat);
	
	if (!pageInfo.exitActive) {
		
		users.defaultDividerLabels = dat.defaultDividerLabels;
		users.languageInPreferences = dat.languageInPreferences;
		users.activeUserNodeName = dat.activeUserNodeName;
		users.rootAdminUsername = dat.rootAdminUsername;
		users.usersDb = dat.usersDb;
		users.usersDbBackup = util.cloneObject(dat.usersDb);
		users.profilesDb = dat.profilesDb;
		users.rolesDb = dat.rolesDb;
		
		// util.showObject(users.defaultDividerLabels);
		
		util.createHash(users.defaultDividerLabels, 'language');
		util.createHash(users.profilesDb, 'name');
		util.createHash(users.rolesDb, 'name');
		
		// util.showObject(users.profilesDb);
		
		// Init	
		
		if (!pageInfo.initComplete) {
			// This is the initial page load
			init();
			users.theList.init(users.usersDb);
			initMainDisplay();
			pageInfo.initComplete = true;
		}
		
		// Set final toolbar state
		users.saveChangesBtn.enable();
		users.undoAllChangesBtn.enable();
		users.newUserBtn.enable();
		updateToolbarButtons(); // handles Duplicate and Delete
		
		adminConfig.setItemListSize();
		YAHOO.util.Event.addListener(window, 'resize', adminConfig.setItemListSize);
	}
}

function displayNoItemForm(isDisplayNoItemForm) {
	
	if (isDisplayNoItemForm) {
		// util.updateT('item_form_label', '-');
		util.hideE('users_form');
		util.showE('no_item_form');
	}
	else {
		util.hideE('no_item_form');
		util.showE('users_form');
	}

	users.noItemFormIsActive = isDisplayNoItemForm;
}

function updateToolbarButtons() {
	
	var isItems = users.theList.isItems();
	users.deleteBtn.enable(isItems);
	users.duplicateBtn.enable(isItems);
}

function updateListAndFormLabel() {
	
	setTimeout('setListAndFormLabel()', 300);
}

function setListAndFormLabel() {
	
	var label = util.getF('users:username');
	if (label == '') {
		label = '-';
	}
	
	if (!pageInfo.isRootAdmin) {
		
		var item = users.theList.getSelectedItem();
		var userNodeName = item.dat.node_name;
		
		if (userNodeName == users.activeUserNodeName) {
			label += ' (' + langVar('lang_admin.users.logged_in') + ')';
		}
	}
	
	// util.updateT('item_form_label', label);
	users.theList.updateListLabel(label);
}

function changeCancelPassword() {
	
	var isChangePassword = !users.changePasswordIsActive;
	// util.showE('users:password_container', isChangePassword);
	// util.showE('users:change_password_btn', !isChangePassword);
	// util.showE('users:cancel_change_password_btn', isChangePassword);
	util.showE('users:password_section', isChangePassword);
	util.showE('users:change_password_section', !isChangePassword);
	users.changePasswordIsActive = isChangePassword;
	
	// Reset any errors
	users.validator.reset();
}

function languageActor() {
		
	var language = util.getF('users:language');
	updateLanguageOptions(language);
}

function updateLanguageOptions(language) {
	
	// language is the language of current user
	
	// This updates the select element label 
	// of number_thousands_divider and number_decimal_divider
	// so that the first list item shows the language specific
	// default dividers.

	function updateOptionText(elementId, label) {
		var element = util.getE(elementId);
		element.options[0].text = label;
	}
	
	if (language == '') {
		// Use default language as set it preferences
		language = users.languageInPreferences;
	}
	
	// Check if we need to update the default divider text
	if (language != users.languageOfDividerLists) {
		
		var dividerItem = users.defaultDividerLabels[util.h(language)];
		updateOptionText('users:number_thousands_divider', dividerItem.defaultThousandDividerLabel);
		updateOptionText('users:number_decimal_divider', dividerItem.defaultDecimalDividerLabel);
		
		// Remember the language of divider lists
		users.languageOfDividerLists = language;
	}
}

function addReportFilter() {
	
	util.hideE('users:add_report_filter:section');
	util.showE('users:report_filter_expression:section');
	
	users.isVisibleReportFilterExpressionField = true;
}

function itemActivated(itemId) {
	
	if (validateActiveItem()) {
		setItem(itemId);
	}
}

function setItem(itemId) {
	
	// selects active item in list and displays the form
		
	users.theList.selectItem(itemId);
	updateForm(itemId);
	
	//
	// set delete button
	//
	/*
	if (itemId != activeUserItemId) {
		deleteButton.enable();
	}
	else {
		deleteButton.disable();
	}
	*/
}

function newUser() {
	
	if (validateActiveItem()) {
		
		var theList = users.theList;
	
		var newItemId = theList.getNewItemId();
		var newNodeName = usersUtil.getNewUserNodeName(users.usersDb, users.deletedUsersDb);
		var activeUserNodeName = users.activeUserNodeName;
		
		// Give a default role in the pro version, the role_2 (Statistics visitor)
		var defaultRoles = users.isEnterprise ? [] : ['role_2'];
		var accessObj = [{
			all_profiles: false,
			profiles: [],
			roles: defaultRoles,
			created_by_user: activeUserNodeName
		}];
		
		var newUserLabel = langVar('lang_admin.users.new_user');
		
		var userObj = {
			id: newItemId,
			type: '',
			label: newUserLabel,
			dat: {
				is_new: true,
				node_name: newNodeName,
				username: newUserLabel,
				password: '',
				email_address: '',
				language: '',
				number_thousands_divider: '',
				number_decimal_divider: '',
				created_by_user: activeUserNodeName,
				access: accessObj,
				auto_direct_to_reports_after_login: false,
				report_filter_expression: ''
			}
		}
		
		theList.newItem(userObj);
		users.isSelectUserName = true;
		setItem(newItemId);
		updateToolbarButtons();
	}
}

function duplicateUser() {
		
	if (validateActiveItem()) {
		
		var theList = users.theList;
		var item = theList.getSelectedItem();
		var username = item.dat.username;
		
		// Get new node name
		var newNodeName = usersUtil.getNewUserNodeName(users.usersDb, users.deletedUsersDb);
		// var newUsername = username + ' ' + langVar('lang_admin.general.copy');
		var newUsername = langVar('lang_stats.general.item_copy');
		newUsername = newUsername.replace(/__PARAM__1/, username);
		
		// Clone item
		var clonedItemId = theList.cloneItem();
		
		//
		// Reset item data
		//
		
		theList.setItemDatValue(clonedItemId, 'is_new', true);
		theList.setItemDatValue(clonedItemId, 'node_name', newNodeName);
		theList.setItemDatValue(clonedItemId, 'username', newUsername);
		theList.setItemDatValue(clonedItemId, 'password', '');
		theList.setItemDatValue(clonedItemId, 'created_by_user', users.activeUserNodeName);
		
		users.isSelectUserName = true;
		setItem(clonedItemId);
	}
}

function deleteUser() {
	
	var theList = users.theList;
	
	var item = theList.getSelectedItem();
	var itemId = item.id;
	var itemNodeName = item.dat.node_name;
	
	var deletedUsersDb = users.deletedUsersDb;
	deletedUsersDb[deletedUsersDb.length] = itemNodeName;
	
	// alert('deleteRole(): ' + itemId);
	
	
	//
	// select the next item
	//
	
	var nextItemIdToBeSelected = theList.deleteItem();
	
	if (nextItemIdToBeSelected != null) {
		
		// reset the validator in case that the deleted an item with error indication
		users.validator.reset();
		setItem(nextItemIdToBeSelected);
	}
	else {
		
		// All items have been deleted
		
		// alert('Last item has been deleted, no more items to select.');
		displayNoItemForm(true);
		updateToolbarButtons();
	}
}

function updateForm(itemId) {
	
	// alert('updateForm()');
	
	var isRootAdmin = pageInfo.isRootAdmin;
	
	var item = users.theList.getSelectedItem();
	var itemDat = item.dat;
	
	// util.showObject(item);
	// util.showObject(itemDat);
	
	// util.updateT('item_form_label', itemDat.username);
	
	var isNewItem = itemDat.is_new;
	
	users.newItemIsActive = isNewItem;
	users.activeItemNodeName = itemDat.node_name;
	
	//
	// Handle username
	//
	
	util.setF('users:username', itemDat.username);
	// var isLoggedInUser = (itemDat.node_name == users.activeUserNodeName);
	// util.showE('users:active_user_info', isLoggedInUser);
	
	// 
	// Handle password
	//
	
	// util.hideE(['users:password_container', 'users:change_password_btn', 'users:cancel_change_password_btn']);
	util.hideE(['users:change_password_section', 'users:password_section']);
	
	var password = itemDat.password;
	var changePasswordIsActive = false;
	util.setF('users:password', password);
	// alert('password: ' + password);
	
	if (!itemDat.is_new) {
		// Existing user item
		if (password == '') {
			// util.hideE('users:password_container');
			// util.showE('users:change_password_btn');
			util.hideE('users:password_section');
			util.showE('users:change_password_section');
		}
		else {
			// password changed already, allow to cancel the change
			// util.showE('users:password_container');
			// util.showE('users:cancel_change_password_btn');
			util.showE('users:password_section');
			util.showE('users:cancel_change_password_btn');
			changePasswordIsActive = true;
		}
	}
	else {
		// New user item
		// util.showE('users:password_container');
		util.showE('users:password_section');
	}
	
	users.changePasswordIsActive = changePasswordIsActive;
	
	util.setF('users:email_address', itemDat.email_address);
	
	//
	// Handle language options & created_by_user
	//
	
	util.setF('users:language', itemDat.language);
	updateLanguageOptions(itemDat.language);
	util.setF('users:number_thousands_divider', itemDat.number_thousands_divider);
	util.setF('users:number_decimal_divider', itemDat.number_decimal_divider);
	users.activeCreatedByUser = itemDat.created_by_user;
	
	
	//
	//
	// Handle access
	//
	//
	
	// Clone the active access array to users.activeAccess, we use 
	// the users.activeAccess to create and manipulate the access list
	// per user item.
	
	users.activeAccess = util.cloneObject(itemDat.access);
	
	// util.showObject(users.activeAccess);
	
	usersUtil.updateAccessList();

	if (users.noItemFormIsActive) {
		displayNoItemForm(false);
	}
	
	// Set auto_direct_to_reports_after_login
	util.setF('users:auto_direct_to_reports_after_login', itemDat.auto_direct_to_reports_after_login);
	
	//
	//
	// Handle report filter
	//
	//
	
	if (users.isEnterprise) {
		
		var reportFilterExpression = itemDat.report_filter_expression;
		var reportFilterExpressionExists = (reportFilterExpression != '');
		
		util.setF('users:report_filter_expression', reportFilterExpression);
		
		if (reportFilterExpressionExists != users.isVisibleReportFilterExpressionField) {
			
			util.showE('users:add_report_filter:section', !reportFilterExpressionExists);
			util.showE('users:report_filter_expression:section', reportFilterExpressionExists);
			users.isVisibleReportFilterExpressionField = reportFilterExpressionExists;
		}
	}

	
	// Assign tabIndex (hard coded html tabindex has a problem with password field, hence we do via js!
	
	/*
	KHP 25/Nov/2010 - disabled because tabIndex looks to work  without js
	and it misses number_thousands_divider, number_decimal_divider and report filter
	anyway.
	var f1 = util.getE('users:username');
	var f2 = util.getE('users:password');
	var f3 = util.getE('users:access:container');
	var f4 = util.getE('users:language');
	f1.tabIndex = 1;
	f2.tabIndex = 2;
	f3.tabIndex = 3;
	f4.tabIndex = 4;
	
	if (users.isSelectUserName) {
		f1.select();
		// Reset isSelectUserName
		users.isSelectUserName = false;
	}
	*/
	
}

function validateActiveItem() {
	
	// Only validate if isEdit permission and if items
	
	var theList = users.theList;
	
	if (pageInfo.permissions.isEdit && theList.isItems()) {
		
		var validator = users.validator;
		validator.reset();
		
		var isNewItem = users.newItemIsActive;
		
		var o = {};
		
		// Transfer is_new and node_name from existing object
		o.is_new = isNewItem;
		o.node_name = users.activeItemNodeName;
		
		o.username = validator.isValue('users:username');
		
		// Make sure the username is not equal the rootAdmin username
		
		if (o.username != users.rootAdminUsername) {
			
			// The username is case sensitive, so "user a" is not equal "USER A", both are unique!
			o.username = validator.isUnique('users:username', theList.getLookupItems('username'));
		}
		else {
			// Same username as rootAdmin, we show a custom error
			var msg = '';
			
			if (pageInfo.isRootAdmin) {
				msg = langVar('lang_admin.users.is_root_admin_username_msg');
			}
			else {
				msg = langVar('lang_admin.users.is_reserved_username_msg');
			}
			
			validator.isCustom('users:username', msg); 
		}
		
		// alert('o.username: ' + o.username);
		
		if (isNewItem || users.changePasswordIsActive) {
			o.password = validator.isValue('users:password');
		}
		else {
			o.password = '';
		}
		
		o.email_address = util.getF('users:email_address');
		
		// Validate for valid email address if any is defined
		if (o.email_address != '') {
			validator.isEmailAddress('users:email_address');
		}
		
		o.language = util.getF('users:language');
		o.number_thousands_divider = util.getF('users:number_thousands_divider');
		o.number_decimal_divider = util.getF('users:number_decimal_divider');
		o.created_by_user = users.activeCreatedByUser;
		
		//
		// Handle access (get active access array from users.activeAccess, it is ready to go)
		//
		// Note, we allow zero profiles and zero roles, there is no validation for profiles and roles!
		
		o.access = util.cloneObject(users.activeAccess);
		
		o.auto_direct_to_reports_after_login = util.getF('users:auto_direct_to_reports_after_login');
		
		o.report_filter_expression = (users.isVisibleReportFilterExpressionField) ? util.getF('users:report_filter_expression') : '';
		
		if (validator.allValid()) {

			theList.saveItem(o);
			return true;
		}
		
		return false;
	}
	
	// No isEdit permission or no items
	return true;
}

function saveChanges() {
		
	if (validateActiveItem()) {
		
		var theList = users.theList;
		var isModified = theList.getIsModified();
		
		// alert('saveChanges() - isModified: ' + isModified);
		
		if (isModified) {
			
			util.hideE('form_section');
			util.showE('saving_info');
			
			var url = '?dp=admin_pages.users.save_data';
			var dat = 'v.fp.page_token=' + pageInfo.pageToken + '&';
			var i;
			
			//
			//
			// Handle deleted users
			//
			//
			
			var deletedUsersDb = users.deletedUsersDb;
			
			if (deletedUsersDb.length > 0) {
				
				for (i = 0; i < deletedUsersDb.length; i++) {
					
					dat += 'v.fp.deleted_users.' + deletedUsersDb[i] + '=true&';
				}
			}
			else {
				
				dat += 'v.fp.deleted_users=&';
			}
			
			
			//
			//
			// Handle users
			//
			//
			
			var usersDb = users.usersDb;
			var numOfUsers = usersDb.length;
			
			if (numOfUsers > 0) {
			
				for (i = 0; i < numOfUsers; i++) {
					
					var itemDat = usersDb[i].dat;
					
					var userPath = 'v.fp.users.' + itemDat.node_name;
					
					dat += userPath + '.is_new=' + itemDat.is_new + '&';
					dat += userPath + '.username=' + encodeURIComponent(itemDat.username) + '&';
					dat += userPath + '.password=' + encodeURIComponent(itemDat.password) + '&';
					dat += userPath + '.email_address=' + encodeURIComponent(itemDat.email_address) + '&';
					dat += userPath + '.language=' + itemDat.language + '&';
					dat += userPath + '.number_thousands_divider=' + encodeURIComponent(itemDat.number_thousands_divider) + '&';
					dat += userPath + '.number_decimal_divider=' + encodeURIComponent(itemDat.number_decimal_divider) + '&';
					dat += userPath + '.created_by_user=' + itemDat.created_by_user + '&';
					
					var access = itemDat.access;
					
					for (var j = 0; j < access.length; j++) {
						
						var accessItem = access[j];
						var accessItemPath = userPath + '.access.' + j;
						dat += accessItemPath + '.all_profiles=' + accessItem.all_profiles + '&';
						dat += accessItemPath + '.created_by_user=' + accessItem.created_by_user + '&';
						
						var accessProfiles = accessItem.profiles;
						var accessRoles = accessItem.roles;
						
						var k = 0;
						
						if (accessProfiles.length > 0) {
							for (k = 0; k < accessProfiles.length; k++) {
								dat += accessItemPath + '.profiles.' + k + '=' + accessProfiles[k] + '&';
							}
						}
						else {
							dat += accessItemPath + '.profiles=&';
						}
						
						if (accessRoles.length > 0) {
							for (k = 0; k < accessRoles.length; k++) {
								dat += accessItemPath + '.roles.' + k + '=' + accessRoles[k] + '&';
							}
						}
						else {
							dat += accessItemPath + '.roles=&';
						}
					}
					
					dat += userPath + '.auto_direct_to_reports_after_login=' + itemDat.auto_direct_to_reports_after_login + '&';
					
					// Add report_filter_expression
					dat += userPath + '.report_filters.all_profiles.filter_expression=' + encodeURIComponent(itemDat.report_filter_expression) + '&';
				}
			}
			else {

				dat += 'v.fp.users=&';
			}
			
			// Handle usersDbBackup
			
			var usersDbBackup = users.usersDbBackup;
			var numOfUsers2 = usersDbBackup.length;
			
			if (numOfUsers2 > 0) {
				
				for (i = 0; i < numOfUsers2; i++) {
					
					itemDat = usersDbBackup[i].dat;
					dat += 'v.fp.users_backup.' + i + '=' + encodeURIComponent(itemDat.username) + '&';
				}
			}
			else {
				dat += 'v.fp.users_backup=&';
			}
			
			dat = dat.replace(/&$/, '');

			util.serverPost(url, dat);
		}
		else {
			
			alert(langVar('lang_stats.general.no_changes_to_save'));
		}
	}
}

function saveChangesResponse() {

	// alert('saveChangesResponse()');
	// Note, we keep the system at current state, we do not re-initialize theList
	users.usersDbBackup = util.cloneObject(users.usersDb);
	
	users.deletedUsersDb = [];
	
	users.theList.resetIsModified();
	
	util.hideE('saving_info');
	util.showE('form_section');
}

function undoAllChanges() {
	
	users.usersDb = util.cloneObject(users.usersDbBackup);
	users.deletedUsersDb = [];
	
	users.theList.init(users.usersDb);
	initMainDisplay();
	updateToolbarButtons();
}

function getIsModifiedPage() {
	
	// Note, isModified will be false if only the active item has been edited
	// but has an error, hence we also check "if (!validateActiveItem() ..."
	
	if (!validateActiveItem() || users.theList.getIsModified()) {
		return true;
	}
	
	return false;
}
