//
// configHomeUtil
//

// This is the configHomeUtil namespace
var configHomeUtil = function() {
	
	var YE = YAHOO.util.Event;
	
	var dbOperationPanel = null;
	var alertPanel = null;
	
	var dbOperationType = '';
	var dbBuildExists = false;
	
	//
	//
	// Db operation panel
	//
	//

	function initDbOperationPanel() {
		
		var panelObj = {
			panelId: 'database_operation:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: '-',
			left: 316,
			top: 160,
			zIndex: 40,
			isCover: true,
			// isSticky: true,
			closeEvent: configHomeUtil.cancelDbOperation
		};
		
		dbOperationPanel = new util.Panel3(panelObj);
		
		YE.addListener('database_operation:yes_btn', 'click', startDbOperation);
		YE.addListener('database_operation:no_btn', 'click', cancelDbOperation);
	}
	
	function openDbOperationPanel(dbOperationTypeArg, dbBuildExistsArg) {
		
		// dbOperationType is: updateDatabase | buildDatabase
		
		var panelLabel = '';
				
		dbOperationType = dbOperationTypeArg;		
		dbBuildExists = dbBuildExistsArg;
		
		var isUpdateDb = (dbOperationType == 'updateDatabase');
		
		if (!dbOperationPanel) {
		 	initDbOperationPanel();
		}
		
		// Handle text info and buttons
		
		util.hideE(['database_operation:update_db:db_build_exists',
				'database_operation:update_db:no_db_build_exists',
				'database_operation:build_db:db_build_exists',
				'database_operation:build_db:no_db_build_exists']);
		
		if (isUpdateDb) {
			
			panelLabel = langVar('lang_stats.btn.update_database');
			
			if (dbBuildExists) {
				util.showE('database_operation:update_db:db_build_exists');
			}
			else {
				util.showE('database_operation:update_db:no_db_build_exists');
			}
		}
		else {
			
			if (dbBuildExists) {
				
				panelLabel = langVar('lang_stats.btn.build_rebuild_database');
				util.showE('database_operation:build_db:db_build_exists');
			}
			else {
				
				panelLabel = langVar('lang_stats.btn.build_database');
				util.showE('database_operation:build_db:no_db_build_exists');
			}
		}
		
		// util.updateT('database_operation:start_btn', buttonLabel);
		
		dbOperationPanel.open({label:panelLabel});
	}
	
	function startDbOperation() {
				
		dbOperationPanel.close();
		configHome.startUpdateOrBuildDatabase(dbOperationType);
	}
	
	function cancelDbOperation() {
		dbOperationPanel.close();
		configHome.cancelDatabaseOperation();
	}
	
	
	//
	//
	// Alert panel
	//
	//
	
	function initAlertPanel() {
		
		var panelObj = {
			panelId: 'config_home_alert:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.general.alert'),
			left: 316,
			top: 160,
			zIndex: 20,
			// isCover: true,
			// isSticky: true,
			closeEvent: configHomeUtil.closeAlertPanel
		};
		
		alertPanel = new util.Panel3(panelObj);
		
		YE.addListener('config_home_alert:cancel_btn', 'click', closeAlertPanel);
	}
	
	function openAlertPanel(alertText) {
		
		if (!alertPanel) {
			initAlertPanel();	
		}
		
		util.updateT('config_home_alert:text', alertText);
		
		alertPanel.open();
	}
	
	function closeAlertPanel() {
		
		alertPanel.close();
		
		// Restore button state in callee
		configHome.cancelDatabaseOperation();
	}
	
	
	//
	// Return global properties and methods
	//
	
	return {
		openDbOperationPanel: openDbOperationPanel,
		cancelDbOperation: cancelDbOperation,
		openAlertPanel: openAlertPanel,
		closeAlertPanel: closeAlertPanel
	}
}();
