//
// reportElementsList.js
//

var reportElementsList = {
	
	moveControl: null,
	list: null,
	
	init: function() {
		
		//
		// Create the report elements list object
		//
		
		var obj = {
			name: 'report_elements',
			tbodyElementId: 'reports:report_element_list:tbody',
			noItemText: langVar('lang_admin.report_editor.no_report_element_defined'),
			isDefaultItem: true,
			listChangeNotificationFunction: reportElementsList.listChangeNotification,
			editItemFunction: reportElement.editItem,
			duplicateItemFunction: reportElement.duplicateItem,
			labelBuilderFunction: reportElement.labelBuilder
		}
		
		reportElementsList.list = new listcontrollerB.List(obj);
		reportElementsList.moveControl = new util.MoveControl('report_element_move_control', reportElementsList.moveItem);
	},
	
	listChangeNotification: function(listName, selectedItemIndex, numberOfItems) {
		// Called from wide item list controller upon list change
		// Set button state of move control
		reportElementsList.moveControl.setState(selectedItemIndex, numberOfItems);
	},
	
	moveItem: function(direction) {
		
		// Invoked from MoveControl
		// var direction = reportElementsList.moveControl.getMoveDirection(this.id);
		// Move item in list
		reportElementsList.list.moveItem(direction);
	}
}
