var allLogFormatsList = function() {

    var YE = YAHOO.util.Event,
        YD = YAHOO.util.Dom;


	/*
		allLogFormatsList Class

		It is used for the three different lists where
		all log formats are shown, all, all syslogs and all syslog_required.
	*/

	function list(listElementId) {

		// this.searchBoxElementId = searchBoxElementId;
		this.listElementId = listElementId;
		this.logFormatDb = null; // A reference to the log formats db provided in init()

		this.inputFieldHintActive = false;

		this.keyupCount = 0;

		this.currentSearchResultId = '';

		this.searchResults = {};
		/* searchResults looks like this
		property name is the search text with a leading and trailing underscore
		labels contains the log format labels in lowercase
		indexes contains the index which refer to the log format item in logFormatDb

		searchResults = {
			__: { THIS IS THE INITIAL SERACH RESULT WHICH CONTAINS ALL FORMATS!
				labels: ['3m', 'apache_combined', ... , 'xy'],
				indexes: [0, 1, ..., 800],
				numOfItems: 800
			},
			_apa_: {
				labels: ['apache_combined', 'apache_2', 'apache_3', ...],
				indexes: [1, 2, 3, 18, 24],
				numOfItems: 5
			},
			_apache_2_: {
				labels: ['apache_2'],
				indexes: [2],
				numOfItems: 1
			},
			...
		}
		*/

		// alert('create new LogFormatList object');
	}

	list.prototype = {

		getIsReady: function() {
			return this.isReady;
		},

		init: function(logFormatDb) {

			// alert('list.prototype.init()')

			this.logFormatDb = logFormatDb;
			var numOfItems = logFormatDb.length;

			// Create the initial search result which contains all formats
			// var obj = {labels: [], indexes: [], numberOfItems: numberOfFormats};
			var labels = [];
			var indexes = [];

			for (var i = 0; i < numOfItems; i++) {
				var label = logFormatDb[i].label;
				labels[i] = label.toLowerCase();
				indexes[i] = i;
			}

			this.searchResults['__'] = {labels: labels, indexes: indexes, numOfItems: numOfItems};
			this.setInputFieldHint();

			// util.showObject(this.searchResults);

			YE.addListener(this.listElementId + ':search', 'focus', this.handleInputFieldHintUponFocus, this);
			YE.addListener(this.listElementId + ':search', 'blur', this.handleInputFieldHintUponBlur, this);
			YE.addListener(this.listElementId + ':search', 'keyup', this.searchActivated, this);

			YE.addListener(this.listElementId + ':clear_btn', 'click', this.clearSearch, this);
		},

		prepareResetList: function(logFormatDb) {

			// This is called every time that a "log format all"
			// wizard page becomes displayed.

			if (this.logFormatDb == null) {
				// Init the list
				this.init(logFormatDb);
			}

			this.keyupCount = 0;

			// Create the list if none is displayed
			if (this.currentSearchResultId == '') {
				this.createList('__', 0);
			}
		},

		handleInputFieldHintUponFocus: function(evt, self) {

			if (self.inputFieldHintActive) {

				// Clear input field from hint
				this.value = '';
				this.className = '';
				self.inputFieldHintActive = false;
			}
		},

		handleInputFieldHintUponBlur: function(evt, self) {

			if (this.value == '') {
				self.setInputFieldHint();
			}
		},

		setInputFieldHint: function() {

			var e = util.getE(this.listElementId + ':search');
			e.className = 'placeholder';
			e.value = langVar('lang_admin.new_profile_wizard.filter_log_formats_by');
			util.hideE(this.listElementId + ':clear_btn');
			this.inputFieldHintActive = true;
		},

		clearSearch: function(evt, self) {

			var e = util.getE(self.listElementId + ':search');
			e.value = '';
			e.focus();
			self.createList('__', 0);
		},

		createList: function(searchResultId, searchTextLength) {

			this.currentSearchResultId = searchResultId;

			var searchResult = this.searchResults[searchResultId];
			var indexes = searchResult.indexes;
			var numOfItems = searchResult.numOfItems;

			// Indicate number of items
			util.updateT(this.listElementId + ':number', '(' + numOfItems + ')');

			var theList = util.getE(this.listElementId);
			theList.options.length = 0;

			var logFormatDb = this.logFormatDb;

			for (i = 0; i < numOfItems; i++) {

				var logFormatIndex = indexes[i];
				var logFormatItem = logFormatDb[logFormatIndex];

				var id = logFormatItem.id;
				var listLabel = logFormatItem.label;

				theList.options[i] = new Option(listLabel, id, false, false);
			}

			// Update clear filter button
			var isSearchText = (searchTextLength > 0);
			util.showE(this.listElementId + ':clear_btn', isSearchText);
		},

		searchActivated: function(evt, self) {

			// Increment keyupCount
			var latestKeyupCount = self.keyupCount + 1;
			self.keyupCount = latestKeyupCount;

			// util.showObject({a: 'searchActivated() - ' + latestKeyupCount});

			var obj = self;
			setTimeout(function() { obj.searchAndUpdateList(latestKeyupCount); }, 500);
		},

		searchAndUpdateList: function(keyupCount) {

			// Only update when there is no more key in action
			if (keyupCount == this.keyupCount) {

				var searchText = util.getF(this.listElementId + ':search');
				searchText = searchText.toLowerCase();
				var searchResultId = '_' + searchText + '_';

				var searchResults = this.searchResults;

				if (searchResults[searchResultId] == null) {

					// util.showObject({b: 'searchAndUpdateList() - keyupCount: ' + keyupCount + ' - searchText: ' + searchText + ' CREATE NEW SEARCH RESULT'});

					// Check from which list we start the search, i.e. a list with less items in it if the current searchText matches an existing searchText
					// Set temp sourceSearchResultId
					var sourceSearchResultId = this.getSourceSearchId(searchText);

					var searchResult = this.getNewSearchResult(sourceSearchResultId, searchText);

					searchResults[searchResultId] = searchResult;
				}
				else {

					// util.showObject({b: 'searchAndUpdateList() - keyupCount: ' + keyupCount + ' - searchText: ' + searchText + ' USE EXISTING SEARCH RESULT'});
				}


				// Create the list
				this.createList(searchResultId, searchText.length);
			}
		},

		getSourceSearchId: function(searchText) {

			/* This checks if there is already a search result with less letters
			of the current searchText. I.e., if the searchText is "apache"
			then we check if there is already a search result as follows:
			check for "apach", if search result exists then use this as source for the next search
			else check for "apac", if search result exists then use this as source for the next search
			else check for "apa", if search result exists then use this as source for the next search
			else check for "ap", if search result exists then use this as source for the next search
			else check for "a", if search result exists then use this as source for the next search
			else use the initial search result in "__", which contains all formats.
			*/

			// util.showObject({__getSourceSearchId: 'searchText: ' + searchText});

			var searchResults = this.searchResults;
			var sourceSearchResultId = "__"; // initial search result

			for (var i = searchText.length - 1; i > 0; i--) {

				var id = '_' + searchText.substring(0, i) + '_';
				// util.showObject({__id: 'checking search result for id: ' + id});

				if (searchResults[id] != null) {
					// Got an existing search result which we can use
					sourceSearchResultId = id;
					break;
				}
			}

			// util.showObject({__id: 'final sourceSearchResultId: ' + sourceSearchResultId});

			return sourceSearchResultId;
		},

		getNewSearchResult: function(sourceSearchResultId, searchText) {

			// sourceSearchResult is the search result from which we start the search.
			// It may contain all log formats or only a few onces if there exists
			// a search result which matches the current searchText.

			var sourceSearchResult = this.searchResults[sourceSearchResultId];

			// util.showObject(sourceSearchResult, 'IT FOLLOWS THE sourceSearchResult OBJECT');

			var sourceSearchResultLables = sourceSearchResult.labels;
			var sourceSearchResultIndexes = sourceSearchResult.indexes;
			var numSourceSearchResultItems = sourceSearchResult.numOfItems;


			// util.showObject({b: 'getNewSearchResult() - number of items to be searched: ' + numSourceSearchResultItems});

			var labelsA = [];  // Log formats which "start" with searchText will be displayed at beginning
			var indexesA = []; // Log formats which "contain" the searchText somewhere after the first character
			var numOfA = 0;

			var labelsB = []; // Log formats which "contain" the searchText somewhere after the first character
			var indexesB = [];
			var numOfB = 0;

			for (var i = 0; i < numSourceSearchResultItems; i++) {

				var theLabel = sourceSearchResultLables[i];
				var posOfSearchText = theLabel.indexOf(searchText);

				if (posOfSearchText != -1) {

					if (posOfSearchText === 0) {
						// This log format starts with searchText
						labelsA[numOfA] = theLabel;
						indexesA[numOfA] = sourceSearchResultIndexes[i];
						numOfA++;
					}
					else {
						// This log format contains the searchText somewhere after the 1st character

						labelsB[numOfB] = theLabel;
						indexesB[numOfB] = sourceSearchResultIndexes[i];
						numOfB++;
					}
				}
			}

			var labels = labelsA.concat(labelsB);
			var indexes = indexesA.concat(indexesB);
			var numOfItems = numOfA + numOfB;
			var searchResult = {labels: labels, indexes: indexes, numOfItems: numOfItems};

			return searchResult;
		}
	}

	//
	// Return global properties and methods
	//

	return {
		list: list
	}
}();
