//
// reports/activeFiltersInfo.js
//


var activeFiltersInfo = function() {
	
	var YE = YAHOO.util.Event;
	var GD = { // General global data
		
		panel: null
	};
	
	function init() {
		
		var panelObj = {
			panelId: 'active_filters_info:panel',
			panelClassName: 'panel-50',
			panelHeaderLabel: langVar('lang_stats.active_filters_info.label'),
			left: 300,
			top: 80,
			zIndex: 20,
			isCover: true,
			isSticky: true,
			closeEvent: activeFiltersInfo.closePanel
		};
		
		GD.panel = new util.Panel3(panelObj);

		YE.addListener('active_filters_info:close_btn', 'click', activeFiltersInfo.closePanel);
	}

	function open() {

		if (GD.panel == null) {

			// Init panel
			init();

			// Get active filters data
			getActiveFiltersDat();
			report.busyPanel.showLoading();
		}
		else {
			// Already loaded
			// updateForm();
			GD.panel.open();
		}
	}

	
	function closePanel() {
		
		GD.panel.close();
	}

	function getActiveFiltersDat() {

		var url = '?dp=statistics.filters.active_filters_info.get_active_filters_info';
		url += '&p=' + reportInfo.profileName;

		var dat = 'v.fp.page_token=' + reportInfo.pageToken;
		dat += '&v.fp.report_job_id=' + reportInfo.reportJobId;

		util.serverPost(url, dat);
	}

	function getActiveFiltersDatResponse(dat) {

		// util.showObject(dat);
		var dateFilter = dat.dateFilter;
		var filterExpression = dat.filterExpression;
		var isDateFilter = dateFilter != '';
		var isFilterExpression = filterExpression != '';

		if (isDateFilter) {
			util.updateT('active_filters_info:date_filter:df1', dateFilter);
			util.updateT('active_filters_info:date_filter:df2', dateFilter);
		}

		if (isFilterExpression) {
			util.updateT('active_filters_info:general_filter:f1', filterExpression);
			util.updateT('active_filters_info:general_filter:f2', filterExpression);
		}

		util.showE('active_filters_info:date_filter', isDateFilter);
		util.showE('active_filters_info:general_filter', isFilterExpression);
		util.showE('active_filters_info:no_filters', !isDateFilter && !isFilterExpression);

		report.busyPanel.stop();
		GD.panel.open();
	}
	
	//
	//
	// Return global properties and methods
	//
	//
	
	return {

		open: open,
		closePanel: closePanel,
		getActiveFiltersDatResponse: getActiveFiltersDatResponse
	}
	
}();


