//
// identifier.js
// Shared utility to show/hide the identifier row and to define a custom identifier (node name)
//

var identifier = {
	
	toggleIdentifierBtn: null,
	
	identifierFieldIsVisible: false,
	isCustomIdentifier: false, // --> property is used in callee to check if the user defined a custom identifier
	
	initialNodeName: '', 	// --> the initialNodeName is set upon updateForm. It is required in case that we cancel
							// a nodeName change where we set the field to the initialNodeName
	
	init: function() {
		
		var commandLinkOptions = {
			classNameEnabled: 'command-link-50',
			classNameDisabled: 'command-link-50-disabled'
		};	
		
		identifier.toggleIdentifierBtn = new util.CommandLink('identifier:toggle_identifier_btn', identifier.toggleIdentifier, true, commandLinkOptions);
		YAHOO.util.Event.addListener('identifier:toggle_define_custom_identifier_btn', 'click', identifier.toggleDefineCustomIdentifier);
	},
	
	initUponUpdateForm: function(nodeName) {
		
		// Called from the callee upon updateForm
		// Reset Custom Identifier and set nodeName in identifier.initialNodeName
		
		identifier.reset();
		identifier.initialNodeName = nodeName;
		util.setF('identifier:node_name', nodeName);
	},
	
	reset: function() {
		
		if (identifier.isCustomIdentifier) {
			identifier.setDefineCustomIdentifier(false);
		}
	},
	
	toggleIdentifier: function() {
		
		var makeVisible = !identifier.identifierFieldIsVisible;
		util.showE('identifier:identifier_section', makeVisible);
		
		var buttonLabel = makeVisible ? langVar('lang_admin.general.hide_identifier') : langVar('lang_admin.general.show_identifier');
		util.updateT('identifier:toggle_identifier_btn', buttonLabel);
		
		identifier.identifierFieldIsVisible = makeVisible;
	},
	
	toggleDefineCustomIdentifier: function() {
		
		var makeCustom = !identifier.isCustomIdentifier;
		identifier.setDefineCustomIdentifier(makeCustom);
	},
	
	setDefineCustomIdentifier: function(makeCustom) {
		
		// alert('setDefineCustomIdentifier() - makeCustom: ' + makeCustom);
		
		util.enableE('identifier:node_name', makeCustom);
		var buttonLabel = makeCustom ? langVar('lang_admin.general.cancel_define_custom_identifier') : langVar('lang_admin.general.define_custom_identifier');
		util.updateT('identifier:toggle_define_custom_identifier_btn', buttonLabel);
		
		var element;
		if (makeCustom) {
			element = util.getE('identifier:node_name');
			element.focus();
		}
		else {
			element = util.getE('identifier:toggle_define_custom_identifier_btn');
			element.blur();
			
			// Give the form element the inital nodeName value
			util.setF('identifier:node_name', identifier.initialNodeName);
		}
		
		// Disbale the Hide Identifier button while makeCustom is true
		identifier.toggleIdentifierBtn.enable(!makeCustom);
	
		identifier.isCustomIdentifier = makeCustom;
	}
}
