//
//
// passwordUtil.js
// 
//

var passwordUtil = {
	
	validatePassword: function(validationRules, newPassword) {
		
		// Validates a password according preferences.password validation paramters.
		// This function does not check 	
		
		// validationRules object:
		/*
		newPasswordValidation = {
			minimumLength: 1,
			requiresLetter: false,
			requiresMixedCase: true,
			requiresDigit: true,
			requiresSymbol: false,
		}
		*/
		
		var vRules = validationRules;
		var isValid = false;
		var errorMessage = '';
		
		if (newPassword.length >= vRules.minimumLength) {
			
			var lowercasePattern = /[a-z]/;
			var uppercasePattern = /[A-Z]/;
			var digitsPattern = /[0-9]/;
			var symbolsPattern = /[^a-zA-Z0-9]/;
			
			var isLowercaseLetters = lowercasePattern.test(newPassword);
			var isUppercaseLetters = uppercasePattern.test(newPassword);
			var isDigits = digitsPattern.test(newPassword);
			var isSymbols = symbolsPattern.test(newPassword);
			
			if (!vRules.requiresLetter || isLowercaseLetters || isUppercaseLetters) {
				if (!vRules.requiresMixedCase || (isLowercaseLetters && isUppercaseLetters)) {
					if (!vRules.requiresDigit || isDigits) {
						if (!vRules.requiresSymbol || isSymbols) {
							isValid = true;
						}
						else {
							errorMessage = langVar('lang_stats.form_validation.passsword_requires_symbol');
						}
					}
					else {
						errorMessage = langVar('lang_stats.form_validation.passsword_requires_digit');
					}
				}
				else {
					errorMessage = langVar('lang_stats.form_validation.passsword_requires_lowercase_and_uppercase');
				}
			}
			else {
				errorMessage = langVar('lang_stats.form_validation.passsword_requires_letter');
			}
		}
		else {
			// errorMessage = 'The password requires minimum ' + vRules.minimumLength + ' characters.';
			errorMessage = langVar('lang_stats.form_validation.passsword_requires_min_n_charaters');
			errorMessage = errorMessage.replace(/__PARAM__1/, vRules.minimumLength);
		}
		
		// Return object
		var obj = {};
		obj.isValid = isValid;
		obj.errorMessage = errorMessage;
		
		return obj;
	}
}
